/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool;

import com.philschatz.swt.dnd.WindowsImageTransfer;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.SimpleWidgetGroup;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CogToolClipboard {
    public static final Object FilePersistence = IProject.FILE_PERSISTENCE;
    public static final String CopyTasks = "Task";
    public static final String CopyDesigns = "EntireDesign";
    public static final String CopyFrames = "FrameOnly";
    public static final String CopyWidgets = "TransitionSourceOnly";
    public static final String[] MAC_IMAGE_TYPES = new String[]{"PNGf", "JPEG", "TIFF", "BMP ", "BMPf", "GIFF"};
    public static int[] MAC_IMAGE_IDS = new int[MAC_IMAGE_TYPES.length];
    protected static Clipboard systemClipboard;
    protected static String[] clipboardData;
    protected static Transfer[] clipboardTypes;

    public static ObjectSaver startClipboardSave(Object purpose) throws IOException {
        return new ClipboardClassSaver(purpose);
    }

    public static ObjectSaver startClipboardSave(Object purpose, IFrame[] selection) throws IOException {
        return new SelectedFrameSaver(purpose, selection);
    }

    public static ObjectSaver startClipboardSave(Object purpose, IWidget[] selection) throws IOException {
        return new SelectedWidgetSaver(purpose, selection);
    }

    public static boolean hasCogToolObjects() {
        return CogToolClipboard.checkTypes((Transfer)CogToolTransfer.getInstance());
    }

    public static boolean hasImageData() {
        if (CogToolClipboard.checkTypes((Transfer)WindowsImageTransfer.getInstance())) {
            return true;
        }
        return CogToolClipboard.checkTypes(MAC_IMAGE_TYPES);
    }

    private static boolean checkTypes(Transfer transfer) {
        TransferData[] types = systemClipboard.getAvailableTypes();
        for (int i = 0; i < types.length; ++i) {
            TransferData type = types[i];
            for (int j = 0; j < types.length; ++j) {
                if (!transfer.isSupportedType(type)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkTypes(String[] goodTypes) {
        String[] types = systemClipboard.getAvailableTypeNames();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            for (int j = 0; j < goodTypes.length; ++j) {
                if (!type.equals(goodTypes[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection fetchCogToolObjects() throws ParserConfigurationException, SAXException, IOException {
        String str = (String)systemClipboard.getContents((Transfer)CogToolTransfer.getInstance());
        if (str == null || !str.startsWith("<persist")) {
            return null;
        }
        ObjectLoader l = new ObjectLoader();
        return l.load(new InputSource(new StringReader(str)), null);
    }

    public static byte[] fetchImageData() {
        if (OSUtils.WINDOWS) {
            ImageData data = (ImageData)systemClipboard.getContents((Transfer)WindowsImageTransfer.getInstance());
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{data};
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.data.length);
            loader.save((OutputStream)byteStream, 1);
            return byteStream.toByteArray();
        }
        if (OSUtils.MACOSX) {
            ByteArrayTransfer xfer = new ByteArrayTransfer(){

                protected int[] getTypeIds() {
                    return MAC_IMAGE_IDS;
                }

                protected String[] getTypeNames() {
                    return MAC_IMAGE_TYPES;
                }
            };
            return (byte[])systemClipboard.getContents((Transfer)xfer);
        }
        throw new IllegalStateException("Can't fetch an image from the clipboard -- nothing to fetch!");
    }

    static {
        for (int i = 0; i < MAC_IMAGE_IDS.length; ++i) {
            CogToolClipboard.MAC_IMAGE_IDS[i] = Transfer.registerType((String)MAC_IMAGE_TYPES[i]);
        }
        systemClipboard = new Clipboard(WindowUtil.globalDisplay);
        clipboardData = new String[1];
        clipboardTypes = new Transfer[]{CogToolTransfer.getInstance()};
    }

    protected static class SelectedWidgetSaver
    extends ClipboardClassSaver {
        protected Set selectedWidgets = new HashSet();
        protected Map headerGroups = new HashMap();

        public SelectedWidgetSaver(Object purpose, IWidget[] selection) throws IOException {
            super(purpose);
            if (selection != null) {
                for (int i = 0; i < selection.length; ++i) {
                    this.selectedWidgets.add(selection[i]);
                }
            }
        }

        public Object filterObject(Object value) throws IOException {
            if (value instanceof IWidgetGroup) {
                IWidgetGroup valueGroup = (IWidgetGroup)value;
                SimpleWidgetGroup replacementGroup = (SimpleWidgetGroup)this.headerGroups.get(valueGroup);
                if (replacementGroup == null) {
                    replacementGroup = new SimpleWidgetGroup(valueGroup.getOrientation());
                    this.headerGroups.put(valueGroup, replacementGroup);
                    Iterator groupWidgets = valueGroup.getAllWidgets();
                    while (groupWidgets.hasNext()) {
                        IWidget widget = (IWidget)groupWidgets.next();
                        if (!this.selectedWidgets.contains(widget)) continue;
                        replacementGroup.simpleAddWidget(widget);
                    }
                }
                return replacementGroup;
            }
            return super.filterObject(value);
        }
    }

    protected static class SelectedFrameSaver
    extends ClipboardClassSaver {
        protected Set selectedFrames = new HashSet();
        protected Set safeTransitions = new HashSet();

        public SelectedFrameSaver(Object purpose, IFrame[] selection) throws IOException {
            super(purpose);
            if (selection != null) {
                for (int i = 0; i < selection.length; ++i) {
                    this.selectedFrames.add(selection[i]);
                }
            }
        }

        public Object filterObject(Object value) throws IOException {
            if (value instanceof ITransition) {
                ITransition t;
                if (!this.safeTransitions.contains(value) && this.selectedFrames.contains((t = (ITransition)value).getDestination()) && this.selectedFrames.contains(t.getSource().getFrame())) {
                    this.safeTransitions.add(t);
                }
                return null;
            }
            return super.filterObject(value);
        }

        public void finish() throws IOException {
            Iterator transitions = this.safeTransitions.iterator();
            while (transitions.hasNext()) {
                ITransition t = (ITransition)transitions.next();
                this.saveObject(t);
            }
            super.finish();
        }
    }

    protected static class ClipboardClassSaver
    extends ObjectSaver {
        public ClipboardClassSaver(Object purpose) throws IOException {
            super(new StringWriter(), purpose);
        }

        public void finish() throws IOException {
            super.finish();
            CogToolClipboard.clipboardData[0] = this.sink.toString();
            systemClipboard.setContents((Object[])clipboardData, clipboardTypes);
        }
    }

    protected static class CogToolTransfer
    extends ByteArrayTransfer {
        private static final String COGTOOL_NAME = "CgTl";
        private static final int COGTOOL_ID = CogToolTransfer.registerType((String)"CgTl");
        private static CogToolTransfer ONLY = new CogToolTransfer();

        private CogToolTransfer() {
        }

        public static CogToolTransfer getInstance() {
            return ONLY;
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof String)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                String xml = (String)object;
                ByteArrayOutputStream out = new ByteArrayOutputStream(xml.length() * 2);
                PrintStream printer = new PrintStream(out);
                printer.print(xml);
                super.javaToNative((Object)out.toByteArray(), transferData);
            } else {
                System.err.println("Not isSupportedType()!" + object);
            }
        }

        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer != null) {
                    return new String(buffer);
                }
                System.err.println("Nothing to paste!");
            }
            return null;
        }

        protected int[] getTypeIds() {
            return new int[]{COGTOOL_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{COGTOOL_NAME};
        }
    }
}

