/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool;

import edu.cmu.cs.hcii.cogtool.controller.ControllerRegistry;
import edu.cmu.cs.hcii.cogtool.controller.DesignEditorControllerFactory;
import edu.cmu.cs.hcii.cogtool.controller.FrameEditorControllerFactory;
import edu.cmu.cs.hcii.cogtool.controller.PERTChartControllerFactory;
import edu.cmu.cs.hcii.cogtool.controller.ProjectController;
import edu.cmu.cs.hcii.cogtool.controller.ProjectControllerFactory;
import edu.cmu.cs.hcii.cogtool.controller.RootController;
import edu.cmu.cs.hcii.cogtool.controller.SEDemoControllerFactory;
import edu.cmu.cs.hcii.cogtool.controller.SEFrameChooseControllerFactory;
import edu.cmu.cs.hcii.cogtool.model.CogToolSerialization;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ProjectPersister;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.IPERTChartUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.IProjectUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.ProjectUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoUIFactory;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserUIFactory;
import edu.cmu.cs.hcii.cogtool.util.DelayedWorkManager;
import edu.cmu.cs.hcii.cogtool.util.DelayedWorkPhase;
import edu.cmu.cs.hcii.cogtool.util.IPersist;
import edu.cmu.cs.hcii.cogtool.util.IPersistFactory;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.UndoManagerFactory;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CogTool {
    public static final CogTool ONLY = new CogTool();
    public static boolean PROJECT_MANAGES_OTHERS = false;
    public static final ProjectControllerFactory projectControllerFactory = new ProjectControllerFactory();
    public static final DesignEditorControllerFactory designEditorControllerFactory = new DesignEditorControllerFactory();
    public static final FrameEditorControllerFactory frameEditorControllerFactory = new FrameEditorControllerFactory();
    public static final SEFrameChooseControllerFactory seFrameChooserControllerFactory = new SEFrameChooseControllerFactory();
    public static final SEDemoControllerFactory seDemoControllerFactory = new SEDemoControllerFactory();
    public static final PERTChartControllerFactory pertChartControllerFactory = new PERTChartControllerFactory();
    public static final IProjectUIFactory projectUIFactory = new ProjectUIFactory();
    public static final IDesignEditorUIFactory designEditorUIFactory = new DesignEditorUIFactory();
    public static final IFrameEditorUIFactory frameEditorUIFactory = new FrameEditorUIFactory();
    public static final ISEFrameChooserUIFactory seFrameChooserUIFactory = new SEFrameChooserUIFactory();
    public static final ISEDemoUIFactory seDemoUIFactory = new SEDemoUIFactory();
    public static final IPERTChartUIFactory pertChartUIFactory = new PERTChartUIFactory();
    public static final UndoManagerFactory undoManagerFactory = new UndoManagerFactory();
    public static final IPersistFactory persistenceFactory = ProjectPersister.ONLY;
    public static final CogToolSerialization serialization = CogToolSerialization.ONLY;
    public static final DelayedWorkPhase selectionPhase = new DelayedWorkPhase();
    public static final DelayedWorkPhase repaintPhase = new DelayedWorkPhase();
    public static final DelayedWorkManager delayedWorkMgr = new DelayedWorkManager();

    private CogTool() {
    }

    public static void main(String[] args) {
        if (!OSUtils.supportCogTool()) {
            System.out.println("JRE 1.4 is required to run CogTool");
            System.exit(1);
        }
        delayedWorkMgr.addDelayedWork(selectionPhase);
        delayedWorkMgr.addDelayedWork(repaintPhase);
        try {
            if (OSUtils.MACOSX) {
                new RootController();
            }
            if (args.length > 0) {
                IPersist persister = persistenceFactory.createPersistenceManager();
                for (int i = 0; i < args.length; ++i) {
                    File file = new File(args[i]);
                    IProject proj = (IProject)persister.load(file);
                    projectControllerFactory.openController(proj, false, true);
                }
            } else {
                ProjectController c = projectControllerFactory.newProjectController();
                String response = c.getInteraction().createNewOrOpenExisting();
                if (response == "CREATE") {
                    c.populateProject();
                } else if (response == "OPEN") {
                    c.openExistingProject(c.getLocation());
                    if (ControllerRegistry.ONLY.openControllerCount() > 1) {
                        c.requestClose();
                    }
                } else {
                    c.requestClose();
                }
            }
            WindowUtil.interact();
        }
        catch (Exception e) {
            CogTool.reportTopLevelException(e);
        }
        WindowUtil.globalDisplay.close();
    }

    public static void reportTopLevelException(Exception e) {
        try {
            final Shell window = new Shell(WindowUtil.globalDisplay, 2080);
            window.setText(L10N.get("UnexpectedError", "Unexpected Error"));
            GridLayout layout = new GridLayout(1, false);
            window.setLayout((Layout)layout);
            Label announcement = new Label((Composite)window, 16384);
            announcement.setText(L10N.get("ErrorHappened", "An unexpected error has occurred. Please contact CogTool support with the following information:"));
            GridData announcementLayout = new GridData();
            announcementLayout.grabExcessHorizontalSpace = true;
            announcement.setLayoutData((Object)announcementLayout);
            Text trace = new Text((Composite)window, 16394);
            StringWriter stringBuffer = new StringWriter();
            String version = CogTool.getVersion();
            stringBuffer.write(version);
            stringBuffer.write(10);
            e.printStackTrace(new PrintWriter(stringBuffer));
            System.err.println(version);
            e.printStackTrace();
            trace.setText(stringBuffer.toString());
            GridData traceLayout = new GridData();
            traceLayout.grabExcessHorizontalSpace = true;
            trace.setLayoutData((Object)traceLayout);
            Button okButton = new Button((Composite)window, 8);
            okButton.setText(L10N.get("B.Exit", "Exit CogTool"));
            okButton.setFocus();
            window.setDefaultButton(okButton);
            GridData okLayout = new GridData(64);
            okButton.setLayoutData((Object)okLayout);
            okButton.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    window.close();
                }
            });
            WindowUtil.displayAndInteract(window);
        }
        catch (Exception anotherException) {
            System.err.println("Another Exception was thrown while attending to one caught at top level. This is a bug.");
            System.err.println("\n*** The new Exception:");
            anotherException.printStackTrace();
            System.err.println("\n*** The original Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getVersion() {
        String buildTime;
        String revision;
        StringBuffer result = new StringBuffer();
        String version = System.getProperty("cogtool.version");
        if (version != null) {
            result.append(version);
        }
        if ((revision = System.getProperty("cogtool.revision")) != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(revision);
        }
        if ((buildTime = System.getProperty("cogtool.build")) != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(buildTime);
        }
        if (result.length() == 0) {
            result.append("[none specified]");
        }
        result.insert(0, L10N.get("CT.Version", "Version: "));
        return result.toString();
    }
}

