/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool;

import edu.cmu.cs.hcii.cogtool.ICogToolWorkThread;
import edu.cmu.cs.hcii.cogtool.util.ASynchronizedCancelable;
import edu.cmu.cs.hcii.cogtool.util.IEnableDisable;
import edu.cmu.cs.hcii.cogtool.util.IProgressCallback;
import edu.cmu.cs.hcii.cogtool.util.RcvrWorkThreadException;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;

public abstract class ACogToolWorkThread
extends ASynchronizedCancelable
implements ICogToolWorkThread,
Runnable {
    protected IEnableDisable disabler;
    protected IProgressCallback progressCallback = null;
    protected RcvrWorkThreadException thrownException = null;

    public ACogToolWorkThread(IEnableDisable howToDisable, IProgressCallback progressNotifier) {
        this.disabler = howToDisable;
        this.progressCallback = progressNotifier;
    }

    public ACogToolWorkThread(IEnableDisable howToDisable) {
        this(howToDisable, null);
    }

    public ACogToolWorkThread(IProgressCallback progressNotifier) {
        this(null, progressNotifier);
    }

    public ACogToolWorkThread() {
        this(null, null);
    }

    public void setDisabler(IEnableDisable howToDisable) {
        this.disabler = howToDisable;
    }

    public void setProgressCallback(IProgressCallback progressNotifier) {
        this.progressCallback = progressNotifier;
    }

    protected void doneCallback() {
        if (this.progressCallback != null) {
            this.progressCallback.dispose();
        }
    }

    public void done() {
        WindowUtil.scheduleAsynchronously(this);
    }

    public void run() {
        if (this.disabler != null) {
            this.disabler.setEnabled(false);
        }
        this.doneCallback();
    }

    public void setProgress(double progress, String status) {
        if (this.progressCallback != null) {
            this.progressCallback.updateProgress(progress, status);
        }
    }

    public void setProgress(double progress) {
        this.setProgress(progress, "");
    }

    public void setWorkException(RcvrWorkThreadException ex) {
        this.thrownException = ex;
    }

    public RcvrWorkThreadException getWorkException() {
        return this.thrownException;
    }
}

