/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;

public class SpecialOneToOneType
extends OneToOneType {
    private final String propertyName;

    public SpecialOneToOneType(String propertyName, String entityName, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName) {
        super(entityName, foreignKeyType, uniqueKeyPropertyName, true);
        this.propertyName = propertyName;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return super.getIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return super.getIdentifierOrUniqueKeyType(mapping).sqlTypes(mapping);
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return super.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeGet(rs, names, session, owner);
    }

    public String getLHSPropertyName() {
        return this.propertyName;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        EntityPersister ownerPersister = session.getFactory().getEntityPersister(session.getEntityName(owner));
        Serializable id = session.getEntityIdentifier(owner);
        boolean isPropertyNull = session.getPersistenceContext().isPropertyNull(new EntityKey(id, ownerPersister, session.getEntityMode()), this.propertyName);
        if (isPropertyNull) {
            return null;
        }
        return super.resolve(value, session, owner);
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return this.getIdentifierType(session).disassemble(value, session, owner);
        }
        if (value == null) {
            return null;
        }
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdentifierType(session).assemble(oid, session, null);
        if (this.isNotEmbedded(session)) {
            return id;
        }
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }
}

