/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public final class CacheSynchronization
implements Synchronization {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$transaction$CacheSynchronization == null ? (class$org$hibernate$transaction$CacheSynchronization = CacheSynchronization.class$("org.hibernate.transaction.CacheSynchronization")) : class$org$hibernate$transaction$CacheSynchronization));
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;
    static /* synthetic */ Class class$org$hibernate$transaction$CacheSynchronization;

    public CacheSynchronization(TransactionFactory.Context ctx, JDBCContext jdbcContext, javax.transaction.Transaction transaction, Transaction tx) {
        this.ctx = ctx;
        this.jdbcContext = jdbcContext;
        this.transaction = transaction;
        this.hibernateTransaction = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeCompletion() {
        boolean flush;
        log.trace((Object)"transaction before completion callback");
        try {
            flush = !this.ctx.isFlushModeNever() && this.ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException se) {
            log.error((Object)"could not determine transaction status", (Throwable)se);
            throw new TransactionException("could not determine transaction status in beforeCompletion()", (Exception)((Object)se));
        }
        try {
            if (flush) {
                log.trace((Object)"automatically flushing session");
                this.ctx.managedFlush();
            }
            Object var4_3 = null;
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
            if (!this.ctx.shouldAutoClose() || !this.ctx.isOpen()) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
            if (!this.ctx.shouldAutoClose() || !this.ctx.isOpen()) throw throwable;
            log.trace((Object)"automatically closing session");
            this.ctx.managedClose();
            throw throwable;
        }
        log.trace((Object)"automatically closing session");
        this.ctx.managedClose();
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("transaction after completion callback, status: " + status));
        }
        this.jdbcContext.afterTransactionCompletion(status == 3, this.hibernateTransaction);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

