/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.entry.StructuredMapCacheEntry;
import org.hibernate.cache.entry.UnstructuredCacheEntry;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectCollectionLoader;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.CompositeElementPropertyMapping;
import org.hibernate.persister.collection.ElementPropertyMapping;
import org.hibernate.persister.collection.NamedQueryCollectionInitializer;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Alias;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.Template;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractCollectionPersister
implements CollectionMetadata,
QueryableCollection {
    private final String role;
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlOrderByString;
    protected final String sqlWhereString;
    private final String sqlOrderByStringTemplate;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    protected final boolean hasWhere;
    private final int baseIndex;
    private final String nodeName;
    private final String elementNodeName;
    private final String indexNodeName;
    protected final boolean indexIsFormula;
    protected final boolean elementIsFormula;
    private final Type keyType;
    private final Type indexType;
    protected final Type elementType;
    private final Type identifierType;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementFormulaTemplates;
    protected final boolean[] elementColumnIsSettable;
    protected final String[] indexColumnAliases;
    protected final String[] elementColumnAliases;
    protected final String[] keyColumnAliases;
    protected final String identifierColumnName;
    private final String identifierColumnAlias;
    private final String unquotedIdentifierColumnName;
    protected final String qualifiedTableName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isArray;
    protected final boolean hasIndex;
    protected final boolean hasIdentifier;
    private final boolean isLazy;
    private final boolean isInverse;
    private final boolean isVersioned;
    protected final int batchSize;
    private final FetchMode fetchMode;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final Class elementClass;
    private final String entityName;
    private final Dialect dialect;
    private final SQLExceptionConverter sqlExceptionConverter;
    private final SessionFactoryImplementor factory;
    private final EntityPersister ownerPersister;
    private final IdentifierGenerator identifierGenerator;
    private final PropertyMapping elementPropertyMapping;
    private final EntityPersister elementPersister;
    private final CacheConcurrencyStrategy cache;
    private final CollectionType collectionType;
    private CollectionInitializer initializer;
    private final CacheEntryStructure cacheEntryStructure;
    private final String[] filterNames;
    private final String[] filterConditions;
    private final boolean insertCallable;
    private final boolean updateCallable;
    private final boolean deleteCallable;
    private final boolean deleteAllCallable;
    private final Serializable[] spaces;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$persister$collection$AbstractCollectionPersister == null ? (class$org$hibernate$persister$collection$AbstractCollectionPersister = AbstractCollectionPersister.class$("org.hibernate.persister.collection.AbstractCollectionPersister")) : class$org$hibernate$persister$collection$AbstractCollectionPersister));
    static /* synthetic */ Class class$org$hibernate$persister$collection$AbstractCollectionPersister;

    public AbstractCollectionPersister(Collection collection, CacheConcurrencyStrategy cache, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        this.factory = factory;
        this.cache = cache;
        this.cacheEntryStructure = factory.getSettings().isStructuredCacheEntriesEnabled() ? (collection.isMap() ? new StructuredMapCacheEntry() : new StructuredCollectionCacheEntry()) : new UnstructuredCacheEntry();
        this.dialect = factory.getDialect();
        this.sqlExceptionConverter = factory.getSQLExceptionConverter();
        this.collectionType = collection.getCollectionType();
        this.role = collection.getRole();
        this.entityName = collection.getOwnerEntityName();
        this.ownerPersister = factory.getEntityPersister(this.entityName);
        this.queryLoaderName = collection.getLoaderName();
        Alias alias = new Alias("__");
        this.nodeName = collection.getNodeName();
        Table table = collection.getCollectionTable();
        this.fetchMode = collection.getElement().getFetchMode();
        this.elementType = collection.getElement().getType();
        this.isPrimitiveArray = collection.isPrimitiveArray();
        this.isArray = collection.isArray();
        this.subselectLoadable = collection.isSubselectLoadable();
        this.qualifiedTableName = table.getQualifiedName(this.dialect, factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        int spacesSize = 1 + collection.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.qualifiedTableName;
        Iterator iter = collection.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = (String)iter.next();
        }
        this.sqlOrderByString = collection.getOrderBy();
        this.hasOrder = this.sqlOrderByString != null;
        this.sqlOrderByStringTemplate = this.hasOrder ? Template.renderOrderByStringTemplate(this.sqlOrderByString, this.dialect) : null;
        this.sqlWhereString = collection.getWhere();
        this.hasWhere = this.sqlWhereString != null;
        this.sqlWhereStringTemplate = this.hasWhere ? Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect) : null;
        this.hasOrphanDelete = collection.hasOrphanDelete();
        int batch = collection.getBatchSize();
        if (batch == -1) {
            batch = factory.getSettings().getDefaultBatchFetchSize();
        }
        this.batchSize = batch;
        this.isVersioned = collection.isOptimisticLocked();
        this.keyType = collection.getKey().getType();
        iter = collection.getKey().getColumnIterator();
        int keySpan = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        String[] keyAliases = new String[keySpan];
        int k = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.keyColumnNames[k] = col.getQuotedName(this.dialect);
            keyAliases[k] = col.getAlias();
            ++k;
        }
        this.keyColumnAliases = alias.toAliasStrings(keyAliases);
        int elementSpan = collection.getElement().getColumnSpan();
        iter = collection.getElement().getColumnIterator();
        String elemNode = collection.getElementNodeName();
        if (this.elementType.isEntityType()) {
            String entityName = ((EntityType)this.elementType).getAssociatedEntityName();
            this.elementPersister = factory.getEntityPersister(entityName);
            if (elemNode == null) {
                elemNode = cfg.getClassMapping(entityName).getNodeName();
            }
        } else {
            this.elementPersister = null;
        }
        this.elementNodeName = elemNode;
        String[] aliases = new String[elementSpan];
        this.elementColumnNames = new String[elementSpan];
        this.elementFormulaTemplates = new String[elementSpan];
        this.elementColumnIsSettable = new boolean[elementSpan];
        boolean isFormula = false;
        int j = 0;
        while (iter.hasNext()) {
            Selectable s = (Selectable)iter.next();
            aliases[j] = s.getAlias();
            if (s.isFormula()) {
                Formula form = (Formula)s;
                this.elementFormulaTemplates[j] = form.getTemplate(this.dialect);
                isFormula = true;
            } else {
                Column col = (Column)s;
                this.elementColumnNames[j] = col.getQuotedName(this.dialect);
                this.elementColumnIsSettable[j] = true;
            }
            ++j;
        }
        this.elementColumnAliases = alias.toAliasStrings(aliases);
        this.elementIsFormula = isFormula;
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedCollection = (IndexedCollection)collection;
            this.indexType = indexedCollection.getIndex().getType();
            int indexSpan = indexedCollection.getIndex().getColumnSpan();
            iter = indexedCollection.getIndex().getColumnIterator();
            this.indexColumnNames = new String[indexSpan];
            this.indexFormulaTemplates = new String[indexSpan];
            this.indexColumnIsSettable = new boolean[indexSpan];
            String[] indexAliases = new String[indexSpan];
            int i = 0;
            isFormula = false;
            while (iter.hasNext()) {
                Selectable s = (Selectable)iter.next();
                indexAliases[i] = s.getAlias();
                if (s.isFormula()) {
                    Formula indexForm = (Formula)s;
                    this.indexFormulaTemplates[i] = indexForm.getTemplate(this.dialect);
                    isFormula = true;
                } else {
                    Column indexCol = (Column)s;
                    this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                    this.indexColumnIsSettable[i] = true;
                }
                ++i;
            }
            this.indexColumnAliases = alias.toAliasStrings(indexAliases);
            this.indexIsFormula = isFormula;
            this.baseIndex = indexedCollection.isList() ? ((List)indexedCollection).getBaseIndex() : 0;
            this.indexNodeName = indexedCollection.getIndexNodeName();
        } else {
            this.indexIsFormula = false;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            this.baseIndex = 0;
            this.indexNodeName = null;
        }
        this.hasIdentifier = collection.isIdentified();
        if (this.hasIdentifier) {
            if (collection.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collection;
            this.identifierType = idColl.getIdentifier().getType();
            iter = idColl.getIdentifier().getColumnIterator();
            Column col = (Column)iter.next();
            this.identifierColumnName = col.getQuotedName(this.dialect);
            this.unquotedIdentifierColumnName = this.identifierColumnAlias = alias.toAliasString(col.getAlias());
            this.identifierGenerator = idColl.getIdentifier().createIdentifierGenerator(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName(), null);
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.unquotedIdentifierColumnName = null;
            this.identifierGenerator = null;
        }
        if (collection.getCustomSQLDeleteAll() == null) {
            this.sqlDeleteString = this.generateDeleteString();
            this.deleteAllCallable = false;
        } else {
            this.sqlDeleteString = collection.getCustomSQLDeleteAll();
            this.deleteAllCallable = collection.isCustomDeleteAllCallable();
        }
        if (collection.getCustomSQLInsert() == null) {
            this.sqlInsertRowString = this.generateInsertRowString();
            this.insertCallable = false;
        } else {
            this.sqlInsertRowString = collection.getCustomSQLInsert();
            this.insertCallable = collection.isCustomInsertCallable();
        }
        if (collection.getCustomSQLUpdate() == null) {
            this.sqlUpdateRowString = this.generateUpdateRowString();
            this.updateCallable = false;
        } else {
            this.sqlUpdateRowString = collection.getCustomSQLUpdate();
            this.updateCallable = collection.isCustomUpdateCallable();
        }
        if (collection.getCustomSQLDelete() == null) {
            this.sqlDeleteRowString = this.generateDeleteRowString();
            this.deleteCallable = false;
        } else {
            this.sqlDeleteRowString = collection.getCustomSQLDelete();
            this.deleteCallable = collection.isCustomDeleteCallable();
        }
        this.logStaticSQL();
        this.isLazy = collection.isLazy();
        this.isInverse = collection.isInverse();
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, this.elementFormulaTemplates, (AbstractComponentType)this.elementType, factory) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : (this.elementPersister instanceof PropertyMapping ? (PropertyMapping)((Object)this.elementPersister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
        int filterCount = collection.getFilterMap().size();
        this.filterNames = new String[filterCount];
        this.filterConditions = new String[filterCount];
        iter = collection.getFilterMap().entrySet().iterator();
        filterCount = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.filterNames[filterCount] = (String)entry.getKey();
            this.filterConditions[filterCount] = Template.renderWhereStringTemplate((String)entry.getValue(), "$FILTER_PLACEHOLDER$", this.dialect);
            this.filterConditions[filterCount] = StringHelper.replace(this.filterConditions[filterCount], ":", ":" + this.filterNames[filterCount] + ".");
            ++filterCount;
        }
    }

    public void postInstantiate() throws MappingException {
        this.initializer = this.queryLoaderName == null ? this.createCollectionInitializer(CollectionHelper.EMPTY_MAP) : new NamedQueryCollectionInitializer(this.queryLoaderName, this);
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Static SQL for collection: " + this.getRole()));
            if (this.getSQLInsertRowString() != null) {
                log.debug((Object)(" Row insert: " + this.getSQLInsertRowString()));
            }
            if (this.getSQLUpdateRowString() != null) {
                log.debug((Object)(" Row update: " + this.getSQLUpdateRowString()));
            }
            if (this.getSQLDeleteRowString() != null) {
                log.debug((Object)(" Row delete: " + this.getSQLDeleteRowString()));
            }
            if (this.getSQLDeleteString() != null) {
                log.debug((Object)(" One-shot delete: " + this.getSQLDeleteString()));
            }
        }
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        this.getAppropriateInitializer(key, session).initialize(key, session);
    }

    protected CollectionInitializer getAppropriateInitializer(Serializable key, SessionImplementor session) {
        if (this.queryLoaderName != null) {
            return this.initializer;
        }
        CollectionInitializer subselectInitializer = this.getSubselectInitializer(key, session);
        if (subselectInitializer != null) {
            return subselectInitializer;
        }
        if (session.getEnabledFilters().isEmpty()) {
            return this.initializer;
        }
        return this.createCollectionInitializer(session.getEnabledFilters());
    }

    private CollectionInitializer getSubselectInitializer(Serializable key, SessionImplementor session) {
        if (!this.isSubselectLoadable()) {
            return null;
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        SubselectFetch subselect = persistenceContext.getBatchFetchQueue().getSubselect(new EntityKey(key, this.getOwnerEntityPersister(), session.getEntityMode()));
        if (subselect == null) {
            return null;
        }
        Iterator iter = subselect.getResult().iterator();
        while (iter.hasNext()) {
            if (persistenceContext.containsEntity((EntityKey)iter.next())) continue;
            iter.remove();
        }
        return this.createSubselectInitializer(subselect, session);
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselect, SessionImplementor session) {
        return new SubselectCollectionLoader(this, subselect.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselect.getResult(), subselect.getQueryParameters(), session.getFactory(), session.getEnabledFilters());
    }

    protected abstract CollectionInitializer createCollectionInitializer(Map var1) throws MappingException;

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    protected String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", alias);
    }

    public String getSQLOrderByString(String alias) {
        return StringHelper.replace(this.sqlOrderByStringTemplate, "$PlaceHolder$", alias);
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    public boolean hasWhere() {
        return this.hasWhere;
    }

    protected String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    protected String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    protected String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet rs, Object owner, SessionImplementor session) throws HibernateException, SQLException {
        Object element = this.getElementType().nullSafeGet(rs, this.elementColumnAliases, session, owner);
        return element;
    }

    public Object readIndex(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object index = this.getIndexType().nullSafeGet(rs, this.indexColumnAliases, session, null);
        if (index == null) {
            throw new HibernateException("null index column for collection: " + this.role);
        }
        if (this.baseIndex != 0) {
            index = new Integer((Integer)index - this.baseIndex);
        }
        return index;
    }

    public Object readIdentifier(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object id = this.getIdentifierType().nullSafeGet(rs, this.unquotedIdentifierColumnName, session, null);
        if (id == null) {
            throw new HibernateException("null identifier column for collection: " + this.role);
        }
        return id;
    }

    public Object readKey(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        return this.getKeyType().nullSafeGet(rs, this.keyColumnAliases, session, null);
    }

    protected int writeKey(PreparedStatement st, Serializable key, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (key == null) {
            throw new NullPointerException("null key for collection: " + this.role);
        }
        this.getKeyType().nullSafeSet(st, key, i, session);
        return i + this.keyColumnAliases.length;
    }

    protected int writeElement(PreparedStatement st, Object elt, int i, SessionImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, i, this.elementColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.elementColumnIsSettable);
    }

    protected int writeIndex(PreparedStatement st, Object index, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (this.baseIndex != 0) {
            index = new Integer((Integer)index + this.baseIndex);
        }
        this.getIndexType().nullSafeSet(st, index, i, this.indexColumnIsSettable, session);
        return i + ArrayHelper.countTrue(this.indexColumnIsSettable);
    }

    protected int writeElementToWhere(PreparedStatement st, Object elt, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (this.elementIsFormula) {
            throw new AssertionFailure("cannot use a formula-based element in the where condition");
        }
        this.getElementType().nullSafeSet(st, elt, i, session);
        return i + this.elementColumnAliases.length;
    }

    protected int writeIndexToWhere(PreparedStatement st, Object index, int i, SessionImplementor session) throws HibernateException, SQLException {
        if (this.indexIsFormula) {
            throw new AssertionFailure("cannot use a formula-based index in the where condition");
        }
        if (this.baseIndex != 0) {
            index = new Integer((Integer)index + this.baseIndex);
        }
        this.getIndexType().nullSafeSet(st, index, i, session);
        return i + this.indexColumnAliases.length;
    }

    public int writeIdentifier(PreparedStatement st, Object id, int i, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(st, id, i, session);
        return i + 1;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String selectFragment(String alias) {
        int i;
        SelectFragment frag = new SelectFragment().setSuffix("").addColumns(alias, this.keyColumnNames, this.keyColumnAliases);
        for (i = 0; i < this.elementColumnIsSettable.length; ++i) {
            if (this.elementColumnIsSettable[i]) {
                frag.addColumn(alias, this.elementColumnNames[i], this.elementColumnAliases[i]);
                continue;
            }
            frag.addFormula(alias, this.elementFormulaTemplates[i], this.elementColumnAliases[i]);
        }
        if (this.hasIndex) {
            for (i = 0; i < this.indexColumnIsSettable.length; ++i) {
                if (this.indexColumnIsSettable[i]) {
                    frag.addColumn(alias, this.indexColumnNames[i], this.indexColumnAliases[i]);
                    continue;
                }
                frag.addFormula(alias, this.indexFormulaTemplates[i], this.indexColumnAliases[i]);
            }
        }
        if (this.hasIdentifier) {
            frag.addColumn(alias, this.identifierColumnName, this.identifierColumnAlias);
        }
        return frag.toFragmentString().substring(2);
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getIndexColumnNames(String alias) {
        return this.indexIsFormula ? StringHelper.replace(this.indexFormulaTemplates, "$PlaceHolder$", alias) : StringHelper.qualify(alias, this.indexColumnNames);
    }

    public String[] getElementColumnNames(String alias) {
        return this.elementIsFormula ? StringHelper.replace(this.elementFormulaTemplates, "$PlaceHolder$", alias) : StringHelper.qualify(alias, this.elementColumnNames);
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public void remove(Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory())));
            }
            try {
                int offset = 1;
                PreparedStatement st = null;
                if (this.isDeleteCallable()) {
                    CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLDeleteString());
                    callstatement.registerOutParameter(offset++, 2);
                    st = callstatement;
                } else {
                    st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
                }
                try {
                    this.writeKey(st, id, offset, session);
                    session.getBatcher().addToBatch(-1);
                }
                catch (SQLException sqle) {
                    session.getBatcher().abortBatch(sqle);
                    throw sqle;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"done deleting collection");
                }
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not delete collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLDeleteString());
            }
        }
    }

    public void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        block15: {
            if (!this.isInverse && this.isRowInsertEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory())));
                }
                try {
                    Iterator entries = collection.entries(this);
                    if (entries.hasNext()) {
                        try {
                            collection.preInsert(this);
                            int i = 0;
                            int count = 0;
                            while (entries.hasNext()) {
                                Object entry = entries.next();
                                if (collection.entryExists(entry, i)) {
                                    int offset = 1;
                                    PreparedStatement st = null;
                                    if (this.isInsertCallable()) {
                                        CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLInsertRowString());
                                        callstatement.registerOutParameter(offset++, 2);
                                        st = callstatement;
                                    } else {
                                        st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                                    }
                                    int loc = this.writeKey(st, id, offset, session);
                                    if (this.hasIdentifier) {
                                        loc = this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                                    }
                                    if (this.hasIndex) {
                                        loc = this.writeIndex(st, collection.getIndex(entry, i, this), loc, session);
                                    }
                                    loc = this.writeElement(st, collection.getElement(entry), loc, session);
                                    session.getBatcher().addToBatch(1);
                                    collection.afterRowInsert(this, entry, i);
                                    ++count;
                                }
                                ++i;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("done inserting collection: " + count + " rows inserted"));
                            }
                            break block15;
                        }
                        catch (SQLException sqle) {
                            session.getBatcher().abortBatch(sqle);
                            throw sqle;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"collection was empty");
                    }
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not insert collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLInsertRowString());
                }
            }
        }
    }

    protected boolean isRowDeleteEnabled() {
        return true;
    }

    public void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        block14: {
            if (!this.isInverse && this.isRowDeleteEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory())));
                }
                boolean deleteByIndex = !this.isOneToMany() && this.hasIndex && !this.indexIsFormula;
                try {
                    Iterator deletes = collection.getDeletes(this, !deleteByIndex);
                    if (deletes.hasNext()) {
                        int offset = 1;
                        int count = 0;
                        PreparedStatement st = null;
                        if (this.isDeleteCallable()) {
                            CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLDeleteRowString());
                            callstatement.registerOutParameter(offset++, 2);
                            st = callstatement;
                        } else {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                        }
                        try {
                            int i = 0;
                            while (deletes.hasNext()) {
                                Object entry = deletes.next();
                                int loc = offset;
                                if (this.hasIdentifier) {
                                    loc = this.writeIdentifier(st, entry, loc, session);
                                } else {
                                    loc = this.writeKey(st, id, loc, session);
                                    loc = deleteByIndex ? this.writeIndexToWhere(st, entry, loc, session) : this.writeElementToWhere(st, entry, loc, session);
                                }
                                session.getBatcher().addToBatch(-1);
                                ++count;
                                ++i;
                            }
                        }
                        catch (SQLException sqle) {
                            session.getBatcher().abortBatch(sqle);
                            throw sqle;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("done deleting collection rows: " + count + " deleted"));
                        }
                        break block14;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"no rows to delete");
                    }
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not delete collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLDeleteRowString());
                }
            }
        }
    }

    protected boolean isRowInsertEnabled() {
        return true;
    }

    public void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory())));
            }
            try {
                Iterator entries = collection.entries(this);
                boolean callable = this.isInsertCallable();
                try {
                    collection.preInsert(this);
                    int i = 0;
                    int count = 0;
                    int offset = 1;
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        PreparedStatement st = null;
                        if (collection.needsInserting(entry, i, this.elementType)) {
                            if (st == null) {
                                if (callable) {
                                    CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLInsertRowString());
                                    callstatement.registerOutParameter(offset++, 2);
                                    st = callstatement;
                                } else {
                                    st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                                }
                            }
                            int loc = this.writeKey(st, id, offset, session);
                            if (this.hasIdentifier) {
                                loc = this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                            }
                            if (this.hasIndex) {
                                loc = this.writeIndex(st, collection.getIndex(entry, i, this), loc, session);
                            }
                            loc = this.writeElement(st, collection.getElement(entry), loc, session);
                            session.getBatcher().addToBatch(1);
                            collection.afterRowInsert(this, entry, i);
                            ++count;
                        }
                        ++i;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("done inserting rows: " + count + " inserted"));
                    }
                }
                catch (SQLException sqle) {
                    session.getBatcher().abortBatch(sqle);
                    throw sqle;
                }
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqle, "could not insert collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLInsertRowString());
            }
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getOwnerEntityName() {
        return this.entityName;
    }

    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    public Type toType(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(propertyName);
    }

    public abstract boolean isManyToMany();

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.isManyToMany()) {
                throw new QueryException("index() function not supported for many-to-many association");
            }
            return StringHelper.qualify(alias, this.indexColumnNames);
        }
        return this.elementPropertyMapping.toColumns(alias, propertyName);
    }

    public String[] toColumns(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.isManyToMany()) {
                throw new QueryException("index() function not supported for many-to-many association");
            }
            return this.indexColumnNames;
        }
        return this.elementPropertyMapping.toColumns(propertyName);
    }

    public Type getType() {
        return this.elementPropertyMapping.getType();
    }

    public String getName() {
        return this.getRole();
    }

    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return (Loadable)this.elementPersister;
    }

    public boolean isCollection() {
        return true;
    }

    public Serializable[] getCollectionSpaces() {
        return this.spaces;
    }

    protected abstract String generateDeleteString();

    protected abstract String generateDeleteRowString();

    protected abstract String generateUpdateRowString();

    protected abstract String generateInsertRowString();

    public void updateRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && collection.isRowUpdatePossible()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating rows of collection: " + this.role + "#" + id));
            }
            int count = this.doUpdateRows(id, collection, session);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done updating rows: " + count + " updated"));
            }
        }
    }

    protected abstract int doUpdateRows(Serializable var1, PersistentCollection var2, SessionImplementor var3) throws HibernateException;

    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected String filterFragment(String alias) throws MappingException {
        return this.hasWhere() ? " and " + this.getSQLWhereString(alias) : "";
    }

    public String filterFragment(String alias, Map enabledFilters) throws MappingException {
        StringBuffer sessionFilterFragment = new StringBuffer();
        if (this.getFilterNames() != null && this.getFilterNames().length > 0) {
            int max = this.getFilterNames().length;
            for (int i = 0; i < max; ++i) {
                String condition;
                if (!enabledFilters.containsKey(this.getFilterNames()[i]) || !StringHelper.isNotEmpty(condition = this.getFilterConditions()[i])) continue;
                sessionFilterFragment.append(" and ").append(StringHelper.replace(condition, "$FILTER_PLACEHOLDER$", alias));
            }
        }
        return sessionFilterFragment.append(this.filterFragment(alias)).toString();
    }

    public String oneToManyFilterFragment(String alias) throws MappingException {
        return "";
    }

    protected boolean isInsertCallable() {
        return this.insertCallable;
    }

    protected boolean isUpdateCallable() {
        return this.updateCallable;
    }

    protected boolean isDeleteCallable() {
        return this.deleteCallable;
    }

    protected boolean isDeleteAllCallable() {
        return this.deleteAllCallable;
    }

    protected String[] getFilterNames() {
        return this.filterNames;
    }

    protected String[] getFilterConditions() {
        return this.filterConditions;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.role + ')';
    }

    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getElementNodeName() {
        return this.elementNodeName;
    }

    public String getIndexNodeName() {
        return this.indexNodeName;
    }

    protected SQLExceptionConverter getSQLExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    public boolean isAffectedByEnabledFilters(SessionImplementor session) {
        Map enabledFilters = session.getEnabledFilters();
        int max = this.filterNames.length;
        for (int i = 0; i < max; ++i) {
            if (!enabledFilters.containsKey(this.filterNames[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

