/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.ArrayHelper;

public abstract class AbstractEntityLoader
extends OuterJoinLoader {
    private final OuterJoinLoadable persister;
    private CollectionPersister collectionPersister;
    private int collectionOwner;
    private String alias;
    private String[] aliases;

    protected String[] getAliases() {
        return this.aliases;
    }

    public AbstractEntityLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, Map enabledFilters) {
        super(factory, enabledFilters);
        this.persister = persister;
        this.alias = this.generateRootAlias(persister.getEntityName());
    }

    protected final void initAll(String whereString, String orderByString, LockMode lockMode) throws MappingException {
        List associations = this.walkEntityTree(this.persister, this.getAlias());
        this.initPersisters(associations, lockMode);
        this.initStatementString(associations, whereString, orderByString, lockMode);
    }

    protected final void initProjection(String projectionString, String whereString, String orderByString, String groupByString, LockMode lockMode) throws MappingException {
        List associations = this.walkEntityTree(this.persister, this.getAlias());
        this.persisters = new Loadable[0];
        this.initStatementString(associations, projectionString, whereString, orderByString, groupByString, lockMode);
    }

    private void initPersisters(List associations, LockMode lockMode) throws MappingException {
        int joins = AbstractEntityLoader.countEntityPersisters(associations);
        this.collectionOwner = -1;
        this.persisters = new Loadable[joins + 1];
        this.aliases = new String[joins + 1];
        this.owners = new int[joins + 1];
        this.ownerAssociationType = new AssociationType[joins + 1];
        this.lockModeArray = ArrayHelper.fillArray(lockMode, joins + 1);
        int i = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            if (!oj.isCollection()) {
                this.persisters[i] = (Loadable)((Object)oj.getJoinable());
                this.aliases[i] = oj.getRHSAlias();
                this.owners[i] = oj.getOwner(associations);
                this.ownerAssociationType[i] = oj.getJoinableType();
                ++i;
                continue;
            }
            QueryableCollection collPersister = (QueryableCollection)oj.getJoinable();
            if (oj.getJoinType() == 1) {
                this.collectionPersister = collPersister;
                this.collectionOwner = oj.getOwner(associations);
            }
            if (!collPersister.isOneToMany()) continue;
            this.persisters[i] = (Loadable)collPersister.getElementPersister();
            this.aliases[i] = oj.getRHSAlias();
            ++i;
        }
        this.persisters[joins] = this.persister;
        this.owners[joins] = -1;
        this.aliases[joins] = this.alias;
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    private void initStatementString(List associations, String condition, String orderBy, LockMode lockMode) throws MappingException {
        this.initStatementString(associations, null, condition, orderBy, "", lockMode);
    }

    private void initStatementString(List associations, String projection, String condition, String orderBy, String groupBy, LockMode lockMode) throws MappingException {
        int joins = AbstractEntityLoader.countEntityPersisters(associations);
        this.suffixes = AbstractEntityLoader.generateSuffixes(joins + 1);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setLockMode(lockMode).setSelectClause(projection == null ? this.persister.selectFragment(this.alias, this.suffixes[joins]) + this.selectString(associations) : projection).setFromClause(this.persister.fromTableFragment(this.alias) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(orderBy).setGroupByClause(groupBy);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        this.sql = select.toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected final Loadable getPersister() {
        return this.persister;
    }

    protected final String getAlias() {
        return this.alias;
    }

    protected final CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected final int getCollectionOwner() {
        return this.collectionOwner;
    }

    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config) {
        return this.isJoinedFetchEnabledInMapping(config, type);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }

    public abstract String getComment();
}

