/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.QueryNode;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.SyntheticAndFactory;
import org.hibernate.sql.JoinFragment;
import org.hibernate.util.StringHelper;

class JoinProcessor
implements SqlTokenTypes {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$JoinProcessor == null ? (class$org$hibernate$hql$ast$JoinProcessor = JoinProcessor.class$("org.hibernate.hql.ast.JoinProcessor")) : class$org$hibernate$hql$ast$JoinProcessor));
    private QueryTranslatorImpl queryTranslatorImpl;
    private SyntheticAndFactory andFactory;
    static /* synthetic */ Class class$org$hibernate$hql$ast$JoinProcessor;

    public JoinProcessor(ASTFactory astFactory, QueryTranslatorImpl queryTranslatorImpl) {
        this.andFactory = new SyntheticAndFactory(astFactory);
        this.queryTranslatorImpl = queryTranslatorImpl;
    }

    public static int toHibernateJoinType(int astJoinType) {
        switch (astJoinType) {
            case 119: {
                return 1;
            }
            case 28: {
                return 0;
            }
            case 120: {
                return 2;
            }
        }
        throw new AssertionFailure("undefined join type " + astJoinType);
    }

    void processJoins(QueryNode query) {
        final FromClause fromClause = query.getFromClause();
        ArrayList orderedFromElements = new ArrayList();
        ListIterator liter = fromClause.getFromElements().listIterator(fromClause.getFromElements().size());
        while (liter.hasPrevious()) {
            orderedFromElements.add(liter.previous());
        }
        Iterator iter = orderedFromElements.iterator();
        while (iter.hasNext()) {
            final FromElement fromElement = (FromElement)iter.next();
            JoinSequence join = fromElement.getJoinSequence();
            join.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String alias) {
                    boolean shallowQuery = JoinProcessor.this.queryTranslatorImpl.isShallowQuery();
                    boolean containsTableAlias = fromClause.containsTableAlias(alias);
                    boolean includeSubclasses = fromElement.isIncludeSubclasses();
                    boolean subQuery = fromClause.isSubQuery();
                    boolean include = includeSubclasses && containsTableAlias && !subQuery && !shallowQuery;
                    return include;
                }
            });
            this.addJoinNodes(query, join, fromElement);
        }
    }

    private void addJoinNodes(QueryNode query, JoinSequence join, FromElement fromElement) {
        JoinFragment joinFragment = join.toJoinFragment(query.isDML() ? Collections.EMPTY_MAP : this.queryTranslatorImpl.getEnabledFilters(), fromElement.useFromFragment());
        String frag = joinFragment.toFromFragmentString();
        String whereFrag = joinFragment.toWhereFragmentString();
        if (fromElement.getType() == 117 && (join.isThetaStyle() || StringHelper.isNotEmpty(whereFrag))) {
            fromElement.setType(115);
        }
        if (fromElement.useFromFragment()) {
            String fromFragment = this.processFromFragment(frag, join);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using FROM fragment [" + fromFragment + "]"));
            }
            fromElement.setText(fromFragment.trim());
        }
        this.andFactory.addWhereFragment(joinFragment, whereFrag, query, fromElement);
    }

    private String processFromFragment(String frag, JoinSequence join) {
        String fromFragment = frag.trim();
        if (fromFragment.startsWith(", ")) {
            fromFragment = fromFragment.substring(2);
        }
        if (join.getJoinCount() > 1 && fromFragment.indexOf(44) >= 0) {
            String[] froms = StringHelper.split(",", fromFragment);
            StringBuffer buf = new StringBuffer();
            for (int i = froms.length - 1; i >= 0; --i) {
                buf.append(froms[i]);
                if (i <= 0) continue;
                buf.append(", ");
            }
            fromFragment = buf.toString();
        }
        return fromFragment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

