/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.ColumnHelper;
import org.hibernate.hql.ast.DisplayableNode;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.FromElementFactory;
import org.hibernate.hql.ast.FromReferenceNode;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.hql.ast.SqlNode;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

class DotNode
extends FromReferenceNode
implements DisplayableNode,
SelectExpression {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$DotNode == null ? (class$org$hibernate$hql$ast$DotNode = DotNode.class$("org.hibernate.hql.ast.DotNode")) : class$org$hibernate$hql$ast$DotNode));
    private static final int DEREF_UNKNOWN = 0;
    private static final int DEREF_ENTITY = 1;
    private static final int DEREF_COMPONENT = 2;
    private static final int DEREF_COLLECTION = 3;
    private static final int DEREF_PRIMITIVE = 4;
    private static final int DEREF_IDENTIFIER = 5;
    private static final int DEREF_JAVA_CONSTANT = 6;
    private String propertyName;
    private String path;
    private String propertyPath;
    private String[] columns;
    private int joinType = 0;
    private boolean fetch = false;
    private int dereferenceType = 0;
    private FromElement impliedJoin;
    static /* synthetic */ Class class$org$hibernate$hql$ast$DotNode;

    DotNode() {
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    private String[] getColumns() throws QueryException {
        if (this.columns == null) {
            String tableAlias = this.getLhs().getFromElement().getTableAlias();
            this.columns = this.getFromElement().toColumns(tableAlias, this.propertyPath, false);
        }
        return this.columns;
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        FromElement fromElement = this.getFromElement();
        buf.append("{propertyName=").append(this.propertyName);
        buf.append(",dereferenceType=").append(ASTPrinter.getConstantName(this.getClass(), this.dereferenceType));
        buf.append(",propertyPath=").append(this.propertyPath);
        buf.append(",path=").append(this.getPath());
        if (fromElement != null) {
            buf.append(",tableAlias=").append(fromElement.getTableAlias());
            buf.append(",className=").append(fromElement.getClassName());
            buf.append(",classAlias=").append(fromElement.getClassAlias());
        } else {
            buf.append(",no from element");
        }
        buf.append('}');
        return buf.toString();
    }

    public void resolveFirstChild() throws SemanticException {
        String propName;
        FromReferenceNode lhs = (FromReferenceNode)this.getFirstChild();
        SqlNode property = (SqlNode)lhs.getNextSibling();
        this.propertyName = propName = property.getText();
        if (this.propertyPath == null) {
            this.propertyPath = propName;
        }
        lhs.resolve(true, true, null, (AST)this);
        this.setFromElement(lhs.getFromElement());
    }

    public void resolveInFunctionCall(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        if (propertyType != null && propertyType.isCollectionType()) {
            this.resolveIndex(null);
        } else {
            this.resolveFirstChild();
            super.resolve(generateJoin, implicitJoin);
        }
    }

    public void resolveIndex(AST parent) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        this.dereferenceCollection((CollectionType)propertyType, true, true, null, parent);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias, AST parent) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type propertyType = this.prepareLhs();
        if (propertyType == null) {
            if (parent == null) {
                this.getWalker().getLiteralProcessor().lookupConstant(this);
            }
            return;
        }
        if (propertyType.isComponentType()) {
            this.dereferenceComponent(parent);
            this.initText();
        } else if (propertyType.isEntityType()) {
            this.dereferenceEntity((EntityType)propertyType, implicitJoin, classAlias, generateJoin, parent);
            this.initText();
        } else if (propertyType.isCollectionType()) {
            this.dereferenceCollection((CollectionType)propertyType, implicitJoin, false, classAlias, parent);
        } else {
            this.dereferenceType = 4;
            this.initText();
        }
        this.setResolved();
    }

    private void initText() {
        this.setText(StringHelper.join(", ", this.getColumns()));
    }

    private Type prepareLhs() throws SemanticException {
        FromReferenceNode lhs = this.getLhs();
        lhs.prepareForDot(this.propertyName);
        Type propertyType = this.getDataType();
        return propertyType;
    }

    private void dereferenceCollection(CollectionType collectionType, boolean implicitJoin, boolean indexed, String classAlias, AST parent) throws SemanticException {
        EntityPersister entityPersister;
        this.dereferenceType = 3;
        String role = collectionType.getRole();
        QueryableCollection queryableCollection = this.getSessionFactoryHelper().requireQueryableCollection(role);
        String propName = this.getPath();
        FromClause currentFromClause = this.getWalker().getCurrentFromClause();
        FromElementFactory factory = new FromElementFactory(currentFromClause, this.getLhs().getFromElement(), propName, classAlias, this.getColumns(), implicitJoin);
        FromElement elem = factory.createCollection(queryableCollection, role, this.joinType, this.fetch, indexed);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceCollection() : Created new FROM element for " + propName + " : " + elem));
        }
        this.setImpliedJoin(elem);
        this.setFromElement(elem);
        if (!implicitJoin && (entityPersister = elem.getEntityPersister()) != null) {
            this.getWalker().addQuerySpaces(entityPersister.getQuerySpaces());
        }
        this.getWalker().addQuerySpaces(queryableCollection.getCollectionSpaces());
    }

    private void dereferenceEntity(EntityType entityType, boolean implicitJoin, String classAlias, boolean generateJoin, AST parent) throws SemanticException {
        boolean joinIsNotNeeded;
        this.checkForCorrelatedSubquery("dereferenceEntity");
        if (this.unresolvedComponent(generateJoin)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dereferenceEntity() : resolving unresolved component '" + this.propertyPath + "' ... "));
            }
            this.dereferenceEntityJoin(classAlias, entityType, implicitJoin, parent);
            return;
        }
        String property = this.propertyName;
        DotNode dotParent = null;
        if (this.isDotNode(parent)) {
            dotParent = (DotNode)parent;
            property = dotParent.propertyName;
        }
        boolean bl = joinIsNotNeeded = this.isPrimaryKeyReference(property, entityType) || this.isNamedIdPropertyShortcut(entityType, property) || !generateJoin;
        if (joinIsNotNeeded) {
            this.dereferenceEntityIdentifier(property, dotParent);
        } else {
            this.dereferenceEntityJoin(classAlias, entityType, implicitJoin, parent);
        }
    }

    private boolean unresolvedComponent(boolean generateJoin) {
        AST c = this.getFirstChild();
        if (generateJoin && this.isDotNode(c)) {
            DotNode dot = (DotNode)c;
            if ((dot.dereferenceType == 2 || dot.dereferenceType == 5) && StringHelper.isNotEmpty(this.propertyPath)) {
                return true;
            }
        }
        return false;
    }

    private boolean isDotNode(AST n) {
        return n != null && n.getType() == 15;
    }

    private void dereferenceEntityJoin(String classAlias, EntityType propertyType, boolean impliedJoin, AST parent) throws SemanticException {
        this.dereferenceType = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceEntityJoin() : generating join for " + this.propertyName + " in " + this.getFromElement().getClassName() + " " + (classAlias == null ? "{no alias}" : "(" + classAlias + ")") + " parent = " + ASTUtil.getDebugString(parent)));
        }
        String associatedEntityName = propertyType.getAssociatedEntityName();
        String tableAlias = this.getAliasGenerator().createName(associatedEntityName);
        String[] joinColumns = this.getColumns();
        String joinPath = this.getPath();
        if (impliedJoin && this.getWalker().isInFrom()) {
            int impliedJoinType;
            this.joinType = impliedJoinType = this.getWalker().getImpliedJoinType();
        }
        FromClause currentFromClause = this.getWalker().getCurrentFromClause();
        FromElement elem = null;
        elem = currentFromClause.findJoinByPath(joinPath);
        if (elem == null) {
            JoinSequence joinSequence = this.getSessionFactoryHelper().createJoinSequence(impliedJoin, propertyType, tableAlias, this.joinType, joinColumns);
            FromElementFactory factory = new FromElementFactory(currentFromClause, this.getLhs().getFromElement(), joinPath, classAlias, joinColumns, impliedJoin);
            elem = factory.createEntityJoin(associatedEntityName, tableAlias, joinSequence, this.fetch, this.getWalker().isInFrom(), propertyType);
        } else {
            currentFromClause.addDuplicateAlias(classAlias, elem);
        }
        this.setImpliedJoin(elem);
        this.getWalker().addQuerySpaces(elem.getEntityPersister().getQuerySpaces());
        this.setFromElement(elem);
    }

    private void setImpliedJoin(FromElement elem) {
        DotNode dotLhs;
        this.impliedJoin = elem;
        if (this.getFirstChild().getType() == 15 && (dotLhs = (DotNode)this.getFirstChild()).getImpliedJoin() != null) {
            this.impliedJoin = dotLhs.getImpliedJoin();
        }
    }

    FromElement getImpliedJoin() {
        return this.impliedJoin;
    }

    private boolean isPrimaryKeyReference(String property, EntityType propertyType) {
        boolean isIdShortcut = "id".equals(property) && propertyType.isReferenceToPrimaryKey();
        return isIdShortcut;
    }

    private boolean isNamedIdPropertyShortcut(EntityType propertyType, String property) {
        String idPropertyName = this.getSessionFactoryHelper().getIdentifierOrUniqueKeyPropertyName(propertyType);
        boolean isNamedIdPropertyShortcut = idPropertyName != null && idPropertyName.equals(property);
        return isNamedIdPropertyShortcut;
    }

    private void checkForCorrelatedSubquery(String methodName) {
        if (this.isCorrelatedSubselect() && log.isDebugEnabled()) {
            log.debug((Object)(methodName + "() : correlated subquery"));
        }
    }

    private boolean isCorrelatedSubselect() {
        return this.getWalker().isSubQuery() && this.getFromElement().getFromClause() != this.getWalker().getCurrentFromClause();
    }

    private void dereferenceComponent(AST parent) {
        this.dereferenceType = 2;
        this.setPropertyNameAndPath(parent);
    }

    private void dereferenceEntityIdentifier(String propertyName, DotNode dotParent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("dereferenceShortcut() : property " + propertyName + " in " + this.getFromElement().getClassName() + " does not require a join."));
        }
        this.initText();
        this.setPropertyNameAndPath((AST)dotParent);
        if (dotParent != null) {
            dotParent.dereferenceType = 5;
            dotParent.setText(this.getText());
            dotParent.columns = this.getColumns();
        }
    }

    private void setPropertyNameAndPath(AST parent) {
        if (this.isDotNode(parent)) {
            DotNode dotNode = (DotNode)parent;
            AST lhs = dotNode.getFirstChild();
            AST rhs = lhs.getNextSibling();
            this.propertyName = rhs.getText();
            dotNode.propertyPath = this.propertyPath = this.propertyPath + "." + this.propertyName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unresolved property path is now '" + dotNode.propertyPath + "'"));
            }
        } else {
            AST lhs = this.getFirstChild();
            AST rhs = lhs.getNextSibling();
            this.propertyPath = rhs.getText();
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            FromElement fromElement = this.getLhs().getFromElement();
            if (fromElement == null) {
                return null;
            }
            Type propertyType = fromElement.getPropertyType(this.propertyName, this.propertyPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDataType() : " + this.propertyPath + " -> " + propertyType));
            }
            super.setDataType(propertyType);
        }
        return super.getDataType();
    }

    void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    FromReferenceNode getLhs() {
        FromReferenceNode lhs = (FromReferenceNode)this.getFirstChild();
        if (lhs == null) {
            throw new IllegalStateException("DOT node with no left-hand-side!");
        }
        return lhs;
    }

    public String getPath() {
        if (this.path == null) {
            FromReferenceNode lhs = this.getLhs();
            if (lhs == null) {
                this.path = this.getText();
            } else {
                SqlNode rhs = (SqlNode)lhs.getNextSibling();
                this.path = lhs.getPath() + "." + rhs.getOriginalText();
            }
        }
        return this.path;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public void setScalarColumnText(int i) throws SemanticException {
        String[] sqlColumns = this.getColumns();
        ColumnHelper.generateScalarColumns(this, sqlColumns, i);
    }

    public void resolveSelectExpression(boolean useThetaStyleImplicitJoins) throws SemanticException {
        if (this.getWalker().isShallowQuery() || this.getWalker().getCurrentFromClause().isSubQuery()) {
            this.resolve(false, true);
        } else {
            this.resolve(true, false);
            Type type = this.getDataType();
            if (type.isEntityType()) {
                FromElement fromElement = this.getFromElement();
                fromElement.setIncludeSubclasses(true);
                if (useThetaStyleImplicitJoins) {
                    fromElement.getJoinSequence().setUseThetaStyle(true);
                    FromElement origin = fromElement.getOrigin();
                    if (origin != null) {
                        ASTUtil.makeSiblingOfParent((AST)origin, (AST)fromElement);
                    }
                }
            }
        }
    }

    public void setResolvedConstant(String text) {
        this.path = text;
        this.dereferenceType = 6;
        this.setResolved();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

