/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class ProjectionList
implements Projection {
    private List elements = new ArrayList();

    protected ProjectionList() {
    }

    public ProjectionList create() {
        return new ProjectionList();
    }

    public ProjectionList add(Projection proj) {
        this.elements.add(proj);
        return this;
    }

    public ProjectionList add(Projection projection, String alias) {
        return this.add(Projections.alias(projection, alias));
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList types = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] elemTypes = this.getProjection(i).getTypes(criteria, criteriaQuery);
            ArrayHelper.addAll(types, elemTypes);
        }
        return ArrayHelper.toTypeArray(types);
    }

    public String toSqlString(Criteria criteria, int loc, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            Projection proj = this.getProjection(i);
            buf.append(proj.toSqlString(criteria, loc, criteriaQuery));
            loc += proj.getColumnAliases(loc).length;
            if (i >= this.elements.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            Projection proj = this.getProjection(i);
            if (!proj.isGrouped()) continue;
            buf.append(proj.toGroupSqlString(criteria, criteriaQuery));
            if (i >= this.elements.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String[] getColumnAliases(int loc) {
        ArrayList result = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] colAliases = this.getProjection(i).getColumnAliases(loc);
            ArrayHelper.addAll(result, colAliases);
            loc += colAliases.length;
        }
        return ArrayHelper.toStringArray(result);
    }

    public String[] getColumnAliases(String alias, int loc) {
        for (int i = 0; i < this.getLength(); ++i) {
            String[] result = this.getProjection(i).getColumnAliases(alias, loc);
            if (result != null) {
                return result;
            }
            loc += this.getProjection(i).getColumnAliases(loc).length;
        }
        return null;
    }

    public Type[] getTypes(String alias, Criteria criteria, CriteriaQuery criteriaQuery) {
        for (int i = 0; i < this.getLength(); ++i) {
            Type[] result = this.getProjection(i).getTypes(alias, criteria, criteriaQuery);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String[] getAliases() {
        ArrayList result = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] aliases = this.getProjection(i).getAliases();
            ArrayHelper.addAll(result, aliases);
        }
        return ArrayHelper.toStringArray(result);
    }

    public Projection getProjection(int i) {
        return (Projection)this.elements.get(i);
    }

    public int getLength() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean isGrouped() {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.getProjection(i).isGrouped()) continue;
            return true;
        }
        return false;
    }
}

