/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    int exitstatus = -1;
    int reply = 0;
    Session session;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Channel getChannel(int n, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Channel channel = (Channel)pool.elementAt(i);
                if (channel.id != n || channel.session != session) continue;
                return channel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel channel) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int n) {
        this.recipient = n;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        block8: {
            if (!this.isConnected()) {
                throw new JSchException("session is down");
            }
            try {
                int n;
                Buffer buffer = new Buffer(100);
                Packet packet = new Packet(buffer);
                packet.reset();
                buffer.putByte((byte)90);
                buffer.putString(this.type);
                buffer.putInt(this.id);
                buffer.putInt(this.lwsize);
                buffer.putInt(this.lmpsize);
                this.session.write(packet);
                for (n = 1000; this.getRecipient() == -1 && this.session.isConnected() && n > 0; --n) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (n == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.start();
            }
            catch (Exception exception) {
                if (!(exception instanceof JSchException)) break block8;
                throw (JSchException)exception;
            }
        }
    }

    public void setXForwarding(boolean bl) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream);
    }

    public void setExtOutputStream(OutputStream outputStream) {
        this.io.setExtOutputStream(outputStream);
    }

    public InputStream getInputStream() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        this.io.setOutputStream(new PassiveOutputStream(pipedInputStream));
        return pipedInputStream;
    }

    public InputStream getExtInputStream() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        this.io.setExtOutputStream(new PassiveOutputStream(pipedInputStream));
        return pipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        this.io.setInputStream(new PassiveInputStream(pipedOutputStream));
        return pipedOutputStream;
    }

    void setLocalWindowSizeMax(int n) {
        this.lwsize_max = n;
    }

    void setLocalWindowSize(int n) {
        this.lwsize = n;
    }

    void setLocalPacketSize(int n) {
        this.lmpsize = n;
    }

    void setRemoteWindowSize(int n) {
        this.rwsize = n;
    }

    void addRemoteWindowSize(int n) {
        this.rwsize += n;
    }

    void setRemotePacketSize(int n) {
        this.rmpsize = n;
    }

    public void run() {
    }

    void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.io.out != null) {
            this.io.put(byArray, n, n2);
        }
    }

    void write_ext(byte[] byArray, int n, int n2) throws IOException {
        if (this.io.out_ext != null) {
            this.io.put_ext(byArray, n, n2);
        }
    }

    void eof() {
        if (this.eof_local || this.close) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isConnected()) {
            this.disconnect();
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void eof(Session session) {
        Channel[] channelArray = null;
        int n = 0;
        Vector vector = pool;
        synchronized (vector) {
            channelArray = new Channel[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                try {
                    Channel channel = (Channel)pool.elementAt(i);
                    if (channel.session != session) continue;
                    channelArray[n++] = channel;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            channelArray[i].eof();
        }
    }

    public void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
        this.session = null;
    }

    public void disconnect() {
        block8: {
            this.close();
            this.thread = null;
            try {
                if (this.io == null) break block8;
                try {
                    if (this.io.in != null && this.io.in instanceof PassiveInputStream) {
                        this.io.in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.io.out != null && this.io.out instanceof PassiveOutputStream) {
                        this.io.out.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.io = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected();
        }
        return false;
    }

    public void sendSignal(String string) throws Exception {
        RequestSignal requestSignal = new RequestSignal();
        requestSignal.setSignal(string);
        requestSignal.request(this.session, this);
    }

    void setExitStatus(int n) {
        this.exitstatus = n;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream pipedInputStream) throws IOException {
            super(pipedInputStream);
        }
    }

    class PassiveInputStream
    extends PipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.out = pipedOutputStream;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }
}

