;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Authors     : Konstantine Prevas, Alex Eiser, Peter Centgraf
;;; Address     : Carnegie Mellon University
;;;             : Human-Computer Interaction Institute
;;;             : Pittsburgh, PA 15217
;;;             : centgraf@cmu.edu
;;;
;;; Copyright   : (c)2004-2005 Carnegie Mellon University
;;; Availability: Covered by the GNU LGPL, see LGPL.txt
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;;;
;;; Filename    : cogtool-movement.lisp
;;; Version     : 1.0
;;; 
;;; Description : New ACT-R movement styles used by CogTool.
;;;
;;; unknown       Gus Prevas
;;;             : Initial implementation.
;;;
;;; 2005-06-07    Peter Centgraf
;;;             : Moved all movement styles here from act-simple.lisp, etc.
;;;             : and added this documentation block.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Why is this overriding standard ACT-R behavior?
(defmethod feat-differences ((move1 movement-style) (move2 movement-style))
  0)
  
;;; "drag" movement style

(defstyle drag ())

(defmethod compute-exec-time ((mtr-mod motor-module) (self drag))
  (+ (init-time mtr-mod) 1.1))

(defmethod queue-output-events ((mtr-mod motor-module) (self drag))
  t)

(push '(drag (:motor drag)) *rhs-pm-calls*)


;;; movement style for a single graffiti gesture

(defstyle graffiti-gesture () key)

(defmethod compute-exec-time ((mtr-mod motor-module) (self graffiti-gesture))
  (+ (init-time mtr-mod) .580))

;;; NOTE for Alex: :DEVICE indicates that :DEVICE is a value for DEVICE in the
;;; slot, and not a named parameter like :where or :command.
(defmethod queue-output-events ((mtr-mod motor-module) (self graffiti-gesture))
  (queue-command
   :where :DEVICE :command 'OUTPUT-GRAFFITI :time (exec-time self)
   :params (key self)))
      
(defgeneric output-graffiti (devin key)
  (:documentation  "Request that the device register a graffiti output for the  given key."))

(defmethod output-graffiti ((devin device-interface) key)
    (if (eq key 'mouse)
      () ;;; Check to see if the key is actually gesturable.
      (device-handle-graffiti (device devin) key)))
   
(defgeneric device-handle-graffiti (device key)
  (:documentation  "Handle the graffiti entry of the given key."))

;; This is defined so that an error is created on call. Subclasses should implement this function
(defmethod device-handle-graffiti (device key)
  (declare (ignore key))
  (error "No method defined for DEVICE-HANDLE-GRAFFITI for object ~S." device))

(push '(graffiti-gesture (:motor graffiti-gesture) (key :key)) *rhs-pm-calls*)

(add-dm-fct '((drag isa motor-command) (drag isa chunk)
              (graffiti-gesture isa motor-command) (graffiti-gesture isa chunk))
            :reset-ia nil
)
