/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Vector;

public class ValueIteration
implements Algorithms {
    private double precision;
    private boolean converged;
    private double pjog;
    private final int pathCost = 1;
    private Maze myMaze;
    private ValueFunction currValues;
    private ValueFunction prevValues;
    private int[][] policy;
    private int iters;
    private long timeTaken;

    public ValueIteration(Maze _maze, double _pjog, double convError) {
        this.myMaze = _maze;
        this.pjog = _pjog;
        this.precision = convError;
        this.currValues = new ValueFunction(this.myMaze.width, this.myMaze.height);
        this.prevValues = new ValueFunction(this.myMaze.width, this.myMaze.height);
        this.policy = new int[this.myMaze.width][this.myMaze.height];
        this.initialize();
    }

    public void initialize() {
        this.converged = false;
        this.iters = 0;
        this.timeTaken = 0L;
        this.currValues.initialize();
        this.prevValues.initialize();
        int i = 0;
        while (i < this.myMaze.width) {
            int j = 0;
            while (j < this.myMaze.height) {
                this.policy[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void setProperty(int name, String value) {
        if (name == Properties.PJOG) {
            this.pjog = Double.parseDouble(value);
        } else if (name == Properties.ConvergenceError) {
            this.precision = Double.parseDouble(value);
        }
    }

    public int getNumOfIters() {
        return this.iters;
    }

    public void execute(int numIters) {
        int iter = 0;
        while (iter < numIters) {
            this.step();
            ++iter;
        }
    }

    public ValueFunction getValueFunction() {
        return this.prevValues;
    }

    public int[][] getPolicy() {
        return this.policy;
    }

    public boolean step() {
        int j;
        long startTime = new Date().getTime();
        double maxDelta = 0.0;
        if (this.converged) {
            long endTime = new Date().getTime();
            this.timeTaken += endTime - startTime;
            return true;
        }
        int i = 0;
        while (i < this.myMaze.width) {
            j = 0;
            while (j < this.myMaze.height) {
                double minV = 2.147483647E9;
                State currState = new State(i, j);
                if (this.myMaze.goals.contains(currState)) {
                    this.currValues.stateValue[i][j] = 0.0;
                    this.policy[i][j] = -1;
                } else {
                    Vector allNext = new Vector(this.myMaze.getSuccessors(currState));
                    int a = 0;
                    while (a < 4) {
                        State desiredNextState = Action.performAction(currState, a);
                        double value = 0.0;
                        int m = 0;
                        while (m < allNext.size()) {
                            State s = (State)allNext.get(m);
                            double prob = !desiredNextState.equals(s) ? this.pjog / 3.0 : 1.0 - this.pjog;
                            double safe = this.myMaze.isValidTransition(currState, s) ? this.prevValues.stateValue[s.x][s.y] : this.myMaze.getReward(currState, s) + this.prevValues.stateValue[i][j];
                            value += prob * safe;
                            ++m;
                        }
                        if (minV > (value += 1.0)) {
                            minV = value;
                            this.policy[i][j] = a;
                        }
                        ++a;
                    }
                    this.currValues.stateValue[i][j] = minV;
                    double delta = Math.abs(this.currValues.stateValue[i][j] - this.prevValues.stateValue[i][j]);
                    maxDelta = maxDelta < delta ? delta : maxDelta;
                }
                ++j;
            }
            ++i;
        }
        this.converged = maxDelta < this.precision;
        i = 0;
        while (i < this.myMaze.width) {
            j = 0;
            while (j < this.myMaze.height) {
                this.prevValues.stateValue[i][j] = this.currValues.stateValue[i][j];
                ++j;
            }
            ++i;
        }
        this.currValues.initialize();
        ++this.iters;
        long endTime = new Date().getTime();
        this.timeTaken += endTime - startTime;
        return this.converged;
    }

    public long getTime() {
        return this.timeTaken;
    }

    void displayValues(double[][] val, int[][] policy) {
        Utility.show("Curr values are");
        int i = this.myMaze.height - 1;
        while (i >= 0) {
            int j = 0;
            while (j < this.myMaze.width) {
                System.out.print(String.valueOf((int)Utility.dec3(val[j][i])) + " ");
                switch (policy[j][i]) {
                    case 0: {
                        System.out.print("^");
                        break;
                    }
                    case 2: {
                        System.out.print("v");
                        break;
                    }
                    case 3: {
                        System.out.print("<");
                        break;
                    }
                    case 1: {
                        System.out.print(">");
                    }
                }
                System.out.print("\t");
                ++j;
            }
            Utility.show();
            --i;
        }
    }

    void printNextStates(Vector next) {
        State s = new State(0, 0);
        int i = 0;
        while (i < next.size()) {
            s = (State)next.get(i);
            System.out.print(String.valueOf(s.x) + "," + s.y + " ");
            ++i;
        }
    }

    static class Properties {
        public static int PJOG = 1;
        public static int ConvergenceError = 2;

        Properties() {
        }
    }
}

