/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Vector;

public class PolicyIteration
implements Algorithms {
    private double precision;
    private boolean converged;
    private int[][] currPolicy;
    private Maze myMaze;
    private double pjog;
    private ValueFunction currValues;
    private ValueFunction prevValues;
    private int iters;
    private long timeTaken;
    private int valueIters;
    private static int MAX_VALUE_ITERS;
    private static int MAX_VALUE_ALLOWED;

    public PolicyIteration(Maze _maze, double _pjog, double convError, int valueFuncLimit, int iterLimit) {
        this.myMaze = _maze;
        this.pjog = _pjog;
        MAX_VALUE_ALLOWED = valueFuncLimit;
        MAX_VALUE_ITERS = iterLimit;
        this.currValues = new ValueFunction(this.myMaze.width, this.myMaze.height);
        this.prevValues = new ValueFunction(this.myMaze.width, this.myMaze.height);
        this.currPolicy = new int[this.myMaze.width][this.myMaze.height];
        this.precision = convError;
        this.converged = false;
        this.initialize();
    }

    public void initialize() {
        this.currValues.initialize();
        this.converged = false;
        this.iters = 0;
        this.timeTaken = 0L;
        int i = 0;
        while (i < this.myMaze.width) {
            int j = 0;
            while (j < this.myMaze.height) {
                this.currPolicy[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void setProperty(int name, String value) {
        if (name == Properties.PJOG) {
            this.pjog = Double.parseDouble(value);
        } else if (name == Properties.ConvergenceError) {
            this.precision = Double.parseDouble(value);
        } else if (name == Properties.ValueFunctionLimit) {
            MAX_VALUE_ALLOWED = Integer.parseInt(value);
        } else if (name == Properties.IterationLimit) {
            MAX_VALUE_ITERS = Integer.parseInt(value);
        }
    }

    public int getNumOfIters() {
        return this.iters;
    }

    public void execute(int numIters) {
        int iter = 0;
        while (iter < numIters) {
            this.step();
            ++iter;
        }
    }

    public ValueFunction getValueFunction() {
        return this.prevValues;
    }

    public int[][] getPolicy() {
        return this.currPolicy;
    }

    public long getTime() {
        return this.timeTaken;
    }

    public boolean step() {
        State currState;
        long startTime = new Date().getTime();
        double v = 0.0;
        double minV = 10000.0;
        double maxDelta = 0.0;
        double delta = 0.0;
        boolean valueConverged = false;
        if (this.converged) {
            long endTime = new Date().getTime();
            this.timeTaken += endTime - startTime;
            return true;
        }
        int valueIters = 0;
        while (!valueConverged && valueIters < MAX_VALUE_ITERS) {
            int j;
            maxDelta = 0.0;
            double maxV = 0.0;
            int i = 0;
            while (i < this.myMaze.width) {
                j = 0;
                while (j < this.myMaze.height) {
                    v = 0.0;
                    currState = new State(i, j);
                    if (this.myMaze.goals.contains(currState)) {
                        this.currValues.stateValue[i][j] = 0.0;
                    } else {
                        Vector allNext = new Vector(this.myMaze.getSuccessors(currState));
                        State desiredNextState = Action.performAction(currState, this.currPolicy[i][j]);
                        int m = 0;
                        while (m < allNext.size()) {
                            State s = (State)allNext.get(m);
                            double prob = !desiredNextState.equals(s) ? this.pjog / 3.0 : 1.0 - this.pjog;
                            double safe = this.myMaze.isValidTransition(currState, s) ? this.prevValues.stateValue[s.x][s.y] : this.myMaze.getReward(currState, s) + this.prevValues.stateValue[i][j];
                            v += prob * safe;
                            ++m;
                        }
                        this.currValues.stateValue[i][j] = v += 1.0;
                        maxV = maxV < v ? v : maxV;
                        delta = Math.abs(this.currValues.stateValue[i][j] - this.prevValues.stateValue[i][j]);
                        if (maxDelta < delta) {
                            maxDelta = delta;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++valueIters;
            if (maxDelta < this.precision) {
                valueConverged = true;
            }
            if (maxV > (double)MAX_VALUE_ALLOWED) {
                valueConverged = true;
            }
            i = 0;
            while (i < this.myMaze.width) {
                j = 0;
                while (j < this.myMaze.height) {
                    this.prevValues.stateValue[i][j] = this.currValues.stateValue[i][j];
                    ++j;
                }
                ++i;
            }
            this.currValues.initialize();
        }
        this.converged = true;
        int action = 0;
        int i = 0;
        while (i < this.myMaze.width) {
            int j = 0;
            while (j < this.myMaze.height) {
                currState = new State(i, j);
                if (this.myMaze.goals.contains(currState)) {
                    this.currPolicy[i][j] = -1;
                } else {
                    minV = Double.MAX_VALUE;
                    int a = 0;
                    while (a < 4) {
                        double vl;
                        State nextState = Action.performAction(currState, a);
                        if (this.myMaze.isValidTransition(currState, nextState) && minV > (vl = this.prevValues.stateValue[nextState.x][nextState.y])) {
                            minV = vl;
                            action = a;
                        }
                        ++a;
                    }
                    if (this.currPolicy[i][j] != action) {
                        this.converged = false;
                        this.currPolicy[i][j] = action;
                    }
                }
                ++j;
            }
            ++i;
        }
        ++this.iters;
        long endTime = new Date().getTime();
        this.timeTaken += endTime - startTime;
        return this.converged;
    }

    static class Properties {
        public static int PJOG = 1;
        public static int ConvergenceError = 2;
        public static int ValueFunctionLimit = 3;
        public static int IterationLimit = 4;

        Properties() {
        }
    }
}

