#!/usr/bin/perl
############################################################################
# NOTE: If you generated a new set of fields using DeriveMetadataInfo.pl 
# (for example, if you decided to ignore some fields, or include some 
# previously ignored fields), you will need to rerun colyquake 
# with `--deltas --no-clusters' options with a certain number of bots 
# (enough to at least change a bunch of fields within the structures)
# After that, feed the DeltaEncodingLog.*s to ClusterDeltaFields.pl 
# and feed its output to this script.
#############################################################################
#
# This script is used to generate src/ClusterTables.cxx which are used
# to determine which bits in the delta bitmask are assigned to which fields
# in the edict. We do delta encoding as follows:
#
# * We group fields that are always altered together and call them a
#   "cluster."
# * We take the clusters and assign them 1 bit in
#   the DeltaMask that is passed to {Un}PackUpdate(...) in order of frequency.
#
# The script takes as input a set of field clusters annotated with a count.
# For example:
#
# 100	s.origin,s.old_origin
# 200	client
# ...
#
# The count represents the frequency of occurrance of the cluster in deltas.
# NOTE: There can only be MAX_DELTA_FIELDS (DeltaMask.h) clusters.

use strict;

# ( [count, [fields...] )
my @clusters;

while (<>) {
    chomp $_;
    my ($count, $fields) = split(/\s+/, $_);
    my @fields = split(/,/, $fields);
    push @clusters, [ $count, \@fields ];
}

## XXX HACK!! for the stupid otherEntity and otherEntity2 fields
push @clusters, [ 1, [ "otherEntity" ] ];
push @clusters, [ 1, [ "otherEntity2" ] ];

@clusters = sort { - ($a->[0] <=> $b->[0]) } @clusters;
my $num_clusters = scalar(@clusters);

print STDERR "num_clusters: $num_clusters\n";

print_header (*STDOUT);
print STDOUT "\nnamespace clusterNS {\n\n";

for (my $i=0; $i<$num_clusters; $i++) {
    print_fields (*STDOUT, $i, $clusters[$i]);
}

print STDOUT <<EOT;
};

const Cluster *g_FieldClusters [] = {
EOT

for (my $i=0; $i<@clusters; $i++) {
    print_cluster(*STDOUT, $i, $clusters[$i]);
}

print STDOUT <<EOT;
};

EOT

###############################################################################

sub min {
    return $_[0] < $_[1] ? $_[0] : $_[1];
}

sub print_header {
    my $fp = shift;
    my $time = scalar localtime();
    print $fp <<EOT;
/*
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MakeClusterTables.pl.
 * DO NOT EDIT BY HAND!!!
 *
 * Generated on: $time
 */
EOT
}

sub print_cluster {
    my $fp = shift;
    my $index = shift;
    my $cluster = shift;
    my @fields = @{$cluster->[1]};
    my $num_fields = scalar @fields;

    print $fp "\tnew Cluster (clusterNS::fields_$index, $num_fields),\n";
}

sub print_fields {
    my $fp = shift;
    my $index = shift;
    my $cluster = shift;

    my $count  = $cluster->[0];
    my @fields = @{$cluster->[1]};
    map { $_ = "\"$_\"" } @fields;

    print $fp "static const char *fields_$index [] = { " . join (", ", @fields) . " };\n"
}


