#!/usr/bin/perl
use strict;

sub populateFieldHashes ($$$) {
    my $field_file = shift;
    my $p_ent_fields = shift;
    my $p_cli_fields = shift;
    
    open F, $field_file or die "Can't open $field_file for reading: $!";
    my @fields = ();
    while (<F>) {
	next if /TYPEINFO\s+typename/;
	last if /<\/TYPEINFO>/;
	
	chomp;
	push @fields, getFieldName ($_);
    }

    for (my $i = 0; $i < scalar @fields; $i++) {
	$p_ent_fields->{$fields [$i]} = $i;
    }

    @fields = ();
    while (<F>) {
	next if /TYPEINFO\s+typename/;
	last if /<\/TYPEINFO>/;

	chomp;
	push @fields, getFieldName ($_);
    }

    for (my $i = 0; $i < scalar @fields; $i++) { 
	$p_cli_fields->{$fields [$i]} = $i;
    }
    close F;
}

sub getReverseMap ($) {
    my $p_hash = shift;
    my @rev_map = ();
    foreach (keys %$p_hash) {
	$rev_map [$p_hash->{$_}] = $_;
    }
    return @rev_map;
}

sub getFieldName ($) { 
    my $line = shift;
    $line =~ /type=:([^:]+):\s+name=:([^:]+):/;
    return $2;
}

sub getClosestMatch ($$) { 
    my $p_hash = shift;
    my $field  = shift;

    foreach my $key (keys %$p_hash) {
	if ($key =~ /$field$/) {
	    return $p_hash->{$key};
	}
    }
    return -1;
}

1;
