#!/usr/bin/perl
use strict;
use Travertine;
use Getopt::Std;
use vars qw($opt_f $opt_r);

getopts ("f:r");

my $dir = `dirname $0`;
chomp $dir;
require "$dir/MDUtils.pl";

our $FIELD_FILE = defined $opt_f ? $opt_f : $ENV{'HOME'} . "/quake3/src/scripts/.extracted-ds";
our $REV_MAP    = defined $opt_r;

our %ENT_FIELDS = ();
our %CLI_FIELDS = ();

populateFieldHashes ($FIELD_FILE, \%ENT_FIELDS, \%CLI_FIELDS);
if ($REV_MAP) { 
    mapLogFile ();
}
else {
    mapCilFile ();
}

##############################
sub mapLogFile () {
    my @strings = `cat strings.out`;
    chomp @strings;
    
    my $ent_fields = scalar keys %ENT_FIELDS;
    my @ent_rev_map = getReverseMap (\%ENT_FIELDS);
    my @cli_rev_map = getReverseMap (\%CLI_FIELDS);

    while (<STDIN>) {
	chomp;
	my ($type, $field, $ent_num, $class, $func);

	if (/(\d+)\t(\d+)\t(\d+)\t(-*\d+)\t(\w+)/) {
	    $type = $1;
	    $field = $2;
	    $ent_num = $3;
	    $class = $4;
	    $func = $5;
	}
	elsif (/(\d+)\t(\d+)\t(\d+)\t(-*\d+)/) {
	    $type = $1;
	    $field = $2;
	    $ent_num = $3;
	    $class = $4;
	    $func = "";
	}
	
	if ($class == -1 or $class >= scalar @strings) { $class = "null"; }
	else { $class = $strings [$class]; }
	
	if ($field >= $ent_fields) { 
	    $field -= $ent_fields;
	    if ($field >= scalar @cli_rev_map) {
		$field = "invalid_client_field";
	    }
	    else {
		$field = $cli_rev_map [$field];
	    }
	}
	else {
	    $field = $ent_rev_map [$field];
	}

	print "$type\t$field\t$ent_num\t$class\t$func\n";
    }
}

sub mapCilFile () {
    while (<STDIN>) {
	if (/^(\s*)(Record\w+)\(([^,]+),([^,]+),([^\)]+)\)/) {
	    my $space = $1;
	    my $func = $2;
	    my $base = $3;
	    my $field = $4;
	    my $isclient = $5;

	    $field =~ s/\s//g;
	    $field =~ s/"//g;
	    my $index = -1;

	    # for RecordFuncWrite, the third field is different...
	    if ($isclient =~ /1/ and $isclient !~ /"/) { 
		$index = $CLI_FIELDS {$field};
		if (not defined $index) {
		    $index = getClosestMatch (\%CLI_FIELDS, $field);
		}
		$index += scalar keys %ENT_FIELDS if ($index >= 0);
	    }
	    else {
		$index = $ENT_FIELDS {$field};
		if (not defined $index) {
		    $index = getClosestMatch (\%ENT_FIELDS, $field);
		}
	    }

	    if (defined $index && $index >= 0) { 
		print "$space$func ($base, $index, $isclient);\n";
	    }
	}
	else {
	    print;
	}
    }
}

