#!/usr/bin/perl
#
# Massage files before running `cilly'. Get rid of the C++ additions in 
# some of the files (transform them into "benign" C code); add a bunch of hacks 
# (run markthink.pl on some, etc. etc.)
# 
use strict;
use Travertine;
use Getopt::Std;
use vars qw();

my $args = join " ", @ARGV;
my $file = $ARGV [-1];

our @SAVES = ("g_local.h", "g_client.c", "g_public.h", "g_main.c");
psystem ("mkdir -p precious/");
foreach (@SAVES) { psystem ("cp --preserve ../game/$_ precious/"); }

if (got_signal ()) {
    psystem ("rm -rf precious/");
}

$SIG{INT} = $SIG{HUP} = \&cleanup_exit;

psystem ("perl -pi -e 's/class Quake3Entity/typedef struct { int d; } Quake3Entity/' ../game/g_local.h");
cleanup_exit () if (got_signal ());
psystem ("perl -pi -e 's/class Quake3Entity/typedef struct { int d; } Quake3Entity/' ../game/g_public.h");
cleanup_exit () if (got_signal ());

if ($file =~ /g_client/) {
    psystem ("perl -ni -e 'print if !/colyseus/' ../game/g_client.c");
    psystem ("perl -pi markthink.pl ../game/g_client.c");
    cleanup_exit () if (got_signal ());
}

if ($file =~ /g_main/) { 
    psystem ("perl -pi -e 's/case GAME_INIT:/case GAME_INIT: { " . 
        "extern void InitRecordingLogs(); InitRecordingLogs(); }/' " .
	"../game/g_main.c");
    psystem ("perl -pi markthink.pl ../game/g_main.c");
    cleanup_exit () if (got_signal ());
}

print STDERR "./cilly $args\n";
system ("CILLY_DONT_COMPILE_AFTER_MERGE=1 CILLY_DONT_LINK_AFTER_MERGE=1 ./cilly $args");

cleanup ();
exit 0;

sub cleanup {
    foreach (@SAVES) { psystem ("cp --preserve precious/$_ ../game/"); }
    psystem ("rm -rf precious/");
}

sub cleanup_exit {
    cleanup ();
    exit 1;
}

sub got_signal () { 
    return $? & 127;
}

