#!/usr/bin/perl
use strict;
use Travertine;
use Getopt::Std;
use vars qw($opt_m $opt_n $opt_t);

getopts ("m:n:t:");
my $expdir = shift @ARGV;
if (!defined $expdir) {
    twarn "Experiment name not defined";
    tinfo "Usage: $0 [options] expname";
    exit 1;
}

our $MAP = defined $opt_m ? $opt_m : "q3dm1";
our $BOTS = defined $opt_n ? $opt_n : 4;
our $TIME = defined $opt_t ? $opt_t : 200;
our $IQDIR = "$ENV{HOME}/quake3/src/apps/iquake3";

psystem ("mkdir -p $expdir");
chdir $expdir;
psystem ("$IQDIR/iquake3 --map $MAP --nbots $BOTS --measurement --log-flush-interval 2000 --timelimit $TIME");
