////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

using namespace std;

#include <unistd.h>
#include <q_exports.h>
#include <server/server.h>
#include <om/common.h>
#include <util/debug.h>
#include <util/ExpLog.h>
#include <Colyseus.h>
#include <extractors/record.h>

static char g_Quake3Map [256];
static int g_NumBots;
static int g_TimeLimit;
static bool s_InitializedStrings = false;

static OptionType g_Options [] = 
{
    { '/', "map", OPT_STR, "quake3 map to load",
	g_Quake3Map, "q3dm1", NULL },
    { '/', "nbots", OPT_INT, "number of bots to introduce in the game",
	&g_NumBots, "4", NULL },
    { '/', "timelimit", OPT_INT, "number of seconds to run this game for",
	&g_TimeLimit, "300", NULL },
	
    { 0, 0, 0, 0, 0, 0, 0 }
};

/**
 * A minimal implementation of the quake3 server event loop. for testing.
 * (change the hard-coded map to try another one).
 */
int main(int argc, char *argv[])
{
    DBG_INIT (&g_LocalSID);
    g_MeasurementParams.enabled = true;
    InitializeColyseus (&argc, argv, g_Options, true);
    
    // Get quake to initialize itself normally
    Sys_Main(argc, argv);
    // ttyconsole doesn't work with nodelay disabled
    Cvar_Set( "ttycon", "0" );
    // We must load from the DLL, not the vm
    Cvar_Set( "vm_game", "0" );
    // Load the quake map and startup the server
    // (constructing the world may require this step)
    SV_SpawnServer(g_Quake3Map, qtrue );

    for (int i = 0; i < g_NumBots; i++) {
	if (i % 2 == 0)
	    Cbuf_AddText ("addbot visor\n");
	else
	    Cbuf_AddText ("addbot sarge\n");
    }
    
    int fps = 20;
    int sleepMs = 1000 / fps;
    while (1) {
	// *** from Com_Frame
	if (level.framenum > g_TimeLimit * fps)
	    break;

	// write config file if anything changed
	Com_WriteConfiguration(); 
	Com_EventLoop();
	Cbuf_Execute ();

	// *** from SV_Frame

	// the menu kills the server with this cvar
	if ( sv_killserver->integer ) {
	    SV_Shutdown ("Server was killed.\n");
	    Cvar_Set( "sv_killserver", "0" );
	    return 1;
	}

	// if it isn't time for the next frame, do nothing
	if ( sv_fps->integer < 1 ) {
	    Cvar_Set( "sv_fps", "10" );
	}
    
	// XXX -- DO SOMETHING ABOUT THIS!!!  if time is about to hit the
	// 32nd bit, kick all clients and clear sv.time, rather than
	// checking for negative time wraparound everywhere.
	// 2giga-milliseconds = 23 days, so it won't be too often
	if ( svs.time > 0x70000000 ) {
	    SV_Shutdown( "Restarting server due to time wrapping" );
	    Cbuf_AddText( "vstr nextmap\n" );
	    return 1;
	}
	// this can happen considerably earlier when lots of clients play
	// and the map doesn't change
	if ( svs.nextSnapshotEntities >= 0x7FFFFFFE - svs.numSnapshotEntities ) {
	    SV_Shutdown( "Restarting server due to numSnapshotEntities wrapping" );
	    Cbuf_AddText( "vstr nextmap\n" );
	    return 1;
	}
    
	// update infostrings if anything has been changed
	if ( cvar_modifiedFlags & CVAR_SERVERINFO ) {
	    SV_SetConfigstring( CS_SERVERINFO, Cvar_InfoString( CVAR_SERVERINFO ) );
	    cvar_modifiedFlags &= ~CVAR_SERVERINFO;
	}
	if ( cvar_modifiedFlags & CVAR_SYSTEMINFO ) {
	    SV_SetConfigstring( CS_SYSTEMINFO, Cvar_InfoString_Big( CVAR_SYSTEMINFO ) );
	    cvar_modifiedFlags &= ~CVAR_SYSTEMINFO;
	}

	// update ping based on the all received frames
	SV_CalcPings();

	SV_BotFrame( svs.time );
    
	// we assume we only run 1 sim chunk at a time
	svs.time += 100;

	// let everything in the world think and move
	// XXX: only do this for the primary objects!
	VM_Call( gvm, GAME_RUN_FRAME, svs.time );

	// Initialize strings only after the game has run for a while
	// So the dynamic strings are hopefully all set up.
	if (!s_InitializedStrings && level.framenum >= 1) {
	    InitializeStringsTable ();
	    s_InitializedStrings = true;
	}

	if (level.framenum % 100 == 0) 
	    fprintf (stderr, "frame: %d\n", level.framenum);

	// *** from server/sv_main.c:SV_Frame
	// check timeouts
	SV_CheckTimeouts();
    
	// send messages back to the clients
	SV_SendClientMessages();
    
	// send a heartbeat to the master if needed
	SV_MasterHeartbeat();

	usleep(sleepMs * 1000);
    }

    SV_Shutdown( "Framelimit reached" );
    Sys_ConsoleInputShutdown();
    
    return 0;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
