////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __QUAKE3_STATIC_ENTITY_H__
#define __QUAKE3_STATIC_ENTITY_H__

#include <gameapi/GameObject.h>
#include "Quake3Entity.h"
#include "q_exports.h"

/**
 * A static immutable globally replicated gentity_t, such as lights,
 * spawn points, and other map constructs.
 */
class Quake3StaticEntity : 
public StaticGameObject, public Quake3Entity
{
 public:
    Quake3StaticEntity(gentity_t *ent, const GUID& guid);
    virtual ~Quake3StaticEntity();
    
    virtual void PrintFields(ostream& out);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
