////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#include <gameapi/GameManager.h>
#include <gameapi/GameStore.h>
#include "Quake3PredictiveInterestFilter.h"
#include "Quake3DynamicEntity.h"
#include "World.h"
#include "Options.h"

Quake3PredictiveInterestFilter::Quake3PredictiveInterestFilter(DynamicGameObject *obj) :
    m_GUID(obj->GetGUID()),
    m_LastTTL (0)
{
    m_LastTime = TIME_NONE;
    ASSERT(obj);
}

Quake3PredictiveInterestFilter::~Quake3PredictiveInterestFilter()
{
}

AreaOfInterest *Quake3PredictiveInterestFilter::Filter(AreaOfInterest *in)
{
    // XXX handle multiple boxes in the future
    ASSERT(in->size() <= 1);

    //DB(1) << "obj: " << m_Obj << endl;

    // XXX handle other object types?
    GameObject *obj = GameManager::GetInstance()->GetStore()->Find(m_GUID);
    ASSERT( obj != NULL );
    Quake3DynamicEntity *ent = 
	dynamic_cast<Quake3DynamicEntity *>(obj);
    if (!ent) {
	WARN << "don't know how to handle: " << obj << endl;
	ASSERT(0);
    }

    AreaOfInterest *out = new AreaOfInterest();
    if (in->size() == 0)
	return out;
    
    int ttl = 0;
    if (ent->GetClass() == Quake3DynamicEntity::PLAYER) {
	ttl = g_QuakePreferences.subttl_player;
    } else if (ent->GetClass() == Quake3DynamicEntity::MISSILE) {
	ttl = g_QuakePreferences.subttl_missile;
    } else {
	WARN << "trying to get predict BBox for non subscriber!" << endl;
	ASSERT(0);
    }

    AnnotatedBBox *ibox = in->front();
    BBox *ibboxp = ibox->GetBBox();

    if (m_LastTime != TIME_NONE && 
	m_LastTime + m_LastTTL > GameManager::GetInstance()->ThisFrameTime() &&
	m_LastPredicted.Contains(*ibboxp)) {
	// new sub inside old pred-sub
	return out;
    } else {
	m_LastTime = GameManager::GetInstance()->ThisFrameTime();
	m_LastTTL  = ttl;
    }

    //
    // First predict how far this guy will move in ttl time
    //

    Quake3World *w = 
	dynamic_cast<Quake3World *>(GameManager::GetInstance()->GetWorld());

    real32 pred = ent->GetSpeed() * ttl * 0.001; // convert to dist/sec
    // XXX should be MAXSPEED * maxdislat
    real32 fudge = ent->GetSpeed() * g_QuakePreferences.maxdislat * 0.001;


    /*
    INFO << "ent=" << ent->GetClassName() << " sub speed=" << ent->GetSpeed()  << " ttl=" << ttl 
	 << " pred=" << pred << " fudge=" << fudge << endl;

    INFO << "last_predicted=" << m_LastPredicted << endl;
    INFO << "curr_sub=" << *ibboxp << endl;
     */

    m_LastPredicted = w->GetPredictedBBox(ent, 2*pred, 1);
    BBox sub = w->GetPredictedBBox(ent, 2*(pred+fudge), 1);

    /*
    INFO << "next_predicted=" << sub << endl;
    INFO << "clipped=" << w->Clip (sub) << endl;
    */

    AnnotatedBBox *obox = 
	new AnnotatedBBox( w->Clip( sub ), ibox->GetGUIDs(), ttl );
    out->push_back(obox);

    return out;
}

void Quake3PredictiveInterestFilter::Delete(AreaOfInterest *aoi)
{
    for (AreaOfInterestIter it = aoi->begin(); it != aoi->end(); it++) {
	delete *it;
    }
    delete aoi;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
