////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __QUAKE3_ENTITY_H__
#define __QUAKE3_ENTITY_H__

#include <gameapi/GameObject.h>
#include "q_exports.h"

#define GAMETYPE_QUAKE3_DYNAMIC ((gTypeCode)1)
#define GAMETYPE_QUAKE3_STATIC ((gTypeCode)1)

/**
 * Base-class for both dynamic and static quake objects. Both need to
 * maintain references to corresponding gentity_t structs in the 
 * g_entities array.
 */
class Quake3Entity : virtual public GameObject
{
 protected:
    // pointer to this entity in the g_entities array (DO NOT MUTATE DIRECTLY!)
    gentity_t *mInternalEntity;

    /**
     * Tie this object with the following entity in g_entities.
     * Should only be called once.
     */
    virtual void Tie(gentity_t *g_entities_ptr, gclient_t *g_client_ptr);

 public:

    static int NumEntityPointers ();
    static vector<gentity_t **> GetEntityPointers(gentity_t *ent);

    Quake3Entity();
    virtual ~Quake3Entity();
    
    const char *GetClassName ();
    gentity_t *GetInternalEntity();

    void PrintFields(ostream& out);
};

ostream& operator<<(ostream& out, gentity_t *ent);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
