////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
#include "Quake3Entity.h"
#include "Quake3Metadata.h"
#include "BBox.h"

///////////////////////////////////////////////////////////////////////////////

ostream& operator<<(ostream& out, gentity_t *ent) {
    if (ent == NULL) {
	out << "(null)";
	return out;
    }
    out << "classname=" << (ent->classname != NULL ? ent->classname : "(null)")
	<< " entityNum=" << ent->s.number
	<< " inuse=" << ent->inuse
	<< " origin=" << ent->s.origin
	<< " pos={" << ent->s.pos.trType
	<< "," << ent->s.pos.trBase
	<< "," << ent->s.pos.trDelta
	<< "}"
	<< " modelindex=" << ent->s.modelindex
	<< " modelindex2=" << ent->s.modelindex2
	<< " frame=" << ent->s.frame
	<< " solid=" << ent->s.solid
	<< " linked=" << ent->r.linked
	<< " linkcount=" << ent->r.linkcount
	<< " svFlags=" << ent->r.svFlags;
    return out;
}

const char *Quake3Entity::GetClassName () 
{
    if (!mInternalEntity) 
	return "null";
    else 
	return mInternalEntity->classname != NULL ? mInternalEntity->classname : "(null)";
}

int Quake3Entity::NumEntityPointers () 
{
    int n = 0;
    for (Quake3PointerInfo *i = g_EntityPointerOffsets; i->name != NULL; i++) 
	n++;
    for (Quake3PointerInfo *i = g_ClientPointerOffsets; i->name != NULL; i++) 
	n++;
    return n;
}

vector<gentity_t **> Quake3Entity::GetEntityPointers(gentity_t *ent)
{
    vector<gentity_t **> result;
    for (Quake3PointerInfo *i = g_EntityPointerOffsets; i->name != NULL; i++) {
	gentity_t **ptr = (gentity_t **)((byte *)ent + i->offset);
	result.push_back(ptr);
    }
    if (ent->client != NULL) {
	for (Quake3PointerInfo *i = g_ClientPointerOffsets; i->name != NULL; i++) {
	    gentity_t **ptr = (gentity_t **)((byte *)(ent->client) + i->offset);
	    result.push_back(ptr);
	} 
    }
    
    return result;
}

Quake3Entity::Quake3Entity() : mInternalEntity(NULL) {}
Quake3Entity::~Quake3Entity() {
    // assume this is untied upon deletion
    ASSERT(mInternalEntity == NULL || mInternalEntity->colyseusObject == NULL);
}

void Quake3Entity::Tie(gentity_t *g_entities_ptr, gclient_t *g_client_ptr)
{
    ASSERT(g_entities_ptr != NULL);
    ASSERT(mInternalEntity == NULL);
    ASSERT(g_entities_ptr->colyseusObject == NULL);
    
    mInternalEntity = g_entities_ptr;
    mInternalEntity->client = g_client_ptr;
    mInternalEntity->colyseusObject = this;
}

gentity_t *Quake3Entity::GetInternalEntity() 
{ 
    return mInternalEntity;
}

void Quake3Entity::PrintFields(ostream& out)
{
    out << mInternalEntity;
}

// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
