////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
#ifndef OPTIONS__H
#define OPTIONS__H

#define SPAWN_DEFAULT   'd' // quake default (farthest or random)
#define SPAWN_TYPEBASED 't' // monsters get fixed spawn points
#define SPAWN_RANDOM    'r' // force random spawn
#define SPAWN_ITEM      'i' // allow spawning by items

// start ashwin
typedef struct {

    int masterIndex;
    int masterTotal;

    char mapname[255];  // map to play

    int  nbots;         // number of bots spawned...

    //int  nmonsters;     // number of bots that are monsters
    //bool fightmonsters; // bots only fight monsters and vis versa
    //char spawn_type;    // type of spawn
    //bool jeffai;        // use jeff and justin's AI for acebots
    //int  timelimit;     // that timelimit cvar causes segfaults because the "map" string is new! 
    //int  framelimit;    // max number of frames to run (runs for min of timelimit and framelimit)
    //bool disable_remote_multicast; // if true, multicast effects (most SFX won't be stored in a buffer to be sent to replica clients)
    //bool enable_looking_at; // if true, quake will print the object a player is looking at
     
    //bool dg_record_demo;     // if true, each distributed server will record a "partial" demo
    //char dg_merge_demos [32];    // merge demo files made using the record demo option
    //char dg_demo_dir [1024]; // directory where all demo files are located
    //char dg_demo_output [1024]; // output demo file
    //int  dg_demo_player;    // whose perspective should we show the demo from
     
    int maxdislat; // maximum discovery latency (ms)

    // prediction/ttl times
    int subttl_player;
    int subttl_missile;
     
    int pubttl_player;
    int pubttl_missile;
    int pubttl_immobile_longlive;
    int pubttl_immobile_shortlive;
    int pubttl_mobile_longlive;
    int pubttl_mobile_shortlive;
     
    //char routing_hubs[256];
    // dimension stripping
    //char stripe_hubname[256]; // something other than x,y,z
    //char stripe_dimname[256]; // x, y, z, "" = none
    //int stripes_x;
    //int stripes_y;
    //int stripes_z;
     
    //int stripe_dim; // (0 = x, 1 = y, 2 = z)
    //int stripes[3];

    // dht options
    //bool dht;
    //char dht_hub[256];
    //int  dht_buckets;
     
    // precomputing bboxes
    //bool  bbox;
    char  bbox_min[256], bbox_max[256];
    float bbox_unit;
    float bbox_xystep, bbox_zstep;
    char  bbox_file[256];

    bool  open_map;                         // whether bboxes should be "clipped"
    float max_bbox_width;
    float max_bbox_height;                  
    float open_bbox_detection_threshold;    // fraction of rays which must be "open"

    // calculate precomputed bbox accuracy
    //bool  bbox_acc_test;
     
    // how to partition items amongst the slaves
    char  item_partition_method;
     
    // precomputing delta fields
    bool deltas;
    bool noclusters;
     
    bool dump_initial;         // just dump initial interests and exit
    bool record_obj_interests; // record primary object pos/bbox each frame
     
    // pubsub simulator options
    //bool  pubsubsim;
    //float pubsubsim_subdist;
    //float pubsubsim_pubdist;
    //bool  pubsubsim_noselfpub;

    // playable map area calculation
    //int   calc_playable_area; // (num samples)
     
    // disable frame-rate adjustment
    //bool  nofradjust;
     
    // disable the startup and use of colyseus (implied by
    // bbox and bbox_acc_test and deltas and client).
    //bool  disable_colyseus;
    //char  visualizer_ip[40]; // specify the visualizer server ip (port = 60000)
     
    //char benchmark_patternstr[1024];
    //char *benchmark_patterns[255];
    bool randomspawns;
} qpref_t;

extern qpref_t g_QuakePreferences;

// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:

#endif // OPTIONS__H
