////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __QUAKE3_GAME_H__
#define __QUAKE3_GAME_H__

#include <gameapi/GameModule.h>
#include "q_exports.h"

class Quake3Module : public GameModule {
private:
    static const int INITIAL_GAME_FRAMES = 50;
    static bool m_Inited;

    typedef map<GUID, gentity_t *, less_GUID> EntityMap;
    typedef EntityMap::iterator EntityMapIter;

    EntityMap m_LastFrameObjects;
    GUID m_LastStaticGUID;

    const GUID& AllocateStaticGUID();
    bool IsDynamicEntity(gentity_t *ent);

    bool RunGameFrame();
    void _CheckSpecialInvariant (GameManager *manager);
public:
    static bool IsInited() {
	return m_Inited;
    }

    virtual const uint32 FrameInterval();
    virtual gRetCode Init(GameManager *manager);
    virtual gRetCode RunFrame(GameManager *manager);
    virtual gRetCode Shutdown(GameManager *manager);
    virtual DynamicGameObject *ConstructObject(gTypeCode type, GObjectInfoIface *info);
    virtual GameObject *ConstructObject(Packet *pkt);
    virtual void DeleteObject(DynamicGameObject *obj);

    virtual void InstallTerminalHandlers (InputHandlers *tofill);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
