////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __LOGS__H
#define __LOGS__H   

#include <util/ExpLog.h>

// Delta encoding info log
struct DeltaEncodingEntry : public ExpLogEntry
{   
    bool  isnew;
    bool  isreplica;
    GUID  guid;
    const char *classname;
    list<string> fields;
    
    DeltaEncodingEntry() {};
    DeltaEncodingEntry(bool isnew, bool isreplica, GUID& guid,
                       const char *classname) :
        isnew(isnew), isreplica(isreplica), guid(guid), classname(classname) {}
    virtual ~DeltaEncodingEntry() {}

    uint32 Dump(FILE *fp) { 
        // this format for calculating what fields to delta encode normally
        uint32 ret = fprintf(fp, "[*] %s\t%s\t%d\t", isnew?"NEW":"CHG", classname,
                isreplica?1:0);
        for (list<string>::iterator it = fields.begin() ;
             it != fields.end(); it++) {
            if (it != fields.begin()) 
		ret += fprintf(fp, ",");
            ret += fprintf(fp, (*it).c_str());
        }
        ret += fprintf(fp, "\n");
	return ret;
    }
};

DECLARE_EXPLOG(DeltaEncodingLog, DeltaEncodingEntry);

void InitQuake3Logs ();

#endif /* __LOGS__H */
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
