/* 
 * This file has been automatically generated. You run the 
 * risk of loosing your changes if you edit it manually. A 
 * better place to incorporate your edits would be 
 * `scripts/DeriveMetadataInfo.pl'. 
 *
 * This file contains the following information extracted from 
 * the game module.
 *
 * * Addresses and declarations of functions _defined_ in the module
 *   Note that it does not include declarations referenced by the 
 *   module (the latter are not needed for our purposes.)
 *
 * * Addresses of global variables. For arrays, we "expand" the array
 *   (the static length is known) and list addresses for each element
 *   in the array. 
 *
 * * Collection of static strings referenced by the module. 
 *
 * * Detailed information about the gentity_t and gclient_t structures.
 *   This includes the types and sizes of sub-fields. 
 *
 */

#include <game/be_aas.h>
#include <game/botlib.h>
#include <game/bg_local.h>
#include <game/q_shared.h>
#include <game/be_ai_goal.h>
#include <game/be_ai_char.h>
#include <game/be_ai_chat.h>
#include <game/be_ai_weap.h>
#include <game/be_ai_move.h>
#include <game/be_ai_gen.h>
#include <game/be_ea.h>
#include <game/ai_main.h>
#include <game/ai_cmd.h>
#include <game/ai_vcmd.h>
#include <game/ai_chat.h>
#include <game/ai_team.h>
#include <game/ai_dmnet.h>
#include <game/ai_dmq3.h>

// HACKS galore... 
//
// These structures are defined in C files (not .h files) and 
// so when we declare the functions which use them in 
// ExtractedMetadata.cxx, compilation does not happen! Basically, 
// these structs and the functions have static linkage, but the 
// function pointers can still be used as think functions

// XXX perhaps these definitions can be obtained automagically?

typedef struct ipFilter_s
{
    unsigned        mask;
    unsigned        compare;
} ipFilter_t;

//ctf task preferences for a client
typedef struct bot_ctftaskpreference_s
{
        char            name[36];
        int                     preference;
} bot_ctftaskpreference_t;

typedef struct voiceCommand_s
{
    char *cmd;
    void (*func)(bot_state_t *bs, int client, int mode);
} voiceCommand_t;

typedef struct {
    int             clientNum;
    int             spawnTime;
} botSpawnQueue_t;

typedef struct {
    char    *name;
    void    (*spawn)(gentity_t *ent);
} spawn_t;

typedef struct {
    gentity_t       *ent;
    vec3_t  origin;
    vec3_t  angles;
    float   deltayaw;
} pushed_t;

typedef struct {
    vmCvar_t        *vmCvar;
    char            *cvarName;
    char            *defaultString;
    int                     cvarFlags;
    int                     modificationCount;  // for tracking changes
    qboolean        trackChange;        // track this variable, and announce if change
    qboolean teamShader;        // track and if changed, update shader state
} cvarTable_t;

typedef struct teamgame_s {
    float                   last_flag_capture;
    int                             last_capture_team;
    flagStatus_t    redStatus;      // CTF
    flagStatus_t    blueStatus;     // CTF
    flagStatus_t    flagStatus;     // One Flag CTF
    int                             redTakenTime;
    int                             blueTakenTime;
    int                             redObeliskAttackedTime;
    int                             blueObeliskAttackedTime;
} teamgame_t;                           

typedef struct {
    char oldShader[MAX_QPATH];
    char newShader[MAX_QPATH];
    float timeOffset;
} shaderRemap_t;

/* Function prototypes */

extern int  BotNumActivePlayers ();
extern int  BotIsFirstInRankings ( bot_state_t * bs);
extern int  BotIsLastInRankings ( bot_state_t * bs);
extern char * BotFirstClientInRankings ();
extern char * BotLastClientInRankings ();
extern char * BotRandomOpponentName ( bot_state_t * bs);
extern char * BotMapTitle ();
extern char * BotWeaponNameForMeansOfDeath ( int  mod);
extern char * BotRandomWeaponName ();
extern int  BotVisibleEnemies ( bot_state_t * bs);
extern int  BotGetItemTeamGoal ( char * goalname,  bot_goal_t * goal);
extern int  BotGetMessageTeamGoal ( bot_state_t * bs,  char * goalname,  bot_goal_t * goal);
extern float  BotGetTime ( bot_match_t * match);
extern int  FindClientByName ( char * name);
extern int  FindEnemyByName ( bot_state_t * bs,  char * name);
extern int  NumPlayersOnSameTeam ( bot_state_t * bs);
extern int  BotGetPatrolWaypoints ( bot_state_t * bs,  bot_match_t * match);
extern int  BotAddressedToBot ( bot_state_t * bs,  bot_match_t * match);
extern int  BotGPSToPosition ( char * buf,  vec_t * position);
extern void  BotMatch_HelpAccompany ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_DefendKeyArea ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_GetItem ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_Camp ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_Patrol ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_GetFlag ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_AttackEnemyBase ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_RushBase ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_TaskPreference ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_ReturnFlag ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_JoinSubteam ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_LeaveSubteam ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_WhichTeam ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_CheckPoint ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_FormationSpace ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_Dismiss ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_Suicide ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_StartTeamLeaderShip ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_StopTeamLeaderShip ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_WhoIsTeamLeader ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_WhatAreYouDoing ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_WhatIsMyCommand ( bot_state_t * bs,  bot_match_t * match);
extern float  BotNearestVisibleItem ( bot_state_t * bs,  char * itemname,  bot_goal_t * goal);
extern void  BotMatch_WhereAreYou ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_LeadTheWay ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_Kill ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_CTF ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_EnterGame ( bot_state_t * bs,  bot_match_t * match);
extern void  BotMatch_NewLeader ( bot_state_t * bs,  bot_match_t * match);
extern void  BotRecordNodeSwitch ( bot_state_t * bs,  char * node,  char * str,  char * s);
extern int  BotGetAirGoal ( bot_state_t * bs,  bot_goal_t * goal);
extern int  BotGoForAir ( bot_state_t * bs,  int  tfl,  bot_goal_t * ltg,  float  range);
extern int  BotNearbyGoal ( bot_state_t * bs,  int  tfl,  bot_goal_t * ltg,  float  range);
extern int  BotReachedGoal ( bot_state_t * bs,  bot_goal_t * goal);
extern int  BotGetItemLongTermGoal ( bot_state_t * bs,  int  tfl,  bot_goal_t * goal);
extern int  BotGetLongTermGoal ( bot_state_t * bs,  int  tfl,  int  retreat,  bot_goal_t * goal);
extern int  BotLongTermGoal ( bot_state_t * bs,  int  tfl,  int  retreat,  bot_goal_t * goal);
extern int  BotSelectActivateWeapon ( bot_state_t * bs);
extern void  BotClearPath ( bot_state_t * bs,  bot_moveresult_t * moveresult);
extern void  AIEnter_Battle_SuicidalFight ( bot_state_t * bs,  char * s);
extern bot_goal_t * BotEnemyFlag ( bot_state_t * bs);
extern bot_goal_t * BotTeamFlag ( bot_state_t * bs);
extern qboolean  EntityCarriesFlag ( aas_entityinfo_t * entinfo);
extern qboolean  EntityIsChatting ( aas_entityinfo_t * entinfo);
extern qboolean  EntityHasQuad ( aas_entityinfo_t * entinfo);
extern void  BotRefuseOrder ( bot_state_t * bs);
extern void  BotCheckItemPickup ( bot_state_t * bs,  int * oldinventory);
extern void  BotSetTeleportTime ( bot_state_t * bs);
extern void  BotInitWaypoints ();
extern void  BotGoCamp ( bot_state_t * bs,  bot_goal_t * goal);
extern void  BotDontAvoid ( bot_state_t * bs,  char * itemname);
extern void  BotGoForPowerups ( bot_state_t * bs);
extern void  BotSetMovedir ( vec_t * angles,  vec_t * movedir);
extern int  BotModelMinsMaxs ( int  modelindex,  int  eType,  int  contents,  vec_t * mins,  vec_t * maxs);
extern int  BotFuncButtonActivateGoal ( bot_state_t * bs,  int  bspent,  bot_activategoal_t * activategoal);
extern int  BotFuncDoorActivateGoal ( bot_state_t * bs,  int  bspent,  bot_activategoal_t * activategoal);
extern int  BotTriggerMultipleActivateGoal ( bot_state_t * bs,  int  bspent,  bot_activategoal_t * activategoal);
extern int  BotPushOntoActivateGoalStack ( bot_state_t * bs,  bot_activategoal_t * activategoal);
extern int  BotIsGoingToActivateEntity ( bot_state_t * bs,  int  entitynum);
extern int  BotGetActivateGoal ( bot_state_t * bs,  int  entitynum,  bot_activategoal_t * activategoal);
extern int  BotGoForActivateGoal ( bot_state_t * bs,  bot_activategoal_t * activategoal);
extern void  BotPrintActivateGoalInfo ( bot_state_t * bs,  bot_activategoal_t * activategoal,  int  bspent);
extern void  BotRandomMove ( bot_state_t * bs,  bot_moveresult_t * moveresult);
extern void  BotCheckConsoleMessages ( bot_state_t * bs);
extern void  BotCheckForGrenades ( bot_state_t * bs,  entityState_t * state);
extern void  BotCheckEvents ( bot_state_t * bs,  entityState_t * state);
extern void  BotCheckSnapshot ( bot_state_t * bs);
extern void  BotCheckAir ( bot_state_t * bs);
extern void  BotSetupAlternativeRouteGoals ();
extern void  BotSetEntityNumForGoalWithModel ( bot_goal_t * goal,  int  eType,  char * modelname);
extern void  BotSetEntityNumForGoal ( bot_goal_t * goal,  char * classname);
extern int  BotGoalForBSPEntity ( char * classname,  bot_goal_t * goal);
extern void  BotReportStatus ( bot_state_t * bs);
extern void  BotTeamplayReport ();
extern void  BotSetInfoConfigString ( bot_state_t * bs);
extern void  BotUpdateInfoConfigStrings ();
extern void  BotInterbreedBots ();
extern void  BotWriteInterbreeded ( char * filename);
extern void  BotInterbreeding ();
extern float  AngleDifference ( float  ang1,  float  ang2);
extern float  BotChangeViewAngle ( float  angle,  float  ideal_angle,  float  speed);
extern void  BotChangeViewAngles ( bot_state_t * bs,  float  thinktime);
extern void  BotInputToUserCommand ( bot_input_t * bi,  usercmd_t * ucmd,  int * delta_angles,  int  time___0);
extern void  BotUpdateInput ( bot_state_t * bs,  int  time___0,  int  elapsed_time);
extern void  BotAIRegularUpdate ();
extern void  RemoveColorEscapeSequences ( char * text);
extern int  BotAI ( int  client,  float  thinktime);
extern void  BotScheduleBotThink ();
extern void  BotWriteSessionData ( bot_state_t * bs);
extern void  BotReadSessionData ( bot_state_t * bs);
extern int  BotInitLibrary ();
extern int  BotValidTeamLeader ( bot_state_t * bs);
extern int  BotNumTeamMates ( bot_state_t * bs);
extern int  BotClientTravelTimeToGoal ( int  client,  bot_goal_t * goal);
extern int  BotSortTeamMatesByBaseTravelTime ( bot_state_t * bs,  int * teammates,  int  maxteammates);
extern int  BotSortTeamMatesByTaskPreference ( bot_state_t * bs,  int * teammates,  int  numteammates);
extern void  BotSayTeamOrderAlways ( bot_state_t * bs,  int  toclient);
extern void  BotSayTeamOrder ( bot_state_t * bs,  int  toclient);
extern void  BotSayVoiceTeamOrder ( bot_state_t * bs,  int  toclient,  char * voicechat);
extern void  BotCTFOrders_BothFlagsNotAtBase ( bot_state_t * bs);
extern void  BotCTFOrders_FlagNotAtBase ( bot_state_t * bs);
extern void  BotCTFOrders_EnemyFlagNotAtBase ( bot_state_t * bs);
extern void  BotCTFOrders_BothFlagsAtBase ( bot_state_t * bs);
extern void  BotCTFOrders ( bot_state_t * bs);
extern void  BotCreateGroup ( bot_state_t * bs,  int * teammates,  int  groupsize);
extern void  BotTeamOrders ( bot_state_t * bs);
extern int  FindHumanTeamLeader ( bot_state_t * bs);
extern void  BotVoiceChat_GetFlag ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_Offense ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_DefendFlag ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_Patrol ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_Camp ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_FollowMe ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_FollowFlagCarrier ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_ReturnFlag ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_StartLeader ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_StopLeader ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_WhoIsLeader ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_WantOnDefense ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_WantOnOffense ( bot_state_t * bs,  int  client,  int  mode);
extern void  BotVoiceChat_Dummy ( bot_state_t * bs,  int  client,  int  mode);
extern void  PM_StartTorsoAnim ( int  anim);
extern void  PM_StartLegsAnim ( int  anim);
extern void  PM_ContinueLegsAnim ( int  anim);
extern void  PM_ContinueTorsoAnim ( int  anim);
extern void  PM_ForceLegsAnim ( int  anim);
extern void  PM_Friction ();
extern void  PM_Accelerate ( vec_t * wishdir,  float  wishspeed,  float  accel);
extern float  PM_CmdScale ( usercmd_t * cmd);
extern void  PM_SetMovementDir ();
extern qboolean  PM_CheckJump ();
extern qboolean  PM_CheckWaterJump ();
extern void  PM_WaterJumpMove ();
extern void  PM_WaterMove ();
extern void  PM_FlyMove ();
extern void  PM_AirMove ();
extern void  PM_GrappleMove ();
extern void  PM_WalkMove ();
extern void  PM_DeadMove ();
extern void  PM_NoclipMove ();
extern int  PM_FootstepForSurface ();
extern void  PM_CrashLand ();
extern int  PM_CorrectAllSolid ( trace_t * trace);
extern void  PM_GroundTraceMissed ();
extern void  PM_GroundTrace ();
extern void  PM_SetWaterLevel ();
extern void  PM_CheckDuck ();
extern void  PM_Footsteps ();
extern void  PM_WaterEvents ();
extern void  PM_BeginWeaponChange ( int  weapon);
extern void  PM_FinishWeaponChange ();
extern void  PM_TorsoAnimation ();
extern void  PM_Weapon ();
extern void  PM_Animate ();
extern void  PM_DropTimers ();
extern void  PmoveSingle ( pmove_t * pmove);
extern void  P_DamageFeedback ( gentity_t * player);
extern void  P_WorldEffects ( gentity_t * ent);
extern void  G_SetClientSound ( gentity_t * ent);
extern void  ClientImpacts ( gentity_t * ent,  pmove_t * pm);
extern void  SpectatorThink ( gentity_t * ent,  usercmd_t * ucmd);
extern qboolean  ClientInactivityTimer ( gclient_t * client);
extern void  ClientTimerActions ( gentity_t * ent,  int  msec);
extern void  ClientIntermissionThink ( gclient_t * client);
extern void  ClientEvents ( gentity_t * ent,  int  oldEventSequence);
extern void  SendPendingPredictableEvents ( playerState_t * ps);
extern void  ClientThink_real ( gentity_t * ent);
extern void  SpectatorClientEndFrame ( gentity_t * ent);
extern gentity_t * SpawnModelOnVictoryPad ( gentity_t * pad,  vec_t * offset,  gentity_t * ent,  int  place);
extern void  CelebrateStop ( gentity_t * player);
extern void  CelebrateStart ( gentity_t * player);
extern void  PodiumPlacementThink ( gentity_t * podium);
extern gentity_t * SpawnPodium ();
extern int  G_ParseInfos ( char * buf,  int  max,  char ** infos);
extern void  G_LoadArenasFromFile ( char * filename);
extern void  G_LoadArenas ();
extern char const   * G_GetArenaInfoByMap ( char const   * map);
extern void  PlayerIntroSound ( char const   * modelAndSkin);
extern void  G_AddRandomBot ( int  team);
extern int  G_RemoveRandomBot ( int  team);
extern int  G_CountHumanPlayers ( int  team);
extern int  G_CountBotPlayers ( int  team);
extern void  G_CheckMinimumPlayers ();
extern void  AddBotToSpawnQueue ( int  clientNum,  int  delay);
extern void  G_AddBot ( char const   * name,  float  skill,  char const   * team,  int  delay,  char * altname);
extern void  G_SpawnBots ( char * botList,  int  baseDelay);
extern void  G_LoadBotsFromFile ( char * filename);
extern void  G_LoadBots ();
extern void  SP_info_player_deathmatch ( gentity_t * ent);
extern void  SP_info_player_start ( gentity_t * ent);
extern void  SP_info_player_intermission ( gentity_t * ent);
extern gentity_t * SelectNearestDeathmatchSpawnPoint ( vec_t * from);
extern gentity_t * SelectRandomDeathmatchSpawnPoint ();
extern gentity_t * SelectRandomFurthestSpawnPoint ( vec_t * avoidPoint,  vec_t * origin,  vec_t * angles);
extern gentity_t * SelectInitialSpawnPoint ( vec_t * origin,  vec_t * angles);
extern gentity_t * SelectSpectatorSpawnPoint ( vec_t * origin,  vec_t * angles);
extern void  BodySink ( gentity_t * ent);
extern void  ClientCleanName ( char const   * in,  char * out,  int  outSize);
extern qboolean  CheatsOk ( gentity_t * ent);
extern char * ConcatArgs ( int  start);
extern void  SanitizeString ( char * in,  char * out);
extern int  ClientNumberFromString ( gentity_t * to,  char * s);
extern void  Cmd_Give_f ( gentity_t * ent);
extern void  Cmd_God_f ( gentity_t * ent);
extern void  Cmd_Notarget_f ( gentity_t * ent);
extern void  Cmd_Noclip_f ( gentity_t * ent);
extern void  Cmd_LevelShot_f ( gentity_t * ent);
extern void  Cmd_TeamTask_f ( gentity_t * ent);
extern void  Cmd_Kill_f ( gentity_t * ent);
extern void  Cmd_Team_f ( gentity_t * ent);
extern void  Cmd_Follow_f ( gentity_t * ent);
extern void  G_SayTo ( gentity_t * ent,  gentity_t * other,  int  mode,  int  color,  char const   * name,  char const   * message);
extern void  G_Say ( gentity_t * ent,  gentity_t * target,  int  mode,  char const   * chatText);
extern void  Cmd_Say_f ( gentity_t * ent,  int  mode,  qboolean  arg0);
extern void  Cmd_Tell_f ( gentity_t * ent);
extern void  G_VoiceTo ( gentity_t * ent,  gentity_t * other,  int  mode,  char const   * id,  qboolean  voiceonly);
extern void  G_Voice ( gentity_t * ent,  gentity_t * target,  int  mode,  char const   * id,  qboolean  voiceonly);
extern void  Cmd_Voice_f ( gentity_t * ent,  int  mode,  qboolean  arg0,  qboolean  voiceonly);
extern void  Cmd_VoiceTell_f ( gentity_t * ent,  qboolean  voiceonly);
extern void  Cmd_VoiceTaunt_f ( gentity_t * ent);
extern void  Cmd_GameCommand_f ( gentity_t * ent);
extern void  Cmd_Where_f ( gentity_t * ent);
extern void  Cmd_CallVote_f ( gentity_t * ent);
extern void  Cmd_Vote_f ( gentity_t * ent);
extern void  Cmd_CallTeamVote_f ( gentity_t * ent);
extern void  Cmd_TeamVote_f ( gentity_t * ent);
extern void  Cmd_SetViewpos_f ( gentity_t * ent);
extern void  Cmd_Stats_f ( gentity_t * ent);
extern void  ScorePlum ( gentity_t * ent,  vec_t * origin,  int  score);
extern void  LookAtKiller ( gentity_t * self,  gentity_t * inflictor,  gentity_t * attacker);
extern void  GibEntity ( gentity_t * self,  int  killer);
extern void  CheckAlmostCapture ( gentity_t * self,  gentity_t * attacker);
extern void  CheckAlmostScored ( gentity_t * self,  gentity_t * attacker);
extern int  CheckArmor ( gentity_t * ent,  int  damage,  int  dflags);
extern int  RaySphereIntersections ( vec_t * origin,  float  radius,  vec_t * point,  vec_t * dir,  vec3_t * intersections);
extern int  Pickup_Powerup ( gentity_t * ent,  gentity_t * other);
extern int  Pickup_Holdable ( gentity_t * ent,  gentity_t * other);
extern int  Pickup_Ammo ( gentity_t * ent,  gentity_t * other);
extern int  Pickup_Weapon ( gentity_t * ent,  gentity_t * other);
extern int  Pickup_Health ( gentity_t * ent,  gentity_t * other);
extern int  Pickup_Armor ( gentity_t * ent,  gentity_t * other);
extern void  Use_Item ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern int  G_ItemDisabled ( gitem_t * item);
extern void  G_BounceItem ( gentity_t * ent,  trace_t * trace);
extern int  qagame_vmMain ( int  command,  int  arg0,  int  arg1,  int  arg2,  int  arg3,  int  arg4,  int  arg5,  int  arg6,  int  arg7,  int  arg8,  int  arg9,  int  arg10,  int  arg11);
extern void  G_FindTeams ();
extern void  G_RemapTeamShaders ();
extern void  G_RegisterCvars ();
extern void  G_UpdateCvars ();
extern void  G_InitGame ( int  levelTime,  int  randomSeed,  int  restart);
extern void  G_ShutdownGame ( int  restart);
extern void  AddTournamentPlayer ();
extern void  RemoveTournamentLoser ();
extern void  RemoveTournamentWinner ();
extern void  AdjustTournamentScores ();
extern int  SortRanks ( void const   * a,  void const   * b);
extern void  ExitLevel ();
extern void  LogExit ( char const   * string);
extern void  CheckIntermissionExit ();
extern qboolean  ScoreIsTied ();
extern void  CheckExitRules ();
extern void  CheckTournament ();
extern void  CheckVote ();
extern void  PrintTeam ( int  team,  char * message);
extern void  CheckTeamVote ( int  team);
extern void  CheckCvars ();
extern void  G_RunFrame ( int  levelTime);
extern void  SP_info_camp ( gentity_t * self);
extern void  SP_info_null ( gentity_t * self);
extern void  SP_info_notnull ( gentity_t * self);
extern void  SP_light ( gentity_t * self);
extern void  SP_misc_teleporter_dest ( gentity_t * ent);
extern void  SP_misc_model ( gentity_t * ent);
extern void  locateCamera ( gentity_t * ent);
extern void  SP_misc_portal_surface ( gentity_t * ent);
extern void  SP_misc_portal_camera ( gentity_t * ent);
extern void  Use_Shooter ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  InitShooter_Finish ( gentity_t * ent);
extern void  InitShooter ( gentity_t * ent,  int  weapon);
extern void  SP_shooter_rocket ( gentity_t * ent);
extern void  SP_shooter_plasma ( gentity_t * ent);
extern void  SP_shooter_grenade ( gentity_t * ent);
extern void  G_BounceMissile ( gentity_t * ent,  trace_t * trace);
extern void  G_ExplodeMissile ( gentity_t * ent);
extern void  G_MissileImpact ( gentity_t * ent,  trace_t * trace);
extern gentity_t * G_TestEntityPosition ( gentity_t * ent);
extern void  G_CreateRotationMatrix ( vec_t * angles,  vec3_t * matrix);
extern void  G_TransposeMatrix ( vec3_t * matrix,  vec3_t * transpose);
extern void  G_RotatePoint ( vec_t * point,  vec3_t * matrix);
extern qboolean  G_TryPushingEntity ( gentity_t * check,  gentity_t * pusher,  vec_t * move,  vec_t * amove);
extern qboolean  G_CheckProxMinePosition ( gentity_t * check);
extern qboolean  G_TryPushingProxMine ( gentity_t * check,  gentity_t * pusher,  vec_t * move,  vec_t * amove);
extern qboolean  G_MoverPush ( gentity_t * pusher,  vec_t * move,  vec_t * amove,  gentity_t ** obstacle);
extern void  G_MoverTeam ( gentity_t * ent);
extern void  SetMoverState ( gentity_t * ent,  moverState_t  moverState,  int  time___0);
extern void  MatchTeam ( gentity_t * teamLeader,  int  moverState,  int  time___0);
extern void  ReturnToPos1 ( gentity_t * ent);
extern void  Reached_BinaryMover ( gentity_t * ent);
extern void  Use_BinaryMover ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  InitMover ( gentity_t * ent);
extern void  Blocked_Door ( gentity_t * ent,  gentity_t * other);
extern void  Touch_DoorTriggerSpectator ( gentity_t * ent,  gentity_t * other,  trace_t * trace);
extern void  Think_SpawnNewDoorTrigger ( gentity_t * ent);
extern void  Think_MatchTeam ( gentity_t * ent);
extern void  SP_func_door ( gentity_t * ent);
extern void  Touch_Plat ( gentity_t * ent,  gentity_t * other,  trace_t * trace);
extern void  Touch_PlatCenterTrigger ( gentity_t * ent,  gentity_t * other,  trace_t * trace);
extern void  SpawnPlatTrigger ( gentity_t * ent);
extern void  SP_func_plat ( gentity_t * ent);
extern void  Touch_Button ( gentity_t * ent,  gentity_t * other,  trace_t * trace);
extern void  SP_func_button ( gentity_t * ent);
extern void  Think_BeginMoving ( gentity_t * ent);
extern void  Reached_Train ( gentity_t * ent);
extern void  Think_SetupTrainTargets ( gentity_t * ent);
extern void  SP_path_corner ( gentity_t * self);
extern void  SP_func_train ( gentity_t * self);
extern void  SP_func_static ( gentity_t * ent);
extern void  SP_func_rotating ( gentity_t * ent);
extern void  SP_func_bobbing ( gentity_t * ent);
extern void  SP_func_pendulum ( gentity_t * ent);
extern void  G_WriteClientSessionData ( gclient_t * client);
extern void  SP_item_botroam ( gentity_t * ent);
extern qboolean  G_CallSpawn ( gentity_t * ent);
extern void  G_ParseField ( char const   * key,  char const   * value,  gentity_t * ent);
extern void  G_SpawnGEntityFromSpawnVars ();
extern char * G_AddSpawnVarToken ( char const   * string);
extern qboolean  G_ParseSpawnVars ();
extern void  SP_worldspawn ();
extern qboolean  StringToFilter ( char * s,  ipFilter_t * f);
extern void  UpdateIPBans ();
extern void  AddIP ( char * str);
extern void  Svcmd_AddIP_f ();
extern void  Svcmd_RemoveIP_f ();
extern void  Svcmd_EntityList_f ();
extern gclient_t * ClientForString ( char const   * s);
extern void  Svcmd_ForceTeam_f ();
extern int  PASSFLOAT ( float  x);
extern void  trap_TraceCapsule ( trace_t * results,  vec_t * start,  vec_t * mins,  vec_t * maxs,  vec_t * end,  int  passEntityNum,  int  contentmask);
extern qboolean  trap_EntityContactCapsule ( vec_t * mins,  vec_t * maxs,  gentity_t const   * ent);
extern int  trap_RealTime ( qtime_t * qtime);
extern int  trap_PC_LoadSource ( char const   * filename);
extern int  trap_PC_FreeSource ( int  handle);
extern int  trap_PC_ReadToken ( int  handle,  pc_token_t * pc_token);
extern int  trap_PC_SourceFileAndLine ( int  handle,  char * filename,  int * line);
extern void  Use_Target_Give ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_give ( gentity_t * ent);
extern void  Use_target_remove_powerups ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_remove_powerups ( gentity_t * ent);
extern void  Think_Target_Delay ( gentity_t * ent);
extern void  Use_Target_Delay ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_delay ( gentity_t * ent);
extern void  Use_Target_Score ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_score ( gentity_t * ent);
extern void  Use_Target_Print ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_print ( gentity_t * ent);
extern void  Use_Target_Speaker ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_speaker ( gentity_t * ent);
extern void  target_laser_think ( gentity_t * self);
extern void  target_laser_on ( gentity_t * self);
extern void  target_laser_off ( gentity_t * self);
extern void  target_laser_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  target_laser_start ( gentity_t * self);
extern void  SP_target_laser ( gentity_t * self);
extern void  target_teleporter_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_teleporter ( gentity_t * self);
extern void  target_relay_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_relay ( gentity_t * self);
extern void  target_kill_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_kill ( gentity_t * self);
extern void  SP_target_position ( gentity_t * self);
extern void  target_location_linkup ( gentity_t * ent);
extern void  SP_target_location ( gentity_t * self);
extern void  Team_SetFlagStatus ( int  team,  flagStatus_t  status);
extern void  Team_ForceGesture ( int  team);
extern gentity_t * Team_ResetFlag ( int  team);
extern void  Team_ResetFlags ();
extern void  Team_ReturnFlagSound ( gentity_t * ent,  int  team);
extern void  Team_TakeFlagSound ( gentity_t * ent,  int  team);
extern void  Team_CaptureFlagSound ( gentity_t * ent,  int  team);
extern int  Team_TouchOurFlag ( gentity_t * ent,  gentity_t * other,  int  team);
extern int  Team_TouchEnemyFlag ( gentity_t * ent,  gentity_t * other,  int  team);
extern gentity_t * SelectRandomTeamSpawnPoint ( int  teamstate,  team_t  team);
extern int  SortClients ( void const   * a,  void const   * b);
extern void  SP_team_CTF_redplayer ( gentity_t * ent);
extern void  SP_team_CTF_blueplayer ( gentity_t * ent);
extern void  SP_team_CTF_redspawn ( gentity_t * ent);
extern void  SP_team_CTF_bluespawn ( gentity_t * ent);
extern void  InitTrigger ( gentity_t * self);
extern void  multi_wait ( gentity_t * ent);
extern void  multi_trigger ( gentity_t * ent,  gentity_t * activator);
extern void  Use_Multi ( gentity_t * ent,  gentity_t * other,  gentity_t * activator);
extern void  Touch_Multi ( gentity_t * self,  gentity_t * other,  trace_t * trace);
extern void  SP_trigger_multiple ( gentity_t * ent);
extern void  trigger_always_think ( gentity_t * ent);
extern void  SP_trigger_always ( gentity_t * ent);
extern void  trigger_push_touch ( gentity_t * self,  gentity_t * other,  trace_t * trace);
extern void  AimAtTarget ( gentity_t * self);
extern void  SP_trigger_push ( gentity_t * self);
extern void  Use_target_push ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  SP_target_push ( gentity_t * self);
extern void  SP_trigger_teleport ( gentity_t * self);
extern void  hurt_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  hurt_touch ( gentity_t * self,  gentity_t * other,  trace_t * trace);
extern void  SP_trigger_hurt ( gentity_t * self);
extern void  func_timer_think ( gentity_t * self);
extern void  func_timer_use ( gentity_t * self,  gentity_t * other,  gentity_t * activator);
extern void  SP_func_timer ( gentity_t * self);
extern int  G_FindConfigstringIndex ( char * name,  int  start,  int  max,  qboolean  create);
extern int  DebugLine ( vec_t * start,  vec_t * end,  int  color);
extern void  G_BounceProjectile ( vec_t * start,  vec_t * impact,  vec_t * dir,  vec_t * endout);
extern void  Weapon_Gauntlet ( gentity_t * ent);
extern void  Bullet_Fire ( gentity_t * ent,  float  spread,  int  damage);
extern void  BFG_Fire ( gentity_t * ent);
extern qboolean  ShotgunPellet ( vec_t * start,  vec_t * end,  gentity_t * ent);
extern void  ShotgunPattern ( vec_t * origin,  vec_t * origin2,  int  seed,  gentity_t * ent);
extern void  weapon_supershotgun_fire ( gentity_t * ent);
extern void  weapon_grenadelauncher_fire ( gentity_t * ent);
extern void  Weapon_RocketLauncher_Fire ( gentity_t * ent);
extern void  Weapon_Plasmagun_Fire ( gentity_t * ent);
extern void  weapon_railgun_fire ( gentity_t * ent);
extern void  Weapon_GrapplingHook_Fire ( gentity_t * ent);
extern void  Weapon_LightningFire ( gentity_t * ent);
extern void  CalcMuzzlePointOrigin ( gentity_t * ent,  vec_t * origin,  vec_t * forward,  vec_t * right,  vec_t * up,  vec_t * muzzlePoint);
extern short  ShortNoSwap ( short  l);
extern int  LongNoSwap ( int  l);
extern qint64  Long64Swap ( qint64  ll);
extern qint64  Long64NoSwap ( qint64  ll);
extern float  FloatNoSwap ( float const   * f);
extern char * SkipWhitespace ( char * data,  qboolean * hasNewLines);
extern void  Info_RemoveKey_Big ( char * s,  char const   * key);

void *g_FunctionPointers [] = 
{
	(void *) BotNumActivePlayers,
	(void *) BotIsFirstInRankings,
	(void *) BotIsLastInRankings,
	(void *) BotFirstClientInRankings,
	(void *) BotLastClientInRankings,
	(void *) BotRandomOpponentName,
	(void *) BotMapTitle,
	(void *) BotWeaponNameForMeansOfDeath,
	(void *) BotRandomWeaponName,
	(void *) BotVisibleEnemies,
	(void *) BotValidChatPosition,
	(void *) BotChat_EnterGame,
	(void *) BotChat_ExitGame,
	(void *) BotChat_StartLevel,
	(void *) BotChat_EndLevel,
	(void *) BotChat_Death,
	(void *) BotChat_Kill,
	(void *) BotChat_EnemySuicide,
	(void *) BotChat_HitTalking,
	(void *) BotChat_HitNoDeath,
	(void *) BotChat_HitNoKill,
	(void *) BotChat_Random,
	(void *) BotChatTime,
	(void *) BotChatTest,
	(void *) VectorLength,
	(void *) BotGetItemTeamGoal,
	(void *) BotGetMessageTeamGoal,
	(void *) BotGetTime,
	(void *) FindClientByName,
	(void *) FindEnemyByName,
	(void *) NumPlayersOnSameTeam,
	(void *) BotGetPatrolWaypoints,
	(void *) BotAddressedToBot,
	(void *) BotGPSToPosition,
	(void *) BotMatch_HelpAccompany,
	(void *) BotMatch_DefendKeyArea,
	(void *) BotMatch_GetItem,
	(void *) BotMatch_Camp,
	(void *) BotMatch_Patrol,
	(void *) BotMatch_GetFlag,
	(void *) BotMatch_AttackEnemyBase,
	(void *) BotMatch_RushBase,
	(void *) BotMatch_TaskPreference,
	(void *) BotMatch_ReturnFlag,
	(void *) BotMatch_JoinSubteam,
	(void *) BotMatch_LeaveSubteam,
	(void *) BotMatch_WhichTeam,
	(void *) BotMatch_CheckPoint,
	(void *) BotMatch_FormationSpace,
	(void *) BotMatch_Dismiss,
	(void *) BotMatch_Suicide,
	(void *) BotMatch_StartTeamLeaderShip,
	(void *) BotMatch_StopTeamLeaderShip,
	(void *) BotMatch_WhoIsTeamLeader,
	(void *) BotMatch_WhatAreYouDoing,
	(void *) BotMatch_WhatIsMyCommand,
	(void *) BotNearestVisibleItem,
	(void *) BotMatch_WhereAreYou,
	(void *) BotMatch_LeadTheWay,
	(void *) BotMatch_Kill,
	(void *) BotMatch_CTF,
	(void *) BotMatch_EnterGame,
	(void *) BotMatch_NewLeader,
	(void *) BotMatchMessage,
	(void *) VectorCompare,
	(void *) VectorLengthSquared,
	(void *) BotResetNodeSwitches,
	(void *) BotDumpNodeSwitches,
	(void *) BotRecordNodeSwitch,
	(void *) BotGetAirGoal,
	(void *) BotGoForAir,
	(void *) BotNearbyGoal,
	(void *) BotReachedGoal,
	(void *) BotGetItemLongTermGoal,
	(void *) BotGetLongTermGoal,
	(void *) BotLongTermGoal,
	(void *) AIEnter_Intermission,
	(void *) AINode_Intermission,
	(void *) AIEnter_Observer,
	(void *) AINode_Observer,
	(void *) AIEnter_Stand,
	(void *) AINode_Stand,
	(void *) AIEnter_Respawn,
	(void *) AINode_Respawn,
	(void *) BotSelectActivateWeapon,
	(void *) BotClearPath,
	(void *) AIEnter_Seek_ActivateEntity,
	(void *) AINode_Seek_ActivateEntity,
	(void *) AIEnter_Seek_NBG,
	(void *) AINode_Seek_NBG,
	(void *) AIEnter_Seek_LTG,
	(void *) AINode_Seek_LTG,
	(void *) AIEnter_Battle_Fight,
	(void *) AIEnter_Battle_SuicidalFight,
	(void *) AINode_Battle_Fight,
	(void *) AIEnter_Battle_Chase,
	(void *) AINode_Battle_Chase,
	(void *) AIEnter_Battle_Retreat,
	(void *) AINode_Battle_Retreat,
	(void *) AIEnter_Battle_NBG,
	(void *) AINode_Battle_NBG,
	(void *) CrossProduct,
	(void *) BotSetUserInfo,
	(void *) BotCTFCarryingFlag,
	(void *) BotTeam,
	(void *) BotOppositeTeam,
	(void *) BotEnemyFlag,
	(void *) BotTeamFlag,
	(void *) EntityIsDead,
	(void *) EntityCarriesFlag,
	(void *) EntityIsInvisible,
	(void *) EntityIsShooting,
	(void *) EntityIsChatting,
	(void *) EntityHasQuad,
	(void *) BotRememberLastOrderedTask,
	(void *) BotSetTeamStatus,
	(void *) BotSetLastOrderedTask,
	(void *) BotRefuseOrder,
	(void *) BotCTFSeekGoals,
	(void *) BotCTFRetreatGoals,
	(void *) BotTeamGoals,
	(void *) BotPointAreaNum,
	(void *) ClientName,
	(void *) ClientSkin,
	(void *) ClientFromName,
	(void *) ClientOnSameTeamFromName,
	(void *) stristr,
	(void *) EasyClientName,
	(void *) BotSynonymContext,
	(void *) BotChooseWeapon,
	(void *) BotSetupForMovement,
	(void *) BotCheckItemPickup,
	(void *) BotUpdateInventory,
	(void *) BotUpdateBattleInventory,
	(void *) BotBattleUseItems,
	(void *) BotSetTeleportTime,
	(void *) BotIsDead,
	(void *) BotIsObserver,
	(void *) BotIntermission,
	(void *) BotInLavaOrSlime,
	(void *) BotCreateWayPoint,
	(void *) BotFindWayPoint,
	(void *) BotFreeWaypoints,
	(void *) BotInitWaypoints,
	(void *) TeamPlayIsOn,
	(void *) BotAggression,
	(void *) BotFeelingBad,
	(void *) BotWantsToRetreat,
	(void *) BotWantsToChase,
	(void *) BotWantsToHelp,
	(void *) BotCanAndWantsToRocketJump,
	(void *) BotHasPersistantPowerupAndWeapon,
	(void *) BotGoCamp,
	(void *) BotWantsToCamp,
	(void *) BotDontAvoid,
	(void *) BotGoForPowerups,
	(void *) BotRoamGoal,
	(void *) BotAttackMove,
	(void *) BotSameTeam,
	(void *) InFieldOfVision,
	(void *) BotEntityVisible,
	(void *) BotFindEnemy,
	(void *) BotTeamFlagCarrierVisible,
	(void *) BotTeamFlagCarrier,
	(void *) BotEnemyFlagCarrierVisible,
	(void *) BotVisibleTeamMatesAndEnemies,
	(void *) BotAimAtEnemy,
	(void *) BotCheckAttack,
	(void *) BotMapScripts,
	(void *) BotSetMovedir,
	(void *) BotModelMinsMaxs,
	(void *) BotFuncButtonActivateGoal,
	(void *) BotFuncDoorActivateGoal,
	(void *) BotTriggerMultipleActivateGoal,
	(void *) BotPopFromActivateGoalStack,
	(void *) BotPushOntoActivateGoalStack,
	(void *) BotClearActivateGoalStack,
	(void *) BotEnableActivateGoalAreas,
	(void *) BotIsGoingToActivateEntity,
	(void *) BotGetActivateGoal,
	(void *) BotGoForActivateGoal,
	(void *) BotPrintActivateGoalInfo,
	(void *) BotRandomMove,
	(void *) BotAIBlocked,
	(void *) BotAIPredictObstacles,
	(void *) BotCheckConsoleMessages,
	(void *) BotCheckForGrenades,
	(void *) BotCheckEvents,
	(void *) BotCheckSnapshot,
	(void *) BotCheckAir,
	(void *) BotAlternateRoute,
	(void *) BotGetAlternateRouteGoal,
	(void *) BotSetupAlternativeRouteGoals,
	(void *) BotDeathmatchAI,
	(void *) BotSetEntityNumForGoalWithModel,
	(void *) BotSetEntityNumForGoal,
	(void *) BotGoalForBSPEntity,
	(void *) BotSetupDeathmatchAI,
	(void *) BotShutdownDeathmatchAI,
	(void *) BotAI_Print,
	(void *) BotAI_Trace,
	(void *) BotAI_GetClientState,
	(void *) BotAI_GetEntityState,
	(void *) BotAI_GetSnapshotEntity,
	(void *) BotAI_BotInitialChat,
	(void *) BotTestAAS,
	(void *) BotReportStatus,
	(void *) BotTeamplayReport,
	(void *) BotSetInfoConfigString,
	(void *) BotUpdateInfoConfigStrings,
	(void *) BotInterbreedBots,
	(void *) BotWriteInterbreeded,
	(void *) BotInterbreedEndMatch,
	(void *) BotInterbreeding,
	(void *) BotEntityInfo,
	(void *) NumBots,
	(void *) BotTeamLeader,
	(void *) AngleDifference,
	(void *) BotChangeViewAngle,
	(void *) BotChangeViewAngles,
	(void *) BotInputToUserCommand,
	(void *) BotUpdateInput,
	(void *) BotAIRegularUpdate,
	(void *) RemoveColorEscapeSequences,
	(void *) BotAI,
	(void *) BotScheduleBotThink,
	(void *) BotWriteSessionData,
	(void *) BotReadSessionData,
	(void *) BotAISetupClient,
	(void *) BotAIShutdownClient,
	(void *) BotResetState,
	(void *) BotAILoadMap,
	(void *) BotAIStartFrame,
	(void *) BotInitLibrary,
	(void *) BotAISetup,
	(void *) BotAIShutdown,
	(void *) BotValidTeamLeader,
	(void *) BotNumTeamMates,
	(void *) BotClientTravelTimeToGoal,
	(void *) BotSortTeamMatesByBaseTravelTime,
	(void *) BotSetTeamMateTaskPreference,
	(void *) BotGetTeamMateTaskPreference,
	(void *) BotSortTeamMatesByTaskPreference,
	(void *) BotSayTeamOrderAlways,
	(void *) BotSayTeamOrder,
	(void *) BotVoiceChat,
	(void *) BotVoiceChatOnly,
	(void *) BotSayVoiceTeamOrder,
	(void *) BotCTFOrders_BothFlagsNotAtBase,
	(void *) BotCTFOrders_FlagNotAtBase,
	(void *) BotCTFOrders_EnemyFlagNotAtBase,
	(void *) BotCTFOrders_BothFlagsAtBase,
	(void *) BotCTFOrders,
	(void *) BotCreateGroup,
	(void *) BotTeamOrders,
	(void *) FindHumanTeamLeader,
	(void *) BotTeamAI,
	(void *) BotVoiceChat_GetFlag,
	(void *) BotVoiceChat_Offense,
	(void *) BotVoiceChat_Defend,
	(void *) BotVoiceChat_DefendFlag,
	(void *) BotVoiceChat_Patrol,
	(void *) BotVoiceChat_Camp,
	(void *) BotVoiceChat_FollowMe,
	(void *) BotVoiceChat_FollowFlagCarrier,
	(void *) BotVoiceChat_ReturnFlag,
	(void *) BotVoiceChat_StartLeader,
	(void *) BotVoiceChat_StopLeader,
	(void *) BotVoiceChat_WhoIsLeader,
	(void *) BotVoiceChat_WantOnDefense,
	(void *) BotVoiceChat_WantOnOffense,
	(void *) BotVoiceChat_Dummy,
	(void *) BotVoiceChatCommand,
	(void *) BG_FindItemForPowerup,
	(void *) BG_FindItemForHoldable,
	(void *) BG_FindItemForWeapon,
	(void *) BG_FindItem,
	(void *) BG_PlayerTouchesItem,
	(void *) BG_CanItemBeGrabbed,
	(void *) BG_EvaluateTrajectory,
	(void *) BG_EvaluateTrajectoryDelta,
	(void *) BG_AddPredictableEventToPlayerstate,
	(void *) BG_TouchJumpPad,
	(void *) BG_PlayerStateToEntityState,
	(void *) BG_PlayerStateToEntityStateExtraPolate,
	(void *) PM_AddEvent,
	(void *) PM_AddTouchEnt,
	(void *) PM_StartTorsoAnim,
	(void *) PM_StartLegsAnim,
	(void *) PM_ContinueLegsAnim,
	(void *) PM_ContinueTorsoAnim,
	(void *) PM_ForceLegsAnim,
	(void *) PM_ClipVelocity,
	(void *) PM_Friction,
	(void *) PM_Accelerate,
	(void *) PM_CmdScale,
	(void *) PM_SetMovementDir,
	(void *) PM_CheckJump,
	(void *) PM_CheckWaterJump,
	(void *) PM_WaterJumpMove,
	(void *) PM_WaterMove,
	(void *) PM_FlyMove,
	(void *) PM_AirMove,
	(void *) PM_GrappleMove,
	(void *) PM_WalkMove,
	(void *) PM_DeadMove,
	(void *) PM_NoclipMove,
	(void *) PM_FootstepForSurface,
	(void *) PM_CrashLand,
	(void *) PM_CorrectAllSolid,
	(void *) PM_GroundTraceMissed,
	(void *) PM_GroundTrace,
	(void *) PM_SetWaterLevel,
	(void *) PM_CheckDuck,
	(void *) PM_Footsteps,
	(void *) PM_WaterEvents,
	(void *) PM_BeginWeaponChange,
	(void *) PM_FinishWeaponChange,
	(void *) PM_TorsoAnimation,
	(void *) PM_Weapon,
	(void *) PM_Animate,
	(void *) PM_DropTimers,
	(void *) PM_UpdateViewAngles,
	(void *) PmoveSingle,
	(void *) Pmove,
	(void *) PM_SlideMove,
	(void *) PM_StepSlideMove,
	(void *) P_DamageFeedback,
	(void *) P_WorldEffects,
	(void *) G_SetClientSound,
	(void *) ClientImpacts,
	(void *) G_TouchTriggers,
	(void *) SpectatorThink,
	(void *) ClientInactivityTimer,
	(void *) ClientTimerActions,
	(void *) ClientIntermissionThink,
	(void *) ClientEvents,
	(void *) SendPendingPredictableEvents,
	(void *) ClientThink_real,
	(void *) ClientThink,
	(void *) G_RunClient,
	(void *) SpectatorClientEndFrame,
	(void *) ClientEndFrame,
	(void *) UpdateTournamentInfo,
	(void *) SpawnModelOnVictoryPad,
	(void *) CelebrateStop,
	(void *) CelebrateStart,
	(void *) PodiumPlacementThink,
	(void *) SpawnPodium,
	(void *) SpawnModelsOnVictoryPads,
	(void *) Svcmd_AbortPodium_f,
	(void *) trap_Cvar_VariableValue,
	(void *) G_ParseInfos,
	(void *) G_LoadArenasFromFile,
	(void *) G_LoadArenas,
	(void *) G_GetArenaInfoByMap,
	(void *) PlayerIntroSound,
	(void *) G_AddRandomBot,
	(void *) G_RemoveRandomBot,
	(void *) G_CountHumanPlayers,
	(void *) G_CountBotPlayers,
	(void *) G_CheckMinimumPlayers,
	(void *) G_CheckBotSpawn,
	(void *) AddBotToSpawnQueue,
	(void *) G_RemoveQueuedBotBegin,
	(void *) G_BotConnect,
	(void *) G_AddBot,
	(void *) Svcmd_AddBot_f,
	(void *) Svcmd_BotList_f,
	(void *) G_SpawnBots,
	(void *) G_LoadBotsFromFile,
	(void *) G_LoadBots,
	(void *) G_GetBotInfoByNumber,
	(void *) G_GetBotInfoByName,
	(void *) G_InitBots,
	(void *) SP_info_player_deathmatch,
	(void *) SP_info_player_start,
	(void *) SP_info_player_intermission,
	(void *) SpotWouldTelefrag,
	(void *) SelectNearestDeathmatchSpawnPoint,
	(void *) SelectRandomDeathmatchSpawnPoint,
	(void *) SelectRandomFurthestSpawnPoint,
	(void *) SelectSpawnPoint,
	(void *) SelectInitialSpawnPoint,
	(void *) SelectSpectatorSpawnPoint,
	(void *) InitBodyQue,
	(void *) BodySink,
	(void *) CopyToBodyQue,
	(void *) SetClientViewAngle,
	(void *) respawn,
	(void *) TeamCount,
	(void *) TeamLeader,
	(void *) PickTeam,
	(void *) ClientCleanName,
	(void *) ClientUserinfoChanged,
	(void *) ClientConnect,
	(void *) ClientBegin,
	(void *) ClientSpawn,
	(void *) ClientDisconnect,
	(void *) DeathmatchScoreboardMessage,
	(void *) Cmd_Score_f,
	(void *) CheatsOk,
	(void *) ConcatArgs,
	(void *) SanitizeString,
	(void *) ClientNumberFromString,
	(void *) Cmd_Give_f,
	(void *) Cmd_God_f,
	(void *) Cmd_Notarget_f,
	(void *) Cmd_Noclip_f,
	(void *) Cmd_LevelShot_f,
	(void *) Cmd_TeamTask_f,
	(void *) Cmd_Kill_f,
	(void *) BroadcastTeamChange,
	(void *) SetTeam,
	(void *) StopFollowing,
	(void *) Cmd_Team_f,
	(void *) Cmd_Follow_f,
	(void *) Cmd_FollowCycle_f,
	(void *) G_SayTo,
	(void *) G_Say,
	(void *) Cmd_Say_f,
	(void *) Cmd_Tell_f,
	(void *) G_VoiceTo,
	(void *) G_Voice,
	(void *) Cmd_Voice_f,
	(void *) Cmd_VoiceTell_f,
	(void *) Cmd_VoiceTaunt_f,
	(void *) Cmd_GameCommand_f,
	(void *) Cmd_Where_f,
	(void *) Cmd_CallVote_f,
	(void *) Cmd_Vote_f,
	(void *) Cmd_CallTeamVote_f,
	(void *) Cmd_TeamVote_f,
	(void *) Cmd_SetViewpos_f,
	(void *) Cmd_Stats_f,
	(void *) ClientCommand,
	(void *) ScorePlum,
	(void *) AddScore,
	(void *) TossClientItems,
	(void *) LookAtKiller,
	(void *) GibEntity,
	(void *) body_die,
	(void *) CheckAlmostCapture,
	(void *) CheckAlmostScored,
	(void *) player_die,
	(void *) CheckArmor,
	(void *) RaySphereIntersections,
	(void *) G_Damage,
	(void *) CanDamage,
	(void *) G_RadiusDamage,
	(void *) Pickup_Powerup,
	(void *) Pickup_Holdable,
	(void *) Add_Ammo,
	(void *) Pickup_Ammo,
	(void *) Pickup_Weapon,
	(void *) Pickup_Health,
	(void *) Pickup_Armor,
	(void *) RespawnItem,
	(void *) Touch_Item,
	(void *) LaunchItem,
	(void *) Drop_Item,
	(void *) Use_Item,
	(void *) FinishSpawningItem,
	(void *) G_CheckTeamItems,
	(void *) ClearRegisteredItems,
	(void *) RegisterItem,
	(void *) SaveRegisteredItems,
	(void *) G_ItemDisabled,
	(void *) G_SpawnItem,
	(void *) G_BounceItem,
	(void *) G_RunItem,
	(void *) qagame_vmMain,
	(void *) G_Printf,
	(void *) G_Error,
	(void *) G_FindTeams,
	(void *) G_RemapTeamShaders,
	(void *) G_RegisterCvars,
	(void *) G_UpdateCvars,
	(void *) G_InitGame,
	(void *) G_ShutdownGame,
	(void *) AddTournamentPlayer,
	(void *) RemoveTournamentLoser,
	(void *) RemoveTournamentWinner,
	(void *) AdjustTournamentScores,
	(void *) SortRanks,
	(void *) CalculateRanks,
	(void *) SendScoreboardMessageToAllClients,
	(void *) MoveClientToIntermission,
	(void *) FindIntermissionPoint,
	(void *) BeginIntermission,
	(void *) ExitLevel,
	(void *) G_LogPrintf,
	(void *) LogExit,
	(void *) CheckIntermissionExit,
	(void *) ScoreIsTied,
	(void *) CheckExitRules,
	(void *) CheckTournament,
	(void *) CheckVote,
	(void *) PrintTeam,
	(void *) SetLeader,
	(void *) CheckTeamLeader,
	(void *) CheckTeamVote,
	(void *) CheckCvars,
	(void *) G_RunThink,
	(void *) G_RunFrame,
	(void *) G_Alloc,
	(void *) G_InitMemory,
	(void *) Svcmd_GameMem_f,
	(void *) SP_info_camp,
	(void *) SP_info_null,
	(void *) SP_info_notnull,
	(void *) SP_light,
	(void *) TeleportPlayer,
	(void *) SP_misc_teleporter_dest,
	(void *) SP_misc_model,
	(void *) locateCamera,
	(void *) SP_misc_portal_surface,
	(void *) SP_misc_portal_camera,
	(void *) Use_Shooter,
	(void *) InitShooter_Finish,
	(void *) InitShooter,
	(void *) SP_shooter_rocket,
	(void *) SP_shooter_plasma,
	(void *) SP_shooter_grenade,
	(void *) G_BounceMissile,
	(void *) G_ExplodeMissile,
	(void *) G_MissileImpact,
	(void *) G_RunMissile,
	(void *) fire_plasma,
	(void *) fire_grenade,
	(void *) fire_bfg,
	(void *) fire_rocket,
	(void *) fire_grapple,
	(void *) VectorInverse,
	(void *) G_TestEntityPosition,
	(void *) G_CreateRotationMatrix,
	(void *) G_TransposeMatrix,
	(void *) G_RotatePoint,
	(void *) G_TryPushingEntity,
	(void *) G_CheckProxMinePosition,
	(void *) G_TryPushingProxMine,
	(void *) G_MoverPush,
	(void *) G_MoverTeam,
	(void *) G_RunMover,
	(void *) SetMoverState,
	(void *) MatchTeam,
	(void *) ReturnToPos1,
	(void *) Reached_BinaryMover,
	(void *) Use_BinaryMover,
	(void *) InitMover,
	(void *) Blocked_Door,
	(void *) Touch_DoorTriggerSpectator,
	(void *) Touch_DoorTrigger,
	(void *) Think_SpawnNewDoorTrigger,
	(void *) Think_MatchTeam,
	(void *) SP_func_door,
	(void *) Touch_Plat,
	(void *) Touch_PlatCenterTrigger,
	(void *) SpawnPlatTrigger,
	(void *) SP_func_plat,
	(void *) Touch_Button,
	(void *) SP_func_button,
	(void *) Think_BeginMoving,
	(void *) Reached_Train,
	(void *) Think_SetupTrainTargets,
	(void *) SP_path_corner,
	(void *) SP_func_train,
	(void *) SP_func_static,
	(void *) SP_func_rotating,
	(void *) SP_func_bobbing,
	(void *) SP_func_pendulum,
	(void *) G_WriteClientSessionData,
	(void *) G_ReadSessionData,
	(void *) G_InitSessionData,
	(void *) G_InitWorldSession,
	(void *) G_WriteSessionData,
	(void *) G_SpawnString,
	(void *) G_SpawnFloat,
	(void *) G_SpawnInt,
	(void *) G_SpawnVector,
	(void *) SP_item_botroam,
	(void *) G_CallSpawn,
	(void *) G_NewString,
	(void *) G_ParseField,
	(void *) G_SpawnGEntityFromSpawnVars,
	(void *) G_AddSpawnVarToken,
	(void *) G_ParseSpawnVars,
	(void *) SP_worldspawn,
	(void *) G_SpawnEntitiesFromString,
	(void *) StringToFilter,
	(void *) UpdateIPBans,
	(void *) G_FilterPacket,
	(void *) AddIP,
	(void *) G_ProcessIPBans,
	(void *) Svcmd_AddIP_f,
	(void *) Svcmd_RemoveIP_f,
	(void *) Svcmd_EntityList_f,
	(void *) ClientForString,
	(void *) Svcmd_ForceTeam_f,
	(void *) ConsoleCommand,
	(void *) PASSFLOAT,
	(void *) trap_Printf,
	(void *) trap_Error,
	(void *) trap_Milliseconds,
	(void *) trap_Argc,
	(void *) trap_Argv,
	(void *) trap_FS_FOpenFile,
	(void *) trap_FS_Read,
	(void *) trap_FS_Write,
	(void *) trap_FS_FCloseFile,
	(void *) trap_FS_GetFileList,
	(void *) trap_FS_Seek,
	(void *) trap_SendConsoleCommand,
	(void *) trap_Cvar_Register,
	(void *) trap_Cvar_Update,
	(void *) trap_Cvar_Set,
	(void *) trap_Cvar_VariableIntegerValue,
	(void *) trap_Cvar_VariableStringBuffer,
	(void *) trap_LocateGameData,
	(void *) trap_DropClient,
	(void *) trap_SendServerCommand,
	(void *) trap_SetConfigstring,
	(void *) trap_GetConfigstring,
	(void *) trap_GetUserinfo,
	(void *) trap_SetUserinfo,
	(void *) trap_GetServerinfo,
	(void *) trap_SetBrushModel,
	(void *) trap_Trace,
	(void *) trap_TraceCapsule,
	(void *) trap_PointContents,
	(void *) trap_InPVS,
	(void *) trap_InPVSIgnorePortals,
	(void *) trap_AdjustAreaPortalState,
	(void *) trap_AreasConnected,
	(void *) trap_LinkEntity,
	(void *) trap_UnlinkEntity,
	(void *) trap_EntitiesInBox,
	(void *) trap_EntityContact,
	(void *) trap_EntityContactCapsule,
	(void *) trap_BotAllocateClient,
	(void *) trap_GetUsercmd,
	(void *) trap_GetEntityToken,
	(void *) trap_DebugPolygonCreate,
	(void *) trap_DebugPolygonDelete,
	(void *) trap_RealTime,
	(void *) trap_SnapVector,
	(void *) trap_BotLibSetup,
	(void *) trap_BotLibShutdown,
	(void *) trap_BotLibVarSet,
	(void *) trap_BotLibVarGet,
	(void *) trap_BotLibDefine,
	(void *) trap_BotLibStartFrame,
	(void *) trap_BotLibLoadMap,
	(void *) trap_BotLibUpdateEntity,
	(void *) trap_BotLibTest,
	(void *) trap_BotGetSnapshotEntity,
	(void *) trap_BotGetServerCommand,
	(void *) trap_BotUserCommand,
	(void *) trap_AAS_EntityInfo,
	(void *) trap_AAS_Initialized,
	(void *) trap_AAS_PresenceTypeBoundingBox,
	(void *) trap_AAS_Time,
	(void *) trap_AAS_PointAreaNum,
	(void *) trap_AAS_PointReachabilityAreaIndex,
	(void *) trap_AAS_TraceAreas,
	(void *) trap_AAS_BBoxAreas,
	(void *) trap_AAS_AreaInfo,
	(void *) trap_AAS_PointContents,
	(void *) trap_AAS_NextBSPEntity,
	(void *) trap_AAS_ValueForBSPEpairKey,
	(void *) trap_AAS_VectorForBSPEpairKey,
	(void *) trap_AAS_FloatForBSPEpairKey,
	(void *) trap_AAS_IntForBSPEpairKey,
	(void *) trap_AAS_AreaReachability,
	(void *) trap_AAS_AreaTravelTimeToGoalArea,
	(void *) trap_AAS_EnableRoutingArea,
	(void *) trap_AAS_PredictRoute,
	(void *) trap_AAS_AlternativeRouteGoals,
	(void *) trap_AAS_Swimming,
	(void *) trap_AAS_PredictClientMovement,
	(void *) trap_EA_Say,
	(void *) trap_EA_SayTeam,
	(void *) trap_EA_Command,
	(void *) trap_EA_Action,
	(void *) trap_EA_Gesture,
	(void *) trap_EA_Talk,
	(void *) trap_EA_Attack,
	(void *) trap_EA_Use,
	(void *) trap_EA_Respawn,
	(void *) trap_EA_Crouch,
	(void *) trap_EA_MoveUp,
	(void *) trap_EA_MoveDown,
	(void *) trap_EA_MoveForward,
	(void *) trap_EA_MoveBack,
	(void *) trap_EA_MoveLeft,
	(void *) trap_EA_MoveRight,
	(void *) trap_EA_SelectWeapon,
	(void *) trap_EA_Jump,
	(void *) trap_EA_DelayedJump,
	(void *) trap_EA_Move,
	(void *) trap_EA_View,
	(void *) trap_EA_EndRegular,
	(void *) trap_EA_GetInput,
	(void *) trap_EA_ResetInput,
	(void *) trap_BotLoadCharacter,
	(void *) trap_BotFreeCharacter,
	(void *) trap_Characteristic_Float,
	(void *) trap_Characteristic_BFloat,
	(void *) trap_Characteristic_Integer,
	(void *) trap_Characteristic_BInteger,
	(void *) trap_Characteristic_String,
	(void *) trap_BotAllocChatState,
	(void *) trap_BotFreeChatState,
	(void *) trap_BotQueueConsoleMessage,
	(void *) trap_BotRemoveConsoleMessage,
	(void *) trap_BotNextConsoleMessage,
	(void *) trap_BotNumConsoleMessages,
	(void *) trap_BotInitialChat,
	(void *) trap_BotNumInitialChats,
	(void *) trap_BotReplyChat,
	(void *) trap_BotChatLength,
	(void *) trap_BotEnterChat,
	(void *) trap_BotGetChatMessage,
	(void *) trap_StringContains,
	(void *) trap_BotFindMatch,
	(void *) trap_BotMatchVariable,
	(void *) trap_UnifyWhiteSpaces,
	(void *) trap_BotReplaceSynonyms,
	(void *) trap_BotLoadChatFile,
	(void *) trap_BotSetChatGender,
	(void *) trap_BotSetChatName,
	(void *) trap_BotResetGoalState,
	(void *) trap_BotResetAvoidGoals,
	(void *) trap_BotRemoveFromAvoidGoals,
	(void *) trap_BotPushGoal,
	(void *) trap_BotPopGoal,
	(void *) trap_BotEmptyGoalStack,
	(void *) trap_BotDumpAvoidGoals,
	(void *) trap_BotDumpGoalStack,
	(void *) trap_BotGoalName,
	(void *) trap_BotGetTopGoal,
	(void *) trap_BotGetSecondGoal,
	(void *) trap_BotChooseLTGItem,
	(void *) trap_BotChooseNBGItem,
	(void *) trap_BotTouchingGoal,
	(void *) trap_BotItemGoalInVisButNotVisible,
	(void *) trap_BotGetLevelItemGoal,
	(void *) trap_BotGetNextCampSpotGoal,
	(void *) trap_BotGetMapLocationGoal,
	(void *) trap_BotAvoidGoalTime,
	(void *) trap_BotSetAvoidGoalTime,
	(void *) trap_BotInitLevelItems,
	(void *) trap_BotUpdateEntityItems,
	(void *) trap_BotLoadItemWeights,
	(void *) trap_BotFreeItemWeights,
	(void *) trap_BotInterbreedGoalFuzzyLogic,
	(void *) trap_BotSaveGoalFuzzyLogic,
	(void *) trap_BotMutateGoalFuzzyLogic,
	(void *) trap_BotAllocGoalState,
	(void *) trap_BotFreeGoalState,
	(void *) trap_BotResetMoveState,
	(void *) trap_BotAddAvoidSpot,
	(void *) trap_BotMoveToGoal,
	(void *) trap_BotMoveInDirection,
	(void *) trap_BotResetAvoidReach,
	(void *) trap_BotResetLastAvoidReach,
	(void *) trap_BotReachabilityArea,
	(void *) trap_BotMovementViewTarget,
	(void *) trap_BotPredictVisiblePosition,
	(void *) trap_BotAllocMoveState,
	(void *) trap_BotFreeMoveState,
	(void *) trap_BotInitMoveState,
	(void *) trap_BotChooseBestFightWeapon,
	(void *) trap_BotGetWeaponInfo,
	(void *) trap_BotLoadWeaponWeights,
	(void *) trap_BotAllocWeaponState,
	(void *) trap_BotFreeWeaponState,
	(void *) trap_BotResetWeaponState,
	(void *) trap_GeneticParentsAndChildSelection,
	(void *) trap_PC_LoadSource,
	(void *) trap_PC_FreeSource,
	(void *) trap_PC_ReadToken,
	(void *) trap_PC_SourceFileAndLine,
	(void *) Use_Target_Give,
	(void *) SP_target_give,
	(void *) Use_target_remove_powerups,
	(void *) SP_target_remove_powerups,
	(void *) Think_Target_Delay,
	(void *) Use_Target_Delay,
	(void *) SP_target_delay,
	(void *) Use_Target_Score,
	(void *) SP_target_score,
	(void *) Use_Target_Print,
	(void *) SP_target_print,
	(void *) Use_Target_Speaker,
	(void *) SP_target_speaker,
	(void *) target_laser_think,
	(void *) target_laser_on,
	(void *) target_laser_off,
	(void *) target_laser_use,
	(void *) target_laser_start,
	(void *) SP_target_laser,
	(void *) target_teleporter_use,
	(void *) SP_target_teleporter,
	(void *) target_relay_use,
	(void *) SP_target_relay,
	(void *) target_kill_use,
	(void *) SP_target_kill,
	(void *) SP_target_position,
	(void *) target_location_linkup,
	(void *) SP_target_location,
	(void *) Team_InitGame,
	(void *) OtherTeam,
	(void *) TeamName,
	(void *) OtherTeamName,
	(void *) TeamColorString,
	(void *) PrintMsg,
	(void *) AddTeamScore,
	(void *) OnSameTeam,
	(void *) Team_SetFlagStatus,
	(void *) Team_CheckDroppedItem,
	(void *) Team_ForceGesture,
	(void *) Team_FragBonuses,
	(void *) Team_CheckHurtCarrier,
	(void *) Team_ResetFlag,
	(void *) Team_ResetFlags,
	(void *) Team_ReturnFlagSound,
	(void *) Team_TakeFlagSound,
	(void *) Team_CaptureFlagSound,
	(void *) Team_ReturnFlag,
	(void *) Team_FreeEntity,
	(void *) Team_DroppedFlagThink,
	(void *) Team_TouchOurFlag,
	(void *) Team_TouchEnemyFlag,
	(void *) Pickup_Team,
	(void *) Team_GetLocation,
	(void *) Team_GetLocationMsg,
	(void *) SelectRandomTeamSpawnPoint,
	(void *) SelectCTFSpawnPoint,
	(void *) SortClients,
	(void *) TeamplayInfoMessage,
	(void *) CheckTeamStatus,
	(void *) SP_team_CTF_redplayer,
	(void *) SP_team_CTF_blueplayer,
	(void *) SP_team_CTF_redspawn,
	(void *) SP_team_CTF_bluespawn,
	(void *) InitTrigger,
	(void *) multi_wait,
	(void *) multi_trigger,
	(void *) Use_Multi,
	(void *) Touch_Multi,
	(void *) SP_trigger_multiple,
	(void *) trigger_always_think,
	(void *) SP_trigger_always,
	(void *) trigger_push_touch,
	(void *) AimAtTarget,
	(void *) SP_trigger_push,
	(void *) Use_target_push,
	(void *) SP_target_push,
	(void *) trigger_teleporter_touch,
	(void *) SP_trigger_teleport,
	(void *) hurt_use,
	(void *) hurt_touch,
	(void *) SP_trigger_hurt,
	(void *) func_timer_think,
	(void *) func_timer_use,
	(void *) SP_func_timer,
	(void *) AddRemap,
	(void *) BuildShaderStateConfig,
	(void *) G_FindConfigstringIndex,
	(void *) G_ModelIndex,
	(void *) G_SoundIndex,
	(void *) G_TeamCommand,
	(void *) G_Find,
	(void *) G_PickTarget,
	(void *) G_UseTargets,
	(void *) tv,
	(void *) vtos,
	(void *) G_SetMovedir,
	(void *) vectoyaw,
	(void *) G_InitGentity,
	(void *) G_Spawn,
	(void *) G_EntitiesFree,
	(void *) G_FreeEntity,
	(void *) G_TempEntity,
	(void *) G_KillBox,
	(void *) G_AddPredictableEvent,
	(void *) G_AddEvent,
	(void *) G_Sound,
	(void *) G_SetOrigin,
	(void *) DebugLine,
	(void *) G_BounceProjectile,
	(void *) Weapon_Gauntlet,
	(void *) CheckGauntletAttack,
	(void *) SnapVectorTowards,
	(void *) Bullet_Fire,
	(void *) BFG_Fire,
	(void *) ShotgunPellet,
	(void *) ShotgunPattern,
	(void *) weapon_supershotgun_fire,
	(void *) weapon_grenadelauncher_fire,
	(void *) Weapon_RocketLauncher_Fire,
	(void *) Weapon_Plasmagun_Fire,
	(void *) weapon_railgun_fire,
	(void *) Weapon_GrapplingHook_Fire,
	(void *) Weapon_HookFree,
	(void *) Weapon_HookThink,
	(void *) Weapon_LightningFire,
	(void *) LogAccuracyHit,
	(void *) CalcMuzzlePoint,
	(void *) CalcMuzzlePointOrigin,
	(void *) FireWeapon,
	(void *) Q_rand,
	(void *) Q_random,
	(void *) Q_crandom,
	(void *) ClampChar,
	(void *) ClampShort,
	(void *) DirToByte,
	(void *) ByteToDir,
	(void *) ColorBytes3,
	(void *) ColorBytes4,
	(void *) NormalizeColor,
	(void *) PlaneFromPoints,
	(void *) RotatePointAroundVector,
	(void *) RotateAroundDirection,
	(void *) vectoangles,
	(void *) AnglesToAxis,
	(void *) AxisClear,
	(void *) AxisCopy,
	(void *) ProjectPointOnPlane,
	(void *) MakeNormalVectors,
	(void *) VectorRotate,
	(void *) Q_rsqrt,
	(void *) Q_fabs,
	(void *) LerpAngle,
	(void *) AngleSubtract,
	(void *) AnglesSubtract,
	(void *) AngleMod,
	(void *) AngleNormalize360,
	(void *) AngleNormalize180,
	(void *) AngleDelta,
	(void *) SetPlaneSignbits,
	(void *) RadiusFromBounds,
	(void *) ClearBounds,
	(void *) AddPointToBounds,
	(void *) VectorNormalize,
	(void *) VectorNormalize2,
	(void *) _VectorMA,
	(void *) _DotProduct,
	(void *) _VectorSubtract,
	(void *) _VectorAdd,
	(void *) _VectorCopy,
	(void *) _VectorScale,
	(void *) Vector4Scale,
	(void *) Q_log2,
	(void *) AngleVectors,
	(void *) PerpendicularVector,
	(void *) Com_Clamp,
	(void *) COM_SkipPath,
	(void *) COM_StripExtension,
	(void *) COM_DefaultExtension,
	(void *) ShortSwap,
	(void *) ShortNoSwap,
	(void *) LongSwap,
	(void *) LongNoSwap,
	(void *) Long64Swap,
	(void *) Long64NoSwap,
	(void *) FloatSwap,
	(void *) FloatNoSwap,
	(void *) COM_BeginParseSession,
	(void *) COM_GetCurrentParseLine,
	(void *) COM_Parse,
	(void *) COM_ParseError,
	(void *) COM_ParseWarning,
	(void *) SkipWhitespace,
	(void *) COM_Compress,
	(void *) COM_ParseExt,
	(void *) COM_MatchToken,
	(void *) SkipBracedSection,
	(void *) SkipRestOfLine,
	(void *) Parse1DMatrix,
	(void *) Parse2DMatrix,
	(void *) Parse3DMatrix,
	(void *) Q_isprint,
	(void *) Q_islower,
	(void *) Q_isupper,
	(void *) Q_isalpha,
	(void *) Q_strrchr,
	(void *) Q_strncpyz,
	(void *) Q_stricmpn,
	(void *) Q_strncmp,
	(void *) Q_stricmp,
	(void *) Q_strlwr,
	(void *) Q_strupr,
	(void *) Q_strcat,
	(void *) Q_PrintStrlen,
	(void *) Q_CleanStr,
	(void *) Com_sprintf,
	(void *) va,
	(void *) Info_ValueForKey,
	(void *) Info_NextPair,
	(void *) Info_RemoveKey,
	(void *) Info_RemoveKey_Big,
	(void *) Info_Validate,
	(void *) Info_SetValueForKey,
	(void *) Info_SetValueForKey_Big,
};

/* Pointers to globals */

extern vmCvar_t bot_grapple;
extern vmCvar_t bot_rocketjump;
extern vmCvar_t bot_fastchat;
extern vmCvar_t bot_nochat;
extern vmCvar_t bot_testrchat;
extern vmCvar_t bot_challenge;
extern bot_goal_t ctf_redflag;
extern bot_goal_t ctf_blueflag;
extern vmCvar_t bot_predictobstacles;
extern vmCvar_t g_spSkill;
extern aas_altroutegoal_t red_altroutegoals[];
extern aas_altroutegoal_t blue_altroutegoals[];
extern vmCvar_t bot_thinktime;
extern vmCvar_t bot_memorydump;
extern vmCvar_t bot_saveroutingcache;
extern vmCvar_t bot_pause;
extern vmCvar_t bot_report;
extern vmCvar_t bot_testsolid;
extern vmCvar_t bot_testclusters;
extern vmCvar_t bot_developer;
extern vmCvar_t bot_interbreedchar;
extern vmCvar_t bot_interbreedbots;
extern vmCvar_t bot_interbreedcycle;
extern vmCvar_t bot_interbreedwrite;
extern bot_ctftaskpreference_t ctftaskpreferences[];
extern voiceCommand_t voiceCommands[];
extern gitem_t bg_itemlist[];
extern pml_t pml;
extern botSpawnQueue_t botSpawnQueue[];
extern vmCvar_t bot_minplayers;
extern qboolean itemRegistered[];
extern level_locals_t level;
extern gentity_t g_entities[];
extern vmCvar_t g_gametype;
extern vmCvar_t g_dedicated;
extern vmCvar_t g_cheats;
extern vmCvar_t g_maxclients;
extern vmCvar_t g_maxGameClients;
extern vmCvar_t g_restarted;
extern vmCvar_t g_dmflags;
extern vmCvar_t g_fraglimit;
extern vmCvar_t g_timelimit;
extern vmCvar_t g_capturelimit;
extern vmCvar_t g_friendlyFire;
extern vmCvar_t g_password;
extern vmCvar_t g_needpass;
extern vmCvar_t g_gravity;
extern vmCvar_t g_speed;
extern vmCvar_t g_knockback;
extern vmCvar_t g_quadfactor;
extern vmCvar_t g_forcerespawn;
extern vmCvar_t g_inactivity;
extern vmCvar_t g_debugMove;
extern vmCvar_t g_debugAlloc;
extern vmCvar_t g_debugDamage;
extern vmCvar_t g_weaponRespawn;
extern vmCvar_t g_weaponTeamRespawn;
extern vmCvar_t g_synchronousClients;
extern vmCvar_t g_motd;
extern vmCvar_t g_warmup;
extern vmCvar_t g_doWarmup;
extern vmCvar_t g_blood;
extern vmCvar_t g_allowVote;
extern vmCvar_t g_teamAutoJoin;
extern vmCvar_t g_teamForceBalance;
extern vmCvar_t g_banIPs;
extern vmCvar_t g_filterBan;
extern vmCvar_t g_smoothClients;
extern vmCvar_t pmove_fixed;
extern vmCvar_t pmove_msec;
extern vmCvar_t g_rankings;
extern gclient_t g_clients[];
extern vmCvar_t g_log;
extern vmCvar_t g_logSync;
extern vmCvar_t g_podiumDist;
extern vmCvar_t g_podiumDrop;
extern vmCvar_t g_listEntity;
extern cvarTable_t gameCvarTable[];
extern pushed_t pushed[];
extern field_t fields[];
extern spawn_t spawns[];
extern ipFilter_t ipFilters[];
extern teamgame_t teamgame;
extern shaderRemap_t remappedShaders[];

void *g_GlobalsPointers [] = 
{
	(void *) &bot_grapple,
	(void *) &bot_rocketjump,
	(void *) &bot_fastchat,
	(void *) &bot_nochat,
	(void *) &bot_testrchat,
	(void *) &bot_challenge,
	(void *) &ctf_redflag,
	(void *) &ctf_blueflag,
	(void *) &bot_predictobstacles,
	(void *) &g_spSkill,
	(void *) (& red_altroutegoals[0]),
	(void *) (& red_altroutegoals[1]),
	(void *) (& red_altroutegoals[2]),
	(void *) (& red_altroutegoals[3]),
	(void *) (& red_altroutegoals[4]),
	(void *) (& red_altroutegoals[5]),
	(void *) (& red_altroutegoals[6]),
	(void *) (& red_altroutegoals[7]),
	(void *) (& red_altroutegoals[8]),
	(void *) (& red_altroutegoals[9]),
	(void *) (& red_altroutegoals[10]),
	(void *) (& red_altroutegoals[11]),
	(void *) (& red_altroutegoals[12]),
	(void *) (& red_altroutegoals[13]),
	(void *) (& red_altroutegoals[14]),
	(void *) (& red_altroutegoals[15]),
	(void *) (& red_altroutegoals[16]),
	(void *) (& red_altroutegoals[17]),
	(void *) (& red_altroutegoals[18]),
	(void *) (& red_altroutegoals[19]),
	(void *) (& red_altroutegoals[20]),
	(void *) (& red_altroutegoals[21]),
	(void *) (& red_altroutegoals[22]),
	(void *) (& red_altroutegoals[23]),
	(void *) (& red_altroutegoals[24]),
	(void *) (& red_altroutegoals[25]),
	(void *) (& red_altroutegoals[26]),
	(void *) (& red_altroutegoals[27]),
	(void *) (& red_altroutegoals[28]),
	(void *) (& red_altroutegoals[29]),
	(void *) (& red_altroutegoals[30]),
	(void *) (& red_altroutegoals[31]),

	(void *) (& blue_altroutegoals[0]),
	(void *) (& blue_altroutegoals[1]),
	(void *) (& blue_altroutegoals[2]),
	(void *) (& blue_altroutegoals[3]),
	(void *) (& blue_altroutegoals[4]),
	(void *) (& blue_altroutegoals[5]),
	(void *) (& blue_altroutegoals[6]),
	(void *) (& blue_altroutegoals[7]),
	(void *) (& blue_altroutegoals[8]),
	(void *) (& blue_altroutegoals[9]),
	(void *) (& blue_altroutegoals[10]),
	(void *) (& blue_altroutegoals[11]),
	(void *) (& blue_altroutegoals[12]),
	(void *) (& blue_altroutegoals[13]),
	(void *) (& blue_altroutegoals[14]),
	(void *) (& blue_altroutegoals[15]),
	(void *) (& blue_altroutegoals[16]),
	(void *) (& blue_altroutegoals[17]),
	(void *) (& blue_altroutegoals[18]),
	(void *) (& blue_altroutegoals[19]),
	(void *) (& blue_altroutegoals[20]),
	(void *) (& blue_altroutegoals[21]),
	(void *) (& blue_altroutegoals[22]),
	(void *) (& blue_altroutegoals[23]),
	(void *) (& blue_altroutegoals[24]),
	(void *) (& blue_altroutegoals[25]),
	(void *) (& blue_altroutegoals[26]),
	(void *) (& blue_altroutegoals[27]),
	(void *) (& blue_altroutegoals[28]),
	(void *) (& blue_altroutegoals[29]),
	(void *) (& blue_altroutegoals[30]),
	(void *) (& blue_altroutegoals[31]),

	(void *) &bot_thinktime,
	(void *) &bot_memorydump,
	(void *) &bot_saveroutingcache,
	(void *) &bot_pause,
	(void *) &bot_report,
	(void *) &bot_testsolid,
	(void *) &bot_testclusters,
	(void *) &bot_developer,
	(void *) &bot_interbreedchar,
	(void *) &bot_interbreedbots,
	(void *) &bot_interbreedcycle,
	(void *) &bot_interbreedwrite,
	(void *) (& ctftaskpreferences[0]),
	(void *) (& ctftaskpreferences[1]),
	(void *) (& ctftaskpreferences[2]),
	(void *) (& ctftaskpreferences[3]),
	(void *) (& ctftaskpreferences[4]),
	(void *) (& ctftaskpreferences[5]),
	(void *) (& ctftaskpreferences[6]),
	(void *) (& ctftaskpreferences[7]),
	(void *) (& ctftaskpreferences[8]),
	(void *) (& ctftaskpreferences[9]),
	(void *) (& ctftaskpreferences[10]),
	(void *) (& ctftaskpreferences[11]),
	(void *) (& ctftaskpreferences[12]),
	(void *) (& ctftaskpreferences[13]),
	(void *) (& ctftaskpreferences[14]),
	(void *) (& ctftaskpreferences[15]),
	(void *) (& ctftaskpreferences[16]),
	(void *) (& ctftaskpreferences[17]),
	(void *) (& ctftaskpreferences[18]),
	(void *) (& ctftaskpreferences[19]),
	(void *) (& ctftaskpreferences[20]),
	(void *) (& ctftaskpreferences[21]),
	(void *) (& ctftaskpreferences[22]),
	(void *) (& ctftaskpreferences[23]),
	(void *) (& ctftaskpreferences[24]),
	(void *) (& ctftaskpreferences[25]),
	(void *) (& ctftaskpreferences[26]),
	(void *) (& ctftaskpreferences[27]),
	(void *) (& ctftaskpreferences[28]),
	(void *) (& ctftaskpreferences[29]),
	(void *) (& ctftaskpreferences[30]),
	(void *) (& ctftaskpreferences[31]),
	(void *) (& ctftaskpreferences[32]),
	(void *) (& ctftaskpreferences[33]),
	(void *) (& ctftaskpreferences[34]),
	(void *) (& ctftaskpreferences[35]),
	(void *) (& ctftaskpreferences[36]),
	(void *) (& ctftaskpreferences[37]),
	(void *) (& ctftaskpreferences[38]),
	(void *) (& ctftaskpreferences[39]),
	(void *) (& ctftaskpreferences[40]),
	(void *) (& ctftaskpreferences[41]),
	(void *) (& ctftaskpreferences[42]),
	(void *) (& ctftaskpreferences[43]),
	(void *) (& ctftaskpreferences[44]),
	(void *) (& ctftaskpreferences[45]),
	(void *) (& ctftaskpreferences[46]),
	(void *) (& ctftaskpreferences[47]),
	(void *) (& ctftaskpreferences[48]),
	(void *) (& ctftaskpreferences[49]),
	(void *) (& ctftaskpreferences[50]),
	(void *) (& ctftaskpreferences[51]),
	(void *) (& ctftaskpreferences[52]),
	(void *) (& ctftaskpreferences[53]),
	(void *) (& ctftaskpreferences[54]),
	(void *) (& ctftaskpreferences[55]),
	(void *) (& ctftaskpreferences[56]),
	(void *) (& ctftaskpreferences[57]),
	(void *) (& ctftaskpreferences[58]),
	(void *) (& ctftaskpreferences[59]),
	(void *) (& ctftaskpreferences[60]),
	(void *) (& ctftaskpreferences[61]),
	(void *) (& ctftaskpreferences[62]),
	(void *) (& ctftaskpreferences[63]),

	(void *) (& voiceCommands[0]),
	(void *) (& voiceCommands[1]),
	(void *) (& voiceCommands[2]),
	(void *) (& voiceCommands[3]),
	(void *) (& voiceCommands[4]),
	(void *) (& voiceCommands[5]),
	(void *) (& voiceCommands[6]),
	(void *) (& voiceCommands[7]),
	(void *) (& voiceCommands[8]),
	(void *) (& voiceCommands[9]),
	(void *) (& voiceCommands[10]),
	(void *) (& voiceCommands[11]),
	(void *) (& voiceCommands[12]),
	(void *) (& voiceCommands[13]),
	(void *) (& voiceCommands[14]),

	(void *) (& bg_itemlist[0]),
	(void *) (& bg_itemlist[1]),
	(void *) (& bg_itemlist[2]),
	(void *) (& bg_itemlist[3]),
	(void *) (& bg_itemlist[4]),
	(void *) (& bg_itemlist[5]),
	(void *) (& bg_itemlist[6]),
	(void *) (& bg_itemlist[7]),
	(void *) (& bg_itemlist[8]),
	(void *) (& bg_itemlist[9]),
	(void *) (& bg_itemlist[10]),
	(void *) (& bg_itemlist[11]),
	(void *) (& bg_itemlist[12]),
	(void *) (& bg_itemlist[13]),
	(void *) (& bg_itemlist[14]),
	(void *) (& bg_itemlist[15]),
	(void *) (& bg_itemlist[16]),
	(void *) (& bg_itemlist[17]),
	(void *) (& bg_itemlist[18]),
	(void *) (& bg_itemlist[19]),
	(void *) (& bg_itemlist[20]),
	(void *) (& bg_itemlist[21]),
	(void *) (& bg_itemlist[22]),
	(void *) (& bg_itemlist[23]),
	(void *) (& bg_itemlist[24]),
	(void *) (& bg_itemlist[25]),
	(void *) (& bg_itemlist[26]),
	(void *) (& bg_itemlist[27]),
	(void *) (& bg_itemlist[28]),
	(void *) (& bg_itemlist[29]),
	(void *) (& bg_itemlist[30]),
	(void *) (& bg_itemlist[31]),
	(void *) (& bg_itemlist[32]),
	(void *) (& bg_itemlist[33]),
	(void *) (& bg_itemlist[34]),
	(void *) (& bg_itemlist[35]),
	(void *) (& bg_itemlist[36]),

	(void *) &pml,
	(void *) (& botSpawnQueue[0]),
	(void *) (& botSpawnQueue[1]),
	(void *) (& botSpawnQueue[2]),
	(void *) (& botSpawnQueue[3]),
	(void *) (& botSpawnQueue[4]),
	(void *) (& botSpawnQueue[5]),
	(void *) (& botSpawnQueue[6]),
	(void *) (& botSpawnQueue[7]),
	(void *) (& botSpawnQueue[8]),
	(void *) (& botSpawnQueue[9]),
	(void *) (& botSpawnQueue[10]),
	(void *) (& botSpawnQueue[11]),
	(void *) (& botSpawnQueue[12]),
	(void *) (& botSpawnQueue[13]),
	(void *) (& botSpawnQueue[14]),
	(void *) (& botSpawnQueue[15]),

	(void *) &bot_minplayers,
	(void *) &level,
	(void *) &g_gametype,
	(void *) &g_dedicated,
	(void *) &g_cheats,
	(void *) &g_maxclients,
	(void *) &g_maxGameClients,
	(void *) &g_restarted,
	(void *) &g_dmflags,
	(void *) &g_fraglimit,
	(void *) &g_timelimit,
	(void *) &g_capturelimit,
	(void *) &g_friendlyFire,
	(void *) &g_password,
	(void *) &g_needpass,
	(void *) &g_gravity,
	(void *) &g_speed,
	(void *) &g_knockback,
	(void *) &g_quadfactor,
	(void *) &g_forcerespawn,
	(void *) &g_inactivity,
	(void *) &g_debugMove,
	(void *) &g_debugAlloc,
	(void *) &g_debugDamage,
	(void *) &g_weaponRespawn,
	(void *) &g_weaponTeamRespawn,
	(void *) &g_synchronousClients,
	(void *) &g_motd,
	(void *) &g_warmup,
	(void *) &g_doWarmup,
	(void *) &g_blood,
	(void *) &g_allowVote,
	(void *) &g_teamAutoJoin,
	(void *) &g_teamForceBalance,
	(void *) &g_banIPs,
	(void *) &g_filterBan,
	(void *) &g_smoothClients,
	(void *) &pmove_fixed,
	(void *) &pmove_msec,
	(void *) &g_rankings,
	(void *) &g_log,
	(void *) &g_logSync,
	(void *) &g_podiumDist,
	(void *) &g_podiumDrop,
	(void *) &g_listEntity,
	(void *) (& gameCvarTable[0]),
	(void *) (& gameCvarTable[1]),
	(void *) (& gameCvarTable[2]),
	(void *) (& gameCvarTable[3]),
	(void *) (& gameCvarTable[4]),
	(void *) (& gameCvarTable[5]),
	(void *) (& gameCvarTable[6]),
	(void *) (& gameCvarTable[7]),
	(void *) (& gameCvarTable[8]),
	(void *) (& gameCvarTable[9]),
	(void *) (& gameCvarTable[10]),
	(void *) (& gameCvarTable[11]),
	(void *) (& gameCvarTable[12]),
	(void *) (& gameCvarTable[13]),
	(void *) (& gameCvarTable[14]),
	(void *) (& gameCvarTable[15]),
	(void *) (& gameCvarTable[16]),
	(void *) (& gameCvarTable[17]),
	(void *) (& gameCvarTable[18]),
	(void *) (& gameCvarTable[19]),
	(void *) (& gameCvarTable[20]),
	(void *) (& gameCvarTable[21]),
	(void *) (& gameCvarTable[22]),
	(void *) (& gameCvarTable[23]),
	(void *) (& gameCvarTable[24]),
	(void *) (& gameCvarTable[25]),
	(void *) (& gameCvarTable[26]),
	(void *) (& gameCvarTable[27]),
	(void *) (& gameCvarTable[28]),
	(void *) (& gameCvarTable[29]),
	(void *) (& gameCvarTable[30]),
	(void *) (& gameCvarTable[31]),
	(void *) (& gameCvarTable[32]),
	(void *) (& gameCvarTable[33]),
	(void *) (& gameCvarTable[34]),
	(void *) (& gameCvarTable[35]),
	(void *) (& gameCvarTable[36]),
	(void *) (& gameCvarTable[37]),
	(void *) (& gameCvarTable[38]),
	(void *) (& gameCvarTable[39]),
	(void *) (& gameCvarTable[40]),
	(void *) (& gameCvarTable[41]),
	(void *) (& gameCvarTable[42]),
	(void *) (& gameCvarTable[43]),
	(void *) (& gameCvarTable[44]),
	(void *) (& gameCvarTable[45]),

	(void *) (& fields[0]),
	(void *) (& fields[1]),
	(void *) (& fields[2]),
	(void *) (& fields[3]),
	(void *) (& fields[4]),
	(void *) (& fields[5]),
	(void *) (& fields[6]),
	(void *) (& fields[7]),
	(void *) (& fields[8]),
	(void *) (& fields[9]),
	(void *) (& fields[10]),
	(void *) (& fields[11]),
	(void *) (& fields[12]),
	(void *) (& fields[13]),
	(void *) (& fields[14]),
	(void *) (& fields[15]),
	(void *) (& fields[16]),
	(void *) (& fields[17]),
	(void *) (& fields[18]),
	(void *) (& fields[19]),
	(void *) (& fields[20]),

	(void *) (& spawns[0]),
	(void *) (& spawns[1]),
	(void *) (& spawns[2]),
	(void *) (& spawns[3]),
	(void *) (& spawns[4]),
	(void *) (& spawns[5]),
	(void *) (& spawns[6]),
	(void *) (& spawns[7]),
	(void *) (& spawns[8]),
	(void *) (& spawns[9]),
	(void *) (& spawns[10]),
	(void *) (& spawns[11]),
	(void *) (& spawns[12]),
	(void *) (& spawns[13]),
	(void *) (& spawns[14]),
	(void *) (& spawns[15]),
	(void *) (& spawns[16]),
	(void *) (& spawns[17]),
	(void *) (& spawns[18]),
	(void *) (& spawns[19]),
	(void *) (& spawns[20]),
	(void *) (& spawns[21]),
	(void *) (& spawns[22]),
	(void *) (& spawns[23]),
	(void *) (& spawns[24]),
	(void *) (& spawns[25]),
	(void *) (& spawns[26]),
	(void *) (& spawns[27]),
	(void *) (& spawns[28]),
	(void *) (& spawns[29]),
	(void *) (& spawns[30]),
	(void *) (& spawns[31]),
	(void *) (& spawns[32]),
	(void *) (& spawns[33]),
	(void *) (& spawns[34]),
	(void *) (& spawns[35]),
	(void *) (& spawns[36]),
	(void *) (& spawns[37]),
	(void *) (& spawns[38]),
	(void *) (& spawns[39]),
	(void *) (& spawns[40]),
	(void *) (& spawns[41]),
	(void *) (& spawns[42]),
	(void *) (& spawns[43]),
	(void *) (& spawns[44]),
	(void *) (& spawns[45]),
	(void *) (& spawns[46]),
	(void *) (& spawns[47]),
	(void *) (& spawns[48]),

	(void *) &teamgame,
	(void *) (& remappedShaders[0]),
	(void *) (& remappedShaders[1]),
	(void *) (& remappedShaders[2]),
	(void *) (& remappedShaders[3]),
	(void *) (& remappedShaders[4]),
	(void *) (& remappedShaders[5]),
	(void *) (& remappedShaders[6]),
	(void *) (& remappedShaders[7]),
	(void *) (& remappedShaders[8]),
	(void *) (& remappedShaders[9]),
	(void *) (& remappedShaders[10]),
	(void *) (& remappedShaders[11]),
	(void *) (& remappedShaders[12]),
	(void *) (& remappedShaders[13]),
	(void *) (& remappedShaders[14]),
	(void *) (& remappedShaders[15]),
	(void *) (& remappedShaders[16]),
	(void *) (& remappedShaders[17]),
	(void *) (& remappedShaders[18]),
	(void *) (& remappedShaders[19]),
	(void *) (& remappedShaders[20]),
	(void *) (& remappedShaders[21]),
	(void *) (& remappedShaders[22]),
	(void *) (& remappedShaders[23]),
	(void *) (& remappedShaders[24]),
	(void *) (& remappedShaders[25]),
	(void *) (& remappedShaders[26]),
	(void *) (& remappedShaders[27]),
	(void *) (& remappedShaders[28]),
	(void *) (& remappedShaders[29]),
	(void *) (& remappedShaders[30]),
	(void *) (& remappedShaders[31]),
	(void *) (& remappedShaders[32]),
	(void *) (& remappedShaders[33]),
	(void *) (& remappedShaders[34]),
	(void *) (& remappedShaders[35]),
	(void *) (& remappedShaders[36]),
	(void *) (& remappedShaders[37]),
	(void *) (& remappedShaders[38]),
	(void *) (& remappedShaders[39]),
	(void *) (& remappedShaders[40]),
	(void *) (& remappedShaders[41]),
	(void *) (& remappedShaders[42]),
	(void *) (& remappedShaders[43]),
	(void *) (& remappedShaders[44]),
	(void *) (& remappedShaders[45]),
	(void *) (& remappedShaders[46]),
	(void *) (& remappedShaders[47]),
	(void *) (& remappedShaders[48]),
	(void *) (& remappedShaders[49]),
	(void *) (& remappedShaders[50]),
	(void *) (& remappedShaders[51]),
	(void *) (& remappedShaders[52]),
	(void *) (& remappedShaders[53]),
	(void *) (& remappedShaders[54]),
	(void *) (& remappedShaders[55]),
	(void *) (& remappedShaders[56]),
	(void *) (& remappedShaders[57]),
	(void *) (& remappedShaders[58]),
	(void *) (& remappedShaders[59]),
	(void *) (& remappedShaders[60]),
	(void *) (& remappedShaders[61]),
	(void *) (& remappedShaders[62]),
	(void *) (& remappedShaders[63]),
	(void *) (& remappedShaders[64]),
	(void *) (& remappedShaders[65]),
	(void *) (& remappedShaders[66]),
	(void *) (& remappedShaders[67]),
	(void *) (& remappedShaders[68]),
	(void *) (& remappedShaders[69]),
	(void *) (& remappedShaders[70]),
	(void *) (& remappedShaders[71]),
	(void *) (& remappedShaders[72]),
	(void *) (& remappedShaders[73]),
	(void *) (& remappedShaders[74]),
	(void *) (& remappedShaders[75]),
	(void *) (& remappedShaders[76]),
	(void *) (& remappedShaders[77]),
	(void *) (& remappedShaders[78]),
	(void *) (& remappedShaders[79]),
	(void *) (& remappedShaders[80]),
	(void *) (& remappedShaders[81]),
	(void *) (& remappedShaders[82]),
	(void *) (& remappedShaders[83]),
	(void *) (& remappedShaders[84]),
	(void *) (& remappedShaders[85]),
	(void *) (& remappedShaders[86]),
	(void *) (& remappedShaders[87]),
	(void *) (& remappedShaders[88]),
	(void *) (& remappedShaders[89]),
	(void *) (& remappedShaders[90]),
	(void *) (& remappedShaders[91]),
	(void *) (& remappedShaders[92]),
	(void *) (& remappedShaders[93]),
	(void *) (& remappedShaders[94]),
	(void *) (& remappedShaders[95]),
	(void *) (& remappedShaders[96]),
	(void *) (& remappedShaders[97]),
	(void *) (& remappedShaders[98]),
	(void *) (& remappedShaders[99]),
	(void *) (& remappedShaders[100]),
	(void *) (& remappedShaders[101]),
	(void *) (& remappedShaders[102]),
	(void *) (& remappedShaders[103]),
	(void *) (& remappedShaders[104]),
	(void *) (& remappedShaders[105]),
	(void *) (& remappedShaders[106]),
	(void *) (& remappedShaders[107]),
	(void *) (& remappedShaders[108]),
	(void *) (& remappedShaders[109]),
	(void *) (& remappedShaders[110]),
	(void *) (& remappedShaders[111]),
	(void *) (& remappedShaders[112]),
	(void *) (& remappedShaders[113]),
	(void *) (& remappedShaders[114]),
	(void *) (& remappedShaders[115]),
	(void *) (& remappedShaders[116]),
	(void *) (& remappedShaders[117]),
	(void *) (& remappedShaders[118]),
	(void *) (& remappedShaders[119]),
	(void *) (& remappedShaders[120]),
	(void *) (& remappedShaders[121]),
	(void *) (& remappedShaders[122]),
	(void *) (& remappedShaders[123]),
	(void *) (& remappedShaders[124]),
	(void *) (& remappedShaders[125]),
	(void *) (& remappedShaders[126]),
	(void *) (& remappedShaders[127]),

};
/* Static strings */

char *g_StaticStrings [] = {
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"mapname",
	"Shotgun",
	"Gauntlet",
	"Machinegun",
	"Grenade Launcher",
	"Rocket Launcher",
	"Plasmagun",
	"Railgun",
	"Lightning Gun",
	"BFG10K",
	"Grapple",
	"[unknown weapon]",
	"Gauntlet",
	"Shotgun",
	"Machinegun",
	"Grenade Launcher",
	"Rocket Launcher",
	"Plasmagun",
	"Railgun",
	"Lightning Gun",
	"BFG10K",
	"game_enter",
	"[invalid var]",
	"[invalid var]",
	"game_exit",
	"[invalid var]",
	"[invalid var]",
	"vtaunt",
	"level_start",
	"vtaunt",
	"level_end_victory",
	"[invalid var]",
	"level_end_lose",
	"[invalid var]",
	"level_end",
	"[world]",
	"[world]",
	"death_teammate",
	"vtaunt",
	"death_drown",
	"death_slime",
	"death_lava",
	"death_cratered",
	"death_suicide",
	"death_suicide",
	"death_suicide",
	"death_suicide",
	"death_suicide",
	"death_suicide",
	"death_telefrag",
	"death_gauntlet",
	"death_rail",
	"death_bfg",
	"death_insult",
	"death_praise",
	"kill_teammate",
	"vtaunt",
	"kill_gauntlet",
	"kill_rail",
	"kill_telefrag",
	"kill_insult",
	"kill_praise",
	"",
	"enemy_suicide",
	"hit_talking",
	"hit_nodeath",
	"hit_nokill",
	"vtaunt",
	"random_misc",
	"[invalid var]",
	"[invalid var]",
	"random_insult",
	"[invalid var]",
	"[invalid var]",
	"game_enter",
	"game_enter",
	"[invalid var]",
	"[invalid var]",
	"game_exit",
	"game_exit",
	"[invalid var]",
	"[invalid var]",
	"level_start",
	"level_start",
	"level_end_victory",
	"level_end_victory",
	"level_end_lose",
	"level_end_lose",
	"level_end",
	"level_end",
	"death_drown",
	"death_drown",
	"death_slime",
	"death_slime",
	"death_lava",
	"death_lava",
	"death_cratered",
	"death_cratered",
	"death_suicide",
	"death_suicide",
	"death_telefrag",
	"death_telefrag",
	"death_gauntlet",
	"death_gauntlet",
	"death_rail",
	"death_rail",
	"death_bfg",
	"death_bfg",
	"death_insult",
	"death_insult",
	"death_praise",
	"death_praise",
	"kill_gauntlet",
	"kill_gauntlet",
	"kill_rail",
	"kill_rail",
	"kill_telefrag",
	"kill_telefrag",
	"kill_insult",
	"kill_insult",
	"kill_praise",
	"kill_praise",
	"enemy_suicide",
	"enemy_suicide",
	"hit_talking",
	"hit_talking",
	"hit_nodeath",
	"hit_nodeath",
	"hit_nokill",
	"hit_nokill",
	"random_misc",
	"random_misc",
	"[invalid var]",
	"[invalid var]",
	"random_insult",
	"random_insult",
	"[invalid var]",
	"[invalid var]",
	"sv_maxclients",
	"sv_maxclients",
	"sv_maxclients",
	"what do you say?",
	"I need more key points to patrol\n",
	"I need more key points to patrol\n",
	"%d\n",
	"whois",
	"whois",
	"whereis",
	"whereareyou",
	"whois",
	"whereareyou",
	"keepinmind",
	"yes",
	"joinedteam",
	"leftteam",
	"",
	"inteam",
	"noteam",
	"%f %f %f",
	"checkpoint_invalid",
	"%1.0f %1.0f %1.0f",
	"checkpoint_confirm",
	"dismissed",
	"kill",
	"taunt",
	"I\'m the team leader\n",
	"helping",
	"accompanying",
	"defending",
	"gettingitem",
	"killing",
	"camping",
	"patrolling",
	"capturingflag",
	"rushingbase",
	"returningflag",
	"roaming",
	"Shotgun",
	"Grenade Launcher",
	"Rocket Launcher",
	"Plasmagun",
	"Railgun",
	"Lightning Gun",
	"BFG10K",
	"Quad Damage",
	"Regeneration",
	"Battle Suit",
	"Speed",
	"Invisibility",
	"Flight",
	"Armor",
	"Heavy Armor",
	"Red Flag",
	"Blue Flag",
	"teamlocation",
	"red",
	"teamlocation",
	"blue",
	"location",
	"location",
	"whois",
	"whereis",
	"whereareyou",
	"whois",
	"red",
	"red",
	"the part of my brain to create formations has been damaged",
	"the part of my brain to create formations has been damaged",
	"unknown match type\n",
	"%s at %1.1f switched more than %d AI nodes\n",
	"",
	"%s at %2.1f entered %s: %s from %s\n",
	"help_start",
	"yes",
	"accompany_start",
	"yes",
	"accompany_stop",
	"accompany_arrive",
	"BotLongTermGoal: go for air",
	"accompany_cannotfind",
	"defend_start",
	"ondefense",
	"defend_stop",
	"kill_start",
	"kill_done",
	"getitem_start",
	"yes",
	"getitem_notthere",
	"getitem_gotit",
	"camp_start",
	"yes",
	"camp_stop",
	"camp_arrive",
	"inposition",
	"camp_stop",
	"",
	" to ",
	"patrol_start",
	"yes",
	"patrol_stop",
	"captureflag_start",
	"ongetflag",
	"returnflag_start",
	"onreturnflag",
	"lead_stop",
	"followme",
	"followme",
	"followme",
	"intermission",
	"",
	"intermission: chat",
	"observer",
	"",
	"observer: left observer",
	"stand",
	"",
	"stand: found enemy",
	"stand: time out",
	"respawn",
	"",
	"respawn: respawned",
	"activate entity",
	"",
	"active entity: observer",
	"activate entity: intermission",
	"activate entity: bot dead",
	"activate entity: no goal",
	"activate entity: time out",
	"activate entity: activated",
	"activate entity: found enemy",
	"activate entity: found enemy",
	"seek NBG",
	"seek NBG",
	"no goal",
	"seek nbg: observer",
	"seek nbg: intermision",
	"seek nbg: bot dead",
	"seek nbg: time out",
	"seek nbg: found enemy",
	"seek nbg: found enemy",
	"seek LTG",
	"seek LTG",
	"no goal",
	"seek ltg: observer",
	"seek ltg: intermission",
	"seek ltg: bot dead",
	"seek ltg: random chat",
	"seek ltg: found enemy",
	"seek ltg: found enemy",
	"ltg seek: nbg",
	"battle fight",
	"",
	"battle fight",
	"",
	"battle fight: observer",
	"battle fight: intermission",
	"battle fight: bot dead",
	"battle fight: no enemy",
	"battle fight: enemy dead",
	"battle fight: enemy dead",
	"battle fight: enemy dead",
	"battle fight: invisible",
	"battle fight: chat health decreased",
	"battle fight: chat hit someone",
	"battle fight: enemy out of sight",
	"battle fight: enemy out of sight",
	"battle fight: wants to retreat",
	"battle chase",
	"",
	"battle chase: observer",
	"battle chase: intermission",
	"battle chase: bot dead",
	"battle chase: no enemy",
	"battle chase",
	"battle chase: better enemy",
	"battle chase: no enemy area",
	"battle chase: time out",
	"battle chase: time out",
	"battle chase: nbg",
	"battle chase: wants to retreat",
	"battle retreat",
	"",
	"battle retreat: observer",
	"battle retreat: intermission",
	"battle retreat: bot dead",
	"battle retreat: no enemy",
	"battle retreat: enemy dead",
	"battle retreat: wants to chase",
	"battle retreat: lost enemy",
	"battle retreat: another enemy",
	"battle retreat: no way out",
	"battle retreat: nbg",
	"battle NBG",
	"",
	"battle nbg: observer",
	"battle nbg: intermission",
	"battle nbg: bot dead",
	"battle nbg: no enemy",
	"battle nbg: enemy dead",
	"battle nbg: time out",
	"battle nbg: time out",
	"t",
	"t",
	"no",
	"%d",
	"teamtask",
	"ihaveflag",
	"onfollow",
	"onfollow",
	"ClientName: client out of range\n",
	"[client out of range]",
	"ClientName: client out of range\n",
	"[client out of range]",
	"n",
	"ClientSkin: client out of range\n",
	"[client out of range]",
	"ClientSkin: client out of range\n",
	"[client out of range]",
	"model",
	"sv_maxclients",
	"n",
	"sv_maxclients",
	"n",
	" ",
	" ",
	"[",
	"]",
	"t",
	"BotCreateWayPoint: Out of waypoints\n",
	"Quad Damage",
	"Regeneration",
	"Battle Suit",
	"Speed",
	"Invisibility",
	"t",
	"t",
	"mapname",
	"q3tourney6",
	"mpq3tourney6",
	"model",
	"lip",
	"angle",
	"health",
	"model",
	"model",
	"*%d",
	"model",
	"BotGetActivateGoal: no entity found with model %s\n",
	"classname",
	"BotGetActivateGoal: entity with model %s has no classname\n",
	"func_door",
	"health",
	"spawnflags",
	"origin",
	"model",
	"func_button",
	"targetname",
	"BotGetActivateGoal: entity with model \"%s\" has no targetname\n",
	"target",
	"BotGetActivateGoal: no entity with target \"%s\"\n",
	"classname",
	"BotGetActivateGoal: entity with target \"%s\" has no classname\n",
	"func_button",
	"trigger_multiple",
	"func_timer",
	"target_relay",
	"target_delay",
	"targetname",
	"BotGoForActivateGoal",
	"classname",
	"%s: I have to shoot at a %s from %1.1f %1.1f %1.1f in area %d\n",
	"%s: I have to activate a %s at %1.1f %1.1f %1.1f in area %d\n",
	"bot_testrchat",
	"1",
	"------------------------\n",
	"**** no valid reply ****\n",
	"BotCheckConsoleMessages: reply chat",
	"EV_GLOBAL_SOUND: eventParm (%d) out of range\n",
	"EV_GLOBAL_SOUND: eventParm (%d) out of range\n",
	"sound/items/poweruprespawn.wav",
	"EV_GENERAL_SOUND: eventParm (%d) out of range\n",
	"EV_GENERAL_SOUND: eventParm (%d) out of range\n",
	"*falling1.wav",
	"sex",
	"team %s",
	"BotDeathmatchAI: no ai node",
	"BotDeathmatchAI: chat enter game",
	"%s at %1.1f switched more than %d AI nodes\n",
	"classname",
	"origin",
	"g_gametype",
	"sv_maxclients",
	"bot_rocketjump",
	"1",
	"bot_grapple",
	"0",
	"bot_fastchat",
	"0",
	"bot_nochat",
	"0",
	"bot_testrchat",
	"0",
	"bot_challenge",
	"0",
	"bot_predictobstacles",
	"1",
	"g_spSkill",
	"2",
	"Red Flag",
	"CTF without Red Flag\n",
	"Blue Flag",
	"CTF without Blue Flag\n",
	"model",
	"%s",
	"^3Warning: %s",
	"^1Error: %s",
	"^1Fatal: %s",
	"^1Exit: %s",
	"unknown print type\n",
	"\remtpy area",
	"\r^1SOLID area",
	"\r^1Solid!                              ",
	"\rarea %d, cluster %d       ",
	"L",
	" ",
	"  ",
	"^1F ",
	"^4F ",
	"%-20s%s%s: helping %s\n",
	"%-20s%s%s: accompanying %s\n",
	"%-20s%s%s: defending %s\n",
	"%-20s%s%s: getting item %s\n",
	"%-20s%s%s: killing %s\n",
	"%-20s%s%s: camping\n",
	"%-20s%s%s: patrolling\n",
	"%-20s%s%s: capturing flag\n",
	"%-20s%s%s: rushing base\n",
	"%-20s%s%s: returning flag\n",
	"%-20s%s%s: attacking the enemy base\n",
	"%-20s%s%s: harvesting\n",
	"%-20s%s%s: roaming\n",
	"^1RED\n",
	"n",
	"t",
	"^4BLUE\n",
	"n",
	"t",
	"L",
	" ",
	"  ",
	"F ",
	"helping %s",
	"accompanying %s",
	"defending %s",
	"getting item %s",
	"killing %s",
	"camping",
	"patrolling",
	"capturing flag",
	"rushing base",
	"returning flag",
	"attacking the enemy base",
	"harvesting",
	"roaming %s",
	"l\\%s\\c\\%s\\a\\%s",
	"n",
	"bot_interbreedwrite",
	"",
	"%d",
	"g_gametype",
	"bot_reloadcharacters",
	"1",
	"addbot %s 4 free %i %s%d\n",
	"bot_interbreedchar",
	"",
	"BotAI: client %d is not setup\n",
	"BotAI: client %d is not setup\n",
	"cp ",
	"cs",
	"print",
	"chat",
	"tchat",
	"scores",
	"clientLevelShot",
	"%i %i %i %i %i %i %i %i %f %f %f %f %f %f %f %f %f",
	"botsession%i",
	"botsession%i",
	"%i %i %i %i %i %i %i %i %f %f %f %f %f %f %f %f %f",
	"BotAISetupClient: client %d already setup\n",
	"AAS not initialized\n",
	"couldn\'t load skill %f from %s\n",
	"bot_testichat",
	"bot_testichat",
	"1",
	"mapname",
	"",
	"memorydump",
	"1",
	"bot_memorydump",
	"0",
	"saveroutingcache",
	"1",
	"bot_saveroutingcache",
	"0",
	"bot_thinktime",
	"200",
	"sv_maxclients",
	"8",
	"maxclients",
	"%d",
	"maxentities",
	"sv_mapChecksum",
	"sv_mapChecksum",
	"max_aaslinks",
	"max_aaslinks",
	"max_levelitems",
	"max_levelitems",
	"g_gametype",
	"0",
	"g_gametype",
	"bot_developer",
	"log",
	"bot_nochat",
	"nochat",
	"0",
	"bot_visualizejumppads",
	"bot_visualizejumppads",
	"bot_forceclustering",
	"forceclustering",
	"bot_forcereachability",
	"forcereachability",
	"bot_forcewrite",
	"forcewrite",
	"bot_aasoptimize",
	"aasoptimize",
	"bot_saveroutingcache",
	"saveroutingcache",
	"bot_reloadcharacters",
	"0",
	"bot_reloadcharacters",
	"fs_basepath",
	"basedir",
	"fs_game",
	"gamedir",
	"fs_cdpath",
	"cddir",
	"bot_thinktime",
	"100",
	"bot_memorydump",
	"0",
	"bot_saveroutingcache",
	"0",
	"bot_pause",
	"0",
	"bot_report",
	"0",
	"bot_testsolid",
	"0",
	"bot_testclusters",
	"0",
	"bot_developer",
	"0",
	"bot_interbreedchar",
	"",
	"bot_interbreedbots",
	"10",
	"bot_interbreedcycle",
	"20",
	"bot_interbreedwrite",
	"",
	"sv_maxclients",
	"n",
	"t",
	"sv_maxclients",
	"n",
	"t",
	"\031(%s\031)\031: %s",
	"cmd_getflag",
	"getflag",
	"cmd_accompanyme",
	"followme",
	"cmd_accompany",
	"followflagcarrier",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"returnflag",
	"cmd_accompanyme",
	"followme",
	"cmd_accompany",
	"followflagcarrier",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"returnflag",
	"cmd_defendbase",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_defendbase",
	"defend",
	"cmd_defendbase",
	"defend",
	"cmd_defendbase",
	"defend",
	"cmd_accompanyme",
	"followme",
	"cmd_accompany",
	"followflagcarrier",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_getflag",
	"getflag",
	"cmd_defendbase",
	"defend",
	"cmd_getflag",
	"getflag",
	"cmd_accompanyme",
	"cmd_accompany",
	"sv_maxclients",
	"n",
	"t",
	"whoisteamleader",
	"iamteamleader",
	"startleader",
	"dismissed",
	"onpatrol",
	"whereareyou",
	"whereareyou",
	"iamteamleader",
	"startleader",
	"keepinmind",
	"yes",
	"keepinmind",
	"yes",
	"getflag",
	"offense",
	"defend",
	"defendflag",
	"patrol",
	"camp",
	"followme",
	"followflagcarrier",
	"returnflag",
	"startleader",
	"stopleader",
	"whoisleader",
	"wantondefense",
	"wantonoffense",
	"",
	"",
	"item_armor_shard",
	"sound/misc/ar1_pkup.wav",
	"models/powerups/armor/shard.md3",
	"models/powerups/armor/shard_sphere.md3",
	"icons/iconr_shard",
	"Armor Shard",
	"",
	"",
	"item_armor_combat",
	"sound/misc/ar2_pkup.wav",
	"models/powerups/armor/armor_yel.md3",
	"icons/iconr_yellow",
	"Armor",
	"",
	"",
	"item_armor_body",
	"sound/misc/ar2_pkup.wav",
	"models/powerups/armor/armor_red.md3",
	"icons/iconr_red",
	"Heavy Armor",
	"",
	"",
	"item_health_small",
	"sound/items/s_health.wav",
	"models/powerups/health/small_cross.md3",
	"models/powerups/health/small_sphere.md3",
	"icons/iconh_green",
	"5 Health",
	"",
	"",
	"item_health",
	"sound/items/n_health.wav",
	"models/powerups/health/medium_cross.md3",
	"models/powerups/health/medium_sphere.md3",
	"icons/iconh_yellow",
	"25 Health",
	"",
	"",
	"item_health_large",
	"sound/items/l_health.wav",
	"models/powerups/health/large_cross.md3",
	"models/powerups/health/large_sphere.md3",
	"icons/iconh_red",
	"50 Health",
	"",
	"",
	"item_health_mega",
	"sound/items/m_health.wav",
	"models/powerups/health/mega_cross.md3",
	"models/powerups/health/mega_sphere.md3",
	"icons/iconh_mega",
	"Mega Health",
	"",
	"",
	"weapon_gauntlet",
	"sound/misc/w_pkup.wav",
	"models/weapons2/gauntlet/gauntlet.md3",
	"icons/iconw_gauntlet",
	"Gauntlet",
	"",
	"",
	"weapon_shotgun",
	"sound/misc/w_pkup.wav",
	"models/weapons2/shotgun/shotgun.md3",
	"icons/iconw_shotgun",
	"Shotgun",
	"",
	"",
	"weapon_machinegun",
	"sound/misc/w_pkup.wav",
	"models/weapons2/machinegun/machinegun.md3",
	"icons/iconw_machinegun",
	"Machinegun",
	"",
	"",
	"weapon_grenadelauncher",
	"sound/misc/w_pkup.wav",
	"models/weapons2/grenadel/grenadel.md3",
	"icons/iconw_grenade",
	"Grenade Launcher",
	"",
	"sound/weapons/grenade/hgrenb1a.wav sound/weapons/grenade/hgrenb2a.wav",
	"weapon_rocketlauncher",
	"sound/misc/w_pkup.wav",
	"models/weapons2/rocketl/rocketl.md3",
	"icons/iconw_rocket",
	"Rocket Launcher",
	"",
	"",
	"weapon_lightning",
	"sound/misc/w_pkup.wav",
	"models/weapons2/lightning/lightning.md3",
	"icons/iconw_lightning",
	"Lightning Gun",
	"",
	"",
	"weapon_railgun",
	"sound/misc/w_pkup.wav",
	"models/weapons2/railgun/railgun.md3",
	"icons/iconw_railgun",
	"Railgun",
	"",
	"",
	"weapon_plasmagun",
	"sound/misc/w_pkup.wav",
	"models/weapons2/plasma/plasma.md3",
	"icons/iconw_plasma",
	"Plasma Gun",
	"",
	"",
	"weapon_bfg",
	"sound/misc/w_pkup.wav",
	"models/weapons2/bfg/bfg.md3",
	"icons/iconw_bfg",
	"BFG10K",
	"",
	"",
	"weapon_grapplinghook",
	"sound/misc/w_pkup.wav",
	"models/weapons2/grapple/grapple.md3",
	"icons/iconw_grapple",
	"Grappling Hook",
	"",
	"",
	"ammo_shells",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/shotgunam.md3",
	"icons/icona_shotgun",
	"Shells",
	"",
	"",
	"ammo_bullets",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/machinegunam.md3",
	"icons/icona_machinegun",
	"Bullets",
	"",
	"",
	"ammo_grenades",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/grenadeam.md3",
	"icons/icona_grenade",
	"Grenades",
	"",
	"",
	"ammo_cells",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/plasmaam.md3",
	"icons/icona_plasma",
	"Cells",
	"",
	"",
	"ammo_lightning",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/lightningam.md3",
	"icons/icona_lightning",
	"Lightning",
	"",
	"",
	"ammo_rockets",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/rocketam.md3",
	"icons/icona_rocket",
	"Rockets",
	"",
	"",
	"ammo_slugs",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/railgunam.md3",
	"icons/icona_railgun",
	"Slugs",
	"",
	"",
	"ammo_bfg",
	"sound/misc/am_pkup.wav",
	"models/powerups/ammo/bfgam.md3",
	"icons/icona_bfg",
	"Bfg Ammo",
	"",
	"",
	"holdable_teleporter",
	"sound/items/holdable.wav",
	"models/powerups/holdable/teleporter.md3",
	"icons/teleporter",
	"Personal Teleporter",
	"",
	"",
	"holdable_medkit",
	"sound/items/holdable.wav",
	"models/powerups/holdable/medkit.md3",
	"models/powerups/holdable/medkit_sphere.md3",
	"icons/medkit",
	"Medkit",
	"",
	"sound/items/use_medkit.wav",
	"item_quad",
	"sound/items/quaddamage.wav",
	"models/powerups/instant/quad.md3",
	"models/powerups/instant/quad_ring.md3",
	"icons/quad",
	"Quad Damage",
	"",
	"sound/items/damage2.wav sound/items/damage3.wav",
	"item_enviro",
	"sound/items/protect.wav",
	"models/powerups/instant/enviro.md3",
	"models/powerups/instant/enviro_ring.md3",
	"icons/envirosuit",
	"Battle Suit",
	"",
	"sound/items/airout.wav sound/items/protect3.wav",
	"item_haste",
	"sound/items/haste.wav",
	"models/powerups/instant/haste.md3",
	"models/powerups/instant/haste_ring.md3",
	"icons/haste",
	"Speed",
	"",
	"",
	"item_invis",
	"sound/items/invisibility.wav",
	"models/powerups/instant/invis.md3",
	"models/powerups/instant/invis_ring.md3",
	"icons/invis",
	"Invisibility",
	"",
	"",
	"item_regen",
	"sound/items/regeneration.wav",
	"models/powerups/instant/regen.md3",
	"models/powerups/instant/regen_ring.md3",
	"icons/regen",
	"Regeneration",
	"",
	"sound/items/regen.wav",
	"item_flight",
	"sound/items/flight.wav",
	"models/powerups/instant/flight.md3",
	"models/powerups/instant/flight_ring.md3",
	"icons/flight",
	"Flight",
	"",
	"sound/items/flight.wav",
	"team_CTF_redflag",
	"models/flags/r_flag.md3",
	"icons/iconf_red1",
	"Red Flag",
	"",
	"",
	"team_CTF_blueflag",
	"models/flags/b_flag.md3",
	"icons/iconf_blu1",
	"Blue Flag",
	"",
	"",
	"HoldableItem not found",
	"Couldn\'t find item for weapon %i",
	"BG_CanItemBeGrabbed: index out of range",
	"BG_CanItemBeGrabbed: index out of range",
	"BG_CanItemBeGrabbed: IT_BAD",
	"BG_CanItemBeGrabbed: unknown enum %d\n",
	"BG_EvaluateTrajectory: unknown trType: %i",
	"BG_EvaluateTrajectoryDelta: unknown trType: %i",
	"EV_NONE",
	"EV_FOOTSTEP",
	"EV_FOOTSTEP_METAL",
	"EV_FOOTSPLASH",
	"EV_FOOTWADE",
	"EV_SWIM",
	"EV_STEP_4",
	"EV_STEP_8",
	"EV_STEP_12",
	"EV_STEP_16",
	"EV_FALL_SHORT",
	"EV_FALL_MEDIUM",
	"EV_FALL_FAR",
	"EV_JUMP_PAD",
	"EV_JUMP",
	"EV_WATER_TOUCH",
	"EV_WATER_LEAVE",
	"EV_WATER_UNDER",
	"EV_WATER_CLEAR",
	"EV_ITEM_PICKUP",
	"EV_GLOBAL_ITEM_PICKUP",
	"EV_NOAMMO",
	"EV_CHANGE_WEAPON",
	"EV_FIRE_WEAPON",
	"EV_USE_ITEM0",
	"EV_USE_ITEM1",
	"EV_USE_ITEM2",
	"EV_USE_ITEM3",
	"EV_USE_ITEM4",
	"EV_USE_ITEM5",
	"EV_USE_ITEM6",
	"EV_USE_ITEM7",
	"EV_USE_ITEM8",
	"EV_USE_ITEM9",
	"EV_USE_ITEM10",
	"EV_USE_ITEM11",
	"EV_USE_ITEM12",
	"EV_USE_ITEM13",
	"EV_USE_ITEM14",
	"EV_USE_ITEM15",
	"EV_ITEM_RESPAWN",
	"EV_ITEM_POP",
	"EV_PLAYER_TELEPORT_IN",
	"EV_PLAYER_TELEPORT_OUT",
	"EV_GRENADE_BOUNCE",
	"EV_GENERAL_SOUND",
	"EV_GLOBAL_SOUND",
	"EV_GLOBAL_TEAM_SOUND",
	"EV_BULLET_HIT_FLESH",
	"EV_BULLET_HIT_WALL",
	"EV_MISSILE_HIT",
	"EV_MISSILE_MISS",
	"EV_MISSILE_MISS_METAL",
	"EV_RAILTRAIL",
	"EV_SHOTGUN",
	"EV_BULLET",
	"EV_PAIN",
	"EV_DEATH1",
	"EV_DEATH2",
	"EV_DEATH3",
	"EV_OBITUARY",
	"EV_POWERUP_QUAD",
	"EV_POWERUP_BATTLESUIT",
	"EV_POWERUP_REGEN",
	"EV_GIB_PLAYER",
	"EV_SCOREPLUM",
	"EV_PROXIMITY_MINE_STICK",
	"EV_PROXIMITY_MINE_TRIGGER",
	"EV_KAMIKAZE",
	"EV_OBELISKEXPLODE",
	"EV_INVUL_IMPACT",
	"EV_JUICED",
	"EV_LIGHTNINGBOLT",
	"EV_DEBUG_LINE",
	"EV_STOPLOOPINGSOUND",
	"EV_TAUNT",
	"%i:allsolid\n",
	"%i:lift\n",
	"%i:kickoff\n",
	"%i:steep\n",
	"%i:Land\n",
	"%i:bend can\'t step\n",
	"%i:stepped\n",
	"*drown.wav",
	"sound/player/gurp1.wav",
	"sound/player/gurp2.wav",
	"Dropped due to inactivity",
	"cp \"Ten seconds until inactivity drop!\n\"",
	"pmove_msec",
	"8",
	"pmove_msec",
	"33",
	"postgame %i %i 0 0 0 0 0 0",
	"postgame %i %i %i %i %i %i %i %i",
	" %i %i %i",
	"^1ERROR: out of gentities\n",
	"g_podiumDist",
	"g_podiumDist",
	"g_podiumDist",
	"g_podiumDrop",
	"podium",
	"models/mapobjects/podium/podium4.md3",
	"g_podiumDist",
	"g_podiumDist",
	"g_podiumDist",
	"g_podiumDrop",
	"{",
	"Missing { in info file\n",
	"Max infos exceeded\n",
	"Unexpected end of info file\n",
	"}",
	"<NULL>",
	"\\num\\",
	"%d",
	"^1file not found: %s\n",
	"^1file too large: %s is %i, max allowed is %i",
	"g_arenasFile",
	"",
	"scripts/arenas.txt",
	"scripts",
	".arena",
	"scripts/",
	"%i arenas parsed\n",
	"%i",
	"num",
	"map",
	"default",
	"play sound/player/announce/%s.wav\n",
	"name",
	"name",
	"g_spSkill",
	"red",
	"blue",
	"",
	"addbot %s %f %s %i\n",
	"kick %s\n",
	"model",
	"^3Unable to delay spawn\n",
	"characterfile",
	"skill",
	"team",
	"BotAISetupClient failed",
	"^1Error: Bot \'%s\' not defined\n",
	"funname",
	"name",
	"name",
	"rate",
	"25000",
	"snaps",
	"20",
	"%1.2f",
	"skill",
	"handicap",
	"50",
	"handicap",
	"70",
	"handicap",
	"90",
	"model",
	"visor/default",
	"team_model",
	"headmodel",
	"team_headmodel",
	"gender",
	"male",
	"sex",
	"color1",
	"4",
	"color2",
	"5",
	"aifile",
	"^1Error: bot has no aifile specified\n",
	"^1Unable to add bot.  All player slots are in use.\n",
	"^1Start server with more \'open\' slots (or check setting of sv_maxclients cvar).\n",
	"red",
	"blue",
	"red",
	"aifile",
	"characterfile",
	"%5.2f",
	"skill",
	"team",
	"bot_enable",
	"Usage: Addbot <botname> [skill 1-5] [team] [msec delay] [altname]\n",
	"cl_running",
	"loaddefered\n",
	"^1name             model            aifile              funname\n",
	"name",
	"UnnamedPlayer",
	"funname",
	"",
	"model",
	"visor/default",
	"aifile",
	"bots/default_c.c",
	"%-16s %-16s %-20s %-20s\n",
	"g_spSkill",
	"g_spSkill",
	"1",
	"g_spSkill",
	"5",
	"addbot %s %f free %i\n",
	"^1file not found: %s\n",
	"^1file too large: %s is %i, max allowed is %i",
	"bot_enable",
	"g_botsFile",
	"",
	"scripts/bots.txt",
	"scripts",
	".bot",
	"scripts/",
	"%i bots parsed\n",
	"^1Invalid bot number: %i\n",
	"^1Invalid bot number: %i\n",
	"name",
	"bot_minplayers",
	"0",
	"mapname",
	"fraglimit",
	"fraglimit",
	"fraglimit",
	"0",
	"timelimit",
	"timelimit",
	"timelimit",
	"0",
	"fraglimit",
	"10",
	"timelimit",
	"0",
	"special",
	"training",
	"bots",
	"nobots",
	"0",
	"nohumans",
	"0",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"Couldn\'t find a spawn point",
	"info_player_deathmatch",
	"bodyque",
	"UnnamedPlayer",
	"UnnamedPlayer",
	"\\name\\badinfo",
	"ip",
	"localhost",
	"cg_predictItems",
	"name",
	"scoreboard",
	"print \"%s^7 renamed to %s\n\"",
	"handicap",
	"team_model",
	"team_headmodel",
	"model",
	"headmodel",
	"team",
	"red",
	"r",
	"blue",
	"b",
	"teamoverlay",
	"teamtask",
	"color1",
	"color2",
	"g_redteam",
	"g_blueteam",
	"skill",
	"n\\%s\\t\\%i\\model\\%s\\hmodel\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\skill\\%s\\tt\\%d\\tl\\%d",
	"n\\%s\\t\\%i\\model\\%s\\hmodel\\%s\\g_redteam\\%s\\g_blueteam\\%s\\c1\\%s\\c2\\%s\\hc\\%i\\w\\%i\\l\\%i\\tt\\%d\\tl\\%d",
	"ClientUserinfoChanged: %i %s\n",
	"ip",
	"You are banned from this server.",
	"localhost",
	"password",
	"none",
	"Invalid password",
	"BotConnectfailed",
	"ClientConnect: %i\n",
	"print \"%s^7 connected\n\"",
	"print \"%s^7 entered the game\n\"",
	"ClientBegin: %i\n",
	"handicap",
	"player",
	"ClientDisconnect: %i\n",
	"disconnected",
	"",
	" %i %i %i %i %i %i %i %i %i %i %i %i %i %i",
	"scores %i %i %i%s",
	"print \"Cheats are not enabled on this server.\n\"",
	"print \"You must be alive to use this command.\n\"",
	"print \"Bad client slot: %i\n\"",
	"print \"Bad client slot: %i\n\"",
	"print \"Client %i is not active\n\"",
	"print \"User %s is not on the server\n\"",
	"all",
	"health",
	"weapons",
	"ammo",
	"armor",
	"excellent",
	"impressive",
	"gauntletaward",
	"defend",
	"assist",
	"godmode OFF\n",
	"godmode ON\n",
	"print \"%s\"",
	"notarget OFF\n",
	"notarget ON\n",
	"print \"%s\"",
	"noclip OFF\n",
	"noclip ON\n",
	"print \"%s\"",
	"print \"Must be in g_gametype 0 for levelshot\n\"",
	"clientLevelShot",
	"%d",
	"teamtask",
	"cp \"%s^7 joined the red team.\n\"",
	"cp \"%s^7 joined the blue team.\n\"",
	"cp \"%s^7 joined the spectators.\n\"",
	"cp \"%s^7 joined the battle.\n\"",
	"scoreboard",
	"score",
	"follow1",
	"follow2",
	"spectator",
	"s",
	"red",
	"r",
	"blue",
	"b",
	"cp \"Red team has too many players.\n\"",
	"cp \"Blue team has too many players.\n\"",
	"print \"Blue team\n\"",
	"print \"Red team\n\"",
	"print \"Free team\n\"",
	"print \"Spectator team\n\"",
	"print \"May not switch teams more than once per 5 seconds.\n\"",
	"spectator",
	"spectator",
	"Cmd_FollowCycle_f: bad dir %i",
	"tchat",
	"chat",
	"%s \"%s%c%c%s\"",
	"say: %s: %s\n",
	"%s%c%c\031: ",
	"sayteam: %s: %s\n",
	"\031(%s%c%c\031) (%s)\031: ",
	"\031(%s%c%c\031)\031: ",
	"\031[%s%c%c\031] (%s)\031: ",
	"\031[%s%c%c\031]\031: ",
	"\031[%s%c%c\031]\031: ",
	"\031[%s%c%c\031]\031: ",
	"\031[%s%c%c\031]\031: ",
	"%s%s\n",
	"tell: %s to %s: %s\n",
	"vtchat",
	"vtell",
	"vchat",
	"%s %d %d %d %s",
	"voice: %s %s\n",
	"vtell: %s to %s: %s\n",
	"death_insult",
	"death_insult",
	"kill_gauntlet",
	"kill_gauntlet",
	"kill_insult",
	"kill_insult",
	"praise",
	"praise",
	"taunt",
	"hold your position",
	"hold this position",
	"come here",
	"cover me",
	"guard location",
	"search and destroy",
	"report",
	"print \"%s\n\"",
	"Free For All",
	"Tournament",
	"Single Player",
	"Team Deathmatch",
	"Capture the Flag",
	"One Flag CTF",
	"Overload",
	"Harvester",
	"print \"Voting not allowed here.\n\"",
	"print \"A vote is already in progress.\n\"",
	"print \"You have called the maximum number of votes.\n\"",
	"print \"Not allowed to call a vote as spectator.\n\"",
	"print \"Invalid vote string.\n\"",
	"print \"Invalid vote string.\n\"",
	"map_restart",
	"nextmap",
	"map",
	"g_gametype",
	"kick",
	"clientkick",
	"g_doWarmup",
	"timelimit",
	"fraglimit",
	"print \"Invalid vote string.\n\"",
	"print \"Vote commands are: map_restart, nextmap, map <mapname>, g_gametype <n>, kick <player>, clientkick <clientnum>, g_doWarmup, timelimit <time>, fraglimit <frags>.\n\"",
	"%s\n",
	"g_gametype",
	"map",
	"nextmap",
	"%s \"%s\"",
	"%s",
	"nextmap",
	"print \"nextmap not set.\n\"",
	"vstr nextmap",
	"%s",
	"nextmap",
	"%s %s; set nextmap \"%s\"",
	"%s %s",
	"%s",
	"print \"Invalid gametype.\n\"",
	"print \"Invalid gametype.\n\"",
	"print \"Invalid gametype.\n\"",
	"%s %d",
	"%s %s",
	"print \"%s called a vote.\n\"",
	"%i",
	"%i",
	"%i",
	"print \"No vote in progress.\n\"",
	"print \"Vote already cast.\n\"",
	"print \"Not allowed to vote as spectator.\n\"",
	"print \"Vote cast.\n\"",
	"%i",
	"%i",
	"%i",
	"%i",
	"print \"Voting not allowed here.\n\"",
	"print \"A team vote is already in progress.\n\"",
	"print \"You have called the maximum number of team votes.\n\"",
	"print \"Not allowed to call a vote as spectator.\n\"",
	" ",
	"print \"Invalid vote string.\n\"",
	"print \"Invalid vote string.\n\"",
	"leader",
	"print \"Invalid vote string.\n\"",
	"print \"Team vote commands are: leader <player>.\n\"",
	"print \"Bad client slot: %i\n\"",
	"print \"Bad client slot: %i\n\"",
	"print \"Client %i is not active\n\"",
	"print \"%s is not a valid player on your team.\n\"",
	"%d",
	"%s %s",
	"print \"%s called a team vote.\n\"",
	"%i",
	"%i",
	"%i",
	"print \"No team vote in progress.\n\"",
	"print \"Team vote already cast.\n\"",
	"print \"Not allowed to vote as spectator.\n\"",
	"print \"Team vote cast.\n\"",
	"%i",
	"%i",
	"%i",
	"%i",
	"print \"Cheats are not enabled on this server.\n\"",
	"print \"usage: setviewpos x y z yaw\n\"",
	"say",
	"say_team",
	"tell",
	"vsay",
	"vsay_team",
	"vtell",
	"vosay",
	"vosay_team",
	"votell",
	"vtaunt",
	"score",
	"give",
	"god",
	"notarget",
	"noclip",
	"kill",
	"teamtask",
	"levelshot",
	"follow",
	"follownext",
	"followprev",
	"team",
	"where",
	"callvote",
	"vote",
	"callteamvote",
	"teamvote",
	"gc",
	"setviewpos",
	"stats",
	"print \"unknown cmd %s\n\"",
	"kamikaze timer",
	"MOD_UNKNOWN",
	"MOD_SHOTGUN",
	"MOD_GAUNTLET",
	"MOD_MACHINEGUN",
	"MOD_GRENADE",
	"MOD_GRENADE_SPLASH",
	"MOD_ROCKET",
	"MOD_ROCKET_SPLASH",
	"MOD_PLASMA",
	"MOD_PLASMA_SPLASH",
	"MOD_RAILGUN",
	"MOD_LIGHTNING",
	"MOD_BFG",
	"MOD_BFG_SPLASH",
	"MOD_WATER",
	"MOD_SLIME",
	"MOD_LAVA",
	"MOD_CRUSH",
	"MOD_TELEFRAG",
	"MOD_FALLING",
	"MOD_SUICIDE",
	"MOD_TARGET_LASER",
	"MOD_TRIGGER_HURT",
	"MOD_GRAPPLE",
	"team_CTF_blueflag",
	"team_CTF_redflag",
	"team_CTF_redflag",
	"team_CTF_blueflag",
	"team_redobelisk",
	"team_blueobelisk",
	"<non-client>",
	"<world>",
	"<world>",
	"<world>",
	"<bad obituary>",
	"<bad obituary>",
	"Kill: %i %i %i: %s killed %s by %s\n",
	"%i: client:%i health:%i damage:%i armor:%i\n",
	"RespawnItem: bad teammaster",
	"sound/items/poweruprespawn.wav",
	"sound/items/kamikazerespawn.wav",
	"FinishSpawningItem: %s startsolid at %s\n",
	"Red Flag",
	"^3WARNING: No team_CTF_redflag in map",
	"^3WARNING: No team_CTF_redflag in map",
	"Blue Flag",
	"^3WARNING: No team_CTF_blueflag in map",
	"^3WARNING: No team_CTF_blueflag in map",
	"RegisterItem: NULL",
	"%i items registered\n",
	"disable_%s",
	"random",
	"0",
	"wait",
	"0",
	"sound/items/poweruprespawn.wav",
	"noglobalsound",
	"0",
	"sv_cheats",
	"",
	"gamename",
	"baseq3",
	"gamedate",
	"Jun 26 2006",
	"g_restarted",
	"0",
	"sv_mapname",
	"",
	"g_gametype",
	"0",
	"sv_maxclients",
	"8",
	"g_maxGameClients",
	"0",
	"dmflags",
	"0",
	"fraglimit",
	"20",
	"timelimit",
	"0",
	"capturelimit",
	"8",
	"g_synchronousClients",
	"0",
	"g_friendlyFire",
	"0",
	"g_teamAutoJoin",
	"0",
	"g_teamForceBalance",
	"0",
	"g_warmup",
	"20",
	"g_doWarmup",
	"0",
	"g_log",
	"games.log",
	"g_logSync",
	"0",
	"g_password",
	"",
	"g_banIPs",
	"",
	"g_filterBan",
	"1",
	"g_needpass",
	"0",
	"dedicated",
	"0",
	"g_speed",
	"320",
	"g_gravity",
	"800",
	"g_knockback",
	"1000",
	"g_quadfactor",
	"3",
	"g_weaponrespawn",
	"5",
	"g_weaponTeamRespawn",
	"30",
	"g_forcerespawn",
	"20",
	"g_inactivity",
	"0",
	"g_debugMove",
	"0",
	"g_debugDamage",
	"0",
	"g_debugAlloc",
	"0",
	"g_motd",
	"",
	"com_blood",
	"1",
	"g_podiumDist",
	"80",
	"g_podiumDrop",
	"70",
	"g_allowVote",
	"1",
	"g_listEntity",
	"0",
	"g_smoothClients",
	"1",
	"pmove_fixed",
	"0",
	"pmove_msec",
	"8",
	"g_rankings",
	"0",
	"%i teams with %i entities\n",
	"g_gametype %i is out of range, defaulting to 0\n",
	"g_gametype",
	"0",
	"g_gametype %i is out of range, defaulting to 0\n",
	"g_gametype",
	"0",
	"print \"Server: %s changed to %s\n\"",
	"------- Game Initialization -------\n",
	"gamename: %s\n",
	"baseq3",
	"gamedate: %s\n",
	"Jun 26 2006",
	"sound/player/fry.wav",
	"WARNING: Couldn\'t open logfile: %s\n",
	"------------------------------------------------------------\n",
	"InitGame: %s\n",
	"Not logging to disk.\n",
	"Not logging to disk.\n",
	"-----------------------------------\n",
	"models/mapobjects/podium/podium4.md3",
	"sound/player/gurp1.wav",
	"sound/player/gurp2.wav",
	"com_buildScript",
	"models/mapobjects/podium/podium4.md3",
	"sound/player/gurp1.wav",
	"sound/player/gurp2.wav",
	"bot_enable",
	"==== ShutdownGame ====\n",
	"ShutdownGame:\n",
	"------------------------------------------------------------\n",
	"bot_enable",
	"f",
	"s",
	"s",
	"%i",
	"%i",
	"%i",
	"%i",
	"%i",
	"%i",
	"%i",
	"%i",
	"info_player_intermission",
	"map_restart 0\n",
	"vstr nextmap\n",
	"%3i:%i%i ",
	"%s",
	"Exit: %s\n",
	"1",
	"red:%i  blue:%i\n",
	"score: %i  ping: %i  client: %i %s\n",
	"print \"Timelimit hit.\n\"",
	"Timelimit hit.",
	"print \"Red hit the fraglimit.\n\"",
	"Fraglimit hit.",
	"print \"Blue hit the fraglimit.\n\"",
	"Fraglimit hit.",
	"Fraglimit hit.",
	"print \"%s^7 hit the fraglimit.\n\"",
	"print \"Red hit the capturelimit.\n\"",
	"Capturelimit hit.",
	"print \"Blue hit the capturelimit.\n\"",
	"Capturelimit hit.",
	"%i",
	"Warmup:\n",
	"%i",
	"g_restarted",
	"1",
	"map_restart 0\n",
	"%i",
	"Warmup:\n",
	"%i",
	"g_restarted",
	"1",
	"map_restart 0\n",
	"%s\n",
	"print \"Vote failed.\n\"",
	"print \"Vote passed.\n\"",
	"print \"Vote failed.\n\"",
	"",
	"print \"%s is not connected\n\"",
	"print \"%s is not on the team anymore\n\"",
	"print \"%s is the new team leader\n\"",
	"print \"Team vote failed.\n\"",
	"print \"Team vote passed.\n\"",
	"leader",
	"%s\n",
	"print \"Team vote failed.\n\"",
	"",
	"none",
	"g_needpass",
	"1",
	"g_needpass",
	"0",
	"g_needpass",
	"0",
	"NULL ent->think",
	"%4i: %s\n",
	"g_listEntity",
	"0",
	"G_Alloc of %i bytes (%i left)\n",
	"G_Alloc: failed on allocation of %i bytes\n",
	"Game memory status: %i out of %i bytes allocated\n",
	"Couldn\'t find target for misc_partal_surface\n",
	"roll",
	"0",
	"hook",
	"plasma",
	"grenade",
	"bfg",
	"rocket",
	"hook",
	"pushed_p > &pushed[MAX_GENTITIES]",
	"Reached_BinaryMover: bad moverState",
	"noise",
	"100",
	"light",
	"100",
	"color",
	"1 1 1",
	"door_trigger",
	"sound/movers/doors/dr1_strt.wav",
	"sound/movers/doors/dr1_end.wav",
	"lip",
	"8",
	"dmg",
	"2",
	"health",
	"0",
	"plat_trigger",
	"sound/movers/plats/pt1_strt.wav",
	"sound/movers/plats/pt1_end.wav",
	"speed",
	"200",
	"dmg",
	"2",
	"wait",
	"1",
	"lip",
	"8",
	"height",
	"0",
	"sound/movers/switches/butn2.wav",
	"lip",
	"4",
	"func_train at %s with an unfound target\n",
	"Train corner at %s without a target\n",
	"Train corner at %s without a target path_corner\n",
	"path_corner",
	"path_corner with no targetname at %s\n",
	"func_train without a target at %s\n",
	"speed",
	"4",
	"height",
	"32",
	"dmg",
	"2",
	"phase",
	"0",
	"speed",
	"30",
	"dmg",
	"2",
	"phase",
	"0",
	"%i %i %i %i %i %i %i",
	"session%i",
	"session%i",
	"%i %i %i %i %i %i %i",
	"team",
	"session",
	"Gametype changed, clearing session data.\n",
	"%i",
	"session",
	"%f %f %f",
	"classname",
	"origin",
	"model",
	"model2",
	"spawnflags",
	"speed",
	"target",
	"targetname",
	"message",
	"team",
	"wait",
	"random",
	"count",
	"health",
	"light",
	"dmg",
	"angles",
	"angle",
	"targetShaderName",
	"targetShaderNewName",
	"info_player_start",
	"info_player_deathmatch",
	"info_player_intermission",
	"info_null",
	"info_notnull",
	"info_camp",
	"func_plat",
	"func_button",
	"func_door",
	"func_static",
	"func_rotating",
	"func_bobbing",
	"func_pendulum",
	"func_train",
	"func_group",
	"func_timer",
	"trigger_always",
	"trigger_multiple",
	"trigger_push",
	"trigger_teleport",
	"trigger_hurt",
	"target_give",
	"target_remove_powerups",
	"target_delay",
	"target_speaker",
	"target_print",
	"target_laser",
	"target_score",
	"target_teleporter",
	"target_relay",
	"target_kill",
	"target_position",
	"target_location",
	"target_push",
	"light",
	"path_corner",
	"misc_teleporter_dest",
	"misc_model",
	"misc_portal_surface",
	"misc_portal_camera",
	"shooter_rocket",
	"shooter_grenade",
	"shooter_plasma",
	"team_CTF_redplayer",
	"team_CTF_blueplayer",
	"team_CTF_redspawn",
	"team_CTF_bluespawn",
	"item_botroam",
	"G_CallSpawn: NULL classname\n",
	"%s doesn\'t have a spawn function\n",
	"%f %f %f",
	"ffa",
	"tournament",
	"single",
	"team",
	"ctf",
	"oneflag",
	"obelisk",
	"harvester",
	"teamtournament",
	"notsingle",
	"0",
	"notteam",
	"0",
	"notfree",
	"0",
	"notq3a",
	"0",
	"gametype",
	"G_AddSpawnVarToken: MAX_SPAWN_CHARS",
	"G_ParseSpawnVars: found %s when expecting {",
	"G_ParseSpawnVars: EOF without closing brace",
	"G_ParseSpawnVars: EOF without closing brace",
	"G_ParseSpawnVars: closing brace without data",
	"G_ParseSpawnVars: MAX_SPAWN_VARS",
	"classname",
	"",
	"worldspawn",
	"SP_worldspawn: The first entity isn\'t \'worldspawn\'",
	"baseq3-1",
	"%i",
	"music",
	"",
	"message",
	"",
	"gravity",
	"800",
	"g_gravity",
	"enableDust",
	"0",
	"g_enableDust",
	"enableBreath",
	"0",
	"g_enableBreath",
	"worldspawn",
	"",
	"g_restarted",
	"0",
	"%i",
	"Warmup:\n",
	"SpawnEntities: no entities",
	"Bad filter address: %s\n",
	"*",
	"%i",
	".",
	" ",
	"g_banIPs overflowed at MAX_CVAR_VALUE_STRING\n",
	"g_banIPs",
	"IP filter list is full\n",
	"Usage:  addip <ip-mask>\n",
	"Usage:  sv removeip <ip-mask>\n",
	"Removed.\n",
	"Didn\'t find %s.\n",
	"%3i:",
	"ET_GENERAL          ",
	"ET_PLAYER           ",
	"ET_ITEM             ",
	"ET_MISSILE          ",
	"ET_MOVER            ",
	"ET_BEAM             ",
	"ET_PORTAL           ",
	"ET_SPEAKER          ",
	"ET_PUSH_TRIGGER     ",
	"ET_TELEPORT_TRIGGER ",
	"ET_INVISIBLE        ",
	"ET_GRAPPLE          ",
	"%3i                 ",
	"%s",
	"\n",
	"Bad client slot: %i\n",
	"Bad client slot: %i\n",
	"Client %i is not connected\n",
	"User %s is not on the server\n",
	"entitylist",
	"forceteam",
	"game_memory",
	"addbot",
	"botlist",
	"abort_podium",
	"addip",
	"removeip",
	"listip",
	"g_banIPs\n",
	"say",
	"print \"server: %s\"",
	"print \"server: %s\"",
	"delay",
	"0",
	"wait",
	"1",
	"cp \"%s\"",
	"cp \"%s\"",
	"cp \"%s\"",
	"cp \"%s\"",
	"wait",
	"0",
	"random",
	"0",
	"noise",
	"NOSOUND",
	"target_speaker without a noise key at %s",
	".wav",
	"%s.wav",
	"%s at %s: %s is a bad target\n",
	"Couldn\'t find teleporter destination\n",
	"untargeted %s at %s\n",
	"unknown",
	"target_location",
	"RED",
	"BLUE",
	"SPECTATOR",
	"FREE",
	"BLUE",
	"RED",
	"SPECTATOR",
	"FREE",
	"^1",
	"^4",
	"^3",
	"^7",
	"PrintMsg overrun",
	"print \"%s\"",
	"%s^7 fragged %s\'s flag carrier!\n",
	"%s^7 fragged %s\'s skull carrier!\n",
	"team_CTF_redflag",
	"team_CTF_blueflag",
	"team_CTF_redflag",
	"team_CTF_blueflag",
	"team_CTF_neutralflag",
	"Warning:  NULL passed to Team_ReturnFlagSound\n",
	"Warning:  NULL passed to Team_TakeFlagSound\n",
	"Warning:  NULL passed to Team_CaptureFlagSound\n",
	"The flag has returned!\n",
	"The %s flag has returned!\n",
	"%s^7 returned the %s flag!\n",
	"%s^7 captured the %s flag!\n",
	"%s^7 got the %s flag!\n",
	"team_CTF_redflag",
	"team_CTF_blueflag",
	"Don\'t know what team the flag is on.\n",
	"%c%c%s^7",
	"%s",
	"team_CTF_redplayer",
	"team_CTF_blueplayer",
	"team_CTF_redspawn",
	"team_CTF_bluespawn",
	" %i %i %i %i %i %i",
	"tinfo %i %s",
	"wait",
	"0.5",
	"random",
	"0",
	"trigger_multiple has random >= wait\n",
	"sound/world/jumppad.wav",
	"sound/world/jumppad.wav",
	"sound/misc/windfly.wav",
	"Couldn\'t find teleporter destination\n",
	"sound/world/jumppad.wav",
	"sound/world/electro.wav",
	"random",
	"1",
	"wait",
	"1",
	"func_timer at %s has random >= wait\n",
	"%s=%s:%5.2f@",
	"G_FindConfigstringIndex: overflow",
	"%s",
	"G_PickTarget called with NULL targetname\n",
	"G_PickTarget: target %s not found\n",
	"WARNING: Entity used itself.\n",
	"entity was removed while using targets\n",
	"(%i %i %i)",
	"noclass",
	"%4i: %s\n",
	"G_Spawn: no free entities",
	"freed",
	"tempEntity",
	"G_AddEvent: zero event added for entity %i\n",
	"Q_fabs(inv_denom) != 0.0f",
	"/home/ashu/quake3/src/quake3/game/q_math.c",
	"ProjectPointOnPlane",
	"!isnan(y)",
	"/home/ashu/quake3/src/quake3/game/q_math.c",
	"Q_rsqrt",
	"%s%s",
	"%s",
	"ERROR: %s, line %d: %s\n",
	"WARNING: %s, line %d: %s\n",
	"MatchToken: %s != %s",
	"(",
	")",
	"(",
	")",
	"(",
	")",
	"Q_strncpyz: NULL dest",
	"Q_strncpyz: NULL src",
	"Q_strncpyz: destsize < 1",
	"Q_strcat: already overflowed",
	"Com_sprintf: overflowed bigbuffer",
	"Com_sprintf: overflow of %i in %i\n",
	"",
	"",
	"Info_ValueForKey: oversize infostring",
	"",
	"",
	"Info_RemoveKey: oversize infostring",
	"Info_RemoveKey_Big: oversize infostring",
	"Info_SetValueForKey: oversize infostring",
	"Can\'t use keys or values with a \\\n",
	"Can\'t use keys or values with a \\\n",
	"Can\'t use keys or values with a semicolon\n",
	"Can\'t use keys or values with a semicolon\n",
	"Can\'t use keys or values with a \"\n",
	"Can\'t use keys or values with a \"\n",
	"\\%s\\%s",
	"Info string length exceeded\n",
	"Info_SetValueForKey: oversize infostring",
	"Can\'t use keys or values with a \\\n",
	"Can\'t use keys or values with a \\\n",
	"Can\'t use keys or values with a semicolon\n",
	"Can\'t use keys or values with a semicolon\n",
	"Can\'t use keys or values with a \"\n",
	"Can\'t use keys or values with a \"\n",
	"\\%s\\%s",
	"BIG Info string length exceeded\n",
};

#undef  FOFS
#define FOFS(x)     #x,(int)&(((gentity_t *)0)->x)

const Field *g_GEntityFields [] = {
    
	new TypedField<int> (FOFS(s.eType)),
	new TypedField<int> (FOFS(s.eFlags)),
	new TypedField<int> (FOFS(s.pos.trType)),
	new TypedField<int> (FOFS(s.pos.trTime)),
	new TypedField<int> (FOFS(s.pos.trDuration)),
	new TypedArray<float > (FOFS(s.pos.trBase), 3),
	new TypedArray<float > (FOFS(s.pos.trDelta), 3),
	new TypedField<int> (FOFS(s.apos.trType)),
	new TypedField<int> (FOFS(s.apos.trTime)),
	new TypedField<int> (FOFS(s.apos.trDuration)),
	new TypedArray<float > (FOFS(s.apos.trBase), 3),
	new TypedArray<float > (FOFS(s.apos.trDelta), 3),
	new TypedField<int> (FOFS(s.time)),
	new TypedField<int> (FOFS(s.time2)),
	new TypedArray<float > (FOFS(s.origin), 3),
	new TypedArray<float > (FOFS(s.origin2), 3),
	new TypedArray<float > (FOFS(s.angles), 3),
	new TypedArray<float > (FOFS(s.angles2), 3),
	new TypedField<int> (FOFS(s.groundEntityNum)),
	new TypedField<int> (FOFS(s.constantLight)),
	new TypedField<int> (FOFS(s.loopSound)),
	new TypedField<int> (FOFS(s.modelindex)),
	new TypedField<int> (FOFS(s.modelindex2)),
	new TypedField<int> (FOFS(s.frame)),
	new TypedField<int> (FOFS(s.solid)),
	new TypedField<int> (FOFS(s.event)),
	new TypedField<int> (FOFS(s.eventParm)),
	new TypedField<int> (FOFS(s.powerups)),
	new TypedField<int> (FOFS(s.weapon)),
	new TypedField<int> (FOFS(s.legsAnim)),
	new TypedField<int> (FOFS(s.torsoAnim)),
	new TypedField<int> (FOFS(s.generic1)),
	new TypedField<int> (FOFS(r.s.number)),
	new TypedField<int> (FOFS(r.s.eType)),
	new TypedField<int> (FOFS(r.s.eFlags)),
	new TypedField<int> (FOFS(r.s.pos.trType)),
	new TypedField<int> (FOFS(r.s.pos.trTime)),
	new TypedField<int> (FOFS(r.s.pos.trDuration)),
	new TypedArray<float > (FOFS(r.s.pos.trBase), 3),
	new TypedArray<float > (FOFS(r.s.pos.trDelta), 3),
	new TypedField<int> (FOFS(r.s.apos.trType)),
	new TypedField<int> (FOFS(r.s.apos.trTime)),
	new TypedField<int> (FOFS(r.s.apos.trDuration)),
	new TypedArray<float > (FOFS(r.s.apos.trBase), 3),
	new TypedArray<float > (FOFS(r.s.apos.trDelta), 3),
	new TypedField<int> (FOFS(r.s.time)),
	new TypedField<int> (FOFS(r.s.time2)),
	new TypedArray<float > (FOFS(r.s.origin), 3),
	new TypedArray<float > (FOFS(r.s.origin2), 3),
	new TypedArray<float > (FOFS(r.s.angles), 3),
	new TypedArray<float > (FOFS(r.s.angles2), 3),
	new TypedField<int> (FOFS(r.s.otherEntityNum)),
	new TypedField<int> (FOFS(r.s.otherEntityNum2)),
	new TypedField<int> (FOFS(r.s.groundEntityNum)),
	new TypedField<int> (FOFS(r.s.constantLight)),
	new TypedField<int> (FOFS(r.s.loopSound)),
	new TypedField<int> (FOFS(r.s.modelindex)),
	new TypedField<int> (FOFS(r.s.modelindex2)),
	new TypedField<int> (FOFS(r.s.clientNum)),
	new TypedField<int> (FOFS(r.s.frame)),
	new TypedField<int> (FOFS(r.s.solid)),
	new TypedField<int> (FOFS(r.s.event)),
	new TypedField<int> (FOFS(r.s.eventParm)),
	new TypedField<int> (FOFS(r.s.powerups)),
	new TypedField<int> (FOFS(r.s.weapon)),
	new TypedField<int> (FOFS(r.s.legsAnim)),
	new TypedField<int> (FOFS(r.s.torsoAnim)),
	new TypedField<int> (FOFS(r.s.generic1)),
	new TypedField<int> (FOFS(r.linked)),
	new TypedField<int> (FOFS(r.linkcount)),
	new TypedField<int> (FOFS(r.svFlags)),
	new TypedField<int> (FOFS(r.singleClient)),
	new TypedField<int> (FOFS(r.bmodel)),
	new TypedArray<float > (FOFS(r.mins), 3),
	new TypedArray<float > (FOFS(r.maxs), 3),
	new TypedField<int> (FOFS(r.contents)),
	new TypedArray<float > (FOFS(r.currentOrigin), 3),
	new TypedArray<float > (FOFS(r.currentAngles), 3),
	new TypedField<int> (FOFS(r.ownerNum)),
	new TypedField<gentity_t *> (FOFS(otherEntity)),
	new TypedField<gentity_t *> (FOFS(otherEntity2)),
	new TypedField<gclient_t *> (FOFS(client)),
	new TypedField<int> (FOFS(inuse)),
	new TypedField<int> (FOFS(spawnflags)),
	new TypedField<int> (FOFS(neverFree)),
	new TypedField<int> (FOFS(flags)),
	new TypedField<int> (FOFS(freetime)),
	new TypedField<int> (FOFS(eventTime)),
	new TypedField<int> (FOFS(freeAfterEvent)),
	new TypedField<int> (FOFS(unlinkAfterEvent)),
	new TypedField<int> (FOFS(physicsObject)),
	new TypedField<float> (FOFS(physicsBounce)),
	new TypedField<int> (FOFS(clipmask)),
	new TypedField<char *> (FOFS(classname)),
	new TypedField<char *> (FOFS(model)),
	new TypedField<char *> (FOFS(model2)),
	new TypedField<int> (FOFS(moverState)),
	new TypedField<int> (FOFS(soundPos1)),
	new TypedField<int> (FOFS(sound1to2)),
	new TypedField<int> (FOFS(sound2to1)),
	new TypedField<int> (FOFS(soundPos2)),
	new TypedField<int> (FOFS(soundLoop)),
	new TypedField<gentity_t *> (FOFS(parent)),
	new TypedField<gentity_t *> (FOFS(nextTrain)),
	new TypedField<gentity_t *> (FOFS(prevTrain)),
	new TypedArray<float > (FOFS(pos1), 3),
	new TypedArray<float > (FOFS(pos2), 3),
	new TypedField<int> (FOFS(timestamp)),
	new TypedField<float> (FOFS(angle)),
	new TypedField<char *> (FOFS(message)),
	new TypedField<char *> (FOFS(target)),
	new TypedField<char *> (FOFS(targetname)),
	new TypedField<char *> (FOFS(team)),
	new TypedField<char *> (FOFS(targetShaderName)),
	new TypedField<char *> (FOFS(targetShaderNewName)),
	new TypedField<gentity_t *> (FOFS(target_ent)),
	new TypedField<float> (FOFS(speed)),
	new TypedArray<float > (FOFS(movedir), 3),
	new TypedField<int> (FOFS(nextthink)),
	new TypedField<void *> (FOFS(think)),
	new TypedField<void *> (FOFS(reached)),
	new TypedField<void *> (FOFS(blocked)),
	new TypedField<void *> (FOFS(touch)),
	new TypedField<void *> (FOFS(use)),
	new TypedField<void *> (FOFS(pain)),
	new TypedField<void *> (FOFS(die)),
	new TypedField<int> (FOFS(pain_debounce_time)),
	new TypedField<int> (FOFS(fly_sound_debounce_time)),
	new TypedField<int> (FOFS(last_move_time)),
	new TypedField<int> (FOFS(health)),
	new TypedField<int> (FOFS(takedamage)),
	new TypedField<int> (FOFS(damage)),
	new TypedField<int> (FOFS(splashDamage)),
	new TypedField<int> (FOFS(splashRadius)),
	new TypedField<int> (FOFS(methodOfDeath)),
	new TypedField<int> (FOFS(splashMethodOfDeath)),
	new TypedField<int> (FOFS(count)),
	new TypedField<gentity_t *> (FOFS(chain)),
	new TypedField<gentity_t *> (FOFS(enemy)),
	new TypedField<gentity_t *> (FOFS(activator)),
	new TypedField<gentity_t *> (FOFS(teamchain)),
	new TypedField<gentity_t *> (FOFS(teammaster)),
	new TypedField<int> (FOFS(watertype)),
	new TypedField<int> (FOFS(waterlevel)),
	new TypedField<int> (FOFS(noise_index)),
	new TypedField<float> (FOFS(wait)),
	new TypedField<float> (FOFS(random)),
	new TypedField<gitem_t *> (FOFS(item)),
    
};

#undef  FOFS
#define FOFS(x)     #x,(int)&(((gclient_t *)0)->x)

const Field *g_GClientFields [] = {
    
	new TypedField<int> (FOFS(ps.commandTime)),
	new TypedField<int> (FOFS(ps.pm_type)),
	new TypedField<int> (FOFS(ps.bobCycle)),
	new TypedField<int> (FOFS(ps.pm_flags)),
	new TypedField<int> (FOFS(ps.pm_time)),
	new TypedArray<float > (FOFS(ps.origin), 3),
	new TypedArray<float > (FOFS(ps.velocity), 3),
	new TypedField<int> (FOFS(ps.weaponTime)),
	new TypedField<int> (FOFS(ps.gravity)),
	new TypedField<int> (FOFS(ps.speed)),
	new TypedArray<int > (FOFS(ps.delta_angles), 3),
	new TypedField<int> (FOFS(ps.groundEntityNum)),
	new TypedField<int> (FOFS(ps.legsTimer)),
	new TypedField<int> (FOFS(ps.legsAnim)),
	new TypedField<int> (FOFS(ps.torsoTimer)),
	new TypedField<int> (FOFS(ps.torsoAnim)),
	new TypedField<int> (FOFS(ps.movementDir)),
	new TypedArray<float > (FOFS(ps.grapplePoint), 3),
	new TypedField<int> (FOFS(ps.eFlags)),
	new TypedField<int> (FOFS(ps.eventSequence)),
	new TypedArray<int > (FOFS(ps.events), 2),
	new TypedArray<int > (FOFS(ps.eventParms), 2),
	new TypedField<int> (FOFS(ps.externalEvent)),
	new TypedField<int> (FOFS(ps.externalEventParm)),
	new TypedField<int> (FOFS(ps.externalEventTime)),
	new TypedField<int> (FOFS(ps.weapon)),
	new TypedField<int> (FOFS(ps.weaponstate)),
	new TypedArray<float > (FOFS(ps.viewangles), 3),
	new TypedField<int> (FOFS(ps.viewheight)),
	new TypedField<int> (FOFS(ps.damageEvent)),
	new TypedField<int> (FOFS(ps.damageYaw)),
	new TypedField<int> (FOFS(ps.damagePitch)),
	new TypedField<int> (FOFS(ps.damageCount)),
	new TypedArray<int > (FOFS(ps.stats), 16),
	new TypedArray<int > (FOFS(ps.persistant), 16),
	new TypedArray<int > (FOFS(ps.powerups), 16),
	new TypedArray<int > (FOFS(ps.ammo), 16),
	new TypedField<int> (FOFS(ps.generic1)),
	new TypedField<int> (FOFS(ps.loopSound)),
	new TypedField<int> (FOFS(ps.jumppad_ent)),
	new TypedField<int> (FOFS(ps.pmove_framecount)),
	new TypedField<int> (FOFS(ps.jumppad_frame)),
	new TypedField<int> (FOFS(ps.entityEventSequence)),
	new TypedField<int> (FOFS(pers.connected)),
	new TypedField<int> (FOFS(pers.cmd.serverTime)),
	new TypedArray<int > (FOFS(pers.cmd.angles), 3),
	new TypedField<int> (FOFS(pers.cmd.buttons)),
	new TypedField<char> (FOFS(pers.cmd.weapon)),
	new TypedField<char> (FOFS(pers.cmd.forwardmove)),
	new TypedField<char> (FOFS(pers.cmd.rightmove)),
	new TypedField<char> (FOFS(pers.cmd.upmove)),
	new TypedField<int> (FOFS(pers.localClient)),
	new TypedField<int> (FOFS(pers.initialSpawn)),
	new TypedField<int> (FOFS(pers.predictItemPickup)),
	new TypedField<int> (FOFS(pers.pmoveFixed)),
	new TypedArray<char> (FOFS(pers.netname), 36),
	new TypedField<int> (FOFS(pers.maxHealth)),
	new TypedField<int> (FOFS(pers.enterTime)),
	new TypedField<int> (FOFS(pers.teamState.state)),
	new TypedField<int> (FOFS(pers.teamState.location)),
	new TypedField<int> (FOFS(pers.teamState.captures)),
	new TypedField<int> (FOFS(pers.teamState.basedefense)),
	new TypedField<int> (FOFS(pers.teamState.carrierdefense)),
	new TypedField<int> (FOFS(pers.teamState.flagrecovery)),
	new TypedField<int> (FOFS(pers.teamState.fragcarrier)),
	new TypedField<int> (FOFS(pers.teamState.assists)),
	new TypedField<float> (FOFS(pers.teamState.lasthurtcarrier)),
	new TypedField<float> (FOFS(pers.teamState.lastreturnedflag)),
	new TypedField<float> (FOFS(pers.teamState.flagsince)),
	new TypedField<float> (FOFS(pers.teamState.lastfraggedcarrier)),
	new TypedField<int> (FOFS(pers.voteCount)),
	new TypedField<int> (FOFS(pers.teamVoteCount)),
	new TypedField<int> (FOFS(pers.teamInfo)),
	new TypedField<int> (FOFS(sess.sessionTeam)),
	new TypedField<int> (FOFS(sess.spectatorTime)),
	new TypedField<int> (FOFS(sess.spectatorState)),
	new TypedField<int> (FOFS(sess.spectatorClient)),
	new TypedField<int> (FOFS(sess.wins)),
	new TypedField<int> (FOFS(sess.losses)),
	new TypedField<int> (FOFS(sess.teamLeader)),
	new TypedField<int> (FOFS(readyToExit)),
	new TypedField<int> (FOFS(noclip)),
	new TypedField<int> (FOFS(lastCmdTime)),
	new TypedField<int> (FOFS(buttons)),
	new TypedField<int> (FOFS(oldbuttons)),
	new TypedField<int> (FOFS(latched_buttons)),
	new TypedArray<float > (FOFS(oldOrigin), 3),
	new TypedField<int> (FOFS(damage_armor)),
	new TypedField<int> (FOFS(damage_blood)),
	new TypedField<int> (FOFS(damage_knockback)),
	new TypedArray<float > (FOFS(damage_from), 3),
	new TypedField<int> (FOFS(damage_fromWorld)),
	new TypedField<int> (FOFS(accurateCount)),
	new TypedField<int> (FOFS(accuracy_shots)),
	new TypedField<int> (FOFS(accuracy_hits)),
	new TypedField<int> (FOFS(lastkilled_client)),
	new TypedField<int> (FOFS(lasthurt_client)),
	new TypedField<int> (FOFS(lasthurt_mod)),
	new TypedField<int> (FOFS(respawnTime)),
	new TypedField<int> (FOFS(inactivityTime)),
	new TypedField<int> (FOFS(inactivityWarning)),
	new TypedField<int> (FOFS(rewardTime)),
	new TypedField<int> (FOFS(lastKillTime)),
	new TypedField<int> (FOFS(fireHeld)),
	new TypedField<gentity_t *> (FOFS(hook)),
	new TypedField<int> (FOFS(switchTeamTime)),
	new TypedField<int> (FOFS(timeResidual)),
	new TypedField<char *> (FOFS(areabits)),

};

