#!/usr/bin/perl

use strict;
use IO::File;

my $ThreeDee = 0;

my %files;

sub filename($) {
    my $sub = shift;
    return "/tmp/$$.$sub.data";
}

open(F, "<$ARGV[0]") || die $!;

if ($ThreeDee) {

    my $out = new IO::File(">/tmp/$$.data");

    my $last = -1;
    while (<F>) {
	chomp $_;
	my ($sub, $pub, $cost, $subttls, $pubttls) = split(/\t/, $_);
	if ($last >= 0 && $sub != $last) {
	    print $out "\n";
	}
	if ($sub != $last) {
	    $last = $sub;
	}
	print $out "$sub\t$pub\t$cost\n";
    }
    close(F);
    close($out);

    open(G, "| sh -c gnuplot") || die $!;
    select G;
    $| = 1;
    select STDOUT;
    #print G "set term postscript color\n";
    print G "set pm3d\n";
    print G "set xlabel \"sub prediction\"\n";
    print G "set ylabel \"pub prediction\"\n";
    print G "set zlabel \"packets per second per node\"\n";
    print G "set yrange [0:400]\n";
    print G "set mztics 5\n";
    print G "set title \"$ARGV[0]\"\n";
    print G "splot \"/tmp/$$.data\" title \"pub sub data\" with pm3d\n";
    #close(G);

    sleep(10000);

    unlink "/tmp/$$.data";

} else {

while (<F>) {
    chomp $_;
    my ($sub, $pub, $cost, $subttls, $pubttls) = split(/\t/, $_);
    my $file = filename($sub);
    if (!exists $files{$sub}) {
	$files{$sub} = new IO::File(">$file");
    }
    my $fh = $files{$sub};

    print $fh "$pub\t$cost\n";
}
close(F);

open(G, "| gnuplot") || die $!;
print G "set term postscript\n";
print G "set xlabel \"pub prediction\"\n";
print G "set ylabel \"packets per second per node\"\n";
print G "set grid ytics mytics\n";
print G "set yrange [0:400]\n";
print G "set mytics 5\n";
print G "set title \"$ARGV[0]\"\n";
print G "plot ";

my @subs = sort { $a <=> $b } keys %files;
for (my $i=0; $i<@subs; $i++) {
    my $file = filename($subs[$i]);
    print G ", " if ($i != 0);
    print G "\"$file\" title \"sub prediction = $subs[$i]\" with linespoints";
}
print G "\n";
close(G);

for (my $i=0; $i<@subs; $i++) {
    my $file = filename($subs[$i]);
    unlink $file;
}

}
