#!/usr/bin/perl
#
# Run a bunch of bots on a single server and simulate the publications and
# subscriptions they would make with various prediction parameters.
#
###############################################################################

use strict;

our @NUMBOTS        = ( 32, 64 );

# prediction radius ...
our @SUBPRED        = ( 0, 64, 128, 192, 256, 512, 1024 ); # in units of world
our @PUBPRED        = ( 0, 64, 128, 192, 256, 512, 1024 ); # " "

our $MERC_DIR       = "../Merc";

our $VERBOSITY      = 0;
our $DBG_FILES      = "";
our $MAP            = "big_map4";
our $FRAMELIMIT     = 1500; # 2.5 min

# game options
our $SPAWNTYPE      = 't'; # (d, t, r, i)
our $PLAYERHEALTH   = 999;
our $MONSTERHEALTH  = 100;

our $MONSTERS_PER_BOT = 1;

# libcolyseus.so is in the Merc directory
$ENV{"LD_LIBRARY_PATH"} = ".:../Merc:" . $ENV{"LD_LIBRARY_PATH"};

##############################################################################

close(STDIN);

$SIG{INT} = $SIG{TERM} = sub {
    system("killall xterm 2>/dev/null");
    system("killall -9 quake2 bootstrap 2>/dev/null");
    system("rm -f dglog.*.log explog.*.log");
    system("rm -f /tmp/RunLocalTest.*");
    exit(1);
};

system("killall -9 quake2 bootstrap 2>/dev/null");
sleep(1);

my $common_args = join(" ", @ARGV);

$common_args .= "--pubsubsim --master --verbosity $VERBOSITY -D '$DBG_FILES' --timelimit 10000000000 --nservers 1 --hostname 127.0.0.1 --measurement --spawn_type '$SPAWNTYPE' --bbox-file bbox/$MAP.bbox";
$common_args .= " +set port 40000 +set dedicated 1 +cheats 1 +exec server.cfg +map '$MAP' +set maxclients 1024 +set maxentities 8192";
$common_args .= " +set sv_playerhealth $PLAYERHEALTH +set sv_monsterhealth $MONSTERHEALTH --jeffai --fightmonsters";

sub DoIt($$$) {
    my $numbots = shift;
    my $nummons = $numbots*$MONSTERS_PER_BOT;
    my $subpred = shift;
    my $pubpred = shift;

    my $numbots_total = $numbots+$nummons;

    # need to give some frames for bots to spawn
    my $framelimit = $numbots_total + $FRAMELIMIT;

    my $master_args = "$common_args --framelimit $framelimit --nbots $numbots_total --nmonsters $nummons --pubsubsim-subdist $subpred --pubsubsim-pubdist $pubpred";
    my $master_cmd = "./quake2 $master_args";
    
    print STDERR "$master_cmd\n";
    system($master_cmd);
}

# run each exp with different number of bots/pub/sub pred combos
system("mkdir -p PubSubSimResults") if ! -e "PubSubSimResults";
foreach my $n (@NUMBOTS) {
    system("mkdir -p PubSubSimResults/pubsubsim-$n") if ! -e "PubSubSimResults/pubsubsim-$n";
    foreach my $s (@SUBPRED) {
	foreach my $p (@PUBPRED) {
	    my $dir = "PubSubSimResults/pubsubsim-$n/PubSubSimExp-$n-$s-$p";
	    system("rm -f *.log");
	    system("mkdir -p $dir");
	    DoIt($n, $s, $p);
	    system("gzip PubSubCostsLog.*.log");
	    system("gzip PubSubLifetimeLog.*.log");
	    system("mv -f PubSubCostsLog.*.log.gz PubSubLifetimeLog.*.log.gz $dir/");
	}
    }
}

print STDERR " ========= DONE! ==========\n";
