#!/usr/bin/perl
#
# Calculate the "optimal" costs for a series of prediction trials
#

use strict;

if (@ARGV < 1) {
    print STDERR "usage: PubSubCalcOptimalCosts.pl <nservers>\n";
    exit 1;
}

our $NSERVERS     = shift @ARGV;
our $TOPDIR       = "$ENV{HOME}/nsdi05-data/pubsubsim/pubsubsim-$NSERVERS";
our $COST_OPTIONS = join(" ", @ARGV) || "";

our $LIFELOG = "PubSubLifetimeLog.127.0.0.1:12000.log.gz";
our $COSTLOG = "PubSubCostsLog.127.0.0.1:12000.log.gz";

our $TTL_SEARCH_RAD  = 100;
our $TTL_SEARCH_STEP = 20;

our $LOG_SAMPLE_SIZE = 300; # in frames

opendir(D, "$TOPDIR") || die "can't open $TOPDIR";
my @dirs = sort { num($a) <=> num($b) } readdir(D);
close(D);

sub num($)
{
    my $n = shift;

    if ($n =~ /(\d+)-(\d+)-(\d+)/) {
	return $1*2**20 + $2*2**10 + $3;
    }
    return 0;
}


#print STDERR "TODO: " . join("\n", @dirs). "\n";

foreach my $f (@dirs) {
    if ($f =~ /PubSubSimExp-(\d+)-(\d+)-(\d+)/) {
        print STDERR "doing: $f...\n";
	my ($players, $sub, $pub) = ($1, $2, $3);
	my ($pubttl, $subttl);
	$pubttl = {};
	$subttl = {};

	foreach my $t ('p', 'o', 'm') {
	    #print "./PubSubSimComputeLifetime.pl -t $t $TOPDIR/$f/$LIFELOG\n";
	    
	    my $out = `./PubSubSimComputeLifetime.pl -t $t $TOPDIR/$f/$LIFELOG`;
	    chomp $out;
	    ($pubttl->{$t}, $subttl->{$t}) = split(/\s+/, $out);
	    
	    if (!defined $pubttl->{$t} || !defined $subttl->{$t}) {
		print STDERR "$players-$pub-$sub: bad lifetime output: $out\n";
		$pubttl->{$t} = 1;
		$subttl->{$t} = 1;
		# assign defaults to 1 since this means the type doesn't
		# show up in the log...
	    }
	}

	my $val;
	($val, $pubttl, $subttl) = 
	    CalcOptimal("$TOPDIR/$f/$COSTLOG", $pubttl, $subttl);
	if (!defined $val) {
	    print "$sub\t$pub\tERROR\n";
	    next;
	}
	
	# sub_predict pub_predict opt_cost opt_sub_ttl opt_pub_ttl
	print "$sub\t$pub\t$val\t$subttl->{p},$subttl->{o},$subttl->{m}\t$pubttl->{p},$subttl->{o},$pubttl->{m}\n";
    }
}

sub CalcOptimal($$$) {
    my ($log, $pubttl, $subttl) = @_;

    my $best_val = 9999999999;

#    my $min_pubttl = max($pubttl - $TTL_SEARCH_RAD, 1);
#    my $max_pubttl = $pubttl + $TTL_SEARCH_RAD;

#    my $min_subttl = max($subttl - $TTL_SEARCH_RAD, 1);
#    my $max_subttl = $subttl + $TTL_SEARCH_RAD;

#    for (my $p = $min_pubttl; $p <= $max_pubttl; $p += $TTL_SEARCH_STEP) {
	# find the best ttls by iterating over some possibilities
	# and looking at a small sample of the log
#	for (my $s = $min_subttl; $s <= $max_subttl; $s += $TTL_SEARCH_STEP) {
	    #print "./PubSubSimComputeCost.pl -T -p $p -u $s -l $LOG_SAMPLE_SIZE $COST_OPTIONS $log\n";
#	    my $val = `./PubSubSimComputeCost.pl -T -n $NSERVERS -p $p -u $s -l $LOG_SAMPLE_SIZE $COST_OPTIONS $log`;
#	    chomp $val;
#	    if (!defined $val) {
#		print STDERR "$log: bad cost output: $val\n"; 
#		return undef;
#	    }
#	    if ($val < $best_val) {
#		$best_val = $val;
#		$pubttl = $p;
#		$subttl = $s;
#	    }
#	}
#    }
    # now run it on the full log

    my $pubstr = join(",", map { "$_=$pubttl->{$_}" } keys %$pubttl);
    my $substr = join(",", map { "$_=$subttl->{$_}" } keys %$subttl);
    
    $best_val = `./PubSubSimComputeCost.pl -T -n $NSERVERS -p $pubstr -u $substr $COST_OPTIONS $log`;
    chomp $best_val;
    if (!defined $best_val) {
	print STDERR "$log: bad cost output: $best_val\n"; 
	return undef;
    }

    return ($best_val, $pubttl, $subttl);
}

###############################################################################

sub min($$)
{
    $_[0] < $_[1] ? $_[0] : $_[1];
}

sub max($$)
{
    $_[0] > $_[1] ? $_[0] : $_[1];
}
