#!/usr/bin/perl
#
# Process the logs generated by ObjectInterestExp.pl.
#
# -f number of frames to predict into the future
#
###############################################################################

use strict;
#use Statistics::Descriptive;
use IO::File;
#use Getopt::Std;
#use vars qw($opt_f);

#getopts("f:");

our @NUMBOTS   = ( 16, 32, 64, 128, 256 ); #( 8, 16, 32, 64, 128, 256, 512 );
our @LOOKAHEAD = ( 0, 5, 10, 50, 100, 300, 600 );

# directory containing the "ObjectInterestExp-*" subdirectories
our $TOPDIR  = "$ENV{HOME}/nsdi05-data/interests-19092004";
# name of each log
our $LOGNAME = "ObjectInterestLog.127.0.0.1:12000.log";

# name of preloaded item log
our $INITLOG = "$TOPDIR/ObjectInterestLog.ItemPositions.log";

# normalization factors
our $DISTNORM = 4032*2; # normalize distance by this ("diameter of map")
our @RANGES   = ( 4032*2, 4032*2, 3776-2816 ); # normalize [x,y,z] ranges

foreach my $f (@LOOKAHEAD) {
    foreach my $n (@NUMBOTS) {
	print STDERR ">>> $f,$n\n";
	DoIt($f, $n);
	close_all();
    }
}

##############################################################################

sub SaveInStore($$$$$$$$)
{
    my ($store, $frameno, $guid, $type, $pos, $min, $max, $lookahead) = @_;

    ## Assume that we see one entry per object per frame
    if (!defined $store->{$guid}) {
	$store->{$guid} = { 'type' => $type,
			    'pos'  => [],
			    'min'  => [], 
			    'max'  => [] };
    }
    $store->{$guid}->{lastframe} = $frameno;
    push @{$store->{$guid}->{pos}}, vector($pos);
    push @{$store->{$guid}->{min}}, vector($min);
    push @{$store->{$guid}->{max}}, vector($max);
    
    if (scalar @{$store->{$guid}->{pos}} > $lookahead+1) {
	shift @{$store->{$guid}->{pos}};
    }
    if (scalar @{$store->{$guid}->{min}} > $lookahead+1) {
	shift @{$store->{$guid}->{min}};
    }
    if (scalar @{$store->{$guid}->{max}} > $lookahead+1) {
	shift @{$store->{$guid}->{max}};
    }
}

sub CleanupStore($$$)
{
    my $store = shift;
    my $frameno = shift;
    my $lookahead = shift;
    foreach my $guid (keys %$store) {
	# last update too old, no longer relevant
	if ($store->{$guid}->{lastframe} + $lookahead < $frameno) {
	    delete $store->{$guid};
	}
    }
}

sub DoIt($) {
    my ($l, $n) = @_;
    my $log = "$TOPDIR/ObjectInterestExp-$n/$LOGNAME";

    # stats for interests of type->type
#    my %instats = ( '0-0' => new Statistics::Descriptive::Full(),
#		    '0-1' => new Statistics::Descriptive::Full(),
#		    '0-2' => new Statistics::Descriptive::Full(),
#		    
#		    '1-0' => new Statistics::Descriptive::Full(),
#		    '1-1' => new Statistics::Descriptive::Full(),
#		    '1-2' => new Statistics::Descriptive::Full() );

#    my $pos_dist = new Statistics::Descriptive::Full();
#    my $pub_size = [ new Statistics::Descriptive::Full(),
#		     new Statistics::Descriptive::Full(),
#		     new Statistics::Descriptive::Full() ];
#    my $sub_size = [ new Statistics::Descriptive::Full(),
#		     new Statistics::Descriptive::Full(),
#		     new Statistics::Descriptive::Full() ];

#    my %item_pos;

    # each hash element is: guid => { 
    #      'type'   => type,
    #      'lastframe' => last_frameno
    #      'pos'    => \( [x,y,z], ... )
    #      'min'    => \( [x,y,z], ... )
    #      'max'    => \( [x,y,z], ... )
    # }
    my %pos = ();

    # preload the static item data
#    open(LOG, "<$INITLOG") || die "can't open $INITLOG: $!";
#    while (<LOG>) {
#	chomp $_;
#	my ($frame, $guid, $type, $pos, $min, $max) = split(/\t/, $_);
#
#	SaveInStore(\%item_pos, $frame, $guid, $type, $pos, $min, $max, $l);
#    }
#    close(LOG);

    my $frameno = -1;

    # now process the log
    open(LOG, "<$log") || die "can't open $log: $!";
    while (<LOG>) {
	chomp $_;
	my ($frame, $guid, $type, $pos, $min, $max) = split(/\t/, $_);

	if ($frameno < $frame) {
	    $frameno = $frame;
	    CleanupStore(\%pos, $frameno, $l);
	}

	SaveInStore(\%pos, $frame, $guid, $type, $pos, $min, $max, $l);

	# if we have enough prediction info for this dude, analyze him
	if (scalar @{$pos{$guid}->{max}} >= $l+1) {
	    Analyze($l, $n, $type, $pos{$guid}); 
		    #$pos_dist, $pub_size, $sub_size);
	}
    }
    close(LOG);

#    # distance traveled
#    print "\tpos\t" . 
#	pr($pos_dist->mean()) . "\t" . 
#	pr($pos_dist->standard_deviation()) . "\t" . 
#	pr($pos_dist->median()) . "\n";
#
#    # expanded pub
#    print "\tpub_x\t" . 
#	pr($pub_size->[0]->mean()) . "\t" . 
#	pr($pub_size->[0]->standard_deviation()) . "\t" . 
#	pr($pub_size->[0]->median()) . "\n";
#    print "\tpub_y\t" . 
#	pr($pub_size->[1]->mean()) . "\t" . 
#	pr($pub_size->[1]->standard_deviation()) . "\t" . 
#	pr($pub_size->[1]->median()) . "\n";
#    print "\tpub_z\t" . 
#	pr($pub_size->[2]->mean()) . "\t" . 
#	pr($pub_size->[2]->standard_deviation()) . "\t" . 
#	pr($pub_size->[2]->median()) . "\n";

#    # expanded bbox
#    print "\tsub_x\t" . 
#	pr($sub_size->[0]->mean()) . "\t" . 
#	pr($sub_size->[0]->standard_deviation()) . "\t" . 
#	pr($sub_size->[0]->median()) . "\n";
#    print "\tsub_y\t" . 
#	pr($sub_size->[1]->mean()) . "\t" . 
#	pr($sub_size->[1]->standard_deviation()) . "\t" . 
#	pr($sub_size->[1]->median()) . "\n";
#    print "\tsub_z\t" . 
#	pr($sub_size->[2]->mean()) . "\t" . 
#	pr($sub_size->[2]->standard_deviation()) . "\t" . 
#	pr($sub_size->[2]->median()) . "\n";
}

sub pr {
    return sprintf "%.5f", $_[0];
}

sub Analyze($$$$)
{
    my($lookahead, $nbots, $type, $pos) = @_;
    # $pos_dist, $pub_size, $sub_size

    my @pos = @{$pos->{pos}->[0]};
    my @pos_min = @pos;
    my @pos_max = @pos;

    my @min = @{$pos->{min}->[0]};
    my @max = @{$pos->{max}->[0]};

    my $farthest_dist = 0;
    for (my $i=1; $i<scalar @{$pos->{pos}}; $i++) {
	my $dist = dist(\@pos, $pos->{pos}->[$i]);
	$farthest_dist = max($farthest_dist, $dist);
	
	for (my $j = 0; $j < 3; $j++) {
	    $pos_min[$j] = min($pos_min[$j], $pos->{pos}->[$i]->[$j]);
	    $pos_max[$j] = max($pos_max[$j], $pos->{pos}->[$i]->[$j]);

	    $min[$j] = min($min[$j], $pos->{min}->[$i]->[$j]);
	    $max[$j] = max($max[$j], $pos->{max}->[$i]->[$j]);
	}
    }
    
    my $file;

    $file = get_file($lookahead, $nbots, $type, "pos_dist");
    print $file (pr($farthest_dist/$DISTNORM) . "\n");

#    $pos_dist->add_data( $farthest_dist/$DISTNORM );

    for (my $j = 0; $j < 3; $j++) {
	my $val;
	if    ($j == 0) { $val = "x" }
	elsif ($j == 1) { $val = "y" }
	elsif ($j == 2) { $val = "z" }
	else { die "bad val: $j" }

	$file = get_file($lookahead, $nbots, $type, "pub_size_$val");
	print $file (pr(($pos_max[$j] - $pos_min[$j])/$RANGES[$j]) . "\n");

	$file = get_file($lookahead, $nbots, $type, "sub_size_$val");
	print $file (pr(($max[$j] - $min[$j])/$RANGES[$j]) . "\n");

#	$pub_size->[$j]->add_data( ($pos_max[$j] - $pos_min[$j])/$RANGES[$j] );
#	$sub_size->[$j]->add_data( ($max[$j] - $min[$j])/$RANGES[$j] );
    }
}

sub vector($) {
    my $str = shift;
    return [ split(/,/, $str) ];
}

sub dist($$)
{
    my($a, $b) = @_;
    my @sq;
    for (my $i=0; $i<3; $i++) {
	$sq[$i] = $a->[$i] - $b->[$i];
	$sq[$i] *= $sq[$i];
    }

    return sqrt($sq[0] + $sq[1] + $sq[2]);
}

sub min($$)
{
    $_[0] < $_[1] ? $_[0] : $_[1];
}

sub max($$)
{
    $_[0] > $_[1] ? $_[0] : $_[1];
}

###############################################################################

our %file_hash;

sub get_file($$$$)
{
    my ($lookahead, $nbots, $type, $name) = @_;

    my $ttype;
    if    ($type == 0) { $ttype = 'missile'; }
    elsif ($type == 1) { $ttype = 'player';  }
    else { die "bad type $type"; }

    my $fname = "$lookahead-$nbots-$name-$ttype.data";

    if (!exists $file_hash{$fname}) {
	$file_hash{$fname} = new IO::File(">$fname");
	die "can't open file '$fname'!" if ! $file_hash{$fname};
    }

    return $file_hash{$fname};
}

sub close_all() {
    foreach my $k (keys %file_hash) {
	close($file_hash{$k});
    }
}
