#!/usr/bin/perl
#
# Run a bunch of bots on a single server and measure their positions and
# subscriptions over time. The logs will be saved in the working directory
# as: ObjectInterestExp-$x where $x is the number of bots the experiment was
# run with.
#
###############################################################################

use strict;

our @NUMBOTS        = ( 8, 16, 32, 64, 128, 256, 512, 1024 );

our $MERC_DIR       = "../Merc";

our $VERBOSITY      = 0;
our $DBG_FILES      = "";
our $MAP            = "big_map4";
our $FRAMELIMIT     = 3000; # 5 min

# libcolyseus.so is in the Merc directory
$ENV{"LD_LIBRARY_PATH"} = ".:../Merc:" . $ENV{"LD_LIBRARY_PATH"};

##############################################################################

close(STDIN);

$SIG{INT} = $SIG{TERM} = sub {
    system("killall xterm 2>/dev/null");
    system("killall -9 quake2 bootstrap 2>/dev/null");
    system("rm -f dglog.*.log explog.*.log");
    system("rm -f /tmp/RunLocalTest.*");
    exit(1);
};

system("killall -9 quake2 bootstrap 2>/dev/null");
sleep(1);

my $common_args = join(" ", @ARGV);

$common_args .= "--disable-colyseus --verbosity $VERBOSITY -D '$DBG_FILES' --timelimit 100000000 --nservers 1 --hostname 127.0.0.1 --measurement --spawn_type r --bbox-file bbox/$MAP.bbox"; 
$common_args .= " +set dedicated 1 +cheats 1 +exec server.cfg +map $MAP";

sub DoIt($) {
    my $numbots = shift;
    # need to give some frames for bots to spawn
    my $framelimit = $numbots*5 + $FRAMELIMIT;

    my $master_args = "$common_args --master --framelimit $framelimit +set port 40000";
    if ($numbots > 0) {
	$master_args .= " --nbots $numbots ";
    } else {
	$master_args .= " --dump-initial ";
    }

    my $master_cmd = "./quake2 $master_args";
    
    print STDERR "$master_cmd\n";
    system($master_cmd);
}

# dump the initial objects
DoIt(0);

# run each exp with different number of bots
foreach my $n (@NUMBOTS) {
    my $dir = "ObjectInterestExp-$n";
    system("rm -f *.log");
    system("mkdir -p $dir");
    DoIt($n);
    system("mv -f *.log $dir/");
}

print STDERR " ========= DONE! ==========\n";
