#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned int uint32;
typedef float vec3_t[3];

int main(int argc, char **argv)
{
    /*
    if (argc != 2) {
	fprintf(stderr, "usage: BBoxMapParser <bbox_map>\n");
	exit(1);
    }
    */

    FILE *fp;

    if (argc >= 2) {
	fp = fopen(argv[1], "r");
	if (!fp) {
	    fprintf(stderr, "can't open file\n");
	    exit(1);
	}
    } else {
	fp = stdin;
    }

    while (1) {
	int ret;

#define READ(ptr, sz, num, fp) { \
     ret = fread(ptr, sz, num, fp); \
     if (ret <= 0) goto END; \
}

	int frameno;
	uint32 objid;
	uint32 ownerid;
	char type, cls, op;
	vec3_t min, max;
	int lifetime;
	uint32 match_objid;
	char match_type;

	READ((void *)&frameno, sizeof(int), 1, fp);
	READ((void *)&objid, sizeof(int), 1, fp);
	READ((void *)&ownerid, sizeof(int), 1, fp);
	READ((void *)&type, sizeof(char), 1, fp);
	READ((void *)&cls, sizeof(char), 1, fp);
	READ((void *)&op, sizeof(char), 1, fp);
	READ((void *)&min, sizeof(vec3_t), 1, fp);
	READ((void *)&max, sizeof(vec3_t), 1, fp);
	if (op == 'u' || op == 'm') {
	    READ((void *)&lifetime, sizeof(int), 1, fp);
	}
	if (op == 'm') {
	    READ((void *)&match_objid, sizeof(int), 1, fp);
	    READ((void *)&match_type, sizeof(char), 1, fp);
	}

	fprintf(stdout, "%d\t%u\t%u\t%c\t%c\t%c\t%.5f,%.5f,%.5f\t%.5f,%.5f,%.5f",
		frameno, objid, ownerid, type, cls, op,
		min[0], min[1], min[2], max[0], max[1], max[2]);
	if (op == 'u' || op == 'm')
	    fprintf(stdout, "\t%d", lifetime);
	if (op == 'm')
	    fprintf(stdout, "\t%d\t%c", match_objid, match_type);
	fprintf(stdout, "\n");
    }
    
 END:
    return 0;
}
    
