#!/usr/bin/perl
#
# Precompute the bounding boxes for a particular map
#

use strict;
use lib "scripts";
# require "inc.pl";

our %MAPS = (
	     'all'      => [ "-4096,-4096,-4096", "4096,4096,4096" ],
	     'big_map'  => [ "-4032,-4032,128",   "4032,4032,320"  ],
	     'big_map4' => [ "-4032,-4032,-3808", "4032,4032,-2784"  ],
	     'rooms'    => [ "-1344,-192,-128",   "768,640,128"    ],
	     'base64'   => [ "-3328,-2176,-1088", "4032,3648,576"  ],
	     );

our $MAP    = $ARGV[0];
if (!exists $MAPS{$MAP}) {
    print STDERR "unknown map: '$MAP'\n";
    exit 1;
}
our $MIN    = $MAPS{$MAP}->[0];
our $MAX    = $MAPS{$MAP}->[1];
our $STEP   = "32";
our $XYSTEP = "5";
our $ZSTEP  = "5";

psystem("./quake2 -v 0 --master --nservers 1 " .
	"--bbox --bbox-file '$MAP.bbox' --bbox-min '$MIN' --bbox-max '$MAX' " .
	"--bbox-unit '$STEP' --bbox-xystep '$XYSTEP' --bbox-zstep '$ZSTEP' " .
	"+set dedicated 1 +map $MAP");

sub psystem { 
    my $cmd = shift;
    print STDERR "$cmd\n";
    return system ($cmd);
}
