#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/Colyseus/run";
use lib "$ENV{HOME}/Colyseus/run/planetlab";
use PlanetLabConf;
use Getopt::Std;
use vars qw($opt_e $opt_l);

getopts ("e:l:");

our $MERC_HOME  = "$ENV{HOME}/Colyseus";
our $EXP_FILE   = defined $opt_e ? $opt_e : "$MERC_HOME/run/plab.exp";
our $LOC_FILE   = defined $opt_l ? $opt_l : "$MERC_HOME/run/planetlab/locmap.txt";
our $PASSWORD   = $TERMPASS;
our $MAXPLAYERS = 4;
our $PORT       = $MERCPORT+10000;

###############################################################################

sub mdie;

my $fs = "font-family: verdana, arial, helvetica; font-size: 75\%";
my $th = "td style=\"font-weight: bold; background-color: \#AAAAAA\"";
my $td = "td style=\"background-color: \#CCCCCC\"";

my %loc;
open(L, "<$LOC_FILE") || warn "can't open $LOC_FILE";
while (<L>) {
    chomp;
    s/\#.*//;
    if (/^([^ \t]+)\s+([^ \t]+)/) {
	$loc{$1} = $2;
    }
}
close(L);

mdie "no exp file: $EXP_FILE" if ! -f $EXP_FILE;
$ENV{PERL5LIB} .= ":$MERC_HOME/run:$MERC_HOME/run/lib";
our $TermExec = "$MERC_HOME/run/TermExec.pl";

my $cmd = "$TermExec -b $PORT -o " . (defined $PASSWORD ? " -p $PASSWORD " : "") .
    " $EXP_FILE GE P P";
my $out = `$cmd`;

my @lines = split(/\n/, $out);

my @players;
my @all;
my @server;

my $curr = undef;
foreach my $line (@lines) {
    if ($line =~ /^[\w\d_-]+\@([\w\d_\-\.]+):([\w\d_\-\.]+)/) {
	my ($host, $iface) = ($1, $2);
	$curr = [ $host, 1, 0, 0 ];
	push @server, $curr; 
    }
    if ($line =~ /edict:.* class=(\w+) .*name=([^\t ]+) .*score=([-\d]+)/) {
	my ($class, $name, $score) = ($1, $2, $3);

	mdie "bad format: $out" if !$curr;

	$curr->[2]++;
	$curr->[3]++ if $class ne 'player';

	my @p = ( $name, $score, $class ne 'player' );
	push @players, \@p if ($class eq 'player');
	push @all, \@p;
    } elsif ($line =~ /NO RESPONSE/) {
	mdie "bad format: $out" if !$curr;

	$curr->[1] = 0; # dead
    }
}

mdie "no servers! $out" if @server == 0;

print "<html><head><meta http-equiv=\"refresh\" content=\"300\"/></head><body>\n";
print "<div style=\"width: 350px; float: left;\">\n";
print "<p style=\"$fs;\" align=\"center\"><strong>Server List</strong></p>\n";
print "<table style=\"$fs; width: 350px;\" align=\"center\" border=0><tr><$th>Server Address</td><$th>State</td><$th>Online</td><$th>Players/Max (Bots)</td></tr>\n";

foreach my $s (sort { $loc{$a->[0]} cmp $loc{$b->[0]} } @server) {
    my $name;
    my $online;
    if ($s->[1]) {
	$online = "yes";
	$name = $s->[0];
    } else {
	$online = "no";
	$name = "<span style=\"color: red\">$s->[0]</span>\n";
    }
    my $loc = $loc{$s->[0]} || "??";

    print STDERR "$s->[0]\t$online\n";
    print "<tr><$td>$name</td><$td>$loc</td><$td>$online</td><$td>$s->[2]/$MAXPLAYERS ($s->[3])</td></tr>\n";
}
print "</table>\n";
print "</div>\n";

@players = sort { $b->[1] <=> $a->[1] } @players;
@all = sort { $b->[1] <=> $a->[1] } @all;

$th = "td style=\"font-weight: bold; color: white; background-color: #5555DD\"";
$td = "td style=\"background-color: #55DD55\"";

print "<div style=\"width: 250px; float: right;\">\n";
print "<p style=\"$fs;\" align=\"center\"><strong>Leaderboard</strong></p>\n";
print "<table style=\"$fs; width: 250px;\" align=\"center\" border=0><tr><$th>Rank</td><$th>Player</td><$th>Score</td></tr>\n";
my $i = 0;
foreach my $p (@all) {
    last if $i++ >= 10;
    print "<tr><$td>$i</td><$td>$p->[0]" . ($p->[2]?" (Bot)":"") . "</td><$td>$p->[1]</td></tr>\n";
}
print "</table>\n";
print "</div>\n";
print "</body></html>\n";

sub mdie {
	my @err = @_;

	print "<html><head><meta http-equiv=\"refresh\" content=\"300\"/></head><body>\n";
	print "<p style=\"$fs; font-size: 110%; color: red;\" align=\"center\">Currently Offline. <a href=\"mailto:jeffpang+colyseus-demo-status\@cs.cmu.edu\">Contact us</a> for a status update.</p>\n";
	print "</body></html>\n";

	die @_;
}
