#!/usr/bin/perl
#
# This script parses the output of quake2 when RECORD_FIELD_DELTA_INFO is
# enabled in dg_main.c. It produces a set of disjoint "clusters" of fields
# which always change together, as well as the relative frequency that
# each cluster changes (as a count). This output can be fed into
# MakeClusterTables.pl to generate the delta encoding tables.

use strict;

our $CLUSTER_ID = 0;
# $ID => [ { fields => 1 }, $count, $ID ]
our %clusters;

while (<>) {
    chomp $_;
    if ($_ =~ /^\[\*\] (NEW|CHG)\s+([\w_]+)\s+(0|1)\s+(.*)/) {
	my $type    = $1;
	my $class   = $2;
	my $replica = $3;
	my @fields  = split(/,/, $4);

	split_clusters(@fields);
    } else {
	next;
    }
}

foreach my $id (keys %clusters) {
    my $cl = $clusters{$id};
    my @fields = keys %{$cl->[0]};
    my $cnt = $cl->[1];
    
    print "$cnt\t" . join(",",@fields) . "\n";
}

exit 0;

sub split_clusters(@)
{
    my %cluster = map { $_ => 1 } @_;
    my %seen;
    my @group;

    foreach my $field (keys %cluster) {
	foreach my $id (keys %clusters) {
	    my $cl = $clusters{$id};
	    if ($cl->[0]->{$field} && !$seen{$cl->[2]}) {
		push @group, $cl;
		$seen{$cl->[2]} = 1;
	    }
	}
    }

    foreach my $cl (@group) {
	if (cluster_eq($cl->[0], \%cluster)) {
	    $cl->[1]++;
	    return;
	}
    }

    my @new_groups;

    if (scalar @group == 0) {
	push @new_groups, [\%cluster, 1, $CLUSTER_ID++];
    } else {
	foreach my $cl (@group) {
	    my %intersection;
	    my %difference;
	    foreach my $field (keys %{$cl->[0]}) {
		if ($cluster{$field}) {
		    $intersection{$field} = 1;
		    delete $cluster{$field}; # no duplication by construction
		} else {
		    $difference{$field} = 1;
		}
	    }
	
	    push @new_groups, [\%intersection, $cl->[1]+1, $CLUSTER_ID++];
	    if (scalar keys %difference > 0) {
		push @new_groups, [\%difference, $cl->[1], $CLUSTER_ID++];
	    }
	    delete $clusters{$cl->[2]};
	    #print "RMVING: " . join(",", keys %{$cl->[0]}) . "\n";
	}

	if (scalar keys %cluster > 0) {
	    push @new_groups, [\%cluster, 1, $CLUSTER_ID++];
	}
    }

    foreach my $grp (@new_groups) {
	#print "ADDING: " . join(",", keys %{$grp->[0]}) . "\n";
	$clusters{$grp->[2]} = $grp;
    }
}

sub cluster_eq($$)
{
    my $a = shift;
    my $b = shift;

    if (scalar(keys %$a) != scalar(keys %$b)) {
	return 0;
    }

    foreach my $k (keys %$a) {
	if (! $b->{$k}) {
	    return 0;
	}
    }

    return 1;
}
