#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAGIC_STRING "q2_bbox_map"
#define MAGIC_STRING2 "q3_bbox_map"

typedef float vec3_t[3];

static float BBoxVolume(vec3_t min, vec3_t max)
{
    return (max[0] - min[0])*(max[1] - min[1])*(max[2] - min[2]);
}

int main(int argc, char **argv)
{
    if (argc != 2) {
	fprintf(stderr, "usage: BBoxMapParser <bbox_map>\n");
	exit(1);
    }

    FILE *fp = fopen(argv[1], "r");
    if (!fp) {
	fprintf(stderr, "can't open file\n");
	exit(1);
    }

    char  *junk = (char *)malloc(strlen(MAGIC_STRING) + 1);
    vec3_t min;
    int xbuckets;
    int ybuckets;
    int zbuckets;
    float step;

    fread((void *)junk, strlen(MAGIC_STRING), 1, fp); // magic
    junk[strlen(MAGIC_STRING)] = '\0';
    if (strcmp(junk, MAGIC_STRING) && strcmp(junk, MAGIC_STRING2)) {
	fprintf(stderr, "file doesn't begin with magic string: " 
		MAGIC_STRING "\n");
	exit(1);
    }

    fread((void *)min, sizeof(vec3_t), 1, fp);    // starting point
    fread((void *)&xbuckets, sizeof(int), 1, fp); // number of x points
    fread((void *)&ybuckets, sizeof(int), 1, fp); // number of y points
    fread((void *)&zbuckets, sizeof(int), 1, fp); // number of z points
    fread((void *)&step, sizeof(float), 1, fp);   // size of step between pts

    vec3_t max;
    max[0] = min[0] + xbuckets*step;
    max[1] = min[1] + ybuckets*step;
    max[2] = min[2] + zbuckets*step;
    float total_vol = BBoxVolume(min, max);
    vec3_t orig, bmin, bmax;
    int x_index, y_index, z_index;

    for (x_index = 0; x_index < xbuckets; x_index++) {
	orig[0] = min[0] + step*x_index;
	
	for (y_index = 0; y_index < ybuckets; y_index++) {
	    orig[1] = min[1] + step*y_index;
	    
	    for (z_index = 0; z_index < zbuckets; z_index++) {
		orig[2] = min[2] + step*z_index;
		int ret;

		ret = fread((void *)bmin, sizeof(vec3_t), 1, fp); // bbox min
		if (ret == 0) {
		    printf("EOF encountered!\n");
		    goto END;
		}
		ret = fread((void *)bmax, sizeof(vec3_t), 1, fp); // bbox max
		if (ret == 0) {
		    printf("EOF encountered!\n");
		    goto END;
		}

		float vol = BBoxVolume(bmin, bmax);
		
		printf("%8.3f,%8.3f,%8.3f\t%8.3f,%8.3f,%8.3f\t%8.3f,%8.3f,%8.3f\t%7.5f\n",
		       orig[0], orig[1], orig[2],
		       bmin[0], bmin[1], bmin[2],
		       bmax[0], bmax[1], bmax[2],
		       vol/total_vol);
	    }
	}
    }
    
 END:
    return 0;
}
    
