#!/usr/bin/perl
#
# Run viz.py on the nodes in an *.exp file generated by Run.pl
#
# Options:
#
# -P     print the required command line.

use strict;
use lib "../scripts";
use Travertine;
use Getopt::Std;
use vars qw($opt_P $opt_r);

getopts("Pr:");

if (@ARGV < 1) {
    print STDERR "usage: expviz.py [options] <exp_file>\n\n";
    print STDERR "       -P        print the command line required only\n";
    exit(1);
}

our $INPUT;

if ($ARGV[0] ne '-') {
    $INPUT = new IO::File("<$ARGV[0]");
    tdie "can't open $ARGV[0]: $!" if !$INPUT;
}

our @ids;

while (<$INPUT>) {
    chomp $_;
    my ($login, $title, $ser) = ($_ =~ /^([^\t]+)\t'([^\t]+)'\t([^\t]+)$/);
    tdie "bad line: $_" if !defined $login or !defined $title or !$ser;

    my ($user, $host, $iface) = ($login =~ /(.*)\@(.*):(.*)/);
    my $port;
    if ($title =~ /bootstrap/) {
	next;
    } elsif ($title =~ /master/) {
	$port = 30000;
    } elsif ($title =~ /.*:(\d+)/) {
	$port = 30000 + $1;
    } else {
	tdie "bad title: $title";
    }

    push @ids, "$iface:$port";
}

my $cmd = "./viz.py " . ($opt_r ? " -r $opt_r " : "") . join(" ", @ids) . "\n";
if ($opt_P) {
    print $cmd;
} else {
    psystem($cmd);
}
