/*
 * ServerSession.java
 * Author: Jeffrey Pang <ee122-at>
 *
 * CVS: $Id: Session.java 982 2004-07-02 00:23:31Z jeffpang $
 */

import java.net.*;

/**
 * Base class for server and client sessions. Provides default functionality.
 */
abstract class Session {

    /**
     * The socketed this session has open with the peer should be assigned to
     * this variable.
     */
    protected Socket socket;

    /**
     * Get the hostname of the remote peer.
     */
    public String getHostname() {
	try {
	    return socket.getInetAddress().getHostName();
	} catch (Exception ex) {
	    return null;
	}
    }

    /**
     * Get the port number of the remote peer.
     */
    public int getPort() {
	return socket.getPort();
    }

    /**
     * Get the number of milliseconds a read on the session blocks until
     * a timeout.
     */
    public int getTimeout() throws SocketException {
	return socket.getSoTimeout();
    }

    /**
     * Set the number of milliseconds a read on the session blocks until
     * a timeout.
     */
    public void setTimeout(int timeout) throws SocketException {
	socket.setSoTimeout(timeout);
    }

    /**
     * Extract the exception message from the exception ex.
     */
    public static String getErrorMessage(Exception ex) {
	String exmsg = ex.toString();
	return exmsg.substring(Math.min(exmsg.indexOf(" ")+1, exmsg.length()-1));
    }

}
