/*
 * ClientSession.java
 * Author: Jeffrey Pang <ee122-at>
 *
 * CVS: $Id: ClientSession.java 982 2004-07-02 00:23:31Z jeffpang $
 */

import java.io.*;
import java.net.*;

/**
 * Encapsulates a session or connection between the client and a server.
 * This session closes off the beginning and end of transactions which
 * they wish to do with each other (between connect and &lt;QUIT&gt;).
 */
public class ClientSession extends Session {

    public PrintStream prt;         // printstream of out
    public OutputStream out;        // output stream of socket
    public InputStream in;          // input stream of socket

    /**
     * Construct a new client session with a specific destination server.
     *
     * @param dest the destination of where packets sent through this
     * session will go.
     * @param mngr the manager this session was created from
     * @param debug if true, spit out everything that we read on System.err
     */
    public ClientSession(Peer dest, boolean debug) 
	throws UnknownHostException, SocketException, IOException
    {
	try {
	    socket = new Socket(dest.getHostname(), dest.getPort());
	    socket.setSoTimeout(30000);
	    out = socket.getOutputStream();
	    in = socket.getInputStream();
	    if (debug) {
		out = new CaltellaUtil.DebugOutputStream(out);
		in = new CaltellaUtil.DebugInputStream(in);
	    }

	    prt = new PrintStream(out);

	    /*
	    // Check for valid welcome message
	    String resp = CaltellaUtil.readLine(in);
	    if (!resp.startsWith("+OK")) {
	    in.close();
	    out.close();
	    socket.close();
	    throw new NetworkException("Connection response did not begin with " +
	    "'+OK' so closing it. '" + resp + "'");
	    }
	    */

	} catch (NumberFormatException ex) {
	    // should not happen
	    CaltellaUtil.die("ERROR");
	}
    }
    
    /**
     * Close the connection associated with this connection.
     */
    public void close() {
	try {
	    prt.print("QUIT\n");
	    in.close();
	    out.close();
	    socket.close();
	} catch (Exception ex) {
	    // closed, don't matter
	}
    
    }

}
