#!/usr/bin/perl

$in_file = shift;
$macro_prefix = shift;

(defined $in_file and defined $macro_prefix) or die;

chomp (@ed_fields = `cat $in_file`);
foreach (@ed_fields) {
    next if (/^\s*$/);
    s/^\s+//;
    s/\s+$//;
    s/;//;
    
    ($type, $name) = split (/\s+/, $_);
    if ($type =~ /int/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_INT },\n);
    }
    elsif ($type =~ /short/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_SHORT },\n);
    }
    elsif ($type =~ /byte/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_CHAR },\n);
    }
    elsif ($type =~ /vec/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_VECTOR },\n);
    }
    elsif ($type =~ /qboolean/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_BOOL },\n);
    }
    elsif ($type =~ /float/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_FLOAT },\n);
    }
    elsif ($type =~ /edict/) {
	$name =~ s/\*//;
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_EDICT_PTR },\n);
    }
    elsif ($type =~ /item/) {
	$name =~ s/\*//;
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_ITEM_PTR },\n);
    }
    elsif ($type =~ /char/) {
	$name =~ s/\*//;
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_CHAR_PTR },\n);
    }
    elsif ($type =~ /guid/) {
	print qq({ "$name", ${macro_prefix}_FOFS($name), DF_GUID },\n);
    }
}
