#include <server/server.h>

enum { FRAME_RANDOM, FRAME_BASELINE, FRAME_FIXED };
int  mbw_strategy = FRAME_FIXED;
int  mbw_distance = 1;   

//
// if checkvisible is true, then we are the centralized client-server case
// else we are in the broadcast p2p case
//
void measure_bw(client_t *cl, bool checkvisible)
{
    sizebuf_t msg;
    char      msg_buf[MAX_MSGLEN];
    
    SV_BuildClientFrame (c, checkvisible);
    SZ_Init (&msg, msg_buf, sizeof(msg_buf));
    msg.allowoverflow = true;
    
    // decide the delta-encoding...
    if (mbw_strategy == FRAME_RANDOM) {
	c->lastframe = sv.framenum - rand_int(UPDATE_BACKUP - 4);
    }
    else if (mbw_strategy == FRAME_BASELINE) {
	c->lastframe = -1;
    }
    else if (mbw_strategy == FRAME_FIXED) {
	c->lastframe = sv.framenum - mbw_distance;
    }
    
    // send over all the relevant entity_state_t
    // and the player_state_t
    SV_WriteFrameToClient (c, &msg);
    frame = &c->frames[sv.framenum & UPDATE_MASK];
    
    if (msg.cursize != 23) {   // magic number; doh! 
	fprintf(bw_file, "client %d frame %d size %d ents %d\n",
		i + 1, sv.framenum, msg.cursize, frame->num_entities);
    }
}

void measure_bw_cs()
{
    int i;
    client_t *c;

    for (i = 0, c = svs.clients ; i < maxclients->value; i++, c++) {
	if (!g_edicts[i + 1].inuse)
	    continue;
	measure_bw(c, true);
    }
}

void measure_bw_p2p()
{
    // for each entity that has changed (regardless of visibility), send it to all clients;

    for (i = 0, c = svs.clients ; i < maxclients->value; i++, c++) {
	if (!g_edicts[i + 1].inuse)
	    continue;

	measure_bw(c, false);  // will send it ONE client
    }
    // finally divide by the number of clients...
}

