#ifndef DG__TYPES__H
#define DG__TYPES__H

#include <mercury/Packet.h>

typedef enum {
    DF_BOOL,
    DF_INT,
    DF_INT_ARRAY,
    DF_CHAR,
    DF_CHAR_ARRAY,
    DF_SHORT,
    DF_SHORT_ARRAY,
    DF_FLOAT,
    DF_FLOAT_ARRAY,
    DF_VECTOR,
    DF_GUID,

    DF_CHAR_PTR,
    DF_EDICT_PTR,

    DF_FUNC_PTR,
    DF_ITEM_PTR,
    DF_ITEM_ARMOR_PTR,
    DF_MMOVE_PTR,
    DF_MFRAME_PTR,

    DF_CLIENT_PTR,
    DF_ENTITYSTATE,
    DF_MOVEINFO,
    DF_MONSTERINFO,
    DF_PLAYER_STATE,
    DF_PMOVE_STATE,
    DF_CLIENT_PERSISTANT,
    DF_CLIENT_RESPAWN,

    DF_MULTICAST_LIST,

    DF_INVALID
} dg_fieldtype_t;

typedef struct
{
    char           *name; // name of the field
    int             ofs;  // offset into field
    dg_fieldtype_t  type; // type of field
    int             alen; // length of array type (if applicable)
} dg_field_t;

/* LOTS of declarations ... */
extern dg_field_t edict_fields[];
extern dg_field_t entitystate_fields[];
extern dg_field_t monsterinfo_fields[];
extern dg_field_t mmove_fields[];  
extern dg_field_t mframe_fields[];  
extern dg_field_t moveinfo_fields[]; 
extern dg_field_t gitemarmor_fields[];  
extern dg_field_t gitem_fields[];  
extern dg_field_t pmovestate_fields[];  
extern dg_field_t playerstate_fields[];  
extern dg_field_t clientpersistant_fields[];  
extern dg_field_t clientrespawn_fields[];  
extern dg_field_t gclient_fields[];
extern dg_field_t sentinel[];

#include <game/q_shared.h>     // for qboolean;
#include <dg/dg_delta_encoding.h>

class DG_Edict;

extern void null_init(dg_field_stack_t *, dg_field_t *);

extern void bool_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int bool_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean bool_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void bool_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void bool_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void int_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int int_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean int_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void int_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void int_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void intarray_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int intarray_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean intarray_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void intarray_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void intarray_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void char_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int char_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean char_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void char_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void char_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void chararray_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int chararray_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean chararray_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void chararray_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void chararray_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void short_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int short_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean short_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void short_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void short_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void shortarray_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int shortarray_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean shortarray_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void shortarray_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void shortarray_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void float_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int float_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean float_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void float_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void float_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void floatarray_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int floatarray_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean floatarray_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void floatarray_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void floatarray_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void vector_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int vector_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean vector_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void vector_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void vector_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void guid_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int guid_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean guid_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void guid_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void guid_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void charptr_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int charptr_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean charptr_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void charptr_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void charptr_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void edictptr_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int edictptr_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean edictptr_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void edictptr_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void edictptr_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void genericptr_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int genericptr_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean genericptr_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void genericptr_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void genericptr_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void multicast_list_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int multicast_list_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean multicast_list_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void multicast_list_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void multicast_list_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);

extern void object_init(dg_field_stack_t *, dg_field_t *);
extern void object_print(int indent, ostream&, dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern int object_length(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *);
extern qboolean object_is_dirty(dg_field_stack_t *, dg_fields *, dg_field_t *, byte *, byte *);
extern void object_serialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *, byte *, Packet *);
extern void object_deserialize(dg_field_stack_t *, dg_fields *, DG_Edict *, dg_field_t *field, Packet *msg, byte *ptr_object, dg_fieldtype_t container, int ofs);


typedef struct {
    dg_fieldtype_t type;
    /**
     * Function called once to initialize delta tables and stuff.
     *
     * @param stack the "fullname" of the field so far
     * @param field the type of this field.
     */
    void     (*init)(dg_field_stack_t *stack, dg_field_t *field);
    /**
     * Print this field.
     *
     * @param indent number of spaces to indent subfields
     * @param ostream the stream to print to
     * @param stack the "fullname" of the field so far
     * @param fields the list of fieldkeys to print (if empty, print all)
     * @param field the type of this field
     * @param ofs the byte offset of this field relative to outer field type
     */
    void     (*print)(int indent, ostream&, dg_field_stack_t *stack, 
		      dg_fields *fields, dg_field_t *field, byte *ofs);
    /**
     * Get the length of this field.
     *
     * @param stack the "fullname" of the field so far
     * @param fields the list of fieldkeys to include (if empty, include all)
     * @param field the type of this field
     * @param ofs the byte offset of this field relative to outer field type
     */
    int      (*length)(dg_field_stack_t *stack, dg_fields *fields, 
		       dg_field_t *field, byte *base);
    /**
     * Check if this field is dirty.
     *
     * @param stack the "fullname" of the field so far
     * @param fields the fieldkeys that we found were dirty (TO FILL)
     * @param field the type of this field
     * @param from the byte offset of this field relative to outer field type
     *             in the old object.
     * @param to   the type offset of this field in the new object.
     */
    qboolean (*is_dirty)(dg_field_stack_t *stack, dg_fields *fields, 
			 dg_field_t *field, byte *from, byte *to);
    /**
     * Serialize a field.
     *
     * @param stack the "fullname" of the field so far
     * @param fields the list of fieldkeys to serialize (if empty, all)
     * @param obj the object we are serializing
     * @param field the type of this field
     * @param base the byte offset of this field relative to outer field type
     * @param msg the packet we serialize ourselves into
     */
    void     (*serialize)(dg_field_stack_t *stack, dg_fields *fields, 
			  DG_Edict *obj, dg_field_t *field, byte *base, 
			  Packet *msg);
    /**
     * Deserialiaze a field. (Ugliness is due to pointer resolution :P)
     *
     * @param stack the "fullname" of the field so far
     * @param fields the list of fieldkeys to deserialize (if empty, all)
     * @param obj the object we are deserializing
     * @param field the type of this field
     * @param msg the packet we deserialize ourselves from
     * @param base the byte offset of this field relative to outer field type
     * @param container the type of "object" this field is in (either
     *                  DF_CLIENT_PTR or DF_EDICT_PTR)
     * @param cofs the offset to this field from the start of the container obj
     */
    void     (*deserialize)(dg_field_stack_t *, dg_fields *, 
			    DG_Edict *obj, dg_field_t *field, 
			    Packet *msg, byte *base, 
			    dg_fieldtype_t container, int cofs);

    /**
     * Subfields within this field.
     */
    dg_field_t *subfield_list;
} typeinfo_t;

#endif // DG__TYPES__H
