
#define DG_INCLUDE
#include <game/g_local.h>
#include "dg.h"
#include "DG_Edict.h"
#include "DG_ObjStore.h"
#include "QuakeAdaptor.h"
#include "dg_test.h"

extern QuakeAdaptor *g_QuakeAdaptor;

char dg_test_msg[1024];

inline bool _eq_int(int i1, int i2, int sz) { 
    return i1 == i2; 
}
inline bool _eq_float(float i1, float i2, int sz) { 
    return i1 == i2; 
}
inline bool _eq_ptr(const void *i1, const void *i2, int sz) { 
    return i1 == i2; 
}
inline bool _eq_edict(const edict_t *ent1, const edict_t *ent2, int sz) {
    if (ent1 == ent2) {
	return true;
    }
    else if (ent1 && !ent1->inuse && !ent2 || 
	     ent2 && !ent1 && !ent2->inuse || 
	     ent1 && ent2 && !ent1->inuse && !ent2->inuse) {
	return true;
    }
    else {
	return false;
    }
}
inline bool _eq_str(const char *m1, const char *m2, int sz) { 
    return m1 == m2 || !(m1 == NULL || m2==NULL) && !strcmp(m1,m2);
}
inline bool _eq_mem(const void *m1, const void *m2, int sz) {
    return m1 == m2 || !(m1 == NULL || m2==NULL) && !memcmp(m1, m2, sz);
}
template<class T>
bool _eq_val(T m1, T m2, int sz) {
    return !memcmp(&m1, &m2, sizeof(T));
}

#define ELT1 __elt1
#define ELT2 __elt2
#define __EQFLD(field, func, fieldname, sz) { \
   if ( (SEL == NULL || *SEL == string(fieldname)) && \
       ! func((ELT1)->field, (ELT2)->field, sz) ) { \
      sprintf(dg_test_msg, "field %s differs\n", \
              fieldname); \
      return false; \
   } \
}
#define EQFLD(field, func, sz) __EQFLD(field, func, # field, sz)
#define EQINT(field) EQFLD(field, _eq_int, -1)
#define EQFLT(field) EQFLD(field, _eq_float, -1)
#define EQPTR(field) EQFLD(field, _eq_ptr, -1)
#define EQEDICT(field) EQFLD(field, _eq_edict, -1)
#define EQMEM(field, sz) EQFLD(field, _eq_mem, sz)
#define EQSTR(field) EQFLD(field, _eq_str, -1)
#define EQVEC(field) EQFLD(field, _eq_mem, sizeof(vec3_t))
#define EQARR(field, T, sz) EQMEM(field, sizeof(T)*(sz))
#define EQTYPE(field, T) EQMEM(field, sizeof(T)) 

#define EQVAL(field, T) EQFLD(field, _eq_val<T>, -1)

bool gclient_equal(struct gclient_s *ELT1, 
		   struct gclient_s *ELT2, string *SEL)
{
    EQVAL(ps, player_state_t);
    EQINT(ping);

    EQVAL(pers, client_persistant_t);
    EQVAL(resp, client_respawn_t);
    EQVAL(old_pmove, pmove_state_t);
    EQTYPE(newweapon, gitem_t);
    EQPTR(chase_target);

    EQINT(update_chase);
    
    EQINT(damage_armor);
    EQINT(damage_parmor);
    EQINT(damage_blood);
    EQINT(damage_knockback);
    EQVEC(damage_from);
    EQFLT(killer_yaw);
    EQINT(showscores);
    EQINT(showinventory);
    EQINT(showhelp);
    EQINT(showhelpicon);

    EQINT(ammo_index);
    EQINT(buttons);
    EQINT(oldbuttons);
    EQINT(latched_buttons);
    EQINT(weapon_thunk);

    EQVAL(weaponstate, weaponstate_t);
    EQVEC(kick_angles);
    EQVEC(kick_origin);
    EQFLT(v_dmg_roll);
    EQFLT(v_dmg_pitch);
    EQFLT(v_dmg_time);
    EQFLT(fall_time);
    EQFLT(fall_value);

    EQFLT(damage_alpha);
    EQFLT(bonus_alpha);
    EQVEC(damage_blend);
    EQVEC(v_angle);
    EQFLT(bobtime);
    EQVEC(oldviewangles);
    EQVEC(oldvelocity);
 
    EQFLT(next_drown_time);
    EQINT(old_waterlevel);
    EQINT(breather_sound);
    EQINT(machinegun_shots);
    
    EQINT(anim_end);
    EQINT(anim_priority);
    EQINT(anim_duck);
    EQINT(anim_run);

    EQFLT(quad_framenum);
    EQFLT(invincible_framenum);
    EQFLT(breather_framenum);
    EQFLT(enviro_framenum);


    EQINT(grenade_blew_up);
    EQFLT(grenade_time);
    EQINT(silencer_shots);
    EQINT(weapon_sound);

    EQFLT(pickup_msg_time);
    EQFLT(flood_locktill);
    EQARR(flood_when, float, 10);

    EQINT(flood_whenhead);
    EQFLT(respawn_time);

    return true;
}

bool edict_equal(edict_t *ELT1, edict_t *ELT2, string *SEL)
{
    EQVEC(s.origin);
    EQVEC(s.angles);
    EQVEC(s.old_origin);
    EQINT(s.modelindex);
    EQINT(s.modelindex2);
    EQINT(s.modelindex3);
    EQINT(s.modelindex4);
    EQINT(s.frame);
    EQINT(s.skinnum);
    EQINT(s.effects);
    EQINT(s.renderfx);
    //EQINT(s.solid);
    EQINT(s.sound);
    EQINT(s.event);

    //EQPTR(client);
    // both non-null: compare contents
    if (ELT1->client != NULL && 
	! gclient_equal(ELT1->client, ELT2->client, SEL) ) {
	return false;
    }

    EQINT(inuse);
    // These field private to local game graphics engine...
    //EQINT(linkcount);
    //EQVAL(area, link_t);
    //EQINT(num_clusters);
    //EQARR(clusternums, int, MAX_ENT_CLUSTERS);
    //EQINT(headnode);
    //EQINT(areanum);
    //EQINT(areanum2);
    
    EQINT(svflags);
    EQVEC(mins);
    EQVEC(maxs);
    EQVAL(solid, solid_t);
    EQINT(clipmask);
    EQEDICT(owner);

    EQINT(movetype);
    EQINT(flags);
    EQFLT(freetime);

    EQINT(spawnflags);
    EQFLT(timestamp);
    EQFLT(angle);

    EQFLT(speed);
    EQFLT(accel);
    EQFLT(decel);
    EQVEC(movedir);
    EQVEC(pos1);
    EQVEC(pos2);

    EQVEC(velocity);
    EQVEC(avelocity);
    EQINT(mass);
    EQFLT(air_finished);
    EQFLT(gravity);

    EQFLT(yaw_speed);
    EQFLT(ideal_yaw);
    EQFLT(nextthink);
    EQFLT(touch_debounce_time);
    EQFLT(pain_debounce_time);
    EQFLT(damage_debounce_time);
    EQFLT(fly_sound_debounce_time);
    EQFLT(last_move_time);

    EQINT(health);
    EQINT(max_health);
    EQINT(gib_health);
    EQINT(deadflag);
    EQINT(show_hostile);
    EQFLT(powerarmor_time);

    EQINT(viewheight);
    EQINT(takedamage);
    EQINT(dmg);
    EQINT(radius_dmg);
    EQFLT(dmg_radius);
    EQINT(sounds);
    EQINT(count);

    EQINT(groundentity_linkcount);
    EQINT(noise_index);
    EQINT(noise_index2);
    EQFLT(volume);
    EQFLT(attenuation);

    EQFLT(wait);
    EQFLT(delay);
    EQFLT(random);
    EQFLT(teleport_time);
    EQINT(watertype);
    EQINT(waterlevel);
    EQVEC(move_origin);
    EQVEC(move_angles);
    
    EQINT(light_level);
    EQINT(style);

    // Distributed game related fields
    //qboolean     is_replica;
    //byte         status;
    //guid_t       guid;
    //sid_t        primary_owner;

    EQSTR(map);
    EQSTR(model);
    EQSTR(message);
    EQSTR(classname);
    EQSTR(target);
    EQSTR(targetname);
    EQSTR(killtarget);
    EQSTR(team);
    EQSTR(pathtarget);
    EQSTR(deathtarget);
    EQSTR(combattarget);


    // changed testing to EQEDICT instead of EQPTR; - Ashwin [05/21]
    // why? because if an entity is "freed", pointers pointing to it are NOT set to null,
    // but the serializer actually sends a NULL guid; thus the deserialized entity will be
    // a null pointer, and just pointer equality will not hold!

    /*    
    EQEDICT(target_ent);
    EQEDICT(goalentity);
    EQEDICT(movetarget);
    EQEDICT(chain);
    EQEDICT(enemy);
    EQEDICT(oldenemy);
    EQEDICT(activator);
    EQEDICT(groundentity);
    EQEDICT(teamchain);
    EQEDICT(teammaster);
    */

    EQEDICT(mynoise);
    EQPTR(mynoise2);
    /* TODO: How to cast these? -- forget for now, I think if these are
       bad we should crash horribly anyway.
    EQPTR(prethink);
    EQPTR(think);
    EQPTR(blocked);
    EQPTR(touch);
    EQPTR(use);
    EQPTR(pain);
    EQPTR(die);
    */
    EQTYPE(item, gitem_t);
    EQVAL(moveinfo, moveinfo_t);
    EQVAL(monsterinfo, monsterinfo_t);

    EQINT(is_bot);
    EQINT(is_jumping);
    EQVEC(move_vector);
    EQFLT(next_move_time);
    EQFLT(wander_timeout);
    EQFLT(suicide_timeout);
    
    EQINT(current_node);
    EQINT(goal_node);
    EQINT(next_node);
    EQINT(node_timeout);
    EQINT(last_node);
    EQINT(tries);

    EQINT(state);

    return true;
}

/*
static char _dump_type_buf[1024];

template<class T>
char *_dump_type(const char *fieldname, T val, int size) {
    // TODO
}

#define __DUMPFLD(field, type, fieldname, sz) { \
   _dump_type<type>(fieldname, (ELT1)->field, sz); \
}
#define DUMPFLD(field, type, sz) __EQFLD(field, type, # field, sz)
#define DUMPINT(field) EQFLD(field, int, -1)
#define DUMPFLT(field) EQFLD(field, float, -1)
#define DUMPPTR(field) EQFLD(field, void *, -1)
#define DUMPMEM(field, sz) EQFLD(field, void *, sz)
#define DUMPSTR(field) EQFLD(field, char *, -1)
#define DUMPVEC(field) EQFLD(field, vec3_t, sizeof(vec3_t))
#define DUMPARR(field, T, sz) EQMEM(field, sizeof(T)*(sz))
#define DUMPTYPE(field, T) EQMEM(field, sizeof(T)) 

#define DUMPVAL(field, T) EQFLD(field, T, -1)

bool dump_edict(edict_t *ELT1)
{
    DUMPVAL(s, entity_state_t);

    DUMPPTR(client);
    // both non-null: compare contents
    if (ELT1->client != NULL && ! gclient_equal(ELT1->client, ELT2->client) ) {
	return false;
    }

    DUMPINT(inuse);
    DUMPINT(linkcount);
    DUMPVAL(area, link_t);
    DUMPINT(num_clusters);
    DUMPARR(clusternums, int, MAX_ENT_CLUSTERS);
    DUMPINT(headnode);
    DUMPINT(areanum);
    DUMPINT(areanum2);
    
    DUMPINT(svflags);
    DUMPVEC(mins);
    DUMPVEC(maxs);
    DUMPVAL(solid, solid_t);
    DUMPINT(clipmask);
    DUMPPTR(owner);

    DUMPINT(movetype);
    DUMPINT(flags);
    DUMPFLT(freetime);

    DUMPINT(spawnflags);
    DUMPFLT(timestamp);
    DUMPFLT(angle);

    DUMPFLT(speed);
    DUMPFLT(accel);
    DUMPFLT(decel);
    DUMPVEC(movedir);
    DUMPVEC(pos1);
    DUMPVEC(pos2);

    DUMPVEC(velocity);
    DUMPVEC(avelocity);
    DUMPINT(mass);
    DUMPFLT(air_finished);
    DUMPFLT(gravity);

    DUMPFLT(yaw_speed);
    DUMPFLT(ideal_yaw);
    DUMPFLT(nextthink);
    DUMPFLT(touch_debounce_time);
    DUMPFLT(pain_debounce_time);
    DUMPFLT(damage_debounce_time);
    DUMPFLT(fly_sound_debounce_time);
    DUMPFLT(last_move_time);

    DUMPINT(health);
    DUMPINT(max_health);
    DUMPINT(gib_health);
    DUMPINT(deadflag);
    DUMPINT(show_hostile);
    DUMPFLT(powerarmor_time);

    DUMPINT(viewheight);
    DUMPINT(takedamage);
    DUMPINT(dmg);
    DUMPINT(radius_dmg);
    DUMPFLT(dmg_radius);
    DUMPINT(sounds);
    DUMPINT(count);

    DUMPINT(groundentity_linkcount);
    DUMPINT(noise_index);
    DUMPINT(noise_index2);
    DUMPFLT(volume);
    DUMPFLT(attenuation);

    DUMPFLT(wait);
    DUMPFLT(delay);
    DUMPFLT(random);
    DUMPFLT(teleport_time);
    DUMPINT(watertype);
    DUMPINT(waterlevel);
    DUMPVEC(move_origin);
    DUMPVEC(move_angles);
    
    DUMPINT(light_level);
    DUMPINT(style);

    // Distributed game related fields
    //qboolean     is_replica;
    //byte         status;
    //guid_t       guid;
    //sid_t        primary_owner;

    DUMPSTR(map);
    DUMPSTR(model);
    DUMPSTR(message);
    DUMPSTR(classname);
    DUMPSTR(target);
    DUMPSTR(targetname);
    DUMPSTR(killtarget);
    DUMPSTR(team);
    DUMPSTR(pathtarget);
    DUMPSTR(deathtarget);
    DUMPSTR(combattarget);

    DUMPPTR(target_ent);
    DUMPPTR(goalentity);
    DUMPPTR(movetarget);
    DUMPPTR(chain);
    DUMPPTR(enemy);
    DUMPPTR(oldenemy);
    DUMPPTR(activator);
    DUMPPTR(groundentity);
    DUMPPTR(teamchain);
    DUMPPTR(teammaster);

    DUMPPTR(mynoise);
    DUMPPTR(mynoise2);

    DUMPTYPE(item, gitem_t);
    DUMPVAL(moveinfo, moveinfo_t);
    DUMPVAL(monsterinfo, monsterinfo_t);

    DUMPINT(is_bot);
    DUMPINT(is_jumping);
    DUMPVEC(move_vector);
    DUMPFLT(next_move_time);
    DUMPFLT(wander_timeout);
    DUMPFLT(suicide_timeout);
    
    DUMPINT(current_node);
    DUMPINT(goal_node);
    DUMPINT(next_node);
    DUMPINT(node_timeout);
    DUMPINT(last_node);
    DUMPINT(tries);

    DUMPINT(state);

    return true;
}
*/

///////////////////////////////////////////////////////////////////////////////

static edict_t *dg_test_edict_shadow = NULL;
static int dg_test_edict_shadow_len = 0;

void DG_test_shadow_restore_begin(edict_t *edict_arr_bef, int size)
{
    ASSERT(edict_arr_bef != NULL);

    DB(1) << "SR_TEST: BEGIN" << endl;

    dg_test_edict_shadow = (edict_t *) ALLOC_MEM(size * sizeof(edict_t));
    memmove(dg_test_edict_shadow, g_edicts, size * sizeof(edict_t));
    dg_test_edict_shadow_len = size;
}

void DG_test_shadow_restore_end(edict_t *edict_arr_aft, int size)
{
    ASSERT(edict_arr_aft != NULL);
    ASSERT(dg_test_edict_shadow_len == size);

    bool success = true;
    
    for (int i=0; i<size; i++) {
	edict_t *ent = &dg_test_edict_shadow[i];
	
	// TODO: need some invariant to check for replicas!
	if (! ent->inuse || ent->is_replica ) {
	    continue;
	}

	DB(1) << "SR_TEST: checking ent #" << ent->s.number 
	      << " class=" << ent->classname << endl;

	if (! edict_equal(&dg_test_edict_shadow[i], &edict_arr_aft[i]) ) {
	    DB(1) << "SR_TEST: " << dg_test_msg << endl;
	    success = false;
	}
    }
    
    DB(1) << "SR_TEST: " << (success?"SUCCESS":"FAILURE") << endl;
}

void DG_test_serialize_deserialize(edict_t *edict_arr, int size)
{
    bool success = true;
    
    for (int i=0; i<size; i++) {
	edict_t *ent = &edict_arr[i];
	if (! ent->inuse || !ent->is_distributed) {
	    continue;
	}

	DB(10) << "SD_TEST: checking ent #" << ent->s.number 
	      << " class=" << ent->classname << endl;

	edict_t ent1, ent2;
	gclient_t cl1, cl2;
	memmove(&ent1, &edict_arr[i], sizeof(edict_t));
	if (ent1.client) {
	    memmove(&cl1, ent1.client, sizeof(gclient_t));
	    ent1.client = &cl1;
	}

	bzero(&ent2, sizeof(edict_t));
	if (ent1.client) {
	    bzero(&cl2, sizeof(gclient_t));
	    ent2.client = &cl2;
	}
	
	
	GObjectInfo info1, info2;
	DG_Edict obj1(&ent1);
	DG_Edict obj2(&ent2);

	gi.linkentity(&ent1);

	DG_MakeInitDeltaMask(&obj1);
	
	if (obj1.IsReplica()) {

	    Packet *blob = new Packet(8192);
	    obj1.PackUpdate(blob, obj1.GetInitDeltaMask());
	    
	    Packet p(blob->GetLength());
	    blob->Serialize(&p);
	    delete blob;
	    
	    Packet *blob2 = new Packet(&p);
	    

	    // make sure we can create an identical object from the pub
	    SIDMap unresolved;
	    info1.SetGUID(obj1.GetGUID());
	    info1.SetSID(obj1.GetSID());
	    info1.SetIsReplica(true);
	    DG_Edict *cons = (DG_Edict *)g_QuakeAdaptor->Construct(&info1, blob2, obj1.GetInitDeltaMask(), &unresolved);
	    ASSERT(cons);

	    if (unresolved.size() > 0) {
		DB(1) << "SD_TEST: unresolved refs while constructing:" 
		      << endl;
		for (SIDMapIter it = unresolved.begin(); 
		     it != unresolved.end(); it++) {
		    DB(1) << "SD_TEST: " << it->first << "=>" << it->second
			  << endl;
		}
		success = false;
	    } else {
		cons->OnObjectAdd();
		if (cons == NULL) {
		    DB(1) << "SD_TEST: constructed object is NULL!" << endl;
		    success = false;
		} else if (cons->m_Entity == NULL) {
		    DB(1) << "SD_TEST: constructed object->m_Entity is NULL!" << endl;
		    success = false;
		} else {
		    if (! edict_equal(cons->m_Entity, &ent1)) {
			DB(1) << "SD_TEST: constructing: " << dg_test_msg 
			      << endl;
			success = false;
			ASSERT(cons);
			ASSERT(0);
		    }
		}
	    }

	    delete cons;
	    delete blob2;
	}

	gi.linkentity(&ent2);

	//DB(1) << "BEFORE: ent2.s.solid=" << ent2.s.solid << endl;

	{

	    Packet *blob = new Packet(8192);
	    obj1.PackUpdate(blob, obj1.GetInitDeltaMask());
	    
	    Packet p(blob->GetLength());
	    blob->Serialize(&p);
	    delete blob;
	    
	    Packet *blob2 = new Packet(&p);
	    
	    // undo changes to ent2
	    bzero(&ent2, sizeof(edict_t));
	    if (ent1.client) {
		bzero(&cl2, sizeof(gclient_t));
		ent2.client = &cl2;
	    }
	    ent2.classname = ent1.classname;
	
	    // now apply the pub/update to ent2, which is just a copy...
	    SIDMap unresolved;
	    obj2.UnpackUpdate(blob2, obj1.GetInitDeltaMask(), &unresolved);
	    
	    //DB(1) << "AFTER: ent2.s.solid=" << ent2.s.solid << endl;
	    
	    if (unresolved.size() > 0) {
		DB(1) << "SD_TEST: unresolved refs while updating:" 
		      << endl;
		for (SIDMapIter it = unresolved.begin(); 
		     it != unresolved.end(); it++) {
		    DB(1) << "SD_TEST: " << it->first << "=>" << it->second
			  << endl;
		}
		success = false;
	    } else {
		if (! edict_equal(&ent2, &ent1)) {
		    DB(1) << "SD_TEST: updating: " << dg_test_msg << endl;
		    success = false;
		    ASSERT(0);
		}
	    }

	    delete blob2;
	}

	gi.unlinkentity(&ent1);
	gi.unlinkentity(&ent2);
    }

    if (!success) 
	DB(1) << "SD_TEST: " << (success?"SUCCESS":"FAILURE") << endl;
}
