/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef __DG_PUBSUBSIM__H
#define __DG_PUBSUBSIM__H

#include "dg.h"

///////////////////////////////////////////////////////////////////////////////
//
// Simple simulator for pub/sub
//

/**
 * For a given snapshot of the object store (the current one) estimate
 * the number of pub/sub messages that would be generated. Assume that
 * this was called each frame.
 */
void DG_EstimatePubSubCosts(int frameno);

/**
 * Call when we exit.
 */
void DG_EstimatePubSubCostsHalt();

#endif
