#define DG_INCLUDE
#include <game/g_local.h>
#include "dg.h"

#define EDICT_FOFS(x) (int)&(((edict_t *)0)->x)
dg_field_t edict_fields[] = {

    {"s", EDICT_FOFS(s), DF_ENTITYSTATE},
    {"client", EDICT_FOFS(client), DF_CLIENT_PTR },

    // always true
    //{"inuse", EDICT_FOFS(inuse), DF_BOOL},

    // set by SV_LinkEdict
    //{"linkcount", EDICT_FOFS(linkcount), DF_INT },
    //{"absmin", EDICT_FOFS(absmin), DF_VECTOR},
    //{"absmax", EDICT_FOFS(absmax), DF_VECTOR},
    //{"size", EDICT_FOFS(size), DF_VECTOR},

    {"svflags", EDICT_FOFS(svflags), DF_INT },
    {"mins", EDICT_FOFS(mins), DF_VECTOR},
    {"maxs", EDICT_FOFS(maxs), DF_VECTOR},
    {"solid", EDICT_FOFS(solid), DF_INT},
    {"clipmask", EDICT_FOFS(clipmask), DF_INT },
    {"owner", EDICT_FOFS(owner), DF_EDICT_PTR },

    { "multicastEventList", EDICT_FOFS(multicastEventList), DF_MULTICAST_LIST},

    // Game DLL specific fields

    { "movetype", EDICT_FOFS(movetype), DF_INT },
    { "flags", EDICT_FOFS(flags), DF_INT },

    // only relevant for freed edicts
    { "freetime", EDICT_FOFS(freetime), DF_FLOAT },

    { "spawnflags", EDICT_FOFS(spawnflags), DF_INT },
    
    // only for self
    { "timestamp", EDICT_FOFS(timestamp), DF_FLOAT },

    { "angle", EDICT_FOFS(angle), DF_FLOAT },

    { "speed", EDICT_FOFS(speed), DF_FLOAT },
    { "accel", EDICT_FOFS(accel), DF_FLOAT },
    { "decel", EDICT_FOFS(decel), DF_FLOAT },
    { "movedir", EDICT_FOFS(movedir), DF_VECTOR },
    { "pos1", EDICT_FOFS(pos1), DF_VECTOR },
    { "pos2", EDICT_FOFS(pos2), DF_VECTOR },

    { "velocity", EDICT_FOFS(velocity), DF_VECTOR },
    { "avelocity", EDICT_FOFS(avelocity), DF_VECTOR },
    { "mass", EDICT_FOFS(mass), DF_INT },
    //{ "air_finished", EDICT_FOFS(air_finished), DF_FLOAT },
    { "gravity", EDICT_FOFS(gravity), DF_FLOAT },

    { "yaw_speed", EDICT_FOFS(yaw_speed), DF_FLOAT },
    { "ideal_yaw", EDICT_FOFS(ideal_yaw), DF_FLOAT },
    // need this when items are touched...
    { "nextthink", EDICT_FOFS(nextthink), DF_FLOAT },
    { "touch_debounce_time", EDICT_FOFS(touch_debounce_time), DF_FLOAT },
    { "pain_debounce_time", EDICT_FOFS(pain_debounce_time), DF_FLOAT },
    { "damage_debounce_time", EDICT_FOFS(damage_debounce_time), DF_FLOAT },
    { "fly_sound_debounce_time", EDICT_FOFS(fly_sound_debounce_time), DF_FLOAT },
    { "last_move_time", EDICT_FOFS(last_move_time), DF_FLOAT },

    { "health", EDICT_FOFS(health), DF_INT },
    { "max_health", EDICT_FOFS(max_health), DF_INT },
    { "gib_health", EDICT_FOFS(gib_health), DF_INT },
    { "deadflag", EDICT_FOFS(deadflag), DF_INT },
    { "show_hostile", EDICT_FOFS(show_hostile), DF_BOOL },
    { "powerarmor_time", EDICT_FOFS(powerarmor_time), DF_FLOAT },

    { "viewheight", EDICT_FOFS(viewheight), DF_INT },
    { "takedamage", EDICT_FOFS(takedamage), DF_INT },
    { "dmg", EDICT_FOFS(dmg), DF_INT },
    { "radius_dmg", EDICT_FOFS(radius_dmg), DF_INT },
    { "dmg_radius", EDICT_FOFS(dmg_radius), DF_FLOAT },
    { "sounds", EDICT_FOFS(sounds), DF_FLOAT },
    { "count", EDICT_FOFS(count), DF_INT },

    { "groundentity_linkcount", EDICT_FOFS(groundentity_linkcount), DF_INT },
    { "noise_index", EDICT_FOFS(noise_index), DF_INT },
    { "noise_index2", EDICT_FOFS(noise_index2), DF_INT },
    { "volume", EDICT_FOFS(volume), DF_FLOAT },
    { "attenuation", EDICT_FOFS(attenuation), DF_FLOAT },

    { "wait", EDICT_FOFS(wait), DF_FLOAT },
    { "delay", EDICT_FOFS(delay), DF_FLOAT },
    { "random", EDICT_FOFS(random), DF_FLOAT },
    { "teleport_time", EDICT_FOFS(teleport_time), DF_FLOAT },
    { "watertype", EDICT_FOFS(watertype), DF_INT },
    { "waterlevel", EDICT_FOFS(waterlevel), DF_INT },
    { "move_origin", EDICT_FOFS(move_origin), DF_VECTOR },
    { "move_angles", EDICT_FOFS(move_angles), DF_VECTOR },

    { "light_level", EDICT_FOFS(light_level), DF_INT },
    { "style", EDICT_FOFS(style), DF_INT },

    // these are set by DG_Edict
    // { "is_replica", EDICT_FOFS(is_replica), DF_BOOL },
    // { "guid", EDICT_FOFS(guid), DF_GUID },

    { "map", EDICT_FOFS(map), DF_CHAR_PTR },
    { "model", EDICT_FOFS(model), DF_CHAR_PTR },
    { "message", EDICT_FOFS(message), DF_CHAR_PTR },
    { "classname", EDICT_FOFS(classname), DF_CHAR_PTR },
    { "target", EDICT_FOFS(target), DF_CHAR_PTR },
    { "targetname", EDICT_FOFS(targetname), DF_CHAR_PTR },
    { "killtarget", EDICT_FOFS(killtarget), DF_CHAR_PTR },
    { "team", EDICT_FOFS(team), DF_CHAR_PTR },
    { "pathtarget", EDICT_FOFS(pathtarget), DF_CHAR_PTR },
    { "deathtarget", EDICT_FOFS(deathtarget), DF_CHAR_PTR },
    { "combattarget", EDICT_FOFS(combattarget), DF_CHAR_PTR },

    /* Jeff 7/1/2004: Try ignoring edict pointers...
       XXX: Will still need to serialize them at least during migration
    { "target_ent", EDICT_FOFS(target_ent), DF_EDICT_PTR },
    { "goalentity", EDICT_FOFS(goalentity), DF_EDICT_PTR },
    { "movetarget", EDICT_FOFS(movetarget), DF_EDICT_PTR },
    { "chain", EDICT_FOFS(chain), DF_EDICT_PTR },
    { "enemy", EDICT_FOFS(enemy), DF_EDICT_PTR },
    { "oldenemy", EDICT_FOFS(oldenemy), DF_EDICT_PTR },
    { "activator", EDICT_FOFS(activator), DF_EDICT_PTR },
    { "groundentity", EDICT_FOFS(groundentity), DF_EDICT_PTR },
    { "teamchain", EDICT_FOFS(teamchain), DF_EDICT_PTR },
    { "teammaster", EDICT_FOFS(teammaster), DF_EDICT_PTR },

    { "mynoise", EDICT_FOFS(mynoise), DF_EDICT_PTR },
    { "mynoise2", EDICT_FOFS(mynoise2), DF_EDICT_PTR },
    */

    {"prethink", EDICT_FOFS(prethink), DF_FUNC_PTR},
    {"think", EDICT_FOFS(think), DF_FUNC_PTR},
    {"blocked", EDICT_FOFS(blocked), DF_FUNC_PTR},
    {"touch", EDICT_FOFS(touch), DF_FUNC_PTR},
    {"use", EDICT_FOFS(use), DF_FUNC_PTR},
    {"pain", EDICT_FOFS(pain), DF_FUNC_PTR},
    {"die", EDICT_FOFS(die), DF_FUNC_PTR},

    {"item", EDICT_FOFS(item), DF_ITEM_PTR },
    {"moveinfo", EDICT_FOFS(moveinfo), DF_MOVEINFO},
    {"monsterinfo", EDICT_FOFS(monsterinfo), DF_MONSTERINFO },

    {"is_bot", EDICT_FOFS(is_bot), DF_BOOL},
    {"is_jumping", EDICT_FOFS(is_jumping), DF_BOOL},
    {"move_vector", EDICT_FOFS(move_vector), DF_VECTOR},
    {"next_move_time", EDICT_FOFS(next_move_time), DF_FLOAT},
    //{"wander_timeout", EDICT_FOFS(wander_timeout), DF_FLOAT},
    //{"suicide_timeout", EDICT_FOFS(suicide_timeout), DF_FLOAT},
    
    {"current_node", EDICT_FOFS(current_node), DF_INT},
    {"goal_node", EDICT_FOFS(goal_node), DF_INT},
    {"next_node", EDICT_FOFS(next_node), DF_INT},
    {"node_timeout", EDICT_FOFS(node_timeout), DF_INT},
    {"last_node", EDICT_FOFS(last_node), DF_INT},
    {"tries", EDICT_FOFS(tries), DF_INT},

    {"state", EDICT_FOFS(state), DF_INT},

    {0, 0, DF_INT }
};

#define ENTITYSTATE_FOFS(x) (int) &(((entity_state_t *)0)->x)

dg_field_t entitystate_fields[] = 
{
    // reset-local
    //{"number", ENTITYSTATE_FOFS(number), DF_INT },    
    {"origin", ENTITYSTATE_FOFS(origin), DF_VECTOR}, 
    {"angles", ENTITYSTATE_FOFS(angles), DF_VECTOR},
    {"old_origin", ENTITYSTATE_FOFS(old_origin), DF_VECTOR }, 
    {"modelindex", ENTITYSTATE_FOFS(modelindex), DF_INT },
    {"modelindex2", ENTITYSTATE_FOFS(modelindex2), DF_INT },
    {"modelindex3", ENTITYSTATE_FOFS(modelindex3), DF_INT },
    {"modelindex4", ENTITYSTATE_FOFS(modelindex4), DF_INT },
    {"frame", ENTITYSTATE_FOFS(frame), DF_INT },
    {"skinnum", ENTITYSTATE_FOFS(skinnum), DF_INT },
    {"effects", ENTITYSTATE_FOFS(effects), DF_INT },
    {"renderfx", ENTITYSTATE_FOFS(renderfx), DF_INT },
    // set by SV_LinkEdict
    //{"solid", ENTITYSTATE_FOFS(solid), DF_INT },
    {"sound", ENTITYSTATE_FOFS(sound), DF_INT },
    {"event", ENTITYSTATE_FOFS(event), DF_INT },
};

#define MONSTERINFO_FOFS(x) (int) &(((monsterinfo_t *)0)->x)

dg_field_t monsterinfo_fields[] = 
{
    { "currentmove", MONSTERINFO_FOFS(currentmove), DF_MMOVE_PTR },

    { "aiflags", MONSTERINFO_FOFS(aiflags), DF_INT },
    { "nextframe", MONSTERINFO_FOFS(nextframe), DF_INT },
    { "scale", MONSTERINFO_FOFS(scale), DF_FLOAT },
    { "pausetime", MONSTERINFO_FOFS(pausetime), DF_FLOAT },
    { "attack_finished", MONSTERINFO_FOFS(attack_finished), DF_FLOAT },
    { "saved_goal", MONSTERINFO_FOFS(saved_goal), DF_VECTOR },
    { "search_time", MONSTERINFO_FOFS(search_time), DF_FLOAT },
    { "trail_time", MONSTERINFO_FOFS(trail_time), DF_FLOAT },
    { "last_sighting", MONSTERINFO_FOFS(last_sighting), DF_VECTOR },
    { "attack_state", MONSTERINFO_FOFS(attack_state), DF_INT },
    { "lefty", MONSTERINFO_FOFS(lefty), DF_INT },
    { "idle_time", MONSTERINFO_FOFS(idle_time), DF_FLOAT },
    { "linkcount", MONSTERINFO_FOFS(linkcount), DF_INT },
    { "power_armor_type", MONSTERINFO_FOFS(power_armor_type), DF_INT },
    { "power_armor_power", MONSTERINFO_FOFS(power_armor_power), DF_INT },

    {"stand", MONSTERINFO_FOFS(stand), DF_FUNC_PTR},
    {"idle", MONSTERINFO_FOFS(idle), DF_FUNC_PTR},
    {"search", MONSTERINFO_FOFS(search), DF_FUNC_PTR},
    {"walk", MONSTERINFO_FOFS(walk), DF_FUNC_PTR},
    {"run", MONSTERINFO_FOFS(run), DF_FUNC_PTR},
    {"dodge", MONSTERINFO_FOFS(dodge), DF_FUNC_PTR},
    {"attack", MONSTERINFO_FOFS(attack), DF_FUNC_PTR},
    {"melee", MONSTERINFO_FOFS(melee), DF_FUNC_PTR},
    {"sight", MONSTERINFO_FOFS(sight), DF_FUNC_PTR},
    {"checkattack", MONSTERINFO_FOFS(checkattack), DF_FUNC_PTR},

    {0, 0, DF_INT},
};

#define MMOVE_FOFS(x) (int) &(((mmove_t *) 0)->x)

dg_field_t mmove_fields[] = {
    {"endfunc", MMOVE_FOFS(endfunc), DF_FUNC_PTR},
    {"firstframe", MMOVE_FOFS(firstframe), DF_INT},
    {"lastframe", MMOVE_FOFS(lastframe), DF_INT},
    {"frame", MMOVE_FOFS(frame), DF_MFRAME_PTR },

    { 0, 0, DF_INT },
};

#define MFRAME_FOFS(x) (int) &(((mframe_t *) 0)->x)

dg_field_t mframe_fields[] = 
{
    {"aifunc", MFRAME_FOFS(aifunc), DF_FUNC_PTR},
    {"thinkfunc", MFRAME_FOFS(thinkfunc), DF_FUNC_PTR},
    {"dist", MFRAME_FOFS(dist), DF_FLOAT},

    { 0, 0, DF_INT },
};

#define MOVEINFO_FOFS(x) (int) &(((moveinfo_t *) 0)->x)

dg_field_t moveinfo_fields[] =
{
    { "start_origin", MOVEINFO_FOFS(start_origin), DF_VECTOR },
    { "start_angles", MOVEINFO_FOFS(start_angles), DF_VECTOR },
    { "end_origin", MOVEINFO_FOFS(end_origin), DF_VECTOR },
    { "end_angles", MOVEINFO_FOFS(end_angles), DF_VECTOR },
    { "sound_start", MOVEINFO_FOFS(sound_start), DF_INT },
    { "sound_middle", MOVEINFO_FOFS(sound_middle), DF_INT },
    { "sound_end", MOVEINFO_FOFS(sound_end), DF_INT },
    { "accel", MOVEINFO_FOFS(accel), DF_FLOAT },
    { "speed", MOVEINFO_FOFS(speed), DF_FLOAT },
    { "decel", MOVEINFO_FOFS(decel), DF_FLOAT },
    { "distance", MOVEINFO_FOFS(distance), DF_FLOAT },
    { "wait", MOVEINFO_FOFS(wait), DF_FLOAT },
    { "state", MOVEINFO_FOFS(state), DF_INT },
    { "dir", MOVEINFO_FOFS(dir), DF_VECTOR },
    { "current_speed", MOVEINFO_FOFS(current_speed), DF_FLOAT },
    { "move_speed", MOVEINFO_FOFS(move_speed), DF_FLOAT },
    { "next_speed", MOVEINFO_FOFS(next_speed), DF_FLOAT },
    { "remaining_distance", MOVEINFO_FOFS(remaining_distance), DF_FLOAT },
    { "decel_distance", MOVEINFO_FOFS(decel_distance), DF_FLOAT },

    {"endfunc", MOVEINFO_FOFS(endfunc), DF_FUNC_PTR},

    { 0, 0, DF_INT },
};

#define GITEM_ARMOR_FOFS(x) (int) &(((gitem_armor_t *) 0)->x )
dg_field_t gitemarmor_fields[] = 
{
    { "base_count", GITEM_ARMOR_FOFS(base_count), DF_INT },
    { "max_count", GITEM_ARMOR_FOFS(max_count), DF_INT },
    { "normal_protection", GITEM_ARMOR_FOFS(normal_protection), DF_FLOAT},
    { "energy_protection", GITEM_ARMOR_FOFS(energy_protection), DF_FLOAT },
    { "armor", GITEM_ARMOR_FOFS(armor), DF_INT },

    { 0, 0, DF_INT },
};

#define ITEM_FOFS(x) (int) &(((gitem_t *) 0)->x )
dg_field_t gitem_fields[] = 
{
    {"pickup", ITEM_FOFS(pickup), DF_FUNC_PTR},
    {"use", ITEM_FOFS(use), DF_FUNC_PTR},
    {"drop", ITEM_FOFS(drop), DF_FUNC_PTR},
    {"weaponthink", ITEM_FOFS(weaponthink), DF_FUNC_PTR},

    { "classname", ITEM_FOFS(classname), DF_CHAR_PTR },
    { "pickup_sound", ITEM_FOFS(pickup_sound), DF_CHAR_PTR },
    { "world_model", ITEM_FOFS(world_model), DF_CHAR_PTR },
    { "world_model_flags", ITEM_FOFS(world_model_flags), DF_INT },
    { "view_model", ITEM_FOFS(view_model), DF_CHAR_PTR },
    { "icon", ITEM_FOFS(icon), DF_CHAR_PTR },
    { "pickup_name", ITEM_FOFS(pickup_name), DF_CHAR_PTR },
    { "count_width", ITEM_FOFS(count_width), DF_INT },
    { "quantity", ITEM_FOFS(quantity), DF_INT },
    { "ammo", ITEM_FOFS(ammo), DF_CHAR_PTR },
    { "flags", ITEM_FOFS(flags), DF_INT },
    { "weapmodel", ITEM_FOFS(weapmodel), DF_INT },
    { "tag", ITEM_FOFS(tag), DF_INT },
    { "precaches", ITEM_FOFS(precaches), DF_CHAR_PTR },

    // yet another hack for the stupid VOID * INFO
    { "info", ITEM_FOFS(info), DF_ITEM_ARMOR_PTR },

    { 0, 0, DF_INT },
};


#define PMOVE_STATE_FOFS(x)  (int)&(((pmove_state_t *)0)->x)
dg_field_t pmovestate_fields[] = 
{
    { "pm_type", PMOVE_STATE_FOFS(pm_type), DF_INT },
    { "pm_flags", PMOVE_STATE_FOFS(pm_flags), DF_CHAR },
    { "pm_time", PMOVE_STATE_FOFS(pm_time), DF_CHAR },
    { "origin", PMOVE_STATE_FOFS(origin), DF_SHORT_ARRAY, 3 },
    { "velocity", PMOVE_STATE_FOFS(velocity), DF_SHORT_ARRAY, 3  },
    { "gravity", PMOVE_STATE_FOFS(gravity), DF_SHORT },
    { "delta_angles", PMOVE_STATE_FOFS(delta_angles), DF_SHORT_ARRAY, 3 },

    { 0, 0, DF_INT },
};

#define PLAYER_STATE_FOFS(x)  (int)&(((player_state_t *)0)->x)
dg_field_t playerstate_fields[] = 
{
    { "pmove", PLAYER_STATE_FOFS(pmove), DF_PMOVE_STATE },

    { "viewangles", PLAYER_STATE_FOFS(viewangles), DF_VECTOR },
    { "viewoffset", PLAYER_STATE_FOFS(viewoffset), DF_VECTOR },
    { "kick_angles", PLAYER_STATE_FOFS(kick_angles), DF_VECTOR },
    { "gunangles", PLAYER_STATE_FOFS(gunangles), DF_VECTOR },
    { "gunoffset", PLAYER_STATE_FOFS(gunoffset), DF_VECTOR },
    { "gunindex", PLAYER_STATE_FOFS(gunindex), DF_INT },
    { "gunframe", PLAYER_STATE_FOFS(gunframe), DF_INT },
    { "blend", PLAYER_STATE_FOFS(blend), DF_FLOAT_ARRAY, 4 },
    { "fov", PLAYER_STATE_FOFS(fov), DF_FLOAT },
    { "rdflags", PLAYER_STATE_FOFS(rdflags), DF_INT },
    // XXX: FIXME: we should have 1 field per stat, not 1 field for *every* stat
    { "stats", PLAYER_STATE_FOFS(stats), DF_SHORT_ARRAY, MAX_STATS },

    { 0, 0, DF_INT },
};

#define CLIENT_PERSISTANT_FOFS(x)  (int)&(((client_persistant_t *)0)->x)
dg_field_t clientpersistant_fields[] = 
{
    // XXX: FIXME: userinfo string rarely fills the entire array! should be a string
    { "userinfo", CLIENT_PERSISTANT_FOFS(userinfo), DF_CHAR_ARRAY, MAX_INFO_STRING },
    { "netname", CLIENT_PERSISTANT_FOFS(netname), DF_CHAR_ARRAY, 16 },
    { "hand", CLIENT_PERSISTANT_FOFS(hand), DF_INT },
    { "connected", CLIENT_PERSISTANT_FOFS(connected), DF_BOOL },
    { "health", CLIENT_PERSISTANT_FOFS(health), DF_INT },
    { "max_health", CLIENT_PERSISTANT_FOFS(max_health), DF_INT },
    { "savedFlags", CLIENT_PERSISTANT_FOFS(savedFlags), DF_INT },
    { "selected_item", CLIENT_PERSISTANT_FOFS(selected_item), DF_INT },
    // XXX: FIXME: should have 1 field per item, not one for *all* items!
    { "inventory", CLIENT_PERSISTANT_FOFS(inventory), DF_INT_ARRAY, MAX_ITEMS },
    { "max_bullets", CLIENT_PERSISTANT_FOFS(max_bullets), DF_INT },
    { "max_shells", CLIENT_PERSISTANT_FOFS(max_shells), DF_INT },
    { "max_rockets", CLIENT_PERSISTANT_FOFS(max_rockets), DF_INT },
    { "max_grenades", CLIENT_PERSISTANT_FOFS(max_grenades), DF_INT },
    { "max_cells", CLIENT_PERSISTANT_FOFS(max_cells), DF_INT },
    { "max_slugs", CLIENT_PERSISTANT_FOFS(max_slugs), DF_INT },
    { "weapon", CLIENT_PERSISTANT_FOFS(weapon), DF_ITEM_PTR },
    { "lastweapon", CLIENT_PERSISTANT_FOFS(lastweapon), DF_ITEM_PTR },
    { "power_cubes", CLIENT_PERSISTANT_FOFS(power_cubes), DF_INT },
    { "score", CLIENT_PERSISTANT_FOFS(score), DF_INT },
    { "game_helpchanged", CLIENT_PERSISTANT_FOFS(game_helpchanged), DF_INT },
    { "helpchanged", CLIENT_PERSISTANT_FOFS(helpchanged), DF_INT },
    { "spectator", CLIENT_PERSISTANT_FOFS(spectator), DF_BOOL },

    { 0, 0, DF_INT },
};

#define CLIENT_RESPAWN_FOFS(x)  (int)&(((client_respawn_t *)0)->x)

dg_field_t clientrespawn_fields[] = 
{
    { "coop_respawn", CLIENT_RESPAWN_FOFS(coop_respawn), DF_CLIENT_PERSISTANT },
    { "enterframe", CLIENT_RESPAWN_FOFS(enterframe), DF_INT },
    { "score", CLIENT_RESPAWN_FOFS(score), DF_INT },
    { "cmd_angles", CLIENT_RESPAWN_FOFS(cmd_angles), DF_VECTOR },
    { "spectator", CLIENT_RESPAWN_FOFS(spectator), DF_BOOL },
    { "respawn_delay", CLIENT_RESPAWN_FOFS(respawn_delay), DF_FLOAT },

    { 0, 0, DF_INT },
};

#define CLIENT_FOFS(x)  (int)&(((gclient_t *)0)->x)
dg_field_t gclient_fields[] = 
{
    // Complicated stuff...
    { "ps", CLIENT_FOFS(ps), DF_PLAYER_STATE },
    { "pers", CLIENT_FOFS(pers), DF_CLIENT_PERSISTANT },
    { "resp", CLIENT_FOFS(resp), DF_CLIENT_RESPAWN },
    { "old_pmove", CLIENT_FOFS(old_pmove), DF_PMOVE_STATE },

    { "ping", CLIENT_FOFS(ping), DF_INT },
    { "newweapon", CLIENT_FOFS(newweapon), DF_ITEM_PTR },
    { "chase_target", CLIENT_FOFS(chase_target), DF_EDICT_PTR },
    { "update_chase", CLIENT_FOFS(update_chase), DF_BOOL },
    { "damage_armor", CLIENT_FOFS(damage_armor), DF_INT },
    { "damage_parmor", CLIENT_FOFS(damage_parmor), DF_INT },
    { "damage_blood", CLIENT_FOFS(damage_blood), DF_INT },
    { "damage_knockback", CLIENT_FOFS(damage_knockback), DF_INT },
    { "damage_from", CLIENT_FOFS(damage_from), DF_VECTOR },
    { "killer_yaw", CLIENT_FOFS(killer_yaw), DF_FLOAT },
    { "showscores", CLIENT_FOFS(showscores), DF_BOOL },
    { "showinventory", CLIENT_FOFS(showinventory), DF_BOOL },
    { "showhelp", CLIENT_FOFS(showhelp), DF_BOOL },
    { "showhelpicon", CLIENT_FOFS(showhelpicon), DF_BOOL },
    { "ammo_index", CLIENT_FOFS(ammo_index), DF_INT },
    { "buttons", CLIENT_FOFS(buttons), DF_INT },
    { "oldbuttons", CLIENT_FOFS(oldbuttons), DF_INT },
    { "latched_buttons", CLIENT_FOFS(latched_buttons), DF_INT },

    { "weapon_thunk", CLIENT_FOFS(weapon_thunk), DF_BOOL },
    { "weaponstate", CLIENT_FOFS(weaponstate), DF_INT}, // -- added by hand

    { "kick_angles", CLIENT_FOFS(kick_angles), DF_VECTOR },
    { "kick_origin", CLIENT_FOFS(kick_origin), DF_VECTOR },
    { "v_dmg_roll", CLIENT_FOFS(v_dmg_roll), DF_FLOAT },
    { "v_dmg_pitch", CLIENT_FOFS(v_dmg_pitch), DF_FLOAT },
    { "v_dmg_time", CLIENT_FOFS(v_dmg_time), DF_FLOAT },
    { "fall_time", CLIENT_FOFS(fall_time), DF_FLOAT },
    { "fall_value", CLIENT_FOFS(fall_value), DF_FLOAT },
    { "damage_alpha", CLIENT_FOFS(damage_alpha), DF_FLOAT },
    { "bonus_alpha", CLIENT_FOFS(bonus_alpha), DF_FLOAT },
    { "damage_blend", CLIENT_FOFS(damage_blend), DF_VECTOR },
    { "v_angle", CLIENT_FOFS(v_angle), DF_VECTOR },
    { "bobtime", CLIENT_FOFS(bobtime), DF_FLOAT },
    { "oldviewangles", CLIENT_FOFS(oldviewangles), DF_VECTOR },
    { "oldvelocity", CLIENT_FOFS(oldvelocity), DF_VECTOR },
    { "next_drown_time", CLIENT_FOFS(next_drown_time), DF_FLOAT },
    { "old_waterlevel", CLIENT_FOFS(old_waterlevel), DF_INT },
    { "breather_sound", CLIENT_FOFS(breather_sound), DF_INT },
    { "machinegun_shots", CLIENT_FOFS(machinegun_shots), DF_INT },
    { "anim_end", CLIENT_FOFS(anim_end), DF_INT },
    { "anim_priority", CLIENT_FOFS(anim_priority), DF_INT },
    { "anim_duck", CLIENT_FOFS(anim_duck), DF_BOOL },
    { "anim_run", CLIENT_FOFS(anim_run), DF_BOOL },
    { "quad_framenum", CLIENT_FOFS(quad_framenum), DF_FLOAT },
    { "invincible_framenum", CLIENT_FOFS(invincible_framenum), DF_FLOAT },
    { "breather_framenum", CLIENT_FOFS(breather_framenum), DF_FLOAT },
    { "enviro_framenum", CLIENT_FOFS(enviro_framenum), DF_FLOAT },
    { "grenade_blew_up", CLIENT_FOFS(grenade_blew_up), DF_BOOL },
    { "grenade_time", CLIENT_FOFS(grenade_time), DF_FLOAT },
    { "silencer_shots", CLIENT_FOFS(silencer_shots), DF_INT },
    { "weapon_sound", CLIENT_FOFS(weapon_sound), DF_INT },
    { "pickup_msg_time", CLIENT_FOFS(pickup_msg_time), DF_FLOAT },
    { "flood_locktill", CLIENT_FOFS(flood_locktill), DF_FLOAT },

    { "flood_when", CLIENT_FOFS(flood_when), DF_FLOAT_ARRAY, 10 },

    { "flood_whenhead", CLIENT_FOFS(flood_whenhead), DF_INT },
    { "respawn_time", CLIENT_FOFS(respawn_time), DF_FLOAT },
    
    { "is_monster", CLIENT_FOFS(is_monster), DF_BOOL }, // added by hand

    { 0, 0,  DF_INT }
};

#include <game/inc_registry.h>

void * func_pointers[] = 
{
(void *)	AI_SetSightClient,
(void *)	ai_move,
(void *)	ai_stand,
(void *)	ai_walk,
(void *)	ai_charge,
(void *)	ai_turn,
(void *)	range,
(void *)	visible,
(void *)	infront,
(void *)	HuntTarget,
(void *)	FoundTarget,
(void *)	FindTarget,
(void *)	FacingIdeal,
(void *)	M_CheckAttack,
(void *)	ai_run_melee,
(void *)	ai_run_missile,
(void *)	ai_run_slide,
(void *)	ai_checkattack,
(void *)	ai_run,
(void *)	UpdateChaseCam,
(void *)	ChaseNext,
(void *)	ChasePrev,
(void *)	GetChaseTarget,
(void *)	OnSameTeam,
(void *)	SelectNextItem,
(void *)	SelectPrevItem,
(void *)	ValidateSelectedItem,
(void *)	Cmd_Give_f,
(void *)	Cmd_God_f,
(void *)	Cmd_Notarget_f,
(void *)	Cmd_Noclip_f,
(void *)	Cmd_Use_f,
(void *)	Cmd_Drop_f,
(void *)	Cmd_Inven_f,
(void *)	Cmd_InvUse_f,
(void *)	Cmd_WeapPrev_f,
(void *)	Cmd_WeapNext_f,
(void *)	Cmd_WeapLast_f,
(void *)	Cmd_InvDrop_f,
(void *)	Cmd_Kill_f,
(void *)	Cmd_PutAway_f,
(void *)	PlayerSort,
(void *)	Cmd_Players_f,
(void *)	Cmd_Wave_f,
(void *)	Cmd_Say_f,
(void *)	Cmd_PlayerList_f,
(void *)	ClientCommand,
(void *)	CanDamage,
(void *)	Killed,
(void *)	SpawnDamage,
(void *)	CheckPowerArmor,
(void *)	CheckArmor,
(void *)	M_ReactToDamage,
(void *)	CheckTeamDamage,
(void *)	T_Damage,
(void *)	T_RadiusDamage,
(void *)	Move_Done,
(void *)	Move_Final,
(void *)	Move_Begin,
(void *)	Move_Calc,
(void *)	AngleMove_Done,
(void *)	AngleMove_Final,
(void *)	AngleMove_Begin,
(void *)	AngleMove_Calc,
(void *)	plat_CalcAcceleratedMove,
(void *)	plat_Accelerate,
(void *)	Think_AccelMove,
(void *)	plat_hit_top,
(void *)	plat_hit_bottom,
(void *)	plat_go_down,
(void *)	plat_go_up,
(void *)	plat_blocked,
(void *)	Use_Plat,
(void *)	Touch_Plat_Center,
(void *)	plat_spawn_inside_trigger,
(void *)	SP_func_plat,
(void *)	rotating_blocked,
(void *)	rotating_touch,
(void *)	rotating_use,
(void *)	SP_func_rotating,
(void *)	button_done,
(void *)	button_return,
(void *)	button_wait,
(void *)	button_fire,
(void *)	button_use,
(void *)	button_touch,
(void *)	button_killed,
(void *)	SP_func_button,
(void *)	door_use_areaportals,
(void *)	door_hit_top,
(void *)	door_hit_bottom,
(void *)	door_go_down,
(void *)	door_go_up,
(void *)	door_use,
(void *)	Touch_DoorTrigger,
(void *)	Think_CalcMoveSpeed,
(void *)	Think_SpawnDoorTrigger,
(void *)	door_blocked,
(void *)	door_killed,
(void *)	door_touch,
(void *)	SP_func_door,
(void *)	SP_func_door_rotating,
(void *)	SP_func_water,
(void *)	train_blocked,
(void *)	train_wait,
(void *)	train_next,
(void *)	train_resume,
(void *)	func_train_find,
(void *)	train_use,
(void *)	SP_func_train,
(void *)	trigger_elevator_use,
(void *)	trigger_elevator_init,
(void *)	SP_trigger_elevator,
(void *)	func_timer_think,
(void *)	func_timer_use,
(void *)	SP_func_timer,
(void *)	func_conveyor_use,
(void *)	SP_func_conveyor,
(void *)	door_secret_use,
(void *)	door_secret_move1,
(void *)	door_secret_move2,
(void *)	door_secret_move3,
(void *)	door_secret_move4,
(void *)	door_secret_move5,
(void *)	door_secret_move6,
(void *)	door_secret_done,
(void *)	door_secret_blocked,
(void *)	door_secret_die,
(void *)	SP_func_door_secret,
(void *)	use_killbox,
(void *)	SP_func_killbox,
(void *)	DoRespawn,
(void *)	SetRespawn,
(void *)	Pickup_Powerup,
(void *)	Drop_General,
(void *)	Pickup_Adrenaline,
(void *)	Pickup_AncientHead,
(void *)	Pickup_Bandolier,
(void *)	Pickup_Pack,
(void *)	Use_Quad,
(void *)	Use_Breather,
(void *)	Use_Envirosuit,
(void *)	Use_Invulnerability,
(void *)	Use_Silencer,
(void *)	Pickup_Key,
(void *)	Add_Ammo,
(void *)	Pickup_Ammo,
(void *)	Drop_Ammo,
(void *)	MegaHealth_think,
(void *)	Pickup_Health,
(void *)	ArmorIndex,
(void *)	Pickup_Armor,
(void *)	PowerArmorType,
(void *)	Use_PowerArmor,
(void *)	Pickup_PowerArmor,
(void *)	Drop_PowerArmor,
(void *)	Touch_Item,
(void *)	drop_temp_touch,
(void *)	drop_make_touchable,
(void *)	Use_Item,
(void *)	droptofloor,
(void *)	PrecacheItem,
(void *)	SpawnItem,
(void *)	SP_item_health,
(void *)	SP_item_health_small,
(void *)	SP_item_health_large,
(void *)	SP_item_health_mega,
(void *)	InitItems,
(void *)	SetItemNames,
(void *)	ShutdownGame,
(void *)	Sys_Error,
(void *)	Com_Printf,
(void *)	ClientEndServerFrames,
(void *)	EndDMLevel,
(void *)	CheckNeedPass,
(void *)	CheckDMRules,
(void *)	ExitLevel,
(void *)	G_RunFrame,
(void *)	Use_Areaportal,
(void *)	SP_func_areaportal,
(void *)	VelocityForDamage,
(void *)	ClipGibVelocity,
(void *)	gib_think,
(void *)	gib_touch,
(void *)	gib_die,
(void *)	ThrowGib,
(void *)	ThrowHead,
(void *)	ThrowClientHead,
(void *)	debris_die,
(void *)	ThrowDebris,
(void *)	BecomeExplosion1,
(void *)	BecomeExplosion2,
(void *)	path_corner_touch,
(void *)	SP_path_corner,
(void *)	point_combat_touch,
(void *)	SP_point_combat,
(void *)	TH_viewthing,
(void *)	SP_viewthing,
(void *)	SP_info_null,
(void *)	SP_info_notnull,
(void *)	light_use,
(void *)	SP_light,
(void *)	func_wall_use,
(void *)	SP_func_wall,
(void *)	func_object_touch,
(void *)	func_object_release,
(void *)	func_object_use,
(void *)	SP_func_object,
(void *)	func_explosive_explode,
(void *)	func_explosive_use,
(void *)	func_explosive_spawn,
(void *)	SP_func_explosive,
(void *)	barrel_touch,
(void *)	barrel_explode,
(void *)	barrel_delay,
(void *)	SP_misc_explobox,
(void *)	misc_blackhole_use,
(void *)	misc_blackhole_think,
(void *)	SP_misc_blackhole,
(void *)	misc_eastertank_think,
(void *)	SP_misc_eastertank,
(void *)	misc_easterchick_think,
(void *)	SP_misc_easterchick,
(void *)	misc_easterchick2_think,
(void *)	SP_misc_easterchick2,
(void *)	commander_body_think,
(void *)	commander_body_use,
(void *)	commander_body_drop,
(void *)	SP_monster_commander_body,
(void *)	misc_banner_think,
(void *)	SP_misc_banner,
(void *)	misc_deadsoldier_die,
(void *)	SP_misc_deadsoldier,
(void *)	misc_viper_use,
(void *)	SP_misc_viper,
(void *)	SP_misc_bigviper,
(void *)	misc_viper_bomb_touch,
(void *)	misc_viper_bomb_prethink,
(void *)	misc_viper_bomb_use,
(void *)	SP_misc_viper_bomb,
(void *)	misc_strogg_ship_use,
(void *)	SP_misc_strogg_ship,
(void *)	misc_satellite_dish_think,
(void *)	misc_satellite_dish_use,
(void *)	SP_misc_satellite_dish,
(void *)	SP_light_mine1,
(void *)	SP_light_mine2,
(void *)	SP_misc_gib_arm,
(void *)	SP_misc_gib_leg,
(void *)	SP_misc_gib_head,
(void *)	SP_target_character,
(void *)	target_string_use,
(void *)	SP_target_string,
(void *)	func_clock_reset,
(void *)	func_clock_format_countdown,
(void *)	func_clock_think,
(void *)	func_clock_use,
(void *)	SP_func_clock,
(void *)	teleporter_touch,
(void *)	SP_misc_teleporter,
(void *)	SP_misc_teleporter_dest,
(void *)	monster_fire_bullet,
(void *)	monster_fire_shotgun,
(void *)	monster_fire_blaster,
(void *)	monster_fire_grenade,
(void *)	monster_fire_rocket,
(void *)	monster_fire_railgun,
(void *)	monster_fire_bfg,
(void *)	M_FliesOff,
(void *)	M_FliesOn,
(void *)	M_FlyCheck,
(void *)	AttackFinished,
(void *)	M_CheckGround,
(void *)	M_CatagorizePosition,
(void *)	M_WorldEffects,
(void *)	M_droptofloor,
(void *)	M_SetEffects,
(void *)	M_MoveFrame,
(void *)	monster_think,
(void *)	monster_use,
(void *)	monster_triggered_spawn,
(void *)	monster_triggered_spawn_use,
(void *)	monster_triggered_start,
(void *)	monster_death_use,
(void *)	monster_start,
(void *)	monster_start_go,
(void *)	walkmonster_start_go,
(void *)	walkmonster_start,
(void *)	flymonster_start_go,
(void *)	flymonster_start,
(void *)	swimmonster_start_go,
(void *)	swimmonster_start,
(void *)	SV_CheckVelocity,
(void *)	SV_RunThink,
(void *)	SV_Impact,
(void *)	ClipVelocity,
(void *)	SV_FlyMove,
(void *)	SV_AddGravity,
(void *)	SV_PushEntity,
(void *)	SV_Push,
(void *)	SV_Physics_Pusher,
(void *)	SV_Physics_None,
(void *)	SV_Physics_Noclip,
(void *)	SV_Physics_Toss,
(void *)	SV_AddRotationalFriction,
(void *)	SV_Physics_Step,
(void *)	G_RunEntity,
(void *)	InitGame,
(void *)	WriteField1,
(void *)	WriteField2,
(void *)	ReadField,
(void *)	WriteClient,
(void *)	ReadClient,
(void *)	WriteGame,
(void *)	ReadGame,
(void *)	WriteEdict,
(void *)	WriteLevelLocals,
(void *)	ReadEdict,
(void *)	ReadLevelLocals,
(void *)	WriteLevel,
(void *)	ReadLevel,
(void *)	ED_CallSpawn,
(void *)	ED_ParseField,
(void *)	G_FindTeams,
(void *)	SpawnEntities,
(void *)	SP_worldspawn,
(void *)	Svcmd_Test_f,
(void *)	StringToFilter,
(void *)	SV_FilterPacket,
(void *)	SVCmd_AddIP_f,
(void *)	SVCmd_RemoveIP_f,
(void *)	SVCmd_ListIP_f,
(void *)	SVCmd_WriteIP_f,
(void *)	ServerCommand,
(void *)	Use_Target_Tent,
(void *)	SP_target_temp_entity,
(void *)	Use_Target_Speaker,
(void *)	SP_target_speaker,
(void *)	Use_Target_Help,
(void *)	SP_target_help,
(void *)	use_target_secret,
(void *)	SP_target_secret,
(void *)	use_target_goal,
(void *)	SP_target_goal,
(void *)	target_explosion_explode,
(void *)	use_target_explosion,
(void *)	SP_target_explosion,
(void *)	use_target_changelevel,
(void *)	SP_target_changelevel,
(void *)	use_target_splash,
(void *)	SP_target_splash,
(void *)	use_target_spawner,
(void *)	SP_target_spawner,
(void *)	use_target_blaster,
(void *)	SP_target_blaster,
(void *)	trigger_crosslevel_trigger_use,
(void *)	SP_target_crosslevel_trigger,
(void *)	target_crosslevel_target_think,
(void *)	SP_target_crosslevel_target,
(void *)	target_laser_think,
(void *)	target_laser_on,
(void *)	target_laser_off,
(void *)	target_laser_use,
(void *)	target_laser_start,
(void *)	SP_target_laser,
(void *)	target_lightramp_think,
(void *)	target_lightramp_use,
(void *)	SP_target_lightramp,
(void *)	target_earthquake_think,
(void *)	target_earthquake_use,
(void *)	SP_target_earthquake,
(void *)	InitTrigger,
(void *)	multi_wait,
(void *)	multi_trigger,
(void *)	Use_Multi,
(void *)	Touch_Multi,
(void *)	trigger_enable,
(void *)	SP_trigger_multiple,
(void *)	SP_trigger_once,
(void *)	trigger_relay_use,
(void *)	SP_trigger_relay,
(void *)	trigger_key_use,
(void *)	SP_trigger_key,
(void *)	trigger_counter_use,
(void *)	SP_trigger_counter,
(void *)	SP_trigger_always,
(void *)	trigger_push_touch,
(void *)	SP_trigger_push,
(void *)	hurt_use,
(void *)	hurt_touch,
(void *)	SP_trigger_hurt,
(void *)	trigger_gravity_touch,
(void *)	SP_trigger_gravity,
(void *)	trigger_monsterjump_touch,
(void *)	SP_trigger_monsterjump,
(void *)	AnglesNormalize,
(void *)	SnapToEights,
(void *)	turret_blocked,
(void *)	turret_breach_fire,
(void *)	turret_breach_think,
(void *)	turret_breach_finish_init,
(void *)	SP_turret_breach,
(void *)	SP_turret_base,
(void *)	turret_driver_die,
(void *)	turret_driver_think,
(void *)	turret_driver_link,
(void *)	SP_turret_driver,
(void *)	G_ProjectSource,
(void *)	Think_Delay,
(void *)	G_UseTargets,
(void *)	G_SetMovedir,
(void *)	vectoyaw,
(void *)	vectoangles,
(void *)	G_InitEdict,
(void *)	G_FreeEdict,
(void *)	G_TouchTriggers,
(void *)	G_TouchSolids,
(void *)	KillBox,
(void *)	check_dodge,
(void *)	fire_hit,
(void *)	fire_lead,
(void *)	fire_bullet,
(void *)	fire_shotgun,
(void *)	blaster_touch,
(void *)	fire_blaster,
(void *)	Grenade_Explode,
(void *)	Grenade_Touch,
(void *)	fire_grenade,
(void *)	fire_grenade2,
(void *)	rocket_touch,
(void *)	fire_rocket,
(void *)	fire_rail,
(void *)	bfg_explode,
(void *)	bfg_touch,
(void *)	bfg_think,
(void *)	fire_bfg,
(void *)	actor_stand,
(void *)	actor_walk,
(void *)	actor_run,
(void *)	actor_pain,
(void *)	actorMachineGun,
(void *)	actor_dead,
(void *)	actor_die,
(void *)	actor_fire,
(void *)	actor_attack,
(void *)	actor_use,
(void *)	SP_misc_actor,
(void *)	target_actor_touch,
(void *)	SP_target_actor,
(void *)	berserk_sight,
(void *)	berserk_search,
(void *)	berserk_stand,
(void *)	berserk_fidget,
(void *)	berserk_walk,
(void *)	berserk_run,
(void *)	berserk_attack_spike,
(void *)	berserk_swing,
(void *)	berserk_attack_club,
(void *)	berserk_strike,
(void *)	berserk_melee,
(void *)	berserk_pain,
(void *)	berserk_dead,
(void *)	berserk_die,
(void *)	SP_monster_berserk,
(void *)	boss2_search,
(void *)	Boss2Rocket,
(void *)	boss2_firebullet_right,
(void *)	boss2_firebullet_left,
(void *)	Boss2MachineGun,
(void *)	boss2_stand,
(void *)	boss2_run,
(void *)	boss2_walk,
(void *)	boss2_attack,
(void *)	boss2_attack_mg,
(void *)	boss2_reattack_mg,
(void *)	boss2_pain,
(void *)	boss2_dead,
(void *)	boss2_die,
(void *)	Boss2_CheckAttack,
(void *)	SP_monster_boss2,
(void *)	jorg_search,
(void *)	jorg_idle,
(void *)	jorg_death_hit,
(void *)	jorg_step_left,
(void *)	jorg_step_right,
(void *)	jorg_stand,
(void *)	jorg_walk,
(void *)	jorg_run,
(void *)	jorg_reattack1,
(void *)	jorg_attack1,
(void *)	jorg_pain,
(void *)	jorgBFG,
(void *)	jorg_firebullet_right,
(void *)	jorg_firebullet_left,
(void *)	jorg_firebullet,
(void *)	jorg_attack,
(void *)	jorg_dead,
(void *)	jorg_die,
(void *)	Jorg_CheckAttack,
(void *)	SP_monster_jorg,
(void *)	makron_taunt,
(void *)	makron_stand,
(void *)	makron_hit,
(void *)	makron_popup,
(void *)	makron_step_left,
(void *)	makron_step_right,
(void *)	makron_brainsplorch,
(void *)	makron_prerailgun,
(void *)	makron_walk,
(void *)	makron_run,
(void *)	makronBFG,
(void *)	MakronSaveloc,
(void *)	MakronRailgun,
(void *)	MakronHyperblaster,
(void *)	makron_pain,
(void *)	makron_sight,
(void *)	makron_attack,
(void *)	makron_torso_think,
(void *)	makron_torso,
(void *)	makron_dead,
(void *)	makron_die,
(void *)	Makron_CheckAttack,
(void *)	MakronPrecache,
(void *)	SP_monster_makron,
(void *)	MakronSpawn,
(void *)	MakronToss,
(void *)	Use_Boss3,
(void *)	Think_Boss3Stand,
(void *)	SP_monster_boss3_stand,
(void *)	brain_sight,
(void *)	brain_search,
(void *)	brain_stand,
(void *)	brain_idle,
(void *)	brain_walk,
(void *)	brain_duck_down,
(void *)	brain_duck_hold,
(void *)	brain_duck_up,
(void *)	brain_dodge,
(void *)	brain_swing_right,
(void *)	brain_hit_right,
(void *)	brain_swing_left,
(void *)	brain_hit_left,
(void *)	brain_chest_open,
(void *)	brain_tentacle_attack,
(void *)	brain_chest_closed,
(void *)	brain_melee,
(void *)	brain_run,
(void *)	brain_pain,
(void *)	brain_dead,
(void *)	brain_die,
(void *)	SP_monster_brain,
(void *)	ChickMoan,
(void *)	chick_fidget,
(void *)	chick_stand,
(void *)	chick_walk,
(void *)	chick_run,
(void *)	chick_pain,
(void *)	chick_dead,
(void *)	chick_die,
(void *)	chick_duck_down,
(void *)	chick_duck_hold,
(void *)	chick_duck_up,
(void *)	chick_dodge,
(void *)	ChickSlash,
(void *)	ChickRocket,
(void *)	Chick_PreAttack1,
(void *)	ChickReload,
(void *)	chick_rerocket,
(void *)	chick_attack1,
(void *)	chick_reslash,
(void *)	chick_slash,
(void *)	chick_melee,
(void *)	chick_attack,
(void *)	chick_sight,
(void *)	SP_monster_chick,
(void *)	flipper_stand,
(void *)	flipper_run_loop,
(void *)	flipper_run,
(void *)	flipper_walk,
(void *)	flipper_start_run,
(void *)	flipper_bite,
(void *)	flipper_preattack,
(void *)	flipper_melee,
(void *)	flipper_pain,
(void *)	flipper_dead,
(void *)	flipper_sight,
(void *)	flipper_die,
(void *)	SP_monster_flipper,
(void *)	floater_sight,
(void *)	floater_idle,
(void *)	floater_fire_blaster,
(void *)	floater_stand,
(void *)	floater_run,
(void *)	floater_walk,
(void *)	floater_wham,
(void *)	floater_zap,
(void *)	floater_attack,
(void *)	floater_melee,
(void *)	floater_pain,
(void *)	floater_dead,
(void *)	floater_die,
(void *)	SP_monster_floater,
(void *)	flyer_sight,
(void *)	flyer_idle,
(void *)	flyer_pop_blades,
(void *)	flyer_run,
(void *)	flyer_walk,
(void *)	flyer_stand,
(void *)	flyer_stop,
(void *)	flyer_start,
(void *)	flyer_fire,
(void *)	flyer_fireleft,
(void *)	flyer_fireright,
(void *)	flyer_slash_left,
(void *)	flyer_slash_right,
(void *)	flyer_loop_melee,
(void *)	flyer_attack,
(void *)	flyer_setstart,
(void *)	flyer_nextmove,
(void *)	flyer_melee,
(void *)	flyer_check_melee,
(void *)	flyer_pain,
(void *)	flyer_die,
(void *)	SP_monster_flyer,
(void *)	gladiator_idle,
(void *)	gladiator_sight,
(void *)	gladiator_search,
(void *)	gladiator_cleaver_swing,
(void *)	gladiator_stand,
(void *)	gladiator_walk,
(void *)	gladiator_run,
(void *)	GaldiatorMelee,
(void *)	gladiator_melee,
(void *)	GladiatorGun,
(void *)	gladiator_attack,
(void *)	gladiator_pain,
(void *)	gladiator_dead,
(void *)	gladiator_die,
(void *)	SP_monster_gladiator,
(void *)	gunner_idlesound,
(void *)	gunner_sight,
(void *)	gunner_search,
(void *)	gunner_fidget,
(void *)	gunner_stand,
(void *)	gunner_walk,
(void *)	gunner_run,
(void *)	gunner_runandshoot,
(void *)	gunner_pain,
(void *)	gunner_dead,
(void *)	gunner_die,
(void *)	gunner_duck_down,
(void *)	gunner_duck_hold,
(void *)	gunner_duck_up,
(void *)	gunner_dodge,
(void *)	gunner_opengun,
(void *)	GunnerFire,
(void *)	GunnerGrenade,
(void *)	gunner_attack,
(void *)	gunner_fire_chain,
(void *)	gunner_refire_chain,
(void *)	SP_monster_gunner,
(void *)	hover_sight,
(void *)	hover_search,
(void *)	hover_reattack,
(void *)	hover_fire_blaster,
(void *)	hover_stand,
(void *)	hover_run,
(void *)	hover_walk,
(void *)	hover_start_attack,
(void *)	hover_attack,
(void *)	hover_pain,
(void *)	hover_deadthink,
(void *)	hover_dead,
(void *)	hover_die,
(void *)	SP_monster_hover,
(void *)	infantry_stand,
(void *)	infantry_fidget,
(void *)	infantry_walk,
(void *)	infantry_run,
(void *)	infantry_pain,
(void *)	InfantryMachineGun,
(void *)	infantry_sight,
(void *)	infantry_dead,
(void *)	infantry_die,
(void *)	infantry_duck_down,
(void *)	infantry_duck_hold,
(void *)	infantry_duck_up,
(void *)	infantry_dodge,
(void *)	infantry_cock_gun,
(void *)	infantry_fire,
(void *)	infantry_swing,
(void *)	infantry_smack,
(void *)	infantry_attack,
(void *)	SP_monster_infantry,
(void *)	insane_fist,
(void *)	insane_shake,
(void *)	insane_moan,
(void *)	insane_scream,
(void *)	insane_cross,
(void *)	insane_walk,
(void *)	insane_run,
(void *)	insane_pain,
(void *)	insane_onground,
(void *)	insane_checkdown,
(void *)	insane_checkup,
(void *)	insane_stand,
(void *)	insane_dead,
(void *)	insane_die,
(void *)	SP_misc_insane,
(void *)	medic_idle,
(void *)	medic_search,
(void *)	medic_sight,
(void *)	medic_stand,
(void *)	medic_walk,
(void *)	medic_run,
(void *)	medic_pain,
(void *)	medic_fire_blaster,
(void *)	medic_dead,
(void *)	medic_die,
(void *)	medic_duck_down,
(void *)	medic_duck_hold,
(void *)	medic_duck_up,
(void *)	medic_dodge,
(void *)	medic_continue,
(void *)	medic_hook_launch,
(void *)	medic_cable_attack,
(void *)	medic_hook_retract,
(void *)	medic_attack,
(void *)	medic_checkattack,
(void *)	SP_monster_medic,
(void *)	M_CheckBottom,
(void *)	SV_movestep,
(void *)	M_ChangeYaw,
(void *)	SV_StepDirection,
(void *)	SV_FixCheckBottom,
(void *)	SV_NewChaseDir,
(void *)	SV_CloseEnough,
(void *)	M_MoveToGoal,
(void *)	M_walkmove,
(void *)	mutant_step,
(void *)	mutant_sight,
(void *)	mutant_search,
(void *)	mutant_swing,
(void *)	mutant_stand,
(void *)	mutant_idle_loop,
(void *)	mutant_idle,
(void *)	mutant_walk_loop,
(void *)	mutant_walk,
(void *)	mutant_run,
(void *)	mutant_hit_left,
(void *)	mutant_hit_right,
(void *)	mutant_check_refire,
(void *)	mutant_melee,
(void *)	mutant_jump_touch,
(void *)	mutant_jump_takeoff,
(void *)	mutant_check_landing,
(void *)	mutant_jump,
(void *)	mutant_check_melee,
(void *)	mutant_check_jump,
(void *)	mutant_checkattack,
(void *)	mutant_pain,
(void *)	mutant_dead,
(void *)	mutant_die,
(void *)	SP_monster_mutant,
(void *)	parasite_launch,
(void *)	parasite_reel_in,
(void *)	parasite_sight,
(void *)	parasite_tap,
(void *)	parasite_scratch,
(void *)	parasite_search,
(void *)	parasite_end_fidget,
(void *)	parasite_do_fidget,
(void *)	parasite_refidget,
(void *)	parasite_idle,
(void *)	parasite_stand,
(void *)	parasite_start_run,
(void *)	parasite_run,
(void *)	parasite_start_walk,
(void *)	parasite_walk,
(void *)	parasite_pain,
(void *)	parasite_drain_attack_ok,
(void *)	parasite_drain_attack,
(void *)	parasite_attack,
(void *)	parasite_dead,
(void *)	parasite_die,
(void *)	SP_monster_parasite,
(void *)	soldier_idle,
(void *)	soldier_cock,
(void *)	soldier_stand,
(void *)	soldier_walk1_random,
(void *)	soldier_walk,
(void *)	soldier_run,
(void *)	soldier_pain,
(void *)	soldier_fire,
(void *)	soldier_fire1,
(void *)	soldier_attack1_refire1,
(void *)	soldier_attack1_refire2,
(void *)	soldier_fire2,
(void *)	soldier_attack2_refire1,
(void *)	soldier_attack2_refire2,
(void *)	soldier_duck_down,
(void *)	soldier_duck_up,
(void *)	soldier_fire3,
(void *)	soldier_attack3_refire,
(void *)	soldier_fire4,
(void *)	soldier_fire8,
(void *)	soldier_attack6_refire,
(void *)	soldier_attack,
(void *)	soldier_sight,
(void *)	soldier_duck_hold,
(void *)	soldier_dodge,
(void *)	soldier_fire6,
(void *)	soldier_fire7,
(void *)	soldier_dead,
(void *)	soldier_die,
(void *)	SP_monster_soldier_x,
(void *)	SP_monster_soldier_light,
(void *)	SP_monster_soldier,
(void *)	SP_monster_soldier_ss,
(void *)	TreadSound,
(void *)	supertank_search,
(void *)	supertank_stand,
(void *)	supertank_forward,
(void *)	supertank_walk,
(void *)	supertank_run,
(void *)	supertank_reattack1,
(void *)	supertank_pain,
(void *)	supertankRocket,
(void *)	supertankMachineGun,
(void *)	supertank_attack,
(void *)	supertank_dead,
(void *)	BossExplode,
(void *)	supertank_die,
(void *)	SP_monster_supertank,
(void *)	tank_sight,
(void *)	tank_footstep,
(void *)	tank_thud,
(void *)	tank_windup,
(void *)	tank_idle,
(void *)	tank_stand,
(void *)	tank_walk,
(void *)	tank_run,
(void *)	tank_pain,
(void *)	TankBlaster,
(void *)	TankStrike,
(void *)	TankRocket,
(void *)	TankMachineGun,
(void *)	tank_reattack_blaster,
(void *)	tank_poststrike,
(void *)	tank_refire_rocket,
(void *)	tank_doattack_rocket,
(void *)	tank_attack,
(void *)	tank_dead,
(void *)	tank_die,
(void *)	SP_monster_tank,
(void *)	SP_FixCoopSpots,
(void *)	SP_CreateCoopSpots,
(void *)	SP_info_player_start,
(void *)	SP_info_player_deathmatch,
(void *)	SP_info_player_coop,
(void *)	SP_info_player_intermission,
(void *)	player_pain,
(void *)	IsFemale,
(void *)	IsNeutral,
(void *)	ClientObituary,
(void *)	TossClientWeapon,
(void *)	LookAtKiller,
(void *)	player_die,
(void *)	InitClientPersistant,
(void *)	InitClientResp,
(void *)	SaveClientData,
(void *)	FetchClientEntData,
(void *)	PlayersRangeFromSpot,
(void *)	SelectSpawnPoint,
(void *)	InitBodyQue,
(void *)	body_die,
(void *)	CopyToBodyQue,
(void *)	respawn,
(void *)	spectator_respawn,
(void *)	PutClientInServer,
(void *)	ClientBeginDeathmatch,
(void *)	ClientBegin,
(void *)	ClientUserinfoChanged,
(void *)	ClientConnect,
(void *)	ClientDisconnect,
(void *)	PM_trace,
(void *)	CheckBlock,
(void *)	PrintPmove,
(void *)	ClientThink,
(void *)	ClientBeginServerFrame,
(void *)	MoveClientToIntermission,
(void *)	BeginIntermission,
(void *)	DeathmatchScoreboardMessage,
(void *)	DeathmatchScoreboard,
(void *)	Cmd_Score_f,
(void *)	HelpComputer,
(void *)	Cmd_Help_f,
(void *)	G_SetStats,
(void *)	G_CheckChaseStats,
(void *)	G_SetSpectatorStats,
(void *)	PlayerTrail_Init,
(void *)	PlayerTrail_Add,
(void *)	PlayerTrail_New,
(void *)	SV_CalcRoll,
(void *)	P_DamageFeedback,
(void *)	SV_CalcViewOffset,
(void *)	SV_CalcGunOffset,
(void *)	SV_AddBlend,
(void *)	SV_CalcBlend,
(void *)	P_FallingDamage,
(void *)	P_WorldEffects,
(void *)	G_SetClientEffects,
(void *)	G_SetClientEvent,
(void *)	G_SetClientSound,
(void *)	G_SetClientFrame,
(void *)	ClientEndServerFrame,
(void *)	P_ProjectSource,
(void *)	PlayerNoise,
(void *)	Pickup_Weapon,
(void *)	ChangeWeapon,
(void *)	NoAmmoWeaponChange,
(void *)	Think_Weapon,
(void *)	Use_Weapon,
(void *)	Drop_Weapon,
(void *)	Weapon_Generic,
(void *)	weapon_grenade_fire,
(void *)	Weapon_Grenade,
(void *)	weapon_grenadelauncher_fire,
(void *)	Weapon_GrenadeLauncher,
(void *)	Weapon_RocketLauncher_Fire,
(void *)	Weapon_RocketLauncher,
(void *)	Blaster_Fire,
(void *)	Weapon_Blaster_Fire,
(void *)	Weapon_Blaster,
(void *)	Weapon_HyperBlaster_Fire,
(void *)	Weapon_HyperBlaster,
(void *)	Machinegun_Fire,
(void *)	Weapon_Machinegun,
(void *)	Chaingun_Fire,
(void *)	Weapon_Chaingun,
(void *)	weapon_shotgun_fire,
(void *)	Weapon_Shotgun,
(void *)	weapon_supershotgun_fire,
(void *)	Weapon_SuperShotgun,
(void *)	weapon_railgun_fire,
(void *)	Weapon_Railgun,
(void *)	weapon_bfg_fire,
(void *)	Weapon_BFG,
(void *)	RotatePointAroundVector,
(void *)	AngleVectors,
(void *)	ProjectPointOnPlane,
(void *)	PerpendicularVector,
(void *)	R_ConcatRotations,
(void *)	R_ConcatTransforms,
(void *)	Q_fabs,
(void *)	LerpAngle,
(void *)	anglemod,
(void *)	BoxOnPlaneSide2,
(void *)	BoxOnPlaneSide,
(void *)	ClearBounds,
(void *)	AddPointToBounds,
(void *)	VectorCompare,
(void *)	VectorNormalize,
(void *)	VectorNormalize2,
(void *)	VectorMA,
(void *)	_DotProduct,
(void *)	_VectorSubtract,
(void *)	_VectorAdd,
(void *)	_VectorCopy,
(void *)	CrossProduct,
(void *)	VectorLength,
(void *)	VectorInverse,
(void *)	VectorScale,
(void *)	Q_log2,
(void *)	COM_StripExtension,
(void *)	COM_FileBase,
(void *)	COM_FilePath,
(void *)	COM_DefaultExtension,
(void *)	BigShort,
(void *)	LittleShort,
(void *)	BigLong,
(void *)	LittleLong,
(void *)	BigFloat,
(void *)	LittleFloat,
(void *)	ShortSwap,
(void *)	ShortNoSwap,
(void *)	LongSwap,
(void *)	LongNoSwap,
(void *)	FloatSwap,
(void *)	FloatNoSwap,
(void *)	Swap_Init,
(void *)	Com_PageInMemory,
(void *)	Q_stricmp,
(void *)	Q_strncasecmp,
(void *)	Q_strcasecmp,
(void *)	Com_sprintf,
(void *)	Info_RemoveKey,
(void *)	Info_Validate,
(void *)	Info_SetValueForKey,
// ------- from acesrc
(void *)	InitTree,
(void *)	InsertNode,
(void *)	DeleteNode,
(void *)	Encode,
(void *)	Decode,
(void *)	ACEAI_Think,
(void *)	ACEAI_PickLongRangeGoal,
(void *)	ACEAI_PickShortRangeGoal,
(void *)	ACEAI_FindEnemy,
(void *)	ACEAI_CheckShot,
(void *)	ACEAI_ChooseWeapon,
(void *)	ACECM_Commands,
(void *)	ACECM_Store,
(void *)	debug_printf,
(void *)	safe_cprintf,
(void *)	safe_centerprintf,
(void *)	safe_bprintf,
(void *)	ACEIT_PlayerAdded,
(void *)	ACEIT_PlayerRemoved,
(void *)	ACEIT_IsReachable,
(void *)	ACEIT_IsVisible,
(void *)	ACEIT_ChangeWeapon,
(void *)	ACEIT_CanUseArmor,
(void *)	ACEIT_ItemNeed,
(void *)	ACEIT_ClassnameToIndex,
(void *)	ACEIT_BuildItemNodeTable,
(void *)	ACEMV_CanMove,
(void *)	ACEMV_SpecialMove,
(void *)	ACEMV_CheckEyes,
(void *)	ACEMV_ChangeBotAngle,
(void *)	ACEMV_MoveToGoal,
(void *)	ACEMV_Move,
(void *)	ACEMV_Wander,
(void *)	ACEMV_Attack,
(void *)	ACEND_FindCost,
(void *)	ACEND_FindCloseReachableNode,
(void *)	ACEND_FindClosestReachableNode,
(void *)	ACEND_SetGoal,
(void *)	ACEND_FollowPath,
(void *)	ACEND_GrapFired,
(void *)	ACEND_CheckForLadder,
(void *)	ACEND_PathMap,
(void *)	ACEND_InitNodes,
(void *)	ACEND_ShowNode,
(void *)	ACEND_DrawPath,
(void *)	ACEND_ShowPath,
(void *)	ACEND_AddNode,
(void *)	ACEND_UpdateNodeEdge,
(void *)	ACEND_RemoveNodeEdge,
(void *)	ACEND_ResolveAllPaths,
(void *)	ACEND_SaveNodes,
(void *)	ACEND_LoadNodes,
(void *)	ACESP_SaveBots,
(void *)	ACESP_LoadBots,
(void *)	ACESP_HoldSpawn,
(void *)	ACESP_PutClientInServer,
(void *)	ACESP_Respawn,
(void *)	ACESP_SetName,
(void *)	ACESP_SpawnBot,
(void *)	ACESP_RemoveBot,

// ------- end from acesrc
NULL,
};

void * globals_pointers [] = 
{
	(gitem_armor_t *) &jacketarmor_info,
	(gitem_armor_t *) &combatarmor_info,
	(gitem_armor_t *) &bodyarmor_info,

	((gitem_t *) itemlist) + 0,
	((gitem_t *) itemlist) + 1,
	((gitem_t *) itemlist) + 2,
	((gitem_t *) itemlist) + 3,
	((gitem_t *) itemlist) + 4,
	((gitem_t *) itemlist) + 5,
	((gitem_t *) itemlist) + 6,
	((gitem_t *) itemlist) + 7,
	((gitem_t *) itemlist) + 8,
	((gitem_t *) itemlist) + 9,
	((gitem_t *) itemlist) + 10,
	((gitem_t *) itemlist) + 11,
	((gitem_t *) itemlist) + 12,
	((gitem_t *) itemlist) + 13,
	((gitem_t *) itemlist) + 14,
	((gitem_t *) itemlist) + 15,
	((gitem_t *) itemlist) + 16,
	((gitem_t *) itemlist) + 17,
	((gitem_t *) itemlist) + 18,
	((gitem_t *) itemlist) + 19,
	((gitem_t *) itemlist) + 20,
	((gitem_t *) itemlist) + 21,
	((gitem_t *) itemlist) + 22,
	((gitem_t *) itemlist) + 23,
	((gitem_t *) itemlist) + 24,
	((gitem_t *) itemlist) + 25,
	((gitem_t *) itemlist) + 26,
	((gitem_t *) itemlist) + 27,
	((gitem_t *) itemlist) + 28,
	((gitem_t *) itemlist) + 29,
	((gitem_t *) itemlist) + 30,
	((gitem_t *) itemlist) + 31,
	((gitem_t *) itemlist) + 32,
	((gitem_t *) itemlist) + 33,
	((gitem_t *) itemlist) + 34,
	((gitem_t *) itemlist) + 35,
	((gitem_t *) itemlist) + 36,
	((gitem_t *) itemlist) + 37,
	((gitem_t *) itemlist) + 38,
	((gitem_t *) itemlist) + 39,
	((gitem_t *) itemlist) + 40,
	((gitem_t *) itemlist) + 41,
	((gitem_t *) itemlist) + 42,

	(mmove_t *) &mmove_reloc,

	((mframe_t *) actor_frames_stand) + 0,
	((mframe_t *) actor_frames_stand) + 1,
	((mframe_t *) actor_frames_stand) + 2,
	((mframe_t *) actor_frames_stand) + 3,
	((mframe_t *) actor_frames_stand) + 4,
	((mframe_t *) actor_frames_stand) + 5,
	((mframe_t *) actor_frames_stand) + 6,
	((mframe_t *) actor_frames_stand) + 7,
	((mframe_t *) actor_frames_stand) + 8,
	((mframe_t *) actor_frames_stand) + 9,
	((mframe_t *) actor_frames_stand) + 10,
	((mframe_t *) actor_frames_stand) + 11,
	((mframe_t *) actor_frames_stand) + 12,
	((mframe_t *) actor_frames_stand) + 13,
	((mframe_t *) actor_frames_stand) + 14,
	((mframe_t *) actor_frames_stand) + 15,
	((mframe_t *) actor_frames_stand) + 16,
	((mframe_t *) actor_frames_stand) + 17,
	((mframe_t *) actor_frames_stand) + 18,
	((mframe_t *) actor_frames_stand) + 19,
	((mframe_t *) actor_frames_stand) + 20,
	((mframe_t *) actor_frames_stand) + 21,
	((mframe_t *) actor_frames_stand) + 22,
	((mframe_t *) actor_frames_stand) + 23,
	((mframe_t *) actor_frames_stand) + 24,
	((mframe_t *) actor_frames_stand) + 25,
	((mframe_t *) actor_frames_stand) + 26,
	((mframe_t *) actor_frames_stand) + 27,
	((mframe_t *) actor_frames_stand) + 28,
	((mframe_t *) actor_frames_stand) + 29,
	((mframe_t *) actor_frames_stand) + 30,
	((mframe_t *) actor_frames_stand) + 31,
	((mframe_t *) actor_frames_stand) + 32,
	((mframe_t *) actor_frames_stand) + 33,
	((mframe_t *) actor_frames_stand) + 34,
	((mframe_t *) actor_frames_stand) + 35,
	((mframe_t *) actor_frames_stand) + 36,
	((mframe_t *) actor_frames_stand) + 37,
	((mframe_t *) actor_frames_stand) + 38,
	((mframe_t *) actor_frames_stand) + 39,

	(mmove_t *) &actor_move_stand,

	((mframe_t *) actor_frames_walk) + 0,
	((mframe_t *) actor_frames_walk) + 1,
	((mframe_t *) actor_frames_walk) + 2,
	((mframe_t *) actor_frames_walk) + 3,
	((mframe_t *) actor_frames_walk) + 4,
	((mframe_t *) actor_frames_walk) + 5,
	((mframe_t *) actor_frames_walk) + 6,
	((mframe_t *) actor_frames_walk) + 7,
	((mframe_t *) actor_frames_walk) + 8,
	((mframe_t *) actor_frames_walk) + 9,
	((mframe_t *) actor_frames_walk) + 10,

	(mmove_t *) &actor_move_walk,

	((mframe_t *) actor_frames_run) + 0,
	((mframe_t *) actor_frames_run) + 1,
	((mframe_t *) actor_frames_run) + 2,
	((mframe_t *) actor_frames_run) + 3,
	((mframe_t *) actor_frames_run) + 4,
	((mframe_t *) actor_frames_run) + 5,
	((mframe_t *) actor_frames_run) + 6,
	((mframe_t *) actor_frames_run) + 7,
	((mframe_t *) actor_frames_run) + 8,
	((mframe_t *) actor_frames_run) + 9,
	((mframe_t *) actor_frames_run) + 10,
	((mframe_t *) actor_frames_run) + 11,

	(mmove_t *) &actor_move_run,

	((mframe_t *) actor_frames_pain1) + 0,
	((mframe_t *) actor_frames_pain1) + 1,
	((mframe_t *) actor_frames_pain1) + 2,

	(mmove_t *) &actor_move_pain1,

	((mframe_t *) actor_frames_pain2) + 0,
	((mframe_t *) actor_frames_pain2) + 1,
	((mframe_t *) actor_frames_pain2) + 2,

	(mmove_t *) &actor_move_pain2,

	((mframe_t *) actor_frames_pain3) + 0,
	((mframe_t *) actor_frames_pain3) + 1,
	((mframe_t *) actor_frames_pain3) + 2,

	(mmove_t *) &actor_move_pain3,

	((mframe_t *) actor_frames_flipoff) + 0,
	((mframe_t *) actor_frames_flipoff) + 1,
	((mframe_t *) actor_frames_flipoff) + 2,
	((mframe_t *) actor_frames_flipoff) + 3,
	((mframe_t *) actor_frames_flipoff) + 4,
	((mframe_t *) actor_frames_flipoff) + 5,
	((mframe_t *) actor_frames_flipoff) + 6,
	((mframe_t *) actor_frames_flipoff) + 7,
	((mframe_t *) actor_frames_flipoff) + 8,
	((mframe_t *) actor_frames_flipoff) + 9,
	((mframe_t *) actor_frames_flipoff) + 10,
	((mframe_t *) actor_frames_flipoff) + 11,
	((mframe_t *) actor_frames_flipoff) + 12,
	((mframe_t *) actor_frames_flipoff) + 13,

	(mmove_t *) &actor_move_flipoff,

	((mframe_t *) actor_frames_taunt) + 0,
	((mframe_t *) actor_frames_taunt) + 1,
	((mframe_t *) actor_frames_taunt) + 2,
	((mframe_t *) actor_frames_taunt) + 3,
	((mframe_t *) actor_frames_taunt) + 4,
	((mframe_t *) actor_frames_taunt) + 5,
	((mframe_t *) actor_frames_taunt) + 6,
	((mframe_t *) actor_frames_taunt) + 7,
	((mframe_t *) actor_frames_taunt) + 8,
	((mframe_t *) actor_frames_taunt) + 9,
	((mframe_t *) actor_frames_taunt) + 10,
	((mframe_t *) actor_frames_taunt) + 11,
	((mframe_t *) actor_frames_taunt) + 12,
	((mframe_t *) actor_frames_taunt) + 13,
	((mframe_t *) actor_frames_taunt) + 14,
	((mframe_t *) actor_frames_taunt) + 15,
	((mframe_t *) actor_frames_taunt) + 16,

	(mmove_t *) &actor_move_taunt,

	((mframe_t *) actor_frames_death1) + 0,
	((mframe_t *) actor_frames_death1) + 1,
	((mframe_t *) actor_frames_death1) + 2,
	((mframe_t *) actor_frames_death1) + 3,
	((mframe_t *) actor_frames_death1) + 4,
	((mframe_t *) actor_frames_death1) + 5,
	((mframe_t *) actor_frames_death1) + 6,

	(mmove_t *) &actor_move_death1,

	((mframe_t *) actor_frames_death2) + 0,
	((mframe_t *) actor_frames_death2) + 1,
	((mframe_t *) actor_frames_death2) + 2,
	((mframe_t *) actor_frames_death2) + 3,
	((mframe_t *) actor_frames_death2) + 4,
	((mframe_t *) actor_frames_death2) + 5,
	((mframe_t *) actor_frames_death2) + 6,
	((mframe_t *) actor_frames_death2) + 7,
	((mframe_t *) actor_frames_death2) + 8,
	((mframe_t *) actor_frames_death2) + 9,
	((mframe_t *) actor_frames_death2) + 10,
	((mframe_t *) actor_frames_death2) + 11,
	((mframe_t *) actor_frames_death2) + 12,

	(mmove_t *) &actor_move_death2,

	((mframe_t *) actor_frames_attack) + 0,
	((mframe_t *) actor_frames_attack) + 1,
	((mframe_t *) actor_frames_attack) + 2,
	((mframe_t *) actor_frames_attack) + 3,

	(mmove_t *) &actor_move_attack,

	((mframe_t *) berserk_frames_stand) + 0,
	((mframe_t *) berserk_frames_stand) + 1,
	((mframe_t *) berserk_frames_stand) + 2,
	((mframe_t *) berserk_frames_stand) + 3,
	((mframe_t *) berserk_frames_stand) + 4,

	(mmove_t *) &berserk_move_stand,

	((mframe_t *) berserk_frames_stand_fidget) + 0,
	((mframe_t *) berserk_frames_stand_fidget) + 1,
	((mframe_t *) berserk_frames_stand_fidget) + 2,
	((mframe_t *) berserk_frames_stand_fidget) + 3,
	((mframe_t *) berserk_frames_stand_fidget) + 4,
	((mframe_t *) berserk_frames_stand_fidget) + 5,
	((mframe_t *) berserk_frames_stand_fidget) + 6,
	((mframe_t *) berserk_frames_stand_fidget) + 7,
	((mframe_t *) berserk_frames_stand_fidget) + 8,
	((mframe_t *) berserk_frames_stand_fidget) + 9,
	((mframe_t *) berserk_frames_stand_fidget) + 10,
	((mframe_t *) berserk_frames_stand_fidget) + 11,
	((mframe_t *) berserk_frames_stand_fidget) + 12,
	((mframe_t *) berserk_frames_stand_fidget) + 13,
	((mframe_t *) berserk_frames_stand_fidget) + 14,
	((mframe_t *) berserk_frames_stand_fidget) + 15,
	((mframe_t *) berserk_frames_stand_fidget) + 16,
	((mframe_t *) berserk_frames_stand_fidget) + 17,
	((mframe_t *) berserk_frames_stand_fidget) + 18,
	((mframe_t *) berserk_frames_stand_fidget) + 19,

	(mmove_t *) &berserk_move_stand_fidget,

	((mframe_t *) berserk_frames_walk) + 0,
	((mframe_t *) berserk_frames_walk) + 1,
	((mframe_t *) berserk_frames_walk) + 2,
	((mframe_t *) berserk_frames_walk) + 3,
	((mframe_t *) berserk_frames_walk) + 4,
	((mframe_t *) berserk_frames_walk) + 5,
	((mframe_t *) berserk_frames_walk) + 6,
	((mframe_t *) berserk_frames_walk) + 7,
	((mframe_t *) berserk_frames_walk) + 8,
	((mframe_t *) berserk_frames_walk) + 9,
	((mframe_t *) berserk_frames_walk) + 10,
	((mframe_t *) berserk_frames_walk) + 11,

	(mmove_t *) &berserk_move_walk,

	((mframe_t *) berserk_frames_run1) + 0,
	((mframe_t *) berserk_frames_run1) + 1,
	((mframe_t *) berserk_frames_run1) + 2,
	((mframe_t *) berserk_frames_run1) + 3,
	((mframe_t *) berserk_frames_run1) + 4,
	((mframe_t *) berserk_frames_run1) + 5,

	(mmove_t *) &berserk_move_run1,

	((mframe_t *) berserk_frames_attack_spike) + 0,
	((mframe_t *) berserk_frames_attack_spike) + 1,
	((mframe_t *) berserk_frames_attack_spike) + 2,
	((mframe_t *) berserk_frames_attack_spike) + 3,
	((mframe_t *) berserk_frames_attack_spike) + 4,
	((mframe_t *) berserk_frames_attack_spike) + 5,
	((mframe_t *) berserk_frames_attack_spike) + 6,
	((mframe_t *) berserk_frames_attack_spike) + 7,

	(mmove_t *) &berserk_move_attack_spike,

	((mframe_t *) berserk_frames_attack_club) + 0,
	((mframe_t *) berserk_frames_attack_club) + 1,
	((mframe_t *) berserk_frames_attack_club) + 2,
	((mframe_t *) berserk_frames_attack_club) + 3,
	((mframe_t *) berserk_frames_attack_club) + 4,
	((mframe_t *) berserk_frames_attack_club) + 5,
	((mframe_t *) berserk_frames_attack_club) + 6,
	((mframe_t *) berserk_frames_attack_club) + 7,
	((mframe_t *) berserk_frames_attack_club) + 8,
	((mframe_t *) berserk_frames_attack_club) + 9,
	((mframe_t *) berserk_frames_attack_club) + 10,
	((mframe_t *) berserk_frames_attack_club) + 11,

	(mmove_t *) &berserk_move_attack_club,

	((mframe_t *) berserk_frames_attack_strike) + 0,
	((mframe_t *) berserk_frames_attack_strike) + 1,
	((mframe_t *) berserk_frames_attack_strike) + 2,
	((mframe_t *) berserk_frames_attack_strike) + 3,
	((mframe_t *) berserk_frames_attack_strike) + 4,
	((mframe_t *) berserk_frames_attack_strike) + 5,
	((mframe_t *) berserk_frames_attack_strike) + 6,
	((mframe_t *) berserk_frames_attack_strike) + 7,
	((mframe_t *) berserk_frames_attack_strike) + 8,
	((mframe_t *) berserk_frames_attack_strike) + 9,
	((mframe_t *) berserk_frames_attack_strike) + 10,
	((mframe_t *) berserk_frames_attack_strike) + 11,
	((mframe_t *) berserk_frames_attack_strike) + 12,
	((mframe_t *) berserk_frames_attack_strike) + 13,

	(mmove_t *) &berserk_move_attack_strike,

	((mframe_t *) berserk_frames_pain1) + 0,
	((mframe_t *) berserk_frames_pain1) + 1,
	((mframe_t *) berserk_frames_pain1) + 2,
	((mframe_t *) berserk_frames_pain1) + 3,

	(mmove_t *) &berserk_move_pain1,

	((mframe_t *) berserk_frames_pain2) + 0,
	((mframe_t *) berserk_frames_pain2) + 1,
	((mframe_t *) berserk_frames_pain2) + 2,
	((mframe_t *) berserk_frames_pain2) + 3,
	((mframe_t *) berserk_frames_pain2) + 4,
	((mframe_t *) berserk_frames_pain2) + 5,
	((mframe_t *) berserk_frames_pain2) + 6,
	((mframe_t *) berserk_frames_pain2) + 7,
	((mframe_t *) berserk_frames_pain2) + 8,
	((mframe_t *) berserk_frames_pain2) + 9,
	((mframe_t *) berserk_frames_pain2) + 10,
	((mframe_t *) berserk_frames_pain2) + 11,
	((mframe_t *) berserk_frames_pain2) + 12,
	((mframe_t *) berserk_frames_pain2) + 13,
	((mframe_t *) berserk_frames_pain2) + 14,
	((mframe_t *) berserk_frames_pain2) + 15,
	((mframe_t *) berserk_frames_pain2) + 16,
	((mframe_t *) berserk_frames_pain2) + 17,
	((mframe_t *) berserk_frames_pain2) + 18,
	((mframe_t *) berserk_frames_pain2) + 19,

	(mmove_t *) &berserk_move_pain2,

	((mframe_t *) berserk_frames_death1) + 0,
	((mframe_t *) berserk_frames_death1) + 1,
	((mframe_t *) berserk_frames_death1) + 2,
	((mframe_t *) berserk_frames_death1) + 3,
	((mframe_t *) berserk_frames_death1) + 4,
	((mframe_t *) berserk_frames_death1) + 5,
	((mframe_t *) berserk_frames_death1) + 6,
	((mframe_t *) berserk_frames_death1) + 7,
	((mframe_t *) berserk_frames_death1) + 8,
	((mframe_t *) berserk_frames_death1) + 9,
	((mframe_t *) berserk_frames_death1) + 10,
	((mframe_t *) berserk_frames_death1) + 11,
	((mframe_t *) berserk_frames_death1) + 12,

	(mmove_t *) &berserk_move_death1,

	((mframe_t *) berserk_frames_death2) + 0,
	((mframe_t *) berserk_frames_death2) + 1,
	((mframe_t *) berserk_frames_death2) + 2,
	((mframe_t *) berserk_frames_death2) + 3,
	((mframe_t *) berserk_frames_death2) + 4,
	((mframe_t *) berserk_frames_death2) + 5,
	((mframe_t *) berserk_frames_death2) + 6,
	((mframe_t *) berserk_frames_death2) + 7,

	(mmove_t *) &berserk_move_death2,

	((mframe_t *) boss2_frames_stand) + 0,
	((mframe_t *) boss2_frames_stand) + 1,
	((mframe_t *) boss2_frames_stand) + 2,
	((mframe_t *) boss2_frames_stand) + 3,
	((mframe_t *) boss2_frames_stand) + 4,
	((mframe_t *) boss2_frames_stand) + 5,
	((mframe_t *) boss2_frames_stand) + 6,
	((mframe_t *) boss2_frames_stand) + 7,
	((mframe_t *) boss2_frames_stand) + 8,
	((mframe_t *) boss2_frames_stand) + 9,
	((mframe_t *) boss2_frames_stand) + 10,
	((mframe_t *) boss2_frames_stand) + 11,
	((mframe_t *) boss2_frames_stand) + 12,
	((mframe_t *) boss2_frames_stand) + 13,
	((mframe_t *) boss2_frames_stand) + 14,
	((mframe_t *) boss2_frames_stand) + 15,
	((mframe_t *) boss2_frames_stand) + 16,
	((mframe_t *) boss2_frames_stand) + 17,
	((mframe_t *) boss2_frames_stand) + 18,
	((mframe_t *) boss2_frames_stand) + 19,
	((mframe_t *) boss2_frames_stand) + 20,

	(mmove_t *) &boss2_move_stand,

	((mframe_t *) boss2_frames_fidget) + 0,
	((mframe_t *) boss2_frames_fidget) + 1,
	((mframe_t *) boss2_frames_fidget) + 2,
	((mframe_t *) boss2_frames_fidget) + 3,
	((mframe_t *) boss2_frames_fidget) + 4,
	((mframe_t *) boss2_frames_fidget) + 5,
	((mframe_t *) boss2_frames_fidget) + 6,
	((mframe_t *) boss2_frames_fidget) + 7,
	((mframe_t *) boss2_frames_fidget) + 8,
	((mframe_t *) boss2_frames_fidget) + 9,
	((mframe_t *) boss2_frames_fidget) + 10,
	((mframe_t *) boss2_frames_fidget) + 11,
	((mframe_t *) boss2_frames_fidget) + 12,
	((mframe_t *) boss2_frames_fidget) + 13,
	((mframe_t *) boss2_frames_fidget) + 14,
	((mframe_t *) boss2_frames_fidget) + 15,
	((mframe_t *) boss2_frames_fidget) + 16,
	((mframe_t *) boss2_frames_fidget) + 17,
	((mframe_t *) boss2_frames_fidget) + 18,
	((mframe_t *) boss2_frames_fidget) + 19,
	((mframe_t *) boss2_frames_fidget) + 20,
	((mframe_t *) boss2_frames_fidget) + 21,
	((mframe_t *) boss2_frames_fidget) + 22,
	((mframe_t *) boss2_frames_fidget) + 23,
	((mframe_t *) boss2_frames_fidget) + 24,
	((mframe_t *) boss2_frames_fidget) + 25,
	((mframe_t *) boss2_frames_fidget) + 26,
	((mframe_t *) boss2_frames_fidget) + 27,
	((mframe_t *) boss2_frames_fidget) + 28,
	((mframe_t *) boss2_frames_fidget) + 29,

	(mmove_t *) &boss2_move_fidget,

	((mframe_t *) boss2_frames_walk) + 0,
	((mframe_t *) boss2_frames_walk) + 1,
	((mframe_t *) boss2_frames_walk) + 2,
	((mframe_t *) boss2_frames_walk) + 3,
	((mframe_t *) boss2_frames_walk) + 4,
	((mframe_t *) boss2_frames_walk) + 5,
	((mframe_t *) boss2_frames_walk) + 6,
	((mframe_t *) boss2_frames_walk) + 7,
	((mframe_t *) boss2_frames_walk) + 8,
	((mframe_t *) boss2_frames_walk) + 9,
	((mframe_t *) boss2_frames_walk) + 10,
	((mframe_t *) boss2_frames_walk) + 11,
	((mframe_t *) boss2_frames_walk) + 12,
	((mframe_t *) boss2_frames_walk) + 13,
	((mframe_t *) boss2_frames_walk) + 14,
	((mframe_t *) boss2_frames_walk) + 15,
	((mframe_t *) boss2_frames_walk) + 16,
	((mframe_t *) boss2_frames_walk) + 17,
	((mframe_t *) boss2_frames_walk) + 18,
	((mframe_t *) boss2_frames_walk) + 19,

	(mmove_t *) &boss2_move_walk,

	((mframe_t *) boss2_frames_run) + 0,
	((mframe_t *) boss2_frames_run) + 1,
	((mframe_t *) boss2_frames_run) + 2,
	((mframe_t *) boss2_frames_run) + 3,
	((mframe_t *) boss2_frames_run) + 4,
	((mframe_t *) boss2_frames_run) + 5,
	((mframe_t *) boss2_frames_run) + 6,
	((mframe_t *) boss2_frames_run) + 7,
	((mframe_t *) boss2_frames_run) + 8,
	((mframe_t *) boss2_frames_run) + 9,
	((mframe_t *) boss2_frames_run) + 10,
	((mframe_t *) boss2_frames_run) + 11,
	((mframe_t *) boss2_frames_run) + 12,
	((mframe_t *) boss2_frames_run) + 13,
	((mframe_t *) boss2_frames_run) + 14,
	((mframe_t *) boss2_frames_run) + 15,
	((mframe_t *) boss2_frames_run) + 16,
	((mframe_t *) boss2_frames_run) + 17,
	((mframe_t *) boss2_frames_run) + 18,
	((mframe_t *) boss2_frames_run) + 19,

	(mmove_t *) &boss2_move_run,

	((mframe_t *) boss2_frames_attack_pre_mg) + 0,
	((mframe_t *) boss2_frames_attack_pre_mg) + 1,
	((mframe_t *) boss2_frames_attack_pre_mg) + 2,
	((mframe_t *) boss2_frames_attack_pre_mg) + 3,
	((mframe_t *) boss2_frames_attack_pre_mg) + 4,
	((mframe_t *) boss2_frames_attack_pre_mg) + 5,
	((mframe_t *) boss2_frames_attack_pre_mg) + 6,
	((mframe_t *) boss2_frames_attack_pre_mg) + 7,
	((mframe_t *) boss2_frames_attack_pre_mg) + 8,

	(mmove_t *) &boss2_move_attack_pre_mg,

	((mframe_t *) boss2_frames_attack_mg) + 0,
	((mframe_t *) boss2_frames_attack_mg) + 1,
	((mframe_t *) boss2_frames_attack_mg) + 2,
	((mframe_t *) boss2_frames_attack_mg) + 3,
	((mframe_t *) boss2_frames_attack_mg) + 4,
	((mframe_t *) boss2_frames_attack_mg) + 5,

	(mmove_t *) &boss2_move_attack_mg,

	((mframe_t *) boss2_frames_attack_post_mg) + 0,
	((mframe_t *) boss2_frames_attack_post_mg) + 1,
	((mframe_t *) boss2_frames_attack_post_mg) + 2,
	((mframe_t *) boss2_frames_attack_post_mg) + 3,

	(mmove_t *) &boss2_move_attack_post_mg,

	((mframe_t *) boss2_frames_attack_rocket) + 0,
	((mframe_t *) boss2_frames_attack_rocket) + 1,
	((mframe_t *) boss2_frames_attack_rocket) + 2,
	((mframe_t *) boss2_frames_attack_rocket) + 3,
	((mframe_t *) boss2_frames_attack_rocket) + 4,
	((mframe_t *) boss2_frames_attack_rocket) + 5,
	((mframe_t *) boss2_frames_attack_rocket) + 6,
	((mframe_t *) boss2_frames_attack_rocket) + 7,
	((mframe_t *) boss2_frames_attack_rocket) + 8,
	((mframe_t *) boss2_frames_attack_rocket) + 9,
	((mframe_t *) boss2_frames_attack_rocket) + 10,
	((mframe_t *) boss2_frames_attack_rocket) + 11,
	((mframe_t *) boss2_frames_attack_rocket) + 12,
	((mframe_t *) boss2_frames_attack_rocket) + 13,
	((mframe_t *) boss2_frames_attack_rocket) + 14,
	((mframe_t *) boss2_frames_attack_rocket) + 15,
	((mframe_t *) boss2_frames_attack_rocket) + 16,
	((mframe_t *) boss2_frames_attack_rocket) + 17,
	((mframe_t *) boss2_frames_attack_rocket) + 18,
	((mframe_t *) boss2_frames_attack_rocket) + 19,
	((mframe_t *) boss2_frames_attack_rocket) + 20,

	(mmove_t *) &boss2_move_attack_rocket,

	((mframe_t *) boss2_frames_pain_heavy) + 0,
	((mframe_t *) boss2_frames_pain_heavy) + 1,
	((mframe_t *) boss2_frames_pain_heavy) + 2,
	((mframe_t *) boss2_frames_pain_heavy) + 3,
	((mframe_t *) boss2_frames_pain_heavy) + 4,
	((mframe_t *) boss2_frames_pain_heavy) + 5,
	((mframe_t *) boss2_frames_pain_heavy) + 6,
	((mframe_t *) boss2_frames_pain_heavy) + 7,
	((mframe_t *) boss2_frames_pain_heavy) + 8,
	((mframe_t *) boss2_frames_pain_heavy) + 9,
	((mframe_t *) boss2_frames_pain_heavy) + 10,
	((mframe_t *) boss2_frames_pain_heavy) + 11,
	((mframe_t *) boss2_frames_pain_heavy) + 12,
	((mframe_t *) boss2_frames_pain_heavy) + 13,
	((mframe_t *) boss2_frames_pain_heavy) + 14,
	((mframe_t *) boss2_frames_pain_heavy) + 15,
	((mframe_t *) boss2_frames_pain_heavy) + 16,
	((mframe_t *) boss2_frames_pain_heavy) + 17,

	(mmove_t *) &boss2_move_pain_heavy,

	((mframe_t *) boss2_frames_pain_light) + 0,
	((mframe_t *) boss2_frames_pain_light) + 1,
	((mframe_t *) boss2_frames_pain_light) + 2,
	((mframe_t *) boss2_frames_pain_light) + 3,

	(mmove_t *) &boss2_move_pain_light,

	((mframe_t *) boss2_frames_death) + 0,
	((mframe_t *) boss2_frames_death) + 1,
	((mframe_t *) boss2_frames_death) + 2,
	((mframe_t *) boss2_frames_death) + 3,
	((mframe_t *) boss2_frames_death) + 4,
	((mframe_t *) boss2_frames_death) + 5,
	((mframe_t *) boss2_frames_death) + 6,
	((mframe_t *) boss2_frames_death) + 7,
	((mframe_t *) boss2_frames_death) + 8,
	((mframe_t *) boss2_frames_death) + 9,
	((mframe_t *) boss2_frames_death) + 10,
	((mframe_t *) boss2_frames_death) + 11,
	((mframe_t *) boss2_frames_death) + 12,
	((mframe_t *) boss2_frames_death) + 13,
	((mframe_t *) boss2_frames_death) + 14,
	((mframe_t *) boss2_frames_death) + 15,
	((mframe_t *) boss2_frames_death) + 16,
	((mframe_t *) boss2_frames_death) + 17,
	((mframe_t *) boss2_frames_death) + 18,
	((mframe_t *) boss2_frames_death) + 19,
	((mframe_t *) boss2_frames_death) + 20,
	((mframe_t *) boss2_frames_death) + 21,
	((mframe_t *) boss2_frames_death) + 22,
	((mframe_t *) boss2_frames_death) + 23,
	((mframe_t *) boss2_frames_death) + 24,
	((mframe_t *) boss2_frames_death) + 25,
	((mframe_t *) boss2_frames_death) + 26,
	((mframe_t *) boss2_frames_death) + 27,
	((mframe_t *) boss2_frames_death) + 28,
	((mframe_t *) boss2_frames_death) + 29,
	((mframe_t *) boss2_frames_death) + 30,
	((mframe_t *) boss2_frames_death) + 31,
	((mframe_t *) boss2_frames_death) + 32,
	((mframe_t *) boss2_frames_death) + 33,
	((mframe_t *) boss2_frames_death) + 34,
	((mframe_t *) boss2_frames_death) + 35,
	((mframe_t *) boss2_frames_death) + 36,
	((mframe_t *) boss2_frames_death) + 37,
	((mframe_t *) boss2_frames_death) + 38,
	((mframe_t *) boss2_frames_death) + 39,
	((mframe_t *) boss2_frames_death) + 40,
	((mframe_t *) boss2_frames_death) + 41,
	((mframe_t *) boss2_frames_death) + 42,
	((mframe_t *) boss2_frames_death) + 43,
	((mframe_t *) boss2_frames_death) + 44,
	((mframe_t *) boss2_frames_death) + 45,
	((mframe_t *) boss2_frames_death) + 46,
	((mframe_t *) boss2_frames_death) + 47,
	((mframe_t *) boss2_frames_death) + 48,

	(mmove_t *) &boss2_move_death,

	((mframe_t *) jorg_frames_stand) + 0,
	((mframe_t *) jorg_frames_stand) + 1,
	((mframe_t *) jorg_frames_stand) + 2,
	((mframe_t *) jorg_frames_stand) + 3,
	((mframe_t *) jorg_frames_stand) + 4,
	((mframe_t *) jorg_frames_stand) + 5,
	((mframe_t *) jorg_frames_stand) + 6,
	((mframe_t *) jorg_frames_stand) + 7,
	((mframe_t *) jorg_frames_stand) + 8,
	((mframe_t *) jorg_frames_stand) + 9,
	((mframe_t *) jorg_frames_stand) + 10,
	((mframe_t *) jorg_frames_stand) + 11,
	((mframe_t *) jorg_frames_stand) + 12,
	((mframe_t *) jorg_frames_stand) + 13,
	((mframe_t *) jorg_frames_stand) + 14,
	((mframe_t *) jorg_frames_stand) + 15,
	((mframe_t *) jorg_frames_stand) + 16,
	((mframe_t *) jorg_frames_stand) + 17,
	((mframe_t *) jorg_frames_stand) + 18,
	((mframe_t *) jorg_frames_stand) + 19,
	((mframe_t *) jorg_frames_stand) + 20,
	((mframe_t *) jorg_frames_stand) + 21,
	((mframe_t *) jorg_frames_stand) + 22,
	((mframe_t *) jorg_frames_stand) + 23,
	((mframe_t *) jorg_frames_stand) + 24,
	((mframe_t *) jorg_frames_stand) + 25,
	((mframe_t *) jorg_frames_stand) + 26,
	((mframe_t *) jorg_frames_stand) + 27,
	((mframe_t *) jorg_frames_stand) + 28,
	((mframe_t *) jorg_frames_stand) + 29,
	((mframe_t *) jorg_frames_stand) + 30,
	((mframe_t *) jorg_frames_stand) + 31,
	((mframe_t *) jorg_frames_stand) + 32,
	((mframe_t *) jorg_frames_stand) + 33,
	((mframe_t *) jorg_frames_stand) + 34,
	((mframe_t *) jorg_frames_stand) + 35,
	((mframe_t *) jorg_frames_stand) + 36,
	((mframe_t *) jorg_frames_stand) + 37,
	((mframe_t *) jorg_frames_stand) + 38,
	((mframe_t *) jorg_frames_stand) + 39,
	((mframe_t *) jorg_frames_stand) + 40,
	((mframe_t *) jorg_frames_stand) + 41,
	((mframe_t *) jorg_frames_stand) + 42,
	((mframe_t *) jorg_frames_stand) + 43,
	((mframe_t *) jorg_frames_stand) + 44,
	((mframe_t *) jorg_frames_stand) + 45,
	((mframe_t *) jorg_frames_stand) + 46,
	((mframe_t *) jorg_frames_stand) + 47,
	((mframe_t *) jorg_frames_stand) + 48,
	((mframe_t *) jorg_frames_stand) + 49,
	((mframe_t *) jorg_frames_stand) + 50,

	(mmove_t *) &jorg_move_stand,

	((mframe_t *) jorg_frames_run) + 0,
	((mframe_t *) jorg_frames_run) + 1,
	((mframe_t *) jorg_frames_run) + 2,
	((mframe_t *) jorg_frames_run) + 3,
	((mframe_t *) jorg_frames_run) + 4,
	((mframe_t *) jorg_frames_run) + 5,
	((mframe_t *) jorg_frames_run) + 6,
	((mframe_t *) jorg_frames_run) + 7,
	((mframe_t *) jorg_frames_run) + 8,
	((mframe_t *) jorg_frames_run) + 9,
	((mframe_t *) jorg_frames_run) + 10,
	((mframe_t *) jorg_frames_run) + 11,
	((mframe_t *) jorg_frames_run) + 12,
	((mframe_t *) jorg_frames_run) + 13,

	(mmove_t *) &jorg_move_run,

	((mframe_t *) jorg_frames_start_walk) + 0,
	((mframe_t *) jorg_frames_start_walk) + 1,
	((mframe_t *) jorg_frames_start_walk) + 2,
	((mframe_t *) jorg_frames_start_walk) + 3,
	((mframe_t *) jorg_frames_start_walk) + 4,

	(mmove_t *) &jorg_move_start_walk,

	((mframe_t *) jorg_frames_walk) + 0,
	((mframe_t *) jorg_frames_walk) + 1,
	((mframe_t *) jorg_frames_walk) + 2,
	((mframe_t *) jorg_frames_walk) + 3,
	((mframe_t *) jorg_frames_walk) + 4,
	((mframe_t *) jorg_frames_walk) + 5,
	((mframe_t *) jorg_frames_walk) + 6,
	((mframe_t *) jorg_frames_walk) + 7,
	((mframe_t *) jorg_frames_walk) + 8,
	((mframe_t *) jorg_frames_walk) + 9,
	((mframe_t *) jorg_frames_walk) + 10,
	((mframe_t *) jorg_frames_walk) + 11,
	((mframe_t *) jorg_frames_walk) + 12,
	((mframe_t *) jorg_frames_walk) + 13,

	(mmove_t *) &jorg_move_walk,

	((mframe_t *) jorg_frames_end_walk) + 0,
	((mframe_t *) jorg_frames_end_walk) + 1,
	((mframe_t *) jorg_frames_end_walk) + 2,
	((mframe_t *) jorg_frames_end_walk) + 3,
	((mframe_t *) jorg_frames_end_walk) + 4,
	((mframe_t *) jorg_frames_end_walk) + 5,

	(mmove_t *) &jorg_move_end_walk,

	((mframe_t *) jorg_frames_pain3) + 0,
	((mframe_t *) jorg_frames_pain3) + 1,
	((mframe_t *) jorg_frames_pain3) + 2,
	((mframe_t *) jorg_frames_pain3) + 3,
	((mframe_t *) jorg_frames_pain3) + 4,
	((mframe_t *) jorg_frames_pain3) + 5,
	((mframe_t *) jorg_frames_pain3) + 6,
	((mframe_t *) jorg_frames_pain3) + 7,
	((mframe_t *) jorg_frames_pain3) + 8,
	((mframe_t *) jorg_frames_pain3) + 9,
	((mframe_t *) jorg_frames_pain3) + 10,
	((mframe_t *) jorg_frames_pain3) + 11,
	((mframe_t *) jorg_frames_pain3) + 12,
	((mframe_t *) jorg_frames_pain3) + 13,
	((mframe_t *) jorg_frames_pain3) + 14,
	((mframe_t *) jorg_frames_pain3) + 15,
	((mframe_t *) jorg_frames_pain3) + 16,
	((mframe_t *) jorg_frames_pain3) + 17,
	((mframe_t *) jorg_frames_pain3) + 18,
	((mframe_t *) jorg_frames_pain3) + 19,
	((mframe_t *) jorg_frames_pain3) + 20,
	((mframe_t *) jorg_frames_pain3) + 21,
	((mframe_t *) jorg_frames_pain3) + 22,
	((mframe_t *) jorg_frames_pain3) + 23,
	((mframe_t *) jorg_frames_pain3) + 24,

	(mmove_t *) &jorg_move_pain3,

	((mframe_t *) jorg_frames_pain2) + 0,
	((mframe_t *) jorg_frames_pain2) + 1,
	((mframe_t *) jorg_frames_pain2) + 2,

	(mmove_t *) &jorg_move_pain2,

	((mframe_t *) jorg_frames_pain1) + 0,
	((mframe_t *) jorg_frames_pain1) + 1,
	((mframe_t *) jorg_frames_pain1) + 2,

	(mmove_t *) &jorg_move_pain1,

	((mframe_t *) jorg_frames_death1) + 0,
	((mframe_t *) jorg_frames_death1) + 1,
	((mframe_t *) jorg_frames_death1) + 2,
	((mframe_t *) jorg_frames_death1) + 3,
	((mframe_t *) jorg_frames_death1) + 4,
	((mframe_t *) jorg_frames_death1) + 5,
	((mframe_t *) jorg_frames_death1) + 6,
	((mframe_t *) jorg_frames_death1) + 7,
	((mframe_t *) jorg_frames_death1) + 8,
	((mframe_t *) jorg_frames_death1) + 9,
	((mframe_t *) jorg_frames_death1) + 10,
	((mframe_t *) jorg_frames_death1) + 11,
	((mframe_t *) jorg_frames_death1) + 12,
	((mframe_t *) jorg_frames_death1) + 13,
	((mframe_t *) jorg_frames_death1) + 14,
	((mframe_t *) jorg_frames_death1) + 15,
	((mframe_t *) jorg_frames_death1) + 16,
	((mframe_t *) jorg_frames_death1) + 17,
	((mframe_t *) jorg_frames_death1) + 18,
	((mframe_t *) jorg_frames_death1) + 19,
	((mframe_t *) jorg_frames_death1) + 20,
	((mframe_t *) jorg_frames_death1) + 21,
	((mframe_t *) jorg_frames_death1) + 22,
	((mframe_t *) jorg_frames_death1) + 23,
	((mframe_t *) jorg_frames_death1) + 24,
	((mframe_t *) jorg_frames_death1) + 25,
	((mframe_t *) jorg_frames_death1) + 26,
	((mframe_t *) jorg_frames_death1) + 27,
	((mframe_t *) jorg_frames_death1) + 28,
	((mframe_t *) jorg_frames_death1) + 29,
	((mframe_t *) jorg_frames_death1) + 30,
	((mframe_t *) jorg_frames_death1) + 31,
	((mframe_t *) jorg_frames_death1) + 32,
	((mframe_t *) jorg_frames_death1) + 33,
	((mframe_t *) jorg_frames_death1) + 34,
	((mframe_t *) jorg_frames_death1) + 35,
	((mframe_t *) jorg_frames_death1) + 36,
	((mframe_t *) jorg_frames_death1) + 37,
	((mframe_t *) jorg_frames_death1) + 38,
	((mframe_t *) jorg_frames_death1) + 39,
	((mframe_t *) jorg_frames_death1) + 40,
	((mframe_t *) jorg_frames_death1) + 41,
	((mframe_t *) jorg_frames_death1) + 42,
	((mframe_t *) jorg_frames_death1) + 43,
	((mframe_t *) jorg_frames_death1) + 44,
	((mframe_t *) jorg_frames_death1) + 45,
	((mframe_t *) jorg_frames_death1) + 46,
	((mframe_t *) jorg_frames_death1) + 47,
	((mframe_t *) jorg_frames_death1) + 48,
	((mframe_t *) jorg_frames_death1) + 49,

	(mmove_t *) &jorg_move_death,

	((mframe_t *) jorg_frames_attack2) + 0,
	((mframe_t *) jorg_frames_attack2) + 1,
	((mframe_t *) jorg_frames_attack2) + 2,
	((mframe_t *) jorg_frames_attack2) + 3,
	((mframe_t *) jorg_frames_attack2) + 4,
	((mframe_t *) jorg_frames_attack2) + 5,
	((mframe_t *) jorg_frames_attack2) + 6,
	((mframe_t *) jorg_frames_attack2) + 7,
	((mframe_t *) jorg_frames_attack2) + 8,
	((mframe_t *) jorg_frames_attack2) + 9,
	((mframe_t *) jorg_frames_attack2) + 10,
	((mframe_t *) jorg_frames_attack2) + 11,
	((mframe_t *) jorg_frames_attack2) + 12,

	(mmove_t *) &jorg_move_attack2,

	((mframe_t *) jorg_frames_start_attack1) + 0,
	((mframe_t *) jorg_frames_start_attack1) + 1,
	((mframe_t *) jorg_frames_start_attack1) + 2,
	((mframe_t *) jorg_frames_start_attack1) + 3,
	((mframe_t *) jorg_frames_start_attack1) + 4,
	((mframe_t *) jorg_frames_start_attack1) + 5,
	((mframe_t *) jorg_frames_start_attack1) + 6,
	((mframe_t *) jorg_frames_start_attack1) + 7,

	(mmove_t *) &jorg_move_start_attack1,

	((mframe_t *) jorg_frames_attack1) + 0,
	((mframe_t *) jorg_frames_attack1) + 1,
	((mframe_t *) jorg_frames_attack1) + 2,
	((mframe_t *) jorg_frames_attack1) + 3,
	((mframe_t *) jorg_frames_attack1) + 4,
	((mframe_t *) jorg_frames_attack1) + 5,

	(mmove_t *) &jorg_move_attack1,

	((mframe_t *) jorg_frames_end_attack1) + 0,
	((mframe_t *) jorg_frames_end_attack1) + 1,
	((mframe_t *) jorg_frames_end_attack1) + 2,
	((mframe_t *) jorg_frames_end_attack1) + 3,

	(mmove_t *) &jorg_move_end_attack1,

	((mframe_t *) makron_frames_stand) + 0,
	((mframe_t *) makron_frames_stand) + 1,
	((mframe_t *) makron_frames_stand) + 2,
	((mframe_t *) makron_frames_stand) + 3,
	((mframe_t *) makron_frames_stand) + 4,
	((mframe_t *) makron_frames_stand) + 5,
	((mframe_t *) makron_frames_stand) + 6,
	((mframe_t *) makron_frames_stand) + 7,
	((mframe_t *) makron_frames_stand) + 8,
	((mframe_t *) makron_frames_stand) + 9,
	((mframe_t *) makron_frames_stand) + 10,
	((mframe_t *) makron_frames_stand) + 11,
	((mframe_t *) makron_frames_stand) + 12,
	((mframe_t *) makron_frames_stand) + 13,
	((mframe_t *) makron_frames_stand) + 14,
	((mframe_t *) makron_frames_stand) + 15,
	((mframe_t *) makron_frames_stand) + 16,
	((mframe_t *) makron_frames_stand) + 17,
	((mframe_t *) makron_frames_stand) + 18,
	((mframe_t *) makron_frames_stand) + 19,
	((mframe_t *) makron_frames_stand) + 20,
	((mframe_t *) makron_frames_stand) + 21,
	((mframe_t *) makron_frames_stand) + 22,
	((mframe_t *) makron_frames_stand) + 23,
	((mframe_t *) makron_frames_stand) + 24,
	((mframe_t *) makron_frames_stand) + 25,
	((mframe_t *) makron_frames_stand) + 26,
	((mframe_t *) makron_frames_stand) + 27,
	((mframe_t *) makron_frames_stand) + 28,
	((mframe_t *) makron_frames_stand) + 29,
	((mframe_t *) makron_frames_stand) + 30,
	((mframe_t *) makron_frames_stand) + 31,
	((mframe_t *) makron_frames_stand) + 32,
	((mframe_t *) makron_frames_stand) + 33,
	((mframe_t *) makron_frames_stand) + 34,
	((mframe_t *) makron_frames_stand) + 35,
	((mframe_t *) makron_frames_stand) + 36,
	((mframe_t *) makron_frames_stand) + 37,
	((mframe_t *) makron_frames_stand) + 38,
	((mframe_t *) makron_frames_stand) + 39,
	((mframe_t *) makron_frames_stand) + 40,
	((mframe_t *) makron_frames_stand) + 41,
	((mframe_t *) makron_frames_stand) + 42,
	((mframe_t *) makron_frames_stand) + 43,
	((mframe_t *) makron_frames_stand) + 44,
	((mframe_t *) makron_frames_stand) + 45,
	((mframe_t *) makron_frames_stand) + 46,
	((mframe_t *) makron_frames_stand) + 47,
	((mframe_t *) makron_frames_stand) + 48,
	((mframe_t *) makron_frames_stand) + 49,
	((mframe_t *) makron_frames_stand) + 50,
	((mframe_t *) makron_frames_stand) + 51,
	((mframe_t *) makron_frames_stand) + 52,
	((mframe_t *) makron_frames_stand) + 53,
	((mframe_t *) makron_frames_stand) + 54,
	((mframe_t *) makron_frames_stand) + 55,
	((mframe_t *) makron_frames_stand) + 56,
	((mframe_t *) makron_frames_stand) + 57,
	((mframe_t *) makron_frames_stand) + 58,
	((mframe_t *) makron_frames_stand) + 59,

	(mmove_t *) &makron_move_stand,

	((mframe_t *) makron_frames_run) + 0,
	((mframe_t *) makron_frames_run) + 1,
	((mframe_t *) makron_frames_run) + 2,
	((mframe_t *) makron_frames_run) + 3,
	((mframe_t *) makron_frames_run) + 4,
	((mframe_t *) makron_frames_run) + 5,
	((mframe_t *) makron_frames_run) + 6,
	((mframe_t *) makron_frames_run) + 7,
	((mframe_t *) makron_frames_run) + 8,
	((mframe_t *) makron_frames_run) + 9,

	(mmove_t *) &makron_move_run,

	((mframe_t *) makron_frames_walk) + 0,
	((mframe_t *) makron_frames_walk) + 1,
	((mframe_t *) makron_frames_walk) + 2,
	((mframe_t *) makron_frames_walk) + 3,
	((mframe_t *) makron_frames_walk) + 4,
	((mframe_t *) makron_frames_walk) + 5,
	((mframe_t *) makron_frames_walk) + 6,
	((mframe_t *) makron_frames_walk) + 7,
	((mframe_t *) makron_frames_walk) + 8,
	((mframe_t *) makron_frames_walk) + 9,

	(mmove_t *) &makron_move_walk,

	((mframe_t *) makron_frames_pain6) + 0,
	((mframe_t *) makron_frames_pain6) + 1,
	((mframe_t *) makron_frames_pain6) + 2,
	((mframe_t *) makron_frames_pain6) + 3,
	((mframe_t *) makron_frames_pain6) + 4,
	((mframe_t *) makron_frames_pain6) + 5,
	((mframe_t *) makron_frames_pain6) + 6,
	((mframe_t *) makron_frames_pain6) + 7,
	((mframe_t *) makron_frames_pain6) + 8,
	((mframe_t *) makron_frames_pain6) + 9,
	((mframe_t *) makron_frames_pain6) + 10,
	((mframe_t *) makron_frames_pain6) + 11,
	((mframe_t *) makron_frames_pain6) + 12,
	((mframe_t *) makron_frames_pain6) + 13,
	((mframe_t *) makron_frames_pain6) + 14,
	((mframe_t *) makron_frames_pain6) + 15,
	((mframe_t *) makron_frames_pain6) + 16,
	((mframe_t *) makron_frames_pain6) + 17,
	((mframe_t *) makron_frames_pain6) + 18,
	((mframe_t *) makron_frames_pain6) + 19,
	((mframe_t *) makron_frames_pain6) + 20,
	((mframe_t *) makron_frames_pain6) + 21,
	((mframe_t *) makron_frames_pain6) + 22,
	((mframe_t *) makron_frames_pain6) + 23,
	((mframe_t *) makron_frames_pain6) + 24,
	((mframe_t *) makron_frames_pain6) + 25,
	((mframe_t *) makron_frames_pain6) + 26,

	(mmove_t *) &makron_move_pain6,

	((mframe_t *) makron_frames_pain5) + 0,
	((mframe_t *) makron_frames_pain5) + 1,
	((mframe_t *) makron_frames_pain5) + 2,
	((mframe_t *) makron_frames_pain5) + 3,

	(mmove_t *) &makron_move_pain5,

	((mframe_t *) makron_frames_pain4) + 0,
	((mframe_t *) makron_frames_pain4) + 1,
	((mframe_t *) makron_frames_pain4) + 2,
	((mframe_t *) makron_frames_pain4) + 3,

	(mmove_t *) &makron_move_pain4,

	((mframe_t *) makron_frames_death2) + 0,
	((mframe_t *) makron_frames_death2) + 1,
	((mframe_t *) makron_frames_death2) + 2,
	((mframe_t *) makron_frames_death2) + 3,
	((mframe_t *) makron_frames_death2) + 4,
	((mframe_t *) makron_frames_death2) + 5,
	((mframe_t *) makron_frames_death2) + 6,
	((mframe_t *) makron_frames_death2) + 7,
	((mframe_t *) makron_frames_death2) + 8,
	((mframe_t *) makron_frames_death2) + 9,
	((mframe_t *) makron_frames_death2) + 10,
	((mframe_t *) makron_frames_death2) + 11,
	((mframe_t *) makron_frames_death2) + 12,
	((mframe_t *) makron_frames_death2) + 13,
	((mframe_t *) makron_frames_death2) + 14,
	((mframe_t *) makron_frames_death2) + 15,
	((mframe_t *) makron_frames_death2) + 16,
	((mframe_t *) makron_frames_death2) + 17,
	((mframe_t *) makron_frames_death2) + 18,
	((mframe_t *) makron_frames_death2) + 19,
	((mframe_t *) makron_frames_death2) + 20,
	((mframe_t *) makron_frames_death2) + 21,
	((mframe_t *) makron_frames_death2) + 22,
	((mframe_t *) makron_frames_death2) + 23,
	((mframe_t *) makron_frames_death2) + 24,
	((mframe_t *) makron_frames_death2) + 25,
	((mframe_t *) makron_frames_death2) + 26,
	((mframe_t *) makron_frames_death2) + 27,
	((mframe_t *) makron_frames_death2) + 28,
	((mframe_t *) makron_frames_death2) + 29,
	((mframe_t *) makron_frames_death2) + 30,
	((mframe_t *) makron_frames_death2) + 31,
	((mframe_t *) makron_frames_death2) + 32,
	((mframe_t *) makron_frames_death2) + 33,
	((mframe_t *) makron_frames_death2) + 34,
	((mframe_t *) makron_frames_death2) + 35,
	((mframe_t *) makron_frames_death2) + 36,
	((mframe_t *) makron_frames_death2) + 37,
	((mframe_t *) makron_frames_death2) + 38,
	((mframe_t *) makron_frames_death2) + 39,
	((mframe_t *) makron_frames_death2) + 40,
	((mframe_t *) makron_frames_death2) + 41,
	((mframe_t *) makron_frames_death2) + 42,
	((mframe_t *) makron_frames_death2) + 43,
	((mframe_t *) makron_frames_death2) + 44,
	((mframe_t *) makron_frames_death2) + 45,
	((mframe_t *) makron_frames_death2) + 46,
	((mframe_t *) makron_frames_death2) + 47,
	((mframe_t *) makron_frames_death2) + 48,
	((mframe_t *) makron_frames_death2) + 49,
	((mframe_t *) makron_frames_death2) + 50,
	((mframe_t *) makron_frames_death2) + 51,
	((mframe_t *) makron_frames_death2) + 52,
	((mframe_t *) makron_frames_death2) + 53,
	((mframe_t *) makron_frames_death2) + 54,
	((mframe_t *) makron_frames_death2) + 55,
	((mframe_t *) makron_frames_death2) + 56,
	((mframe_t *) makron_frames_death2) + 57,
	((mframe_t *) makron_frames_death2) + 58,
	((mframe_t *) makron_frames_death2) + 59,
	((mframe_t *) makron_frames_death2) + 60,
	((mframe_t *) makron_frames_death2) + 61,
	((mframe_t *) makron_frames_death2) + 62,
	((mframe_t *) makron_frames_death2) + 63,
	((mframe_t *) makron_frames_death2) + 64,
	((mframe_t *) makron_frames_death2) + 65,
	((mframe_t *) makron_frames_death2) + 66,
	((mframe_t *) makron_frames_death2) + 67,
	((mframe_t *) makron_frames_death2) + 68,
	((mframe_t *) makron_frames_death2) + 69,
	((mframe_t *) makron_frames_death2) + 70,
	((mframe_t *) makron_frames_death2) + 71,
	((mframe_t *) makron_frames_death2) + 72,
	((mframe_t *) makron_frames_death2) + 73,
	((mframe_t *) makron_frames_death2) + 74,
	((mframe_t *) makron_frames_death2) + 75,
	((mframe_t *) makron_frames_death2) + 76,
	((mframe_t *) makron_frames_death2) + 77,
	((mframe_t *) makron_frames_death2) + 78,
	((mframe_t *) makron_frames_death2) + 79,
	((mframe_t *) makron_frames_death2) + 80,
	((mframe_t *) makron_frames_death2) + 81,
	((mframe_t *) makron_frames_death2) + 82,
	((mframe_t *) makron_frames_death2) + 83,
	((mframe_t *) makron_frames_death2) + 84,
	((mframe_t *) makron_frames_death2) + 85,
	((mframe_t *) makron_frames_death2) + 86,
	((mframe_t *) makron_frames_death2) + 87,
	((mframe_t *) makron_frames_death2) + 88,
	((mframe_t *) makron_frames_death2) + 89,
	((mframe_t *) makron_frames_death2) + 90,
	((mframe_t *) makron_frames_death2) + 91,
	((mframe_t *) makron_frames_death2) + 92,
	((mframe_t *) makron_frames_death2) + 93,
	((mframe_t *) makron_frames_death2) + 94,

	(mmove_t *) &makron_move_death2,

	((mframe_t *) makron_frames_death3) + 0,
	((mframe_t *) makron_frames_death3) + 1,
	((mframe_t *) makron_frames_death3) + 2,
	((mframe_t *) makron_frames_death3) + 3,
	((mframe_t *) makron_frames_death3) + 4,
	((mframe_t *) makron_frames_death3) + 5,
	((mframe_t *) makron_frames_death3) + 6,
	((mframe_t *) makron_frames_death3) + 7,
	((mframe_t *) makron_frames_death3) + 8,
	((mframe_t *) makron_frames_death3) + 9,
	((mframe_t *) makron_frames_death3) + 10,
	((mframe_t *) makron_frames_death3) + 11,
	((mframe_t *) makron_frames_death3) + 12,
	((mframe_t *) makron_frames_death3) + 13,
	((mframe_t *) makron_frames_death3) + 14,
	((mframe_t *) makron_frames_death3) + 15,
	((mframe_t *) makron_frames_death3) + 16,
	((mframe_t *) makron_frames_death3) + 17,
	((mframe_t *) makron_frames_death3) + 18,
	((mframe_t *) makron_frames_death3) + 19,

	(mmove_t *) &makron_move_death3,

	((mframe_t *) makron_frames_sight) + 0,
	((mframe_t *) makron_frames_sight) + 1,
	((mframe_t *) makron_frames_sight) + 2,
	((mframe_t *) makron_frames_sight) + 3,
	((mframe_t *) makron_frames_sight) + 4,
	((mframe_t *) makron_frames_sight) + 5,
	((mframe_t *) makron_frames_sight) + 6,
	((mframe_t *) makron_frames_sight) + 7,
	((mframe_t *) makron_frames_sight) + 8,
	((mframe_t *) makron_frames_sight) + 9,
	((mframe_t *) makron_frames_sight) + 10,
	((mframe_t *) makron_frames_sight) + 11,
	((mframe_t *) makron_frames_sight) + 12,

	(mmove_t *) &makron_move_sight,

	((mframe_t *) makron_frames_attack3) + 0,
	((mframe_t *) makron_frames_attack3) + 1,
	((mframe_t *) makron_frames_attack3) + 2,
	((mframe_t *) makron_frames_attack3) + 3,
	((mframe_t *) makron_frames_attack3) + 4,
	((mframe_t *) makron_frames_attack3) + 5,
	((mframe_t *) makron_frames_attack3) + 6,
	((mframe_t *) makron_frames_attack3) + 7,

	(mmove_t *) &makron_move_attack3,

	((mframe_t *) makron_frames_attack4) + 0,
	((mframe_t *) makron_frames_attack4) + 1,
	((mframe_t *) makron_frames_attack4) + 2,
	((mframe_t *) makron_frames_attack4) + 3,
	((mframe_t *) makron_frames_attack4) + 4,
	((mframe_t *) makron_frames_attack4) + 5,
	((mframe_t *) makron_frames_attack4) + 6,
	((mframe_t *) makron_frames_attack4) + 7,
	((mframe_t *) makron_frames_attack4) + 8,
	((mframe_t *) makron_frames_attack4) + 9,
	((mframe_t *) makron_frames_attack4) + 10,
	((mframe_t *) makron_frames_attack4) + 11,
	((mframe_t *) makron_frames_attack4) + 12,
	((mframe_t *) makron_frames_attack4) + 13,
	((mframe_t *) makron_frames_attack4) + 14,
	((mframe_t *) makron_frames_attack4) + 15,
	((mframe_t *) makron_frames_attack4) + 16,
	((mframe_t *) makron_frames_attack4) + 17,
	((mframe_t *) makron_frames_attack4) + 18,
	((mframe_t *) makron_frames_attack4) + 19,
	((mframe_t *) makron_frames_attack4) + 20,
	((mframe_t *) makron_frames_attack4) + 21,
	((mframe_t *) makron_frames_attack4) + 22,
	((mframe_t *) makron_frames_attack4) + 23,
	((mframe_t *) makron_frames_attack4) + 24,
	((mframe_t *) makron_frames_attack4) + 25,

	(mmove_t *) &makron_move_attack4,

	((mframe_t *) makron_frames_attack5) + 0,
	((mframe_t *) makron_frames_attack5) + 1,
	((mframe_t *) makron_frames_attack5) + 2,
	((mframe_t *) makron_frames_attack5) + 3,
	((mframe_t *) makron_frames_attack5) + 4,
	((mframe_t *) makron_frames_attack5) + 5,
	((mframe_t *) makron_frames_attack5) + 6,
	((mframe_t *) makron_frames_attack5) + 7,
	((mframe_t *) makron_frames_attack5) + 8,
	((mframe_t *) makron_frames_attack5) + 9,
	((mframe_t *) makron_frames_attack5) + 10,
	((mframe_t *) makron_frames_attack5) + 11,
	((mframe_t *) makron_frames_attack5) + 12,
	((mframe_t *) makron_frames_attack5) + 13,
	((mframe_t *) makron_frames_attack5) + 14,
	((mframe_t *) makron_frames_attack5) + 15,

	(mmove_t *) &makron_move_attack5,

	((mframe_t *) brain_frames_stand) + 0,
	((mframe_t *) brain_frames_stand) + 1,
	((mframe_t *) brain_frames_stand) + 2,
	((mframe_t *) brain_frames_stand) + 3,
	((mframe_t *) brain_frames_stand) + 4,
	((mframe_t *) brain_frames_stand) + 5,
	((mframe_t *) brain_frames_stand) + 6,
	((mframe_t *) brain_frames_stand) + 7,
	((mframe_t *) brain_frames_stand) + 8,
	((mframe_t *) brain_frames_stand) + 9,
	((mframe_t *) brain_frames_stand) + 10,
	((mframe_t *) brain_frames_stand) + 11,
	((mframe_t *) brain_frames_stand) + 12,
	((mframe_t *) brain_frames_stand) + 13,
	((mframe_t *) brain_frames_stand) + 14,
	((mframe_t *) brain_frames_stand) + 15,
	((mframe_t *) brain_frames_stand) + 16,
	((mframe_t *) brain_frames_stand) + 17,
	((mframe_t *) brain_frames_stand) + 18,
	((mframe_t *) brain_frames_stand) + 19,
	((mframe_t *) brain_frames_stand) + 20,
	((mframe_t *) brain_frames_stand) + 21,
	((mframe_t *) brain_frames_stand) + 22,
	((mframe_t *) brain_frames_stand) + 23,
	((mframe_t *) brain_frames_stand) + 24,
	((mframe_t *) brain_frames_stand) + 25,
	((mframe_t *) brain_frames_stand) + 26,
	((mframe_t *) brain_frames_stand) + 27,
	((mframe_t *) brain_frames_stand) + 28,
	((mframe_t *) brain_frames_stand) + 29,

	(mmove_t *) &brain_move_stand,

	((mframe_t *) brain_frames_idle) + 0,
	((mframe_t *) brain_frames_idle) + 1,
	((mframe_t *) brain_frames_idle) + 2,
	((mframe_t *) brain_frames_idle) + 3,
	((mframe_t *) brain_frames_idle) + 4,
	((mframe_t *) brain_frames_idle) + 5,
	((mframe_t *) brain_frames_idle) + 6,
	((mframe_t *) brain_frames_idle) + 7,
	((mframe_t *) brain_frames_idle) + 8,
	((mframe_t *) brain_frames_idle) + 9,
	((mframe_t *) brain_frames_idle) + 10,
	((mframe_t *) brain_frames_idle) + 11,
	((mframe_t *) brain_frames_idle) + 12,
	((mframe_t *) brain_frames_idle) + 13,
	((mframe_t *) brain_frames_idle) + 14,
	((mframe_t *) brain_frames_idle) + 15,
	((mframe_t *) brain_frames_idle) + 16,
	((mframe_t *) brain_frames_idle) + 17,
	((mframe_t *) brain_frames_idle) + 18,
	((mframe_t *) brain_frames_idle) + 19,
	((mframe_t *) brain_frames_idle) + 20,
	((mframe_t *) brain_frames_idle) + 21,
	((mframe_t *) brain_frames_idle) + 22,
	((mframe_t *) brain_frames_idle) + 23,
	((mframe_t *) brain_frames_idle) + 24,
	((mframe_t *) brain_frames_idle) + 25,
	((mframe_t *) brain_frames_idle) + 26,
	((mframe_t *) brain_frames_idle) + 27,
	((mframe_t *) brain_frames_idle) + 28,
	((mframe_t *) brain_frames_idle) + 29,

	(mmove_t *) &brain_move_idle,

	((mframe_t *) brain_frames_walk1) + 0,
	((mframe_t *) brain_frames_walk1) + 1,
	((mframe_t *) brain_frames_walk1) + 2,
	((mframe_t *) brain_frames_walk1) + 3,
	((mframe_t *) brain_frames_walk1) + 4,
	((mframe_t *) brain_frames_walk1) + 5,
	((mframe_t *) brain_frames_walk1) + 6,
	((mframe_t *) brain_frames_walk1) + 7,
	((mframe_t *) brain_frames_walk1) + 8,
	((mframe_t *) brain_frames_walk1) + 9,
	((mframe_t *) brain_frames_walk1) + 10,

	(mmove_t *) &brain_move_walk1,

	((mframe_t *) brain_frames_defense) + 0,
	((mframe_t *) brain_frames_defense) + 1,
	((mframe_t *) brain_frames_defense) + 2,
	((mframe_t *) brain_frames_defense) + 3,
	((mframe_t *) brain_frames_defense) + 4,
	((mframe_t *) brain_frames_defense) + 5,
	((mframe_t *) brain_frames_defense) + 6,
	((mframe_t *) brain_frames_defense) + 7,
	((mframe_t *) brain_frames_defense) + 8,

	(mmove_t *) &brain_move_defense,

	((mframe_t *) brain_frames_pain3) + 0,
	((mframe_t *) brain_frames_pain3) + 1,
	((mframe_t *) brain_frames_pain3) + 2,
	((mframe_t *) brain_frames_pain3) + 3,
	((mframe_t *) brain_frames_pain3) + 4,
	((mframe_t *) brain_frames_pain3) + 5,

	(mmove_t *) &brain_move_pain3,

	((mframe_t *) brain_frames_pain2) + 0,
	((mframe_t *) brain_frames_pain2) + 1,
	((mframe_t *) brain_frames_pain2) + 2,
	((mframe_t *) brain_frames_pain2) + 3,
	((mframe_t *) brain_frames_pain2) + 4,
	((mframe_t *) brain_frames_pain2) + 5,
	((mframe_t *) brain_frames_pain2) + 6,
	((mframe_t *) brain_frames_pain2) + 7,

	(mmove_t *) &brain_move_pain2,

	((mframe_t *) brain_frames_pain1) + 0,
	((mframe_t *) brain_frames_pain1) + 1,
	((mframe_t *) brain_frames_pain1) + 2,
	((mframe_t *) brain_frames_pain1) + 3,
	((mframe_t *) brain_frames_pain1) + 4,
	((mframe_t *) brain_frames_pain1) + 5,
	((mframe_t *) brain_frames_pain1) + 6,
	((mframe_t *) brain_frames_pain1) + 7,
	((mframe_t *) brain_frames_pain1) + 8,
	((mframe_t *) brain_frames_pain1) + 9,
	((mframe_t *) brain_frames_pain1) + 10,
	((mframe_t *) brain_frames_pain1) + 11,
	((mframe_t *) brain_frames_pain1) + 12,
	((mframe_t *) brain_frames_pain1) + 13,
	((mframe_t *) brain_frames_pain1) + 14,
	((mframe_t *) brain_frames_pain1) + 15,
	((mframe_t *) brain_frames_pain1) + 16,
	((mframe_t *) brain_frames_pain1) + 17,
	((mframe_t *) brain_frames_pain1) + 18,
	((mframe_t *) brain_frames_pain1) + 19,
	((mframe_t *) brain_frames_pain1) + 20,

	(mmove_t *) &brain_move_pain1,

	((mframe_t *) brain_frames_duck) + 0,
	((mframe_t *) brain_frames_duck) + 1,
	((mframe_t *) brain_frames_duck) + 2,
	((mframe_t *) brain_frames_duck) + 3,
	((mframe_t *) brain_frames_duck) + 4,
	((mframe_t *) brain_frames_duck) + 5,
	((mframe_t *) brain_frames_duck) + 6,
	((mframe_t *) brain_frames_duck) + 7,

	(mmove_t *) &brain_move_duck,

	((mframe_t *) brain_frames_death2) + 0,
	((mframe_t *) brain_frames_death2) + 1,
	((mframe_t *) brain_frames_death2) + 2,
	((mframe_t *) brain_frames_death2) + 3,
	((mframe_t *) brain_frames_death2) + 4,

	(mmove_t *) &brain_move_death2,

	((mframe_t *) brain_frames_death1) + 0,
	((mframe_t *) brain_frames_death1) + 1,
	((mframe_t *) brain_frames_death1) + 2,
	((mframe_t *) brain_frames_death1) + 3,
	((mframe_t *) brain_frames_death1) + 4,
	((mframe_t *) brain_frames_death1) + 5,
	((mframe_t *) brain_frames_death1) + 6,
	((mframe_t *) brain_frames_death1) + 7,
	((mframe_t *) brain_frames_death1) + 8,
	((mframe_t *) brain_frames_death1) + 9,
	((mframe_t *) brain_frames_death1) + 10,
	((mframe_t *) brain_frames_death1) + 11,
	((mframe_t *) brain_frames_death1) + 12,
	((mframe_t *) brain_frames_death1) + 13,
	((mframe_t *) brain_frames_death1) + 14,
	((mframe_t *) brain_frames_death1) + 15,
	((mframe_t *) brain_frames_death1) + 16,
	((mframe_t *) brain_frames_death1) + 17,

	(mmove_t *) &brain_move_death1,

	((mframe_t *) brain_frames_attack1) + 0,
	((mframe_t *) brain_frames_attack1) + 1,
	((mframe_t *) brain_frames_attack1) + 2,
	((mframe_t *) brain_frames_attack1) + 3,
	((mframe_t *) brain_frames_attack1) + 4,
	((mframe_t *) brain_frames_attack1) + 5,
	((mframe_t *) brain_frames_attack1) + 6,
	((mframe_t *) brain_frames_attack1) + 7,
	((mframe_t *) brain_frames_attack1) + 8,
	((mframe_t *) brain_frames_attack1) + 9,
	((mframe_t *) brain_frames_attack1) + 10,
	((mframe_t *) brain_frames_attack1) + 11,
	((mframe_t *) brain_frames_attack1) + 12,
	((mframe_t *) brain_frames_attack1) + 13,
	((mframe_t *) brain_frames_attack1) + 14,
	((mframe_t *) brain_frames_attack1) + 15,
	((mframe_t *) brain_frames_attack1) + 16,
	((mframe_t *) brain_frames_attack1) + 17,

	(mmove_t *) &brain_move_attack1,

	((mframe_t *) brain_frames_attack2) + 0,
	((mframe_t *) brain_frames_attack2) + 1,
	((mframe_t *) brain_frames_attack2) + 2,
	((mframe_t *) brain_frames_attack2) + 3,
	((mframe_t *) brain_frames_attack2) + 4,
	((mframe_t *) brain_frames_attack2) + 5,
	((mframe_t *) brain_frames_attack2) + 6,
	((mframe_t *) brain_frames_attack2) + 7,
	((mframe_t *) brain_frames_attack2) + 8,
	((mframe_t *) brain_frames_attack2) + 9,
	((mframe_t *) brain_frames_attack2) + 10,
	((mframe_t *) brain_frames_attack2) + 11,
	((mframe_t *) brain_frames_attack2) + 12,
	((mframe_t *) brain_frames_attack2) + 13,
	((mframe_t *) brain_frames_attack2) + 14,
	((mframe_t *) brain_frames_attack2) + 15,
	((mframe_t *) brain_frames_attack2) + 16,

	(mmove_t *) &brain_move_attack2,

	((mframe_t *) brain_frames_run) + 0,
	((mframe_t *) brain_frames_run) + 1,
	((mframe_t *) brain_frames_run) + 2,
	((mframe_t *) brain_frames_run) + 3,
	((mframe_t *) brain_frames_run) + 4,
	((mframe_t *) brain_frames_run) + 5,
	((mframe_t *) brain_frames_run) + 6,
	((mframe_t *) brain_frames_run) + 7,
	((mframe_t *) brain_frames_run) + 8,
	((mframe_t *) brain_frames_run) + 9,
	((mframe_t *) brain_frames_run) + 10,

	(mmove_t *) &brain_move_run,

	((mframe_t *) chick_frames_fidget) + 0,
	((mframe_t *) chick_frames_fidget) + 1,
	((mframe_t *) chick_frames_fidget) + 2,
	((mframe_t *) chick_frames_fidget) + 3,
	((mframe_t *) chick_frames_fidget) + 4,
	((mframe_t *) chick_frames_fidget) + 5,
	((mframe_t *) chick_frames_fidget) + 6,
	((mframe_t *) chick_frames_fidget) + 7,
	((mframe_t *) chick_frames_fidget) + 8,
	((mframe_t *) chick_frames_fidget) + 9,
	((mframe_t *) chick_frames_fidget) + 10,
	((mframe_t *) chick_frames_fidget) + 11,
	((mframe_t *) chick_frames_fidget) + 12,
	((mframe_t *) chick_frames_fidget) + 13,
	((mframe_t *) chick_frames_fidget) + 14,
	((mframe_t *) chick_frames_fidget) + 15,
	((mframe_t *) chick_frames_fidget) + 16,
	((mframe_t *) chick_frames_fidget) + 17,
	((mframe_t *) chick_frames_fidget) + 18,
	((mframe_t *) chick_frames_fidget) + 19,
	((mframe_t *) chick_frames_fidget) + 20,
	((mframe_t *) chick_frames_fidget) + 21,
	((mframe_t *) chick_frames_fidget) + 22,
	((mframe_t *) chick_frames_fidget) + 23,
	((mframe_t *) chick_frames_fidget) + 24,
	((mframe_t *) chick_frames_fidget) + 25,
	((mframe_t *) chick_frames_fidget) + 26,
	((mframe_t *) chick_frames_fidget) + 27,
	((mframe_t *) chick_frames_fidget) + 28,
	((mframe_t *) chick_frames_fidget) + 29,

	(mmove_t *) &chick_move_fidget,

	((mframe_t *) chick_frames_stand) + 0,
	((mframe_t *) chick_frames_stand) + 1,
	((mframe_t *) chick_frames_stand) + 2,
	((mframe_t *) chick_frames_stand) + 3,
	((mframe_t *) chick_frames_stand) + 4,
	((mframe_t *) chick_frames_stand) + 5,
	((mframe_t *) chick_frames_stand) + 6,
	((mframe_t *) chick_frames_stand) + 7,
	((mframe_t *) chick_frames_stand) + 8,
	((mframe_t *) chick_frames_stand) + 9,
	((mframe_t *) chick_frames_stand) + 10,
	((mframe_t *) chick_frames_stand) + 11,
	((mframe_t *) chick_frames_stand) + 12,
	((mframe_t *) chick_frames_stand) + 13,
	((mframe_t *) chick_frames_stand) + 14,
	((mframe_t *) chick_frames_stand) + 15,
	((mframe_t *) chick_frames_stand) + 16,
	((mframe_t *) chick_frames_stand) + 17,
	((mframe_t *) chick_frames_stand) + 18,
	((mframe_t *) chick_frames_stand) + 19,
	((mframe_t *) chick_frames_stand) + 20,
	((mframe_t *) chick_frames_stand) + 21,
	((mframe_t *) chick_frames_stand) + 22,
	((mframe_t *) chick_frames_stand) + 23,
	((mframe_t *) chick_frames_stand) + 24,
	((mframe_t *) chick_frames_stand) + 25,
	((mframe_t *) chick_frames_stand) + 26,
	((mframe_t *) chick_frames_stand) + 27,
	((mframe_t *) chick_frames_stand) + 28,
	((mframe_t *) chick_frames_stand) + 29,

	(mmove_t *) &chick_move_stand,

	((mframe_t *) chick_frames_start_run) + 0,
	((mframe_t *) chick_frames_start_run) + 1,
	((mframe_t *) chick_frames_start_run) + 2,
	((mframe_t *) chick_frames_start_run) + 3,
	((mframe_t *) chick_frames_start_run) + 4,
	((mframe_t *) chick_frames_start_run) + 5,
	((mframe_t *) chick_frames_start_run) + 6,
	((mframe_t *) chick_frames_start_run) + 7,
	((mframe_t *) chick_frames_start_run) + 8,
	((mframe_t *) chick_frames_start_run) + 9,

	(mmove_t *) &chick_move_start_run,

	((mframe_t *) chick_frames_run) + 0,
	((mframe_t *) chick_frames_run) + 1,
	((mframe_t *) chick_frames_run) + 2,
	((mframe_t *) chick_frames_run) + 3,
	((mframe_t *) chick_frames_run) + 4,
	((mframe_t *) chick_frames_run) + 5,
	((mframe_t *) chick_frames_run) + 6,
	((mframe_t *) chick_frames_run) + 7,
	((mframe_t *) chick_frames_run) + 8,
	((mframe_t *) chick_frames_run) + 9,

	(mmove_t *) &chick_move_run,

	((mframe_t *) chick_frames_walk) + 0,
	((mframe_t *) chick_frames_walk) + 1,
	((mframe_t *) chick_frames_walk) + 2,
	((mframe_t *) chick_frames_walk) + 3,
	((mframe_t *) chick_frames_walk) + 4,
	((mframe_t *) chick_frames_walk) + 5,
	((mframe_t *) chick_frames_walk) + 6,
	((mframe_t *) chick_frames_walk) + 7,
	((mframe_t *) chick_frames_walk) + 8,
	((mframe_t *) chick_frames_walk) + 9,

	(mmove_t *) &chick_move_walk,

	((mframe_t *) chick_frames_pain1) + 0,
	((mframe_t *) chick_frames_pain1) + 1,
	((mframe_t *) chick_frames_pain1) + 2,
	((mframe_t *) chick_frames_pain1) + 3,
	((mframe_t *) chick_frames_pain1) + 4,

	(mmove_t *) &chick_move_pain1,

	((mframe_t *) chick_frames_pain2) + 0,
	((mframe_t *) chick_frames_pain2) + 1,
	((mframe_t *) chick_frames_pain2) + 2,
	((mframe_t *) chick_frames_pain2) + 3,
	((mframe_t *) chick_frames_pain2) + 4,

	(mmove_t *) &chick_move_pain2,

	((mframe_t *) chick_frames_pain3) + 0,
	((mframe_t *) chick_frames_pain3) + 1,
	((mframe_t *) chick_frames_pain3) + 2,
	((mframe_t *) chick_frames_pain3) + 3,
	((mframe_t *) chick_frames_pain3) + 4,
	((mframe_t *) chick_frames_pain3) + 5,
	((mframe_t *) chick_frames_pain3) + 6,
	((mframe_t *) chick_frames_pain3) + 7,
	((mframe_t *) chick_frames_pain3) + 8,
	((mframe_t *) chick_frames_pain3) + 9,
	((mframe_t *) chick_frames_pain3) + 10,
	((mframe_t *) chick_frames_pain3) + 11,
	((mframe_t *) chick_frames_pain3) + 12,
	((mframe_t *) chick_frames_pain3) + 13,
	((mframe_t *) chick_frames_pain3) + 14,
	((mframe_t *) chick_frames_pain3) + 15,
	((mframe_t *) chick_frames_pain3) + 16,
	((mframe_t *) chick_frames_pain3) + 17,
	((mframe_t *) chick_frames_pain3) + 18,
	((mframe_t *) chick_frames_pain3) + 19,
	((mframe_t *) chick_frames_pain3) + 20,

	(mmove_t *) &chick_move_pain3,

	((mframe_t *) chick_frames_death2) + 0,
	((mframe_t *) chick_frames_death2) + 1,
	((mframe_t *) chick_frames_death2) + 2,
	((mframe_t *) chick_frames_death2) + 3,
	((mframe_t *) chick_frames_death2) + 4,
	((mframe_t *) chick_frames_death2) + 5,
	((mframe_t *) chick_frames_death2) + 6,
	((mframe_t *) chick_frames_death2) + 7,
	((mframe_t *) chick_frames_death2) + 8,
	((mframe_t *) chick_frames_death2) + 9,
	((mframe_t *) chick_frames_death2) + 10,
	((mframe_t *) chick_frames_death2) + 11,
	((mframe_t *) chick_frames_death2) + 12,
	((mframe_t *) chick_frames_death2) + 13,
	((mframe_t *) chick_frames_death2) + 14,
	((mframe_t *) chick_frames_death2) + 15,
	((mframe_t *) chick_frames_death2) + 16,
	((mframe_t *) chick_frames_death2) + 17,
	((mframe_t *) chick_frames_death2) + 18,
	((mframe_t *) chick_frames_death2) + 19,
	((mframe_t *) chick_frames_death2) + 20,
	((mframe_t *) chick_frames_death2) + 21,
	((mframe_t *) chick_frames_death2) + 22,

	(mmove_t *) &chick_move_death2,

	((mframe_t *) chick_frames_death1) + 0,
	((mframe_t *) chick_frames_death1) + 1,
	((mframe_t *) chick_frames_death1) + 2,
	((mframe_t *) chick_frames_death1) + 3,
	((mframe_t *) chick_frames_death1) + 4,
	((mframe_t *) chick_frames_death1) + 5,
	((mframe_t *) chick_frames_death1) + 6,
	((mframe_t *) chick_frames_death1) + 7,
	((mframe_t *) chick_frames_death1) + 8,
	((mframe_t *) chick_frames_death1) + 9,
	((mframe_t *) chick_frames_death1) + 10,
	((mframe_t *) chick_frames_death1) + 11,

	(mmove_t *) &chick_move_death1,

	((mframe_t *) chick_frames_duck) + 0,
	((mframe_t *) chick_frames_duck) + 1,
	((mframe_t *) chick_frames_duck) + 2,
	((mframe_t *) chick_frames_duck) + 3,
	((mframe_t *) chick_frames_duck) + 4,
	((mframe_t *) chick_frames_duck) + 5,
	((mframe_t *) chick_frames_duck) + 6,

	(mmove_t *) &chick_move_duck,

	((mframe_t *) chick_frames_start_attack1) + 0,
	((mframe_t *) chick_frames_start_attack1) + 1,
	((mframe_t *) chick_frames_start_attack1) + 2,
	((mframe_t *) chick_frames_start_attack1) + 3,
	((mframe_t *) chick_frames_start_attack1) + 4,
	((mframe_t *) chick_frames_start_attack1) + 5,
	((mframe_t *) chick_frames_start_attack1) + 6,
	((mframe_t *) chick_frames_start_attack1) + 7,
	((mframe_t *) chick_frames_start_attack1) + 8,
	((mframe_t *) chick_frames_start_attack1) + 9,
	((mframe_t *) chick_frames_start_attack1) + 10,
	((mframe_t *) chick_frames_start_attack1) + 11,
	((mframe_t *) chick_frames_start_attack1) + 12,

	(mmove_t *) &chick_move_start_attack1,

	((mframe_t *) chick_frames_attack1) + 0,
	((mframe_t *) chick_frames_attack1) + 1,
	((mframe_t *) chick_frames_attack1) + 2,
	((mframe_t *) chick_frames_attack1) + 3,
	((mframe_t *) chick_frames_attack1) + 4,
	((mframe_t *) chick_frames_attack1) + 5,
	((mframe_t *) chick_frames_attack1) + 6,
	((mframe_t *) chick_frames_attack1) + 7,
	((mframe_t *) chick_frames_attack1) + 8,
	((mframe_t *) chick_frames_attack1) + 9,
	((mframe_t *) chick_frames_attack1) + 10,
	((mframe_t *) chick_frames_attack1) + 11,
	((mframe_t *) chick_frames_attack1) + 12,
	((mframe_t *) chick_frames_attack1) + 13,

	(mmove_t *) &chick_move_attack1,

	((mframe_t *) chick_frames_end_attack1) + 0,
	((mframe_t *) chick_frames_end_attack1) + 1,
	((mframe_t *) chick_frames_end_attack1) + 2,
	((mframe_t *) chick_frames_end_attack1) + 3,
	((mframe_t *) chick_frames_end_attack1) + 4,

	(mmove_t *) &chick_move_end_attack1,

	((mframe_t *) chick_frames_slash) + 0,
	((mframe_t *) chick_frames_slash) + 1,
	((mframe_t *) chick_frames_slash) + 2,
	((mframe_t *) chick_frames_slash) + 3,
	((mframe_t *) chick_frames_slash) + 4,
	((mframe_t *) chick_frames_slash) + 5,
	((mframe_t *) chick_frames_slash) + 6,
	((mframe_t *) chick_frames_slash) + 7,
	((mframe_t *) chick_frames_slash) + 8,

	(mmove_t *) &chick_move_slash,

	((mframe_t *) chick_frames_end_slash) + 0,
	((mframe_t *) chick_frames_end_slash) + 1,
	((mframe_t *) chick_frames_end_slash) + 2,
	((mframe_t *) chick_frames_end_slash) + 3,

	(mmove_t *) &chick_move_end_slash,

	((mframe_t *) chick_frames_start_slash) + 0,
	((mframe_t *) chick_frames_start_slash) + 1,
	((mframe_t *) chick_frames_start_slash) + 2,

	(mmove_t *) &chick_move_start_slash,

	((mframe_t *) flipper_frames_stand) + 0,

	(mmove_t *) &flipper_move_stand,

	((mframe_t *) flipper_frames_run) + 0,
	((mframe_t *) flipper_frames_run) + 1,
	((mframe_t *) flipper_frames_run) + 2,
	((mframe_t *) flipper_frames_run) + 3,
	((mframe_t *) flipper_frames_run) + 4,
	((mframe_t *) flipper_frames_run) + 5,
	((mframe_t *) flipper_frames_run) + 6,
	((mframe_t *) flipper_frames_run) + 7,
	((mframe_t *) flipper_frames_run) + 8,
	((mframe_t *) flipper_frames_run) + 9,
	((mframe_t *) flipper_frames_run) + 10,
	((mframe_t *) flipper_frames_run) + 11,
	((mframe_t *) flipper_frames_run) + 12,
	((mframe_t *) flipper_frames_run) + 13,
	((mframe_t *) flipper_frames_run) + 14,
	((mframe_t *) flipper_frames_run) + 15,
	((mframe_t *) flipper_frames_run) + 16,
	((mframe_t *) flipper_frames_run) + 17,
	((mframe_t *) flipper_frames_run) + 18,
	((mframe_t *) flipper_frames_run) + 19,
	((mframe_t *) flipper_frames_run) + 20,
	((mframe_t *) flipper_frames_run) + 21,
	((mframe_t *) flipper_frames_run) + 22,
	((mframe_t *) flipper_frames_run) + 23,

	(mmove_t *) &flipper_move_run_loop,

	((mframe_t *) flipper_frames_run_start) + 0,
	((mframe_t *) flipper_frames_run_start) + 1,
	((mframe_t *) flipper_frames_run_start) + 2,
	((mframe_t *) flipper_frames_run_start) + 3,
	((mframe_t *) flipper_frames_run_start) + 4,
	((mframe_t *) flipper_frames_run_start) + 5,

	(mmove_t *) &flipper_move_run_start,

	((mframe_t *) flipper_frames_walk) + 0,
	((mframe_t *) flipper_frames_walk) + 1,
	((mframe_t *) flipper_frames_walk) + 2,
	((mframe_t *) flipper_frames_walk) + 3,
	((mframe_t *) flipper_frames_walk) + 4,
	((mframe_t *) flipper_frames_walk) + 5,
	((mframe_t *) flipper_frames_walk) + 6,
	((mframe_t *) flipper_frames_walk) + 7,
	((mframe_t *) flipper_frames_walk) + 8,
	((mframe_t *) flipper_frames_walk) + 9,
	((mframe_t *) flipper_frames_walk) + 10,
	((mframe_t *) flipper_frames_walk) + 11,
	((mframe_t *) flipper_frames_walk) + 12,
	((mframe_t *) flipper_frames_walk) + 13,
	((mframe_t *) flipper_frames_walk) + 14,
	((mframe_t *) flipper_frames_walk) + 15,
	((mframe_t *) flipper_frames_walk) + 16,
	((mframe_t *) flipper_frames_walk) + 17,
	((mframe_t *) flipper_frames_walk) + 18,
	((mframe_t *) flipper_frames_walk) + 19,
	((mframe_t *) flipper_frames_walk) + 20,
	((mframe_t *) flipper_frames_walk) + 21,
	((mframe_t *) flipper_frames_walk) + 22,
	((mframe_t *) flipper_frames_walk) + 23,

	(mmove_t *) &flipper_move_walk,

	((mframe_t *) flipper_frames_start_run) + 0,
	((mframe_t *) flipper_frames_start_run) + 1,
	((mframe_t *) flipper_frames_start_run) + 2,
	((mframe_t *) flipper_frames_start_run) + 3,
	((mframe_t *) flipper_frames_start_run) + 4,

	(mmove_t *) &flipper_move_start_run,

	((mframe_t *) flipper_frames_pain2) + 0,
	((mframe_t *) flipper_frames_pain2) + 1,
	((mframe_t *) flipper_frames_pain2) + 2,
	((mframe_t *) flipper_frames_pain2) + 3,
	((mframe_t *) flipper_frames_pain2) + 4,

	(mmove_t *) &flipper_move_pain2,

	((mframe_t *) flipper_frames_pain1) + 0,
	((mframe_t *) flipper_frames_pain1) + 1,
	((mframe_t *) flipper_frames_pain1) + 2,
	((mframe_t *) flipper_frames_pain1) + 3,
	((mframe_t *) flipper_frames_pain1) + 4,

	(mmove_t *) &flipper_move_pain1,

	((mframe_t *) flipper_frames_attack) + 0,
	((mframe_t *) flipper_frames_attack) + 1,
	((mframe_t *) flipper_frames_attack) + 2,
	((mframe_t *) flipper_frames_attack) + 3,
	((mframe_t *) flipper_frames_attack) + 4,
	((mframe_t *) flipper_frames_attack) + 5,
	((mframe_t *) flipper_frames_attack) + 6,
	((mframe_t *) flipper_frames_attack) + 7,
	((mframe_t *) flipper_frames_attack) + 8,
	((mframe_t *) flipper_frames_attack) + 9,
	((mframe_t *) flipper_frames_attack) + 10,
	((mframe_t *) flipper_frames_attack) + 11,
	((mframe_t *) flipper_frames_attack) + 12,
	((mframe_t *) flipper_frames_attack) + 13,
	((mframe_t *) flipper_frames_attack) + 14,
	((mframe_t *) flipper_frames_attack) + 15,
	((mframe_t *) flipper_frames_attack) + 16,
	((mframe_t *) flipper_frames_attack) + 17,
	((mframe_t *) flipper_frames_attack) + 18,
	((mframe_t *) flipper_frames_attack) + 19,

	(mmove_t *) &flipper_move_attack,

	((mframe_t *) flipper_frames_death) + 0,
	((mframe_t *) flipper_frames_death) + 1,
	((mframe_t *) flipper_frames_death) + 2,
	((mframe_t *) flipper_frames_death) + 3,
	((mframe_t *) flipper_frames_death) + 4,
	((mframe_t *) flipper_frames_death) + 5,
	((mframe_t *) flipper_frames_death) + 6,
	((mframe_t *) flipper_frames_death) + 7,
	((mframe_t *) flipper_frames_death) + 8,
	((mframe_t *) flipper_frames_death) + 9,
	((mframe_t *) flipper_frames_death) + 10,
	((mframe_t *) flipper_frames_death) + 11,
	((mframe_t *) flipper_frames_death) + 12,
	((mframe_t *) flipper_frames_death) + 13,
	((mframe_t *) flipper_frames_death) + 14,
	((mframe_t *) flipper_frames_death) + 15,
	((mframe_t *) flipper_frames_death) + 16,
	((mframe_t *) flipper_frames_death) + 17,
	((mframe_t *) flipper_frames_death) + 18,
	((mframe_t *) flipper_frames_death) + 19,
	((mframe_t *) flipper_frames_death) + 20,
	((mframe_t *) flipper_frames_death) + 21,
	((mframe_t *) flipper_frames_death) + 22,
	((mframe_t *) flipper_frames_death) + 23,
	((mframe_t *) flipper_frames_death) + 24,
	((mframe_t *) flipper_frames_death) + 25,
	((mframe_t *) flipper_frames_death) + 26,
	((mframe_t *) flipper_frames_death) + 27,
	((mframe_t *) flipper_frames_death) + 28,
	((mframe_t *) flipper_frames_death) + 29,
	((mframe_t *) flipper_frames_death) + 30,
	((mframe_t *) flipper_frames_death) + 31,
	((mframe_t *) flipper_frames_death) + 32,
	((mframe_t *) flipper_frames_death) + 33,
	((mframe_t *) flipper_frames_death) + 34,
	((mframe_t *) flipper_frames_death) + 35,
	((mframe_t *) flipper_frames_death) + 36,
	((mframe_t *) flipper_frames_death) + 37,
	((mframe_t *) flipper_frames_death) + 38,
	((mframe_t *) flipper_frames_death) + 39,
	((mframe_t *) flipper_frames_death) + 40,
	((mframe_t *) flipper_frames_death) + 41,
	((mframe_t *) flipper_frames_death) + 42,
	((mframe_t *) flipper_frames_death) + 43,
	((mframe_t *) flipper_frames_death) + 44,
	((mframe_t *) flipper_frames_death) + 45,
	((mframe_t *) flipper_frames_death) + 46,
	((mframe_t *) flipper_frames_death) + 47,
	((mframe_t *) flipper_frames_death) + 48,
	((mframe_t *) flipper_frames_death) + 49,
	((mframe_t *) flipper_frames_death) + 50,
	((mframe_t *) flipper_frames_death) + 51,
	((mframe_t *) flipper_frames_death) + 52,
	((mframe_t *) flipper_frames_death) + 53,
	((mframe_t *) flipper_frames_death) + 54,
	((mframe_t *) flipper_frames_death) + 55,

	(mmove_t *) &flipper_move_death,

	((mframe_t *) floater_frames_stand1) + 0,
	((mframe_t *) floater_frames_stand1) + 1,
	((mframe_t *) floater_frames_stand1) + 2,
	((mframe_t *) floater_frames_stand1) + 3,
	((mframe_t *) floater_frames_stand1) + 4,
	((mframe_t *) floater_frames_stand1) + 5,
	((mframe_t *) floater_frames_stand1) + 6,
	((mframe_t *) floater_frames_stand1) + 7,
	((mframe_t *) floater_frames_stand1) + 8,
	((mframe_t *) floater_frames_stand1) + 9,
	((mframe_t *) floater_frames_stand1) + 10,
	((mframe_t *) floater_frames_stand1) + 11,
	((mframe_t *) floater_frames_stand1) + 12,
	((mframe_t *) floater_frames_stand1) + 13,
	((mframe_t *) floater_frames_stand1) + 14,
	((mframe_t *) floater_frames_stand1) + 15,
	((mframe_t *) floater_frames_stand1) + 16,
	((mframe_t *) floater_frames_stand1) + 17,
	((mframe_t *) floater_frames_stand1) + 18,
	((mframe_t *) floater_frames_stand1) + 19,
	((mframe_t *) floater_frames_stand1) + 20,
	((mframe_t *) floater_frames_stand1) + 21,
	((mframe_t *) floater_frames_stand1) + 22,
	((mframe_t *) floater_frames_stand1) + 23,
	((mframe_t *) floater_frames_stand1) + 24,
	((mframe_t *) floater_frames_stand1) + 25,
	((mframe_t *) floater_frames_stand1) + 26,
	((mframe_t *) floater_frames_stand1) + 27,
	((mframe_t *) floater_frames_stand1) + 28,
	((mframe_t *) floater_frames_stand1) + 29,
	((mframe_t *) floater_frames_stand1) + 30,
	((mframe_t *) floater_frames_stand1) + 31,
	((mframe_t *) floater_frames_stand1) + 32,
	((mframe_t *) floater_frames_stand1) + 33,
	((mframe_t *) floater_frames_stand1) + 34,
	((mframe_t *) floater_frames_stand1) + 35,
	((mframe_t *) floater_frames_stand1) + 36,
	((mframe_t *) floater_frames_stand1) + 37,
	((mframe_t *) floater_frames_stand1) + 38,
	((mframe_t *) floater_frames_stand1) + 39,
	((mframe_t *) floater_frames_stand1) + 40,
	((mframe_t *) floater_frames_stand1) + 41,
	((mframe_t *) floater_frames_stand1) + 42,
	((mframe_t *) floater_frames_stand1) + 43,
	((mframe_t *) floater_frames_stand1) + 44,
	((mframe_t *) floater_frames_stand1) + 45,
	((mframe_t *) floater_frames_stand1) + 46,
	((mframe_t *) floater_frames_stand1) + 47,
	((mframe_t *) floater_frames_stand1) + 48,
	((mframe_t *) floater_frames_stand1) + 49,
	((mframe_t *) floater_frames_stand1) + 50,
	((mframe_t *) floater_frames_stand1) + 51,

	(mmove_t *) &floater_move_stand1,

	((mframe_t *) floater_frames_stand2) + 0,
	((mframe_t *) floater_frames_stand2) + 1,
	((mframe_t *) floater_frames_stand2) + 2,
	((mframe_t *) floater_frames_stand2) + 3,
	((mframe_t *) floater_frames_stand2) + 4,
	((mframe_t *) floater_frames_stand2) + 5,
	((mframe_t *) floater_frames_stand2) + 6,
	((mframe_t *) floater_frames_stand2) + 7,
	((mframe_t *) floater_frames_stand2) + 8,
	((mframe_t *) floater_frames_stand2) + 9,
	((mframe_t *) floater_frames_stand2) + 10,
	((mframe_t *) floater_frames_stand2) + 11,
	((mframe_t *) floater_frames_stand2) + 12,
	((mframe_t *) floater_frames_stand2) + 13,
	((mframe_t *) floater_frames_stand2) + 14,
	((mframe_t *) floater_frames_stand2) + 15,
	((mframe_t *) floater_frames_stand2) + 16,
	((mframe_t *) floater_frames_stand2) + 17,
	((mframe_t *) floater_frames_stand2) + 18,
	((mframe_t *) floater_frames_stand2) + 19,
	((mframe_t *) floater_frames_stand2) + 20,
	((mframe_t *) floater_frames_stand2) + 21,
	((mframe_t *) floater_frames_stand2) + 22,
	((mframe_t *) floater_frames_stand2) + 23,
	((mframe_t *) floater_frames_stand2) + 24,
	((mframe_t *) floater_frames_stand2) + 25,
	((mframe_t *) floater_frames_stand2) + 26,
	((mframe_t *) floater_frames_stand2) + 27,
	((mframe_t *) floater_frames_stand2) + 28,
	((mframe_t *) floater_frames_stand2) + 29,
	((mframe_t *) floater_frames_stand2) + 30,
	((mframe_t *) floater_frames_stand2) + 31,
	((mframe_t *) floater_frames_stand2) + 32,
	((mframe_t *) floater_frames_stand2) + 33,
	((mframe_t *) floater_frames_stand2) + 34,
	((mframe_t *) floater_frames_stand2) + 35,
	((mframe_t *) floater_frames_stand2) + 36,
	((mframe_t *) floater_frames_stand2) + 37,
	((mframe_t *) floater_frames_stand2) + 38,
	((mframe_t *) floater_frames_stand2) + 39,
	((mframe_t *) floater_frames_stand2) + 40,
	((mframe_t *) floater_frames_stand2) + 41,
	((mframe_t *) floater_frames_stand2) + 42,
	((mframe_t *) floater_frames_stand2) + 43,
	((mframe_t *) floater_frames_stand2) + 44,
	((mframe_t *) floater_frames_stand2) + 45,
	((mframe_t *) floater_frames_stand2) + 46,
	((mframe_t *) floater_frames_stand2) + 47,
	((mframe_t *) floater_frames_stand2) + 48,
	((mframe_t *) floater_frames_stand2) + 49,
	((mframe_t *) floater_frames_stand2) + 50,
	((mframe_t *) floater_frames_stand2) + 51,

	(mmove_t *) &floater_move_stand2,

	((mframe_t *) floater_frames_activate) + 0,
	((mframe_t *) floater_frames_activate) + 1,
	((mframe_t *) floater_frames_activate) + 2,
	((mframe_t *) floater_frames_activate) + 3,
	((mframe_t *) floater_frames_activate) + 4,
	((mframe_t *) floater_frames_activate) + 5,
	((mframe_t *) floater_frames_activate) + 6,
	((mframe_t *) floater_frames_activate) + 7,
	((mframe_t *) floater_frames_activate) + 8,
	((mframe_t *) floater_frames_activate) + 9,
	((mframe_t *) floater_frames_activate) + 10,
	((mframe_t *) floater_frames_activate) + 11,
	((mframe_t *) floater_frames_activate) + 12,
	((mframe_t *) floater_frames_activate) + 13,
	((mframe_t *) floater_frames_activate) + 14,
	((mframe_t *) floater_frames_activate) + 15,
	((mframe_t *) floater_frames_activate) + 16,
	((mframe_t *) floater_frames_activate) + 17,
	((mframe_t *) floater_frames_activate) + 18,
	((mframe_t *) floater_frames_activate) + 19,
	((mframe_t *) floater_frames_activate) + 20,
	((mframe_t *) floater_frames_activate) + 21,
	((mframe_t *) floater_frames_activate) + 22,
	((mframe_t *) floater_frames_activate) + 23,
	((mframe_t *) floater_frames_activate) + 24,
	((mframe_t *) floater_frames_activate) + 25,
	((mframe_t *) floater_frames_activate) + 26,
	((mframe_t *) floater_frames_activate) + 27,
	((mframe_t *) floater_frames_activate) + 28,
	((mframe_t *) floater_frames_activate) + 29,

	(mmove_t *) &floater_move_activate,

	((mframe_t *) floater_frames_attack1) + 0,
	((mframe_t *) floater_frames_attack1) + 1,
	((mframe_t *) floater_frames_attack1) + 2,
	((mframe_t *) floater_frames_attack1) + 3,
	((mframe_t *) floater_frames_attack1) + 4,
	((mframe_t *) floater_frames_attack1) + 5,
	((mframe_t *) floater_frames_attack1) + 6,
	((mframe_t *) floater_frames_attack1) + 7,
	((mframe_t *) floater_frames_attack1) + 8,
	((mframe_t *) floater_frames_attack1) + 9,
	((mframe_t *) floater_frames_attack1) + 10,
	((mframe_t *) floater_frames_attack1) + 11,
	((mframe_t *) floater_frames_attack1) + 12,
	((mframe_t *) floater_frames_attack1) + 13,

	(mmove_t *) &floater_move_attack1,

	((mframe_t *) floater_frames_attack2) + 0,
	((mframe_t *) floater_frames_attack2) + 1,
	((mframe_t *) floater_frames_attack2) + 2,
	((mframe_t *) floater_frames_attack2) + 3,
	((mframe_t *) floater_frames_attack2) + 4,
	((mframe_t *) floater_frames_attack2) + 5,
	((mframe_t *) floater_frames_attack2) + 6,
	((mframe_t *) floater_frames_attack2) + 7,
	((mframe_t *) floater_frames_attack2) + 8,
	((mframe_t *) floater_frames_attack2) + 9,
	((mframe_t *) floater_frames_attack2) + 10,
	((mframe_t *) floater_frames_attack2) + 11,
	((mframe_t *) floater_frames_attack2) + 12,
	((mframe_t *) floater_frames_attack2) + 13,
	((mframe_t *) floater_frames_attack2) + 14,
	((mframe_t *) floater_frames_attack2) + 15,
	((mframe_t *) floater_frames_attack2) + 16,
	((mframe_t *) floater_frames_attack2) + 17,
	((mframe_t *) floater_frames_attack2) + 18,
	((mframe_t *) floater_frames_attack2) + 19,
	((mframe_t *) floater_frames_attack2) + 20,
	((mframe_t *) floater_frames_attack2) + 21,
	((mframe_t *) floater_frames_attack2) + 22,
	((mframe_t *) floater_frames_attack2) + 23,
	((mframe_t *) floater_frames_attack2) + 24,

	(mmove_t *) &floater_move_attack2,

	((mframe_t *) floater_frames_attack3) + 0,
	((mframe_t *) floater_frames_attack3) + 1,
	((mframe_t *) floater_frames_attack3) + 2,
	((mframe_t *) floater_frames_attack3) + 3,
	((mframe_t *) floater_frames_attack3) + 4,
	((mframe_t *) floater_frames_attack3) + 5,
	((mframe_t *) floater_frames_attack3) + 6,
	((mframe_t *) floater_frames_attack3) + 7,
	((mframe_t *) floater_frames_attack3) + 8,
	((mframe_t *) floater_frames_attack3) + 9,
	((mframe_t *) floater_frames_attack3) + 10,
	((mframe_t *) floater_frames_attack3) + 11,
	((mframe_t *) floater_frames_attack3) + 12,
	((mframe_t *) floater_frames_attack3) + 13,
	((mframe_t *) floater_frames_attack3) + 14,
	((mframe_t *) floater_frames_attack3) + 15,
	((mframe_t *) floater_frames_attack3) + 16,
	((mframe_t *) floater_frames_attack3) + 17,
	((mframe_t *) floater_frames_attack3) + 18,
	((mframe_t *) floater_frames_attack3) + 19,
	((mframe_t *) floater_frames_attack3) + 20,
	((mframe_t *) floater_frames_attack3) + 21,
	((mframe_t *) floater_frames_attack3) + 22,
	((mframe_t *) floater_frames_attack3) + 23,
	((mframe_t *) floater_frames_attack3) + 24,
	((mframe_t *) floater_frames_attack3) + 25,
	((mframe_t *) floater_frames_attack3) + 26,
	((mframe_t *) floater_frames_attack3) + 27,
	((mframe_t *) floater_frames_attack3) + 28,
	((mframe_t *) floater_frames_attack3) + 29,
	((mframe_t *) floater_frames_attack3) + 30,
	((mframe_t *) floater_frames_attack3) + 31,
	((mframe_t *) floater_frames_attack3) + 32,
	((mframe_t *) floater_frames_attack3) + 33,

	(mmove_t *) &floater_move_attack3,

	((mframe_t *) floater_frames_death) + 0,
	((mframe_t *) floater_frames_death) + 1,
	((mframe_t *) floater_frames_death) + 2,
	((mframe_t *) floater_frames_death) + 3,
	((mframe_t *) floater_frames_death) + 4,
	((mframe_t *) floater_frames_death) + 5,
	((mframe_t *) floater_frames_death) + 6,
	((mframe_t *) floater_frames_death) + 7,
	((mframe_t *) floater_frames_death) + 8,
	((mframe_t *) floater_frames_death) + 9,
	((mframe_t *) floater_frames_death) + 10,
	((mframe_t *) floater_frames_death) + 11,
	((mframe_t *) floater_frames_death) + 12,

	(mmove_t *) &floater_move_death,

	((mframe_t *) floater_frames_pain1) + 0,
	((mframe_t *) floater_frames_pain1) + 1,
	((mframe_t *) floater_frames_pain1) + 2,
	((mframe_t *) floater_frames_pain1) + 3,
	((mframe_t *) floater_frames_pain1) + 4,
	((mframe_t *) floater_frames_pain1) + 5,
	((mframe_t *) floater_frames_pain1) + 6,

	(mmove_t *) &floater_move_pain1,

	((mframe_t *) floater_frames_pain2) + 0,
	((mframe_t *) floater_frames_pain2) + 1,
	((mframe_t *) floater_frames_pain2) + 2,
	((mframe_t *) floater_frames_pain2) + 3,
	((mframe_t *) floater_frames_pain2) + 4,
	((mframe_t *) floater_frames_pain2) + 5,
	((mframe_t *) floater_frames_pain2) + 6,
	((mframe_t *) floater_frames_pain2) + 7,

	(mmove_t *) &floater_move_pain2,

	((mframe_t *) floater_frames_pain3) + 0,
	((mframe_t *) floater_frames_pain3) + 1,
	((mframe_t *) floater_frames_pain3) + 2,
	((mframe_t *) floater_frames_pain3) + 3,
	((mframe_t *) floater_frames_pain3) + 4,
	((mframe_t *) floater_frames_pain3) + 5,
	((mframe_t *) floater_frames_pain3) + 6,
	((mframe_t *) floater_frames_pain3) + 7,
	((mframe_t *) floater_frames_pain3) + 8,
	((mframe_t *) floater_frames_pain3) + 9,
	((mframe_t *) floater_frames_pain3) + 10,
	((mframe_t *) floater_frames_pain3) + 11,

	(mmove_t *) &floater_move_pain3,

	((mframe_t *) floater_frames_walk) + 0,
	((mframe_t *) floater_frames_walk) + 1,
	((mframe_t *) floater_frames_walk) + 2,
	((mframe_t *) floater_frames_walk) + 3,
	((mframe_t *) floater_frames_walk) + 4,
	((mframe_t *) floater_frames_walk) + 5,
	((mframe_t *) floater_frames_walk) + 6,
	((mframe_t *) floater_frames_walk) + 7,
	((mframe_t *) floater_frames_walk) + 8,
	((mframe_t *) floater_frames_walk) + 9,
	((mframe_t *) floater_frames_walk) + 10,
	((mframe_t *) floater_frames_walk) + 11,
	((mframe_t *) floater_frames_walk) + 12,
	((mframe_t *) floater_frames_walk) + 13,
	((mframe_t *) floater_frames_walk) + 14,
	((mframe_t *) floater_frames_walk) + 15,
	((mframe_t *) floater_frames_walk) + 16,
	((mframe_t *) floater_frames_walk) + 17,
	((mframe_t *) floater_frames_walk) + 18,
	((mframe_t *) floater_frames_walk) + 19,
	((mframe_t *) floater_frames_walk) + 20,
	((mframe_t *) floater_frames_walk) + 21,
	((mframe_t *) floater_frames_walk) + 22,
	((mframe_t *) floater_frames_walk) + 23,
	((mframe_t *) floater_frames_walk) + 24,
	((mframe_t *) floater_frames_walk) + 25,
	((mframe_t *) floater_frames_walk) + 26,
	((mframe_t *) floater_frames_walk) + 27,
	((mframe_t *) floater_frames_walk) + 28,
	((mframe_t *) floater_frames_walk) + 29,
	((mframe_t *) floater_frames_walk) + 30,
	((mframe_t *) floater_frames_walk) + 31,
	((mframe_t *) floater_frames_walk) + 32,
	((mframe_t *) floater_frames_walk) + 33,
	((mframe_t *) floater_frames_walk) + 34,
	((mframe_t *) floater_frames_walk) + 35,
	((mframe_t *) floater_frames_walk) + 36,
	((mframe_t *) floater_frames_walk) + 37,
	((mframe_t *) floater_frames_walk) + 38,
	((mframe_t *) floater_frames_walk) + 39,
	((mframe_t *) floater_frames_walk) + 40,
	((mframe_t *) floater_frames_walk) + 41,
	((mframe_t *) floater_frames_walk) + 42,
	((mframe_t *) floater_frames_walk) + 43,
	((mframe_t *) floater_frames_walk) + 44,
	((mframe_t *) floater_frames_walk) + 45,
	((mframe_t *) floater_frames_walk) + 46,
	((mframe_t *) floater_frames_walk) + 47,
	((mframe_t *) floater_frames_walk) + 48,
	((mframe_t *) floater_frames_walk) + 49,
	((mframe_t *) floater_frames_walk) + 50,
	((mframe_t *) floater_frames_walk) + 51,

	(mmove_t *) &floater_move_walk,

	((mframe_t *) floater_frames_run) + 0,
	((mframe_t *) floater_frames_run) + 1,
	((mframe_t *) floater_frames_run) + 2,
	((mframe_t *) floater_frames_run) + 3,
	((mframe_t *) floater_frames_run) + 4,
	((mframe_t *) floater_frames_run) + 5,
	((mframe_t *) floater_frames_run) + 6,
	((mframe_t *) floater_frames_run) + 7,
	((mframe_t *) floater_frames_run) + 8,
	((mframe_t *) floater_frames_run) + 9,
	((mframe_t *) floater_frames_run) + 10,
	((mframe_t *) floater_frames_run) + 11,
	((mframe_t *) floater_frames_run) + 12,
	((mframe_t *) floater_frames_run) + 13,
	((mframe_t *) floater_frames_run) + 14,
	((mframe_t *) floater_frames_run) + 15,
	((mframe_t *) floater_frames_run) + 16,
	((mframe_t *) floater_frames_run) + 17,
	((mframe_t *) floater_frames_run) + 18,
	((mframe_t *) floater_frames_run) + 19,
	((mframe_t *) floater_frames_run) + 20,
	((mframe_t *) floater_frames_run) + 21,
	((mframe_t *) floater_frames_run) + 22,
	((mframe_t *) floater_frames_run) + 23,
	((mframe_t *) floater_frames_run) + 24,
	((mframe_t *) floater_frames_run) + 25,
	((mframe_t *) floater_frames_run) + 26,
	((mframe_t *) floater_frames_run) + 27,
	((mframe_t *) floater_frames_run) + 28,
	((mframe_t *) floater_frames_run) + 29,
	((mframe_t *) floater_frames_run) + 30,
	((mframe_t *) floater_frames_run) + 31,
	((mframe_t *) floater_frames_run) + 32,
	((mframe_t *) floater_frames_run) + 33,
	((mframe_t *) floater_frames_run) + 34,
	((mframe_t *) floater_frames_run) + 35,
	((mframe_t *) floater_frames_run) + 36,
	((mframe_t *) floater_frames_run) + 37,
	((mframe_t *) floater_frames_run) + 38,
	((mframe_t *) floater_frames_run) + 39,
	((mframe_t *) floater_frames_run) + 40,
	((mframe_t *) floater_frames_run) + 41,
	((mframe_t *) floater_frames_run) + 42,
	((mframe_t *) floater_frames_run) + 43,
	((mframe_t *) floater_frames_run) + 44,
	((mframe_t *) floater_frames_run) + 45,
	((mframe_t *) floater_frames_run) + 46,
	((mframe_t *) floater_frames_run) + 47,
	((mframe_t *) floater_frames_run) + 48,
	((mframe_t *) floater_frames_run) + 49,
	((mframe_t *) floater_frames_run) + 50,
	((mframe_t *) floater_frames_run) + 51,

	(mmove_t *) &floater_move_run,

	((mframe_t *) flyer_frames_stand) + 0,
	((mframe_t *) flyer_frames_stand) + 1,
	((mframe_t *) flyer_frames_stand) + 2,
	((mframe_t *) flyer_frames_stand) + 3,
	((mframe_t *) flyer_frames_stand) + 4,
	((mframe_t *) flyer_frames_stand) + 5,
	((mframe_t *) flyer_frames_stand) + 6,
	((mframe_t *) flyer_frames_stand) + 7,
	((mframe_t *) flyer_frames_stand) + 8,
	((mframe_t *) flyer_frames_stand) + 9,
	((mframe_t *) flyer_frames_stand) + 10,
	((mframe_t *) flyer_frames_stand) + 11,
	((mframe_t *) flyer_frames_stand) + 12,
	((mframe_t *) flyer_frames_stand) + 13,
	((mframe_t *) flyer_frames_stand) + 14,
	((mframe_t *) flyer_frames_stand) + 15,
	((mframe_t *) flyer_frames_stand) + 16,
	((mframe_t *) flyer_frames_stand) + 17,
	((mframe_t *) flyer_frames_stand) + 18,
	((mframe_t *) flyer_frames_stand) + 19,
	((mframe_t *) flyer_frames_stand) + 20,
	((mframe_t *) flyer_frames_stand) + 21,
	((mframe_t *) flyer_frames_stand) + 22,
	((mframe_t *) flyer_frames_stand) + 23,
	((mframe_t *) flyer_frames_stand) + 24,
	((mframe_t *) flyer_frames_stand) + 25,
	((mframe_t *) flyer_frames_stand) + 26,
	((mframe_t *) flyer_frames_stand) + 27,
	((mframe_t *) flyer_frames_stand) + 28,
	((mframe_t *) flyer_frames_stand) + 29,
	((mframe_t *) flyer_frames_stand) + 30,
	((mframe_t *) flyer_frames_stand) + 31,
	((mframe_t *) flyer_frames_stand) + 32,
	((mframe_t *) flyer_frames_stand) + 33,
	((mframe_t *) flyer_frames_stand) + 34,
	((mframe_t *) flyer_frames_stand) + 35,
	((mframe_t *) flyer_frames_stand) + 36,
	((mframe_t *) flyer_frames_stand) + 37,
	((mframe_t *) flyer_frames_stand) + 38,
	((mframe_t *) flyer_frames_stand) + 39,
	((mframe_t *) flyer_frames_stand) + 40,
	((mframe_t *) flyer_frames_stand) + 41,
	((mframe_t *) flyer_frames_stand) + 42,
	((mframe_t *) flyer_frames_stand) + 43,
	((mframe_t *) flyer_frames_stand) + 44,

	(mmove_t *) &flyer_move_stand,

	((mframe_t *) flyer_frames_walk) + 0,
	((mframe_t *) flyer_frames_walk) + 1,
	((mframe_t *) flyer_frames_walk) + 2,
	((mframe_t *) flyer_frames_walk) + 3,
	((mframe_t *) flyer_frames_walk) + 4,
	((mframe_t *) flyer_frames_walk) + 5,
	((mframe_t *) flyer_frames_walk) + 6,
	((mframe_t *) flyer_frames_walk) + 7,
	((mframe_t *) flyer_frames_walk) + 8,
	((mframe_t *) flyer_frames_walk) + 9,
	((mframe_t *) flyer_frames_walk) + 10,
	((mframe_t *) flyer_frames_walk) + 11,
	((mframe_t *) flyer_frames_walk) + 12,
	((mframe_t *) flyer_frames_walk) + 13,
	((mframe_t *) flyer_frames_walk) + 14,
	((mframe_t *) flyer_frames_walk) + 15,
	((mframe_t *) flyer_frames_walk) + 16,
	((mframe_t *) flyer_frames_walk) + 17,
	((mframe_t *) flyer_frames_walk) + 18,
	((mframe_t *) flyer_frames_walk) + 19,
	((mframe_t *) flyer_frames_walk) + 20,
	((mframe_t *) flyer_frames_walk) + 21,
	((mframe_t *) flyer_frames_walk) + 22,
	((mframe_t *) flyer_frames_walk) + 23,
	((mframe_t *) flyer_frames_walk) + 24,
	((mframe_t *) flyer_frames_walk) + 25,
	((mframe_t *) flyer_frames_walk) + 26,
	((mframe_t *) flyer_frames_walk) + 27,
	((mframe_t *) flyer_frames_walk) + 28,
	((mframe_t *) flyer_frames_walk) + 29,
	((mframe_t *) flyer_frames_walk) + 30,
	((mframe_t *) flyer_frames_walk) + 31,
	((mframe_t *) flyer_frames_walk) + 32,
	((mframe_t *) flyer_frames_walk) + 33,
	((mframe_t *) flyer_frames_walk) + 34,
	((mframe_t *) flyer_frames_walk) + 35,
	((mframe_t *) flyer_frames_walk) + 36,
	((mframe_t *) flyer_frames_walk) + 37,
	((mframe_t *) flyer_frames_walk) + 38,
	((mframe_t *) flyer_frames_walk) + 39,
	((mframe_t *) flyer_frames_walk) + 40,
	((mframe_t *) flyer_frames_walk) + 41,
	((mframe_t *) flyer_frames_walk) + 42,
	((mframe_t *) flyer_frames_walk) + 43,
	((mframe_t *) flyer_frames_walk) + 44,

	(mmove_t *) &flyer_move_walk,

	((mframe_t *) flyer_frames_run) + 0,
	((mframe_t *) flyer_frames_run) + 1,
	((mframe_t *) flyer_frames_run) + 2,
	((mframe_t *) flyer_frames_run) + 3,
	((mframe_t *) flyer_frames_run) + 4,
	((mframe_t *) flyer_frames_run) + 5,
	((mframe_t *) flyer_frames_run) + 6,
	((mframe_t *) flyer_frames_run) + 7,
	((mframe_t *) flyer_frames_run) + 8,
	((mframe_t *) flyer_frames_run) + 9,
	((mframe_t *) flyer_frames_run) + 10,
	((mframe_t *) flyer_frames_run) + 11,
	((mframe_t *) flyer_frames_run) + 12,
	((mframe_t *) flyer_frames_run) + 13,
	((mframe_t *) flyer_frames_run) + 14,
	((mframe_t *) flyer_frames_run) + 15,
	((mframe_t *) flyer_frames_run) + 16,
	((mframe_t *) flyer_frames_run) + 17,
	((mframe_t *) flyer_frames_run) + 18,
	((mframe_t *) flyer_frames_run) + 19,
	((mframe_t *) flyer_frames_run) + 20,
	((mframe_t *) flyer_frames_run) + 21,
	((mframe_t *) flyer_frames_run) + 22,
	((mframe_t *) flyer_frames_run) + 23,
	((mframe_t *) flyer_frames_run) + 24,
	((mframe_t *) flyer_frames_run) + 25,
	((mframe_t *) flyer_frames_run) + 26,
	((mframe_t *) flyer_frames_run) + 27,
	((mframe_t *) flyer_frames_run) + 28,
	((mframe_t *) flyer_frames_run) + 29,
	((mframe_t *) flyer_frames_run) + 30,
	((mframe_t *) flyer_frames_run) + 31,
	((mframe_t *) flyer_frames_run) + 32,
	((mframe_t *) flyer_frames_run) + 33,
	((mframe_t *) flyer_frames_run) + 34,
	((mframe_t *) flyer_frames_run) + 35,
	((mframe_t *) flyer_frames_run) + 36,
	((mframe_t *) flyer_frames_run) + 37,
	((mframe_t *) flyer_frames_run) + 38,
	((mframe_t *) flyer_frames_run) + 39,
	((mframe_t *) flyer_frames_run) + 40,
	((mframe_t *) flyer_frames_run) + 41,
	((mframe_t *) flyer_frames_run) + 42,
	((mframe_t *) flyer_frames_run) + 43,
	((mframe_t *) flyer_frames_run) + 44,

	(mmove_t *) &flyer_move_run,

	((mframe_t *) flyer_frames_start) + 0,
	((mframe_t *) flyer_frames_start) + 1,
	((mframe_t *) flyer_frames_start) + 2,
	((mframe_t *) flyer_frames_start) + 3,
	((mframe_t *) flyer_frames_start) + 4,
	((mframe_t *) flyer_frames_start) + 5,

	(mmove_t *) &flyer_move_start,

	((mframe_t *) flyer_frames_stop) + 0,
	((mframe_t *) flyer_frames_stop) + 1,
	((mframe_t *) flyer_frames_stop) + 2,
	((mframe_t *) flyer_frames_stop) + 3,
	((mframe_t *) flyer_frames_stop) + 4,
	((mframe_t *) flyer_frames_stop) + 5,
	((mframe_t *) flyer_frames_stop) + 6,

	(mmove_t *) &flyer_move_stop,

	((mframe_t *) flyer_frames_rollright) + 0,
	((mframe_t *) flyer_frames_rollright) + 1,
	((mframe_t *) flyer_frames_rollright) + 2,
	((mframe_t *) flyer_frames_rollright) + 3,
	((mframe_t *) flyer_frames_rollright) + 4,
	((mframe_t *) flyer_frames_rollright) + 5,
	((mframe_t *) flyer_frames_rollright) + 6,
	((mframe_t *) flyer_frames_rollright) + 7,
	((mframe_t *) flyer_frames_rollright) + 8,

	(mmove_t *) &flyer_move_rollright,

	((mframe_t *) flyer_frames_rollleft) + 0,
	((mframe_t *) flyer_frames_rollleft) + 1,
	((mframe_t *) flyer_frames_rollleft) + 2,
	((mframe_t *) flyer_frames_rollleft) + 3,
	((mframe_t *) flyer_frames_rollleft) + 4,
	((mframe_t *) flyer_frames_rollleft) + 5,
	((mframe_t *) flyer_frames_rollleft) + 6,
	((mframe_t *) flyer_frames_rollleft) + 7,
	((mframe_t *) flyer_frames_rollleft) + 8,

	(mmove_t *) &flyer_move_rollleft,

	((mframe_t *) flyer_frames_pain3) + 0,
	((mframe_t *) flyer_frames_pain3) + 1,
	((mframe_t *) flyer_frames_pain3) + 2,
	((mframe_t *) flyer_frames_pain3) + 3,

	(mmove_t *) &flyer_move_pain3,

	((mframe_t *) flyer_frames_pain2) + 0,
	((mframe_t *) flyer_frames_pain2) + 1,
	((mframe_t *) flyer_frames_pain2) + 2,
	((mframe_t *) flyer_frames_pain2) + 3,

	(mmove_t *) &flyer_move_pain2,

	((mframe_t *) flyer_frames_pain1) + 0,
	((mframe_t *) flyer_frames_pain1) + 1,
	((mframe_t *) flyer_frames_pain1) + 2,
	((mframe_t *) flyer_frames_pain1) + 3,
	((mframe_t *) flyer_frames_pain1) + 4,
	((mframe_t *) flyer_frames_pain1) + 5,
	((mframe_t *) flyer_frames_pain1) + 6,
	((mframe_t *) flyer_frames_pain1) + 7,
	((mframe_t *) flyer_frames_pain1) + 8,

	(mmove_t *) &flyer_move_pain1,

	((mframe_t *) flyer_frames_defense) + 0,
	((mframe_t *) flyer_frames_defense) + 1,
	((mframe_t *) flyer_frames_defense) + 2,
	((mframe_t *) flyer_frames_defense) + 3,
	((mframe_t *) flyer_frames_defense) + 4,
	((mframe_t *) flyer_frames_defense) + 5,

	(mmove_t *) &flyer_move_defense,

	((mframe_t *) flyer_frames_bankright) + 0,
	((mframe_t *) flyer_frames_bankright) + 1,
	((mframe_t *) flyer_frames_bankright) + 2,
	((mframe_t *) flyer_frames_bankright) + 3,
	((mframe_t *) flyer_frames_bankright) + 4,
	((mframe_t *) flyer_frames_bankright) + 5,
	((mframe_t *) flyer_frames_bankright) + 6,

	(mmove_t *) &flyer_move_bankright,

	((mframe_t *) flyer_frames_bankleft) + 0,
	((mframe_t *) flyer_frames_bankleft) + 1,
	((mframe_t *) flyer_frames_bankleft) + 2,
	((mframe_t *) flyer_frames_bankleft) + 3,
	((mframe_t *) flyer_frames_bankleft) + 4,
	((mframe_t *) flyer_frames_bankleft) + 5,
	((mframe_t *) flyer_frames_bankleft) + 6,

	(mmove_t *) &flyer_move_bankleft,

	((mframe_t *) flyer_frames_attack2) + 0,
	((mframe_t *) flyer_frames_attack2) + 1,
	((mframe_t *) flyer_frames_attack2) + 2,
	((mframe_t *) flyer_frames_attack2) + 3,
	((mframe_t *) flyer_frames_attack2) + 4,
	((mframe_t *) flyer_frames_attack2) + 5,
	((mframe_t *) flyer_frames_attack2) + 6,
	((mframe_t *) flyer_frames_attack2) + 7,
	((mframe_t *) flyer_frames_attack2) + 8,
	((mframe_t *) flyer_frames_attack2) + 9,
	((mframe_t *) flyer_frames_attack2) + 10,
	((mframe_t *) flyer_frames_attack2) + 11,
	((mframe_t *) flyer_frames_attack2) + 12,
	((mframe_t *) flyer_frames_attack2) + 13,
	((mframe_t *) flyer_frames_attack2) + 14,
	((mframe_t *) flyer_frames_attack2) + 15,
	((mframe_t *) flyer_frames_attack2) + 16,

	(mmove_t *) &flyer_move_attack2,

	((mframe_t *) flyer_frames_start_melee) + 0,
	((mframe_t *) flyer_frames_start_melee) + 1,
	((mframe_t *) flyer_frames_start_melee) + 2,
	((mframe_t *) flyer_frames_start_melee) + 3,
	((mframe_t *) flyer_frames_start_melee) + 4,
	((mframe_t *) flyer_frames_start_melee) + 5,

	(mmove_t *) &flyer_move_start_melee,

	((mframe_t *) flyer_frames_end_melee) + 0,
	((mframe_t *) flyer_frames_end_melee) + 1,
	((mframe_t *) flyer_frames_end_melee) + 2,

	(mmove_t *) &flyer_move_end_melee,

	((mframe_t *) flyer_frames_loop_melee) + 0,
	((mframe_t *) flyer_frames_loop_melee) + 1,
	((mframe_t *) flyer_frames_loop_melee) + 2,
	((mframe_t *) flyer_frames_loop_melee) + 3,
	((mframe_t *) flyer_frames_loop_melee) + 4,
	((mframe_t *) flyer_frames_loop_melee) + 5,
	((mframe_t *) flyer_frames_loop_melee) + 6,
	((mframe_t *) flyer_frames_loop_melee) + 7,
	((mframe_t *) flyer_frames_loop_melee) + 8,
	((mframe_t *) flyer_frames_loop_melee) + 9,
	((mframe_t *) flyer_frames_loop_melee) + 10,
	((mframe_t *) flyer_frames_loop_melee) + 11,

	(mmove_t *) &flyer_move_loop_melee,

	((mframe_t *) gladiator_frames_stand) + 0,
	((mframe_t *) gladiator_frames_stand) + 1,
	((mframe_t *) gladiator_frames_stand) + 2,
	((mframe_t *) gladiator_frames_stand) + 3,
	((mframe_t *) gladiator_frames_stand) + 4,
	((mframe_t *) gladiator_frames_stand) + 5,
	((mframe_t *) gladiator_frames_stand) + 6,

	(mmove_t *) &gladiator_move_stand,

	((mframe_t *) gladiator_frames_walk) + 0,
	((mframe_t *) gladiator_frames_walk) + 1,
	((mframe_t *) gladiator_frames_walk) + 2,
	((mframe_t *) gladiator_frames_walk) + 3,
	((mframe_t *) gladiator_frames_walk) + 4,
	((mframe_t *) gladiator_frames_walk) + 5,
	((mframe_t *) gladiator_frames_walk) + 6,
	((mframe_t *) gladiator_frames_walk) + 7,
	((mframe_t *) gladiator_frames_walk) + 8,
	((mframe_t *) gladiator_frames_walk) + 9,
	((mframe_t *) gladiator_frames_walk) + 10,
	((mframe_t *) gladiator_frames_walk) + 11,
	((mframe_t *) gladiator_frames_walk) + 12,
	((mframe_t *) gladiator_frames_walk) + 13,
	((mframe_t *) gladiator_frames_walk) + 14,
	((mframe_t *) gladiator_frames_walk) + 15,

	(mmove_t *) &gladiator_move_walk,

	((mframe_t *) gladiator_frames_run) + 0,
	((mframe_t *) gladiator_frames_run) + 1,
	((mframe_t *) gladiator_frames_run) + 2,
	((mframe_t *) gladiator_frames_run) + 3,
	((mframe_t *) gladiator_frames_run) + 4,
	((mframe_t *) gladiator_frames_run) + 5,

	(mmove_t *) &gladiator_move_run,

	((mframe_t *) gladiator_frames_attack_melee) + 0,
	((mframe_t *) gladiator_frames_attack_melee) + 1,
	((mframe_t *) gladiator_frames_attack_melee) + 2,
	((mframe_t *) gladiator_frames_attack_melee) + 3,
	((mframe_t *) gladiator_frames_attack_melee) + 4,
	((mframe_t *) gladiator_frames_attack_melee) + 5,
	((mframe_t *) gladiator_frames_attack_melee) + 6,
	((mframe_t *) gladiator_frames_attack_melee) + 7,
	((mframe_t *) gladiator_frames_attack_melee) + 8,
	((mframe_t *) gladiator_frames_attack_melee) + 9,
	((mframe_t *) gladiator_frames_attack_melee) + 10,
	((mframe_t *) gladiator_frames_attack_melee) + 11,
	((mframe_t *) gladiator_frames_attack_melee) + 12,
	((mframe_t *) gladiator_frames_attack_melee) + 13,
	((mframe_t *) gladiator_frames_attack_melee) + 14,
	((mframe_t *) gladiator_frames_attack_melee) + 15,
	((mframe_t *) gladiator_frames_attack_melee) + 16,

	(mmove_t *) &gladiator_move_attack_melee,

	((mframe_t *) gladiator_frames_attack_gun) + 0,
	((mframe_t *) gladiator_frames_attack_gun) + 1,
	((mframe_t *) gladiator_frames_attack_gun) + 2,
	((mframe_t *) gladiator_frames_attack_gun) + 3,
	((mframe_t *) gladiator_frames_attack_gun) + 4,
	((mframe_t *) gladiator_frames_attack_gun) + 5,
	((mframe_t *) gladiator_frames_attack_gun) + 6,
	((mframe_t *) gladiator_frames_attack_gun) + 7,
	((mframe_t *) gladiator_frames_attack_gun) + 8,

	(mmove_t *) &gladiator_move_attack_gun,

	((mframe_t *) gladiator_frames_pain) + 0,
	((mframe_t *) gladiator_frames_pain) + 1,
	((mframe_t *) gladiator_frames_pain) + 2,
	((mframe_t *) gladiator_frames_pain) + 3,
	((mframe_t *) gladiator_frames_pain) + 4,
	((mframe_t *) gladiator_frames_pain) + 5,

	(mmove_t *) &gladiator_move_pain,

	((mframe_t *) gladiator_frames_pain_air) + 0,
	((mframe_t *) gladiator_frames_pain_air) + 1,
	((mframe_t *) gladiator_frames_pain_air) + 2,
	((mframe_t *) gladiator_frames_pain_air) + 3,
	((mframe_t *) gladiator_frames_pain_air) + 4,
	((mframe_t *) gladiator_frames_pain_air) + 5,
	((mframe_t *) gladiator_frames_pain_air) + 6,

	(mmove_t *) &gladiator_move_pain_air,

	((mframe_t *) gladiator_frames_death) + 0,
	((mframe_t *) gladiator_frames_death) + 1,
	((mframe_t *) gladiator_frames_death) + 2,
	((mframe_t *) gladiator_frames_death) + 3,
	((mframe_t *) gladiator_frames_death) + 4,
	((mframe_t *) gladiator_frames_death) + 5,
	((mframe_t *) gladiator_frames_death) + 6,
	((mframe_t *) gladiator_frames_death) + 7,
	((mframe_t *) gladiator_frames_death) + 8,
	((mframe_t *) gladiator_frames_death) + 9,
	((mframe_t *) gladiator_frames_death) + 10,
	((mframe_t *) gladiator_frames_death) + 11,
	((mframe_t *) gladiator_frames_death) + 12,
	((mframe_t *) gladiator_frames_death) + 13,
	((mframe_t *) gladiator_frames_death) + 14,
	((mframe_t *) gladiator_frames_death) + 15,
	((mframe_t *) gladiator_frames_death) + 16,
	((mframe_t *) gladiator_frames_death) + 17,
	((mframe_t *) gladiator_frames_death) + 18,
	((mframe_t *) gladiator_frames_death) + 19,
	((mframe_t *) gladiator_frames_death) + 20,
	((mframe_t *) gladiator_frames_death) + 21,

	(mmove_t *) &gladiator_move_death,

	((mframe_t *) gunner_frames_fidget) + 0,
	((mframe_t *) gunner_frames_fidget) + 1,
	((mframe_t *) gunner_frames_fidget) + 2,
	((mframe_t *) gunner_frames_fidget) + 3,
	((mframe_t *) gunner_frames_fidget) + 4,
	((mframe_t *) gunner_frames_fidget) + 5,
	((mframe_t *) gunner_frames_fidget) + 6,
	((mframe_t *) gunner_frames_fidget) + 7,
	((mframe_t *) gunner_frames_fidget) + 8,
	((mframe_t *) gunner_frames_fidget) + 9,
	((mframe_t *) gunner_frames_fidget) + 10,
	((mframe_t *) gunner_frames_fidget) + 11,
	((mframe_t *) gunner_frames_fidget) + 12,
	((mframe_t *) gunner_frames_fidget) + 13,
	((mframe_t *) gunner_frames_fidget) + 14,
	((mframe_t *) gunner_frames_fidget) + 15,
	((mframe_t *) gunner_frames_fidget) + 16,
	((mframe_t *) gunner_frames_fidget) + 17,
	((mframe_t *) gunner_frames_fidget) + 18,
	((mframe_t *) gunner_frames_fidget) + 19,
	((mframe_t *) gunner_frames_fidget) + 20,
	((mframe_t *) gunner_frames_fidget) + 21,
	((mframe_t *) gunner_frames_fidget) + 22,
	((mframe_t *) gunner_frames_fidget) + 23,
	((mframe_t *) gunner_frames_fidget) + 24,
	((mframe_t *) gunner_frames_fidget) + 25,
	((mframe_t *) gunner_frames_fidget) + 26,
	((mframe_t *) gunner_frames_fidget) + 27,
	((mframe_t *) gunner_frames_fidget) + 28,
	((mframe_t *) gunner_frames_fidget) + 29,
	((mframe_t *) gunner_frames_fidget) + 30,
	((mframe_t *) gunner_frames_fidget) + 31,
	((mframe_t *) gunner_frames_fidget) + 32,
	((mframe_t *) gunner_frames_fidget) + 33,
	((mframe_t *) gunner_frames_fidget) + 34,
	((mframe_t *) gunner_frames_fidget) + 35,
	((mframe_t *) gunner_frames_fidget) + 36,
	((mframe_t *) gunner_frames_fidget) + 37,
	((mframe_t *) gunner_frames_fidget) + 38,
	((mframe_t *) gunner_frames_fidget) + 39,
	((mframe_t *) gunner_frames_fidget) + 40,
	((mframe_t *) gunner_frames_fidget) + 41,
	((mframe_t *) gunner_frames_fidget) + 42,
	((mframe_t *) gunner_frames_fidget) + 43,
	((mframe_t *) gunner_frames_fidget) + 44,
	((mframe_t *) gunner_frames_fidget) + 45,
	((mframe_t *) gunner_frames_fidget) + 46,
	((mframe_t *) gunner_frames_fidget) + 47,
	((mframe_t *) gunner_frames_fidget) + 48,

	(mmove_t *) &gunner_move_fidget,

	((mframe_t *) gunner_frames_stand) + 0,
	((mframe_t *) gunner_frames_stand) + 1,
	((mframe_t *) gunner_frames_stand) + 2,
	((mframe_t *) gunner_frames_stand) + 3,
	((mframe_t *) gunner_frames_stand) + 4,
	((mframe_t *) gunner_frames_stand) + 5,
	((mframe_t *) gunner_frames_stand) + 6,
	((mframe_t *) gunner_frames_stand) + 7,
	((mframe_t *) gunner_frames_stand) + 8,
	((mframe_t *) gunner_frames_stand) + 9,
	((mframe_t *) gunner_frames_stand) + 10,
	((mframe_t *) gunner_frames_stand) + 11,
	((mframe_t *) gunner_frames_stand) + 12,
	((mframe_t *) gunner_frames_stand) + 13,
	((mframe_t *) gunner_frames_stand) + 14,
	((mframe_t *) gunner_frames_stand) + 15,
	((mframe_t *) gunner_frames_stand) + 16,
	((mframe_t *) gunner_frames_stand) + 17,
	((mframe_t *) gunner_frames_stand) + 18,
	((mframe_t *) gunner_frames_stand) + 19,
	((mframe_t *) gunner_frames_stand) + 20,
	((mframe_t *) gunner_frames_stand) + 21,
	((mframe_t *) gunner_frames_stand) + 22,
	((mframe_t *) gunner_frames_stand) + 23,
	((mframe_t *) gunner_frames_stand) + 24,
	((mframe_t *) gunner_frames_stand) + 25,
	((mframe_t *) gunner_frames_stand) + 26,
	((mframe_t *) gunner_frames_stand) + 27,
	((mframe_t *) gunner_frames_stand) + 28,
	((mframe_t *) gunner_frames_stand) + 29,

	(mmove_t *) &gunner_move_stand,

	((mframe_t *) gunner_frames_walk) + 0,
	((mframe_t *) gunner_frames_walk) + 1,
	((mframe_t *) gunner_frames_walk) + 2,
	((mframe_t *) gunner_frames_walk) + 3,
	((mframe_t *) gunner_frames_walk) + 4,
	((mframe_t *) gunner_frames_walk) + 5,
	((mframe_t *) gunner_frames_walk) + 6,
	((mframe_t *) gunner_frames_walk) + 7,
	((mframe_t *) gunner_frames_walk) + 8,
	((mframe_t *) gunner_frames_walk) + 9,
	((mframe_t *) gunner_frames_walk) + 10,
	((mframe_t *) gunner_frames_walk) + 11,
	((mframe_t *) gunner_frames_walk) + 12,

	(mmove_t *) &gunner_move_walk,

	((mframe_t *) gunner_frames_run) + 0,
	((mframe_t *) gunner_frames_run) + 1,
	((mframe_t *) gunner_frames_run) + 2,
	((mframe_t *) gunner_frames_run) + 3,
	((mframe_t *) gunner_frames_run) + 4,
	((mframe_t *) gunner_frames_run) + 5,
	((mframe_t *) gunner_frames_run) + 6,
	((mframe_t *) gunner_frames_run) + 7,

	(mmove_t *) &gunner_move_run,

	((mframe_t *) gunner_frames_runandshoot) + 0,
	((mframe_t *) gunner_frames_runandshoot) + 1,
	((mframe_t *) gunner_frames_runandshoot) + 2,
	((mframe_t *) gunner_frames_runandshoot) + 3,
	((mframe_t *) gunner_frames_runandshoot) + 4,
	((mframe_t *) gunner_frames_runandshoot) + 5,

	(mmove_t *) &gunner_move_runandshoot,

	((mframe_t *) gunner_frames_pain3) + 0,
	((mframe_t *) gunner_frames_pain3) + 1,
	((mframe_t *) gunner_frames_pain3) + 2,
	((mframe_t *) gunner_frames_pain3) + 3,
	((mframe_t *) gunner_frames_pain3) + 4,

	(mmove_t *) &gunner_move_pain3,

	((mframe_t *) gunner_frames_pain2) + 0,
	((mframe_t *) gunner_frames_pain2) + 1,
	((mframe_t *) gunner_frames_pain2) + 2,
	((mframe_t *) gunner_frames_pain2) + 3,
	((mframe_t *) gunner_frames_pain2) + 4,
	((mframe_t *) gunner_frames_pain2) + 5,
	((mframe_t *) gunner_frames_pain2) + 6,
	((mframe_t *) gunner_frames_pain2) + 7,

	(mmove_t *) &gunner_move_pain2,

	((mframe_t *) gunner_frames_pain1) + 0,
	((mframe_t *) gunner_frames_pain1) + 1,
	((mframe_t *) gunner_frames_pain1) + 2,
	((mframe_t *) gunner_frames_pain1) + 3,
	((mframe_t *) gunner_frames_pain1) + 4,
	((mframe_t *) gunner_frames_pain1) + 5,
	((mframe_t *) gunner_frames_pain1) + 6,
	((mframe_t *) gunner_frames_pain1) + 7,
	((mframe_t *) gunner_frames_pain1) + 8,
	((mframe_t *) gunner_frames_pain1) + 9,
	((mframe_t *) gunner_frames_pain1) + 10,
	((mframe_t *) gunner_frames_pain1) + 11,
	((mframe_t *) gunner_frames_pain1) + 12,
	((mframe_t *) gunner_frames_pain1) + 13,
	((mframe_t *) gunner_frames_pain1) + 14,
	((mframe_t *) gunner_frames_pain1) + 15,
	((mframe_t *) gunner_frames_pain1) + 16,
	((mframe_t *) gunner_frames_pain1) + 17,

	(mmove_t *) &gunner_move_pain1,

	((mframe_t *) gunner_frames_death) + 0,
	((mframe_t *) gunner_frames_death) + 1,
	((mframe_t *) gunner_frames_death) + 2,
	((mframe_t *) gunner_frames_death) + 3,
	((mframe_t *) gunner_frames_death) + 4,
	((mframe_t *) gunner_frames_death) + 5,
	((mframe_t *) gunner_frames_death) + 6,
	((mframe_t *) gunner_frames_death) + 7,
	((mframe_t *) gunner_frames_death) + 8,
	((mframe_t *) gunner_frames_death) + 9,
	((mframe_t *) gunner_frames_death) + 10,

	(mmove_t *) &gunner_move_death,

	((mframe_t *) gunner_frames_duck) + 0,
	((mframe_t *) gunner_frames_duck) + 1,
	((mframe_t *) gunner_frames_duck) + 2,
	((mframe_t *) gunner_frames_duck) + 3,
	((mframe_t *) gunner_frames_duck) + 4,
	((mframe_t *) gunner_frames_duck) + 5,
	((mframe_t *) gunner_frames_duck) + 6,
	((mframe_t *) gunner_frames_duck) + 7,

	(mmove_t *) &gunner_move_duck,

	((mframe_t *) gunner_frames_attack_chain) + 0,
	((mframe_t *) gunner_frames_attack_chain) + 1,
	((mframe_t *) gunner_frames_attack_chain) + 2,
	((mframe_t *) gunner_frames_attack_chain) + 3,
	((mframe_t *) gunner_frames_attack_chain) + 4,
	((mframe_t *) gunner_frames_attack_chain) + 5,
	((mframe_t *) gunner_frames_attack_chain) + 6,

	(mmove_t *) &gunner_move_attack_chain,

	((mframe_t *) gunner_frames_fire_chain) + 0,
	((mframe_t *) gunner_frames_fire_chain) + 1,
	((mframe_t *) gunner_frames_fire_chain) + 2,
	((mframe_t *) gunner_frames_fire_chain) + 3,
	((mframe_t *) gunner_frames_fire_chain) + 4,
	((mframe_t *) gunner_frames_fire_chain) + 5,
	((mframe_t *) gunner_frames_fire_chain) + 6,
	((mframe_t *) gunner_frames_fire_chain) + 7,

	(mmove_t *) &gunner_move_fire_chain,

	((mframe_t *) gunner_frames_endfire_chain) + 0,
	((mframe_t *) gunner_frames_endfire_chain) + 1,
	((mframe_t *) gunner_frames_endfire_chain) + 2,
	((mframe_t *) gunner_frames_endfire_chain) + 3,
	((mframe_t *) gunner_frames_endfire_chain) + 4,
	((mframe_t *) gunner_frames_endfire_chain) + 5,
	((mframe_t *) gunner_frames_endfire_chain) + 6,

	(mmove_t *) &gunner_move_endfire_chain,

	((mframe_t *) gunner_frames_attack_grenade) + 0,
	((mframe_t *) gunner_frames_attack_grenade) + 1,
	((mframe_t *) gunner_frames_attack_grenade) + 2,
	((mframe_t *) gunner_frames_attack_grenade) + 3,
	((mframe_t *) gunner_frames_attack_grenade) + 4,
	((mframe_t *) gunner_frames_attack_grenade) + 5,
	((mframe_t *) gunner_frames_attack_grenade) + 6,
	((mframe_t *) gunner_frames_attack_grenade) + 7,
	((mframe_t *) gunner_frames_attack_grenade) + 8,
	((mframe_t *) gunner_frames_attack_grenade) + 9,
	((mframe_t *) gunner_frames_attack_grenade) + 10,
	((mframe_t *) gunner_frames_attack_grenade) + 11,
	((mframe_t *) gunner_frames_attack_grenade) + 12,
	((mframe_t *) gunner_frames_attack_grenade) + 13,
	((mframe_t *) gunner_frames_attack_grenade) + 14,
	((mframe_t *) gunner_frames_attack_grenade) + 15,
	((mframe_t *) gunner_frames_attack_grenade) + 16,
	((mframe_t *) gunner_frames_attack_grenade) + 17,
	((mframe_t *) gunner_frames_attack_grenade) + 18,
	((mframe_t *) gunner_frames_attack_grenade) + 19,
	((mframe_t *) gunner_frames_attack_grenade) + 20,

	(mmove_t *) &gunner_move_attack_grenade,

	((mframe_t *) hover_frames_stand) + 0,
	((mframe_t *) hover_frames_stand) + 1,
	((mframe_t *) hover_frames_stand) + 2,
	((mframe_t *) hover_frames_stand) + 3,
	((mframe_t *) hover_frames_stand) + 4,
	((mframe_t *) hover_frames_stand) + 5,
	((mframe_t *) hover_frames_stand) + 6,
	((mframe_t *) hover_frames_stand) + 7,
	((mframe_t *) hover_frames_stand) + 8,
	((mframe_t *) hover_frames_stand) + 9,
	((mframe_t *) hover_frames_stand) + 10,
	((mframe_t *) hover_frames_stand) + 11,
	((mframe_t *) hover_frames_stand) + 12,
	((mframe_t *) hover_frames_stand) + 13,
	((mframe_t *) hover_frames_stand) + 14,
	((mframe_t *) hover_frames_stand) + 15,
	((mframe_t *) hover_frames_stand) + 16,
	((mframe_t *) hover_frames_stand) + 17,
	((mframe_t *) hover_frames_stand) + 18,
	((mframe_t *) hover_frames_stand) + 19,
	((mframe_t *) hover_frames_stand) + 20,
	((mframe_t *) hover_frames_stand) + 21,
	((mframe_t *) hover_frames_stand) + 22,
	((mframe_t *) hover_frames_stand) + 23,
	((mframe_t *) hover_frames_stand) + 24,
	((mframe_t *) hover_frames_stand) + 25,
	((mframe_t *) hover_frames_stand) + 26,
	((mframe_t *) hover_frames_stand) + 27,
	((mframe_t *) hover_frames_stand) + 28,
	((mframe_t *) hover_frames_stand) + 29,

	(mmove_t *) &hover_move_stand,

	((mframe_t *) hover_frames_stop1) + 0,
	((mframe_t *) hover_frames_stop1) + 1,
	((mframe_t *) hover_frames_stop1) + 2,
	((mframe_t *) hover_frames_stop1) + 3,
	((mframe_t *) hover_frames_stop1) + 4,
	((mframe_t *) hover_frames_stop1) + 5,
	((mframe_t *) hover_frames_stop1) + 6,
	((mframe_t *) hover_frames_stop1) + 7,
	((mframe_t *) hover_frames_stop1) + 8,

	(mmove_t *) &hover_move_stop1,

	((mframe_t *) hover_frames_stop2) + 0,
	((mframe_t *) hover_frames_stop2) + 1,
	((mframe_t *) hover_frames_stop2) + 2,
	((mframe_t *) hover_frames_stop2) + 3,
	((mframe_t *) hover_frames_stop2) + 4,
	((mframe_t *) hover_frames_stop2) + 5,
	((mframe_t *) hover_frames_stop2) + 6,
	((mframe_t *) hover_frames_stop2) + 7,

	(mmove_t *) &hover_move_stop2,

	((mframe_t *) hover_frames_takeoff) + 0,
	((mframe_t *) hover_frames_takeoff) + 1,
	((mframe_t *) hover_frames_takeoff) + 2,
	((mframe_t *) hover_frames_takeoff) + 3,
	((mframe_t *) hover_frames_takeoff) + 4,
	((mframe_t *) hover_frames_takeoff) + 5,
	((mframe_t *) hover_frames_takeoff) + 6,
	((mframe_t *) hover_frames_takeoff) + 7,
	((mframe_t *) hover_frames_takeoff) + 8,
	((mframe_t *) hover_frames_takeoff) + 9,
	((mframe_t *) hover_frames_takeoff) + 10,
	((mframe_t *) hover_frames_takeoff) + 11,
	((mframe_t *) hover_frames_takeoff) + 12,
	((mframe_t *) hover_frames_takeoff) + 13,
	((mframe_t *) hover_frames_takeoff) + 14,
	((mframe_t *) hover_frames_takeoff) + 15,
	((mframe_t *) hover_frames_takeoff) + 16,
	((mframe_t *) hover_frames_takeoff) + 17,
	((mframe_t *) hover_frames_takeoff) + 18,
	((mframe_t *) hover_frames_takeoff) + 19,
	((mframe_t *) hover_frames_takeoff) + 20,
	((mframe_t *) hover_frames_takeoff) + 21,
	((mframe_t *) hover_frames_takeoff) + 22,
	((mframe_t *) hover_frames_takeoff) + 23,
	((mframe_t *) hover_frames_takeoff) + 24,
	((mframe_t *) hover_frames_takeoff) + 25,
	((mframe_t *) hover_frames_takeoff) + 26,
	((mframe_t *) hover_frames_takeoff) + 27,
	((mframe_t *) hover_frames_takeoff) + 28,
	((mframe_t *) hover_frames_takeoff) + 29,

	(mmove_t *) &hover_move_takeoff,

	((mframe_t *) hover_frames_pain3) + 0,
	((mframe_t *) hover_frames_pain3) + 1,
	((mframe_t *) hover_frames_pain3) + 2,
	((mframe_t *) hover_frames_pain3) + 3,
	((mframe_t *) hover_frames_pain3) + 4,
	((mframe_t *) hover_frames_pain3) + 5,
	((mframe_t *) hover_frames_pain3) + 6,
	((mframe_t *) hover_frames_pain3) + 7,
	((mframe_t *) hover_frames_pain3) + 8,

	(mmove_t *) &hover_move_pain3,

	((mframe_t *) hover_frames_pain2) + 0,
	((mframe_t *) hover_frames_pain2) + 1,
	((mframe_t *) hover_frames_pain2) + 2,
	((mframe_t *) hover_frames_pain2) + 3,
	((mframe_t *) hover_frames_pain2) + 4,
	((mframe_t *) hover_frames_pain2) + 5,
	((mframe_t *) hover_frames_pain2) + 6,
	((mframe_t *) hover_frames_pain2) + 7,
	((mframe_t *) hover_frames_pain2) + 8,
	((mframe_t *) hover_frames_pain2) + 9,
	((mframe_t *) hover_frames_pain2) + 10,
	((mframe_t *) hover_frames_pain2) + 11,

	(mmove_t *) &hover_move_pain2,

	((mframe_t *) hover_frames_pain1) + 0,
	((mframe_t *) hover_frames_pain1) + 1,
	((mframe_t *) hover_frames_pain1) + 2,
	((mframe_t *) hover_frames_pain1) + 3,
	((mframe_t *) hover_frames_pain1) + 4,
	((mframe_t *) hover_frames_pain1) + 5,
	((mframe_t *) hover_frames_pain1) + 6,
	((mframe_t *) hover_frames_pain1) + 7,
	((mframe_t *) hover_frames_pain1) + 8,
	((mframe_t *) hover_frames_pain1) + 9,
	((mframe_t *) hover_frames_pain1) + 10,
	((mframe_t *) hover_frames_pain1) + 11,
	((mframe_t *) hover_frames_pain1) + 12,
	((mframe_t *) hover_frames_pain1) + 13,
	((mframe_t *) hover_frames_pain1) + 14,
	((mframe_t *) hover_frames_pain1) + 15,
	((mframe_t *) hover_frames_pain1) + 16,
	((mframe_t *) hover_frames_pain1) + 17,
	((mframe_t *) hover_frames_pain1) + 18,
	((mframe_t *) hover_frames_pain1) + 19,
	((mframe_t *) hover_frames_pain1) + 20,
	((mframe_t *) hover_frames_pain1) + 21,
	((mframe_t *) hover_frames_pain1) + 22,
	((mframe_t *) hover_frames_pain1) + 23,
	((mframe_t *) hover_frames_pain1) + 24,
	((mframe_t *) hover_frames_pain1) + 25,
	((mframe_t *) hover_frames_pain1) + 26,
	((mframe_t *) hover_frames_pain1) + 27,

	(mmove_t *) &hover_move_pain1,

	((mframe_t *) hover_frames_land) + 0,

	(mmove_t *) &hover_move_land,

	((mframe_t *) hover_frames_forward) + 0,
	((mframe_t *) hover_frames_forward) + 1,
	((mframe_t *) hover_frames_forward) + 2,
	((mframe_t *) hover_frames_forward) + 3,
	((mframe_t *) hover_frames_forward) + 4,
	((mframe_t *) hover_frames_forward) + 5,
	((mframe_t *) hover_frames_forward) + 6,
	((mframe_t *) hover_frames_forward) + 7,
	((mframe_t *) hover_frames_forward) + 8,
	((mframe_t *) hover_frames_forward) + 9,
	((mframe_t *) hover_frames_forward) + 10,
	((mframe_t *) hover_frames_forward) + 11,
	((mframe_t *) hover_frames_forward) + 12,
	((mframe_t *) hover_frames_forward) + 13,
	((mframe_t *) hover_frames_forward) + 14,
	((mframe_t *) hover_frames_forward) + 15,
	((mframe_t *) hover_frames_forward) + 16,
	((mframe_t *) hover_frames_forward) + 17,
	((mframe_t *) hover_frames_forward) + 18,
	((mframe_t *) hover_frames_forward) + 19,
	((mframe_t *) hover_frames_forward) + 20,
	((mframe_t *) hover_frames_forward) + 21,
	((mframe_t *) hover_frames_forward) + 22,
	((mframe_t *) hover_frames_forward) + 23,
	((mframe_t *) hover_frames_forward) + 24,
	((mframe_t *) hover_frames_forward) + 25,
	((mframe_t *) hover_frames_forward) + 26,
	((mframe_t *) hover_frames_forward) + 27,
	((mframe_t *) hover_frames_forward) + 28,
	((mframe_t *) hover_frames_forward) + 29,
	((mframe_t *) hover_frames_forward) + 30,
	((mframe_t *) hover_frames_forward) + 31,
	((mframe_t *) hover_frames_forward) + 32,
	((mframe_t *) hover_frames_forward) + 33,
	((mframe_t *) hover_frames_forward) + 34,

	(mmove_t *) &hover_move_forward,

	((mframe_t *) hover_frames_walk) + 0,
	((mframe_t *) hover_frames_walk) + 1,
	((mframe_t *) hover_frames_walk) + 2,
	((mframe_t *) hover_frames_walk) + 3,
	((mframe_t *) hover_frames_walk) + 4,
	((mframe_t *) hover_frames_walk) + 5,
	((mframe_t *) hover_frames_walk) + 6,
	((mframe_t *) hover_frames_walk) + 7,
	((mframe_t *) hover_frames_walk) + 8,
	((mframe_t *) hover_frames_walk) + 9,
	((mframe_t *) hover_frames_walk) + 10,
	((mframe_t *) hover_frames_walk) + 11,
	((mframe_t *) hover_frames_walk) + 12,
	((mframe_t *) hover_frames_walk) + 13,
	((mframe_t *) hover_frames_walk) + 14,
	((mframe_t *) hover_frames_walk) + 15,
	((mframe_t *) hover_frames_walk) + 16,
	((mframe_t *) hover_frames_walk) + 17,
	((mframe_t *) hover_frames_walk) + 18,
	((mframe_t *) hover_frames_walk) + 19,
	((mframe_t *) hover_frames_walk) + 20,
	((mframe_t *) hover_frames_walk) + 21,
	((mframe_t *) hover_frames_walk) + 22,
	((mframe_t *) hover_frames_walk) + 23,
	((mframe_t *) hover_frames_walk) + 24,
	((mframe_t *) hover_frames_walk) + 25,
	((mframe_t *) hover_frames_walk) + 26,
	((mframe_t *) hover_frames_walk) + 27,
	((mframe_t *) hover_frames_walk) + 28,
	((mframe_t *) hover_frames_walk) + 29,
	((mframe_t *) hover_frames_walk) + 30,
	((mframe_t *) hover_frames_walk) + 31,
	((mframe_t *) hover_frames_walk) + 32,
	((mframe_t *) hover_frames_walk) + 33,
	((mframe_t *) hover_frames_walk) + 34,

	(mmove_t *) &hover_move_walk,

	((mframe_t *) hover_frames_run) + 0,
	((mframe_t *) hover_frames_run) + 1,
	((mframe_t *) hover_frames_run) + 2,
	((mframe_t *) hover_frames_run) + 3,
	((mframe_t *) hover_frames_run) + 4,
	((mframe_t *) hover_frames_run) + 5,
	((mframe_t *) hover_frames_run) + 6,
	((mframe_t *) hover_frames_run) + 7,
	((mframe_t *) hover_frames_run) + 8,
	((mframe_t *) hover_frames_run) + 9,
	((mframe_t *) hover_frames_run) + 10,
	((mframe_t *) hover_frames_run) + 11,
	((mframe_t *) hover_frames_run) + 12,
	((mframe_t *) hover_frames_run) + 13,
	((mframe_t *) hover_frames_run) + 14,
	((mframe_t *) hover_frames_run) + 15,
	((mframe_t *) hover_frames_run) + 16,
	((mframe_t *) hover_frames_run) + 17,
	((mframe_t *) hover_frames_run) + 18,
	((mframe_t *) hover_frames_run) + 19,
	((mframe_t *) hover_frames_run) + 20,
	((mframe_t *) hover_frames_run) + 21,
	((mframe_t *) hover_frames_run) + 22,
	((mframe_t *) hover_frames_run) + 23,
	((mframe_t *) hover_frames_run) + 24,
	((mframe_t *) hover_frames_run) + 25,
	((mframe_t *) hover_frames_run) + 26,
	((mframe_t *) hover_frames_run) + 27,
	((mframe_t *) hover_frames_run) + 28,
	((mframe_t *) hover_frames_run) + 29,
	((mframe_t *) hover_frames_run) + 30,
	((mframe_t *) hover_frames_run) + 31,
	((mframe_t *) hover_frames_run) + 32,
	((mframe_t *) hover_frames_run) + 33,
	((mframe_t *) hover_frames_run) + 34,

	(mmove_t *) &hover_move_run,

	((mframe_t *) hover_frames_death1) + 0,
	((mframe_t *) hover_frames_death1) + 1,
	((mframe_t *) hover_frames_death1) + 2,
	((mframe_t *) hover_frames_death1) + 3,
	((mframe_t *) hover_frames_death1) + 4,
	((mframe_t *) hover_frames_death1) + 5,
	((mframe_t *) hover_frames_death1) + 6,
	((mframe_t *) hover_frames_death1) + 7,
	((mframe_t *) hover_frames_death1) + 8,
	((mframe_t *) hover_frames_death1) + 9,
	((mframe_t *) hover_frames_death1) + 10,

	(mmove_t *) &hover_move_death1,

	((mframe_t *) hover_frames_backward) + 0,
	((mframe_t *) hover_frames_backward) + 1,
	((mframe_t *) hover_frames_backward) + 2,
	((mframe_t *) hover_frames_backward) + 3,
	((mframe_t *) hover_frames_backward) + 4,
	((mframe_t *) hover_frames_backward) + 5,
	((mframe_t *) hover_frames_backward) + 6,
	((mframe_t *) hover_frames_backward) + 7,
	((mframe_t *) hover_frames_backward) + 8,
	((mframe_t *) hover_frames_backward) + 9,
	((mframe_t *) hover_frames_backward) + 10,
	((mframe_t *) hover_frames_backward) + 11,
	((mframe_t *) hover_frames_backward) + 12,
	((mframe_t *) hover_frames_backward) + 13,
	((mframe_t *) hover_frames_backward) + 14,
	((mframe_t *) hover_frames_backward) + 15,
	((mframe_t *) hover_frames_backward) + 16,
	((mframe_t *) hover_frames_backward) + 17,
	((mframe_t *) hover_frames_backward) + 18,
	((mframe_t *) hover_frames_backward) + 19,
	((mframe_t *) hover_frames_backward) + 20,
	((mframe_t *) hover_frames_backward) + 21,
	((mframe_t *) hover_frames_backward) + 22,
	((mframe_t *) hover_frames_backward) + 23,

	(mmove_t *) &hover_move_backward,

	((mframe_t *) hover_frames_start_attack) + 0,
	((mframe_t *) hover_frames_start_attack) + 1,
	((mframe_t *) hover_frames_start_attack) + 2,

	(mmove_t *) &hover_move_start_attack,

	((mframe_t *) hover_frames_attack1) + 0,
	((mframe_t *) hover_frames_attack1) + 1,
	((mframe_t *) hover_frames_attack1) + 2,

	(mmove_t *) &hover_move_attack1,

	((mframe_t *) hover_frames_end_attack) + 0,
	((mframe_t *) hover_frames_end_attack) + 1,

	(mmove_t *) &hover_move_end_attack,

	((mframe_t *) infantry_frames_stand) + 0,
	((mframe_t *) infantry_frames_stand) + 1,
	((mframe_t *) infantry_frames_stand) + 2,
	((mframe_t *) infantry_frames_stand) + 3,
	((mframe_t *) infantry_frames_stand) + 4,
	((mframe_t *) infantry_frames_stand) + 5,
	((mframe_t *) infantry_frames_stand) + 6,
	((mframe_t *) infantry_frames_stand) + 7,
	((mframe_t *) infantry_frames_stand) + 8,
	((mframe_t *) infantry_frames_stand) + 9,
	((mframe_t *) infantry_frames_stand) + 10,
	((mframe_t *) infantry_frames_stand) + 11,
	((mframe_t *) infantry_frames_stand) + 12,
	((mframe_t *) infantry_frames_stand) + 13,
	((mframe_t *) infantry_frames_stand) + 14,
	((mframe_t *) infantry_frames_stand) + 15,
	((mframe_t *) infantry_frames_stand) + 16,
	((mframe_t *) infantry_frames_stand) + 17,
	((mframe_t *) infantry_frames_stand) + 18,
	((mframe_t *) infantry_frames_stand) + 19,
	((mframe_t *) infantry_frames_stand) + 20,
	((mframe_t *) infantry_frames_stand) + 21,

	(mmove_t *) &infantry_move_stand,

	((mframe_t *) infantry_frames_fidget) + 0,
	((mframe_t *) infantry_frames_fidget) + 1,
	((mframe_t *) infantry_frames_fidget) + 2,
	((mframe_t *) infantry_frames_fidget) + 3,
	((mframe_t *) infantry_frames_fidget) + 4,
	((mframe_t *) infantry_frames_fidget) + 5,
	((mframe_t *) infantry_frames_fidget) + 6,
	((mframe_t *) infantry_frames_fidget) + 7,
	((mframe_t *) infantry_frames_fidget) + 8,
	((mframe_t *) infantry_frames_fidget) + 9,
	((mframe_t *) infantry_frames_fidget) + 10,
	((mframe_t *) infantry_frames_fidget) + 11,
	((mframe_t *) infantry_frames_fidget) + 12,
	((mframe_t *) infantry_frames_fidget) + 13,
	((mframe_t *) infantry_frames_fidget) + 14,
	((mframe_t *) infantry_frames_fidget) + 15,
	((mframe_t *) infantry_frames_fidget) + 16,
	((mframe_t *) infantry_frames_fidget) + 17,
	((mframe_t *) infantry_frames_fidget) + 18,
	((mframe_t *) infantry_frames_fidget) + 19,
	((mframe_t *) infantry_frames_fidget) + 20,
	((mframe_t *) infantry_frames_fidget) + 21,
	((mframe_t *) infantry_frames_fidget) + 22,
	((mframe_t *) infantry_frames_fidget) + 23,
	((mframe_t *) infantry_frames_fidget) + 24,
	((mframe_t *) infantry_frames_fidget) + 25,
	((mframe_t *) infantry_frames_fidget) + 26,
	((mframe_t *) infantry_frames_fidget) + 27,
	((mframe_t *) infantry_frames_fidget) + 28,
	((mframe_t *) infantry_frames_fidget) + 29,
	((mframe_t *) infantry_frames_fidget) + 30,
	((mframe_t *) infantry_frames_fidget) + 31,
	((mframe_t *) infantry_frames_fidget) + 32,
	((mframe_t *) infantry_frames_fidget) + 33,
	((mframe_t *) infantry_frames_fidget) + 34,
	((mframe_t *) infantry_frames_fidget) + 35,
	((mframe_t *) infantry_frames_fidget) + 36,
	((mframe_t *) infantry_frames_fidget) + 37,
	((mframe_t *) infantry_frames_fidget) + 38,
	((mframe_t *) infantry_frames_fidget) + 39,
	((mframe_t *) infantry_frames_fidget) + 40,
	((mframe_t *) infantry_frames_fidget) + 41,
	((mframe_t *) infantry_frames_fidget) + 42,
	((mframe_t *) infantry_frames_fidget) + 43,
	((mframe_t *) infantry_frames_fidget) + 44,
	((mframe_t *) infantry_frames_fidget) + 45,
	((mframe_t *) infantry_frames_fidget) + 46,
	((mframe_t *) infantry_frames_fidget) + 47,
	((mframe_t *) infantry_frames_fidget) + 48,

	(mmove_t *) &infantry_move_fidget,

	((mframe_t *) infantry_frames_walk) + 0,
	((mframe_t *) infantry_frames_walk) + 1,
	((mframe_t *) infantry_frames_walk) + 2,
	((mframe_t *) infantry_frames_walk) + 3,
	((mframe_t *) infantry_frames_walk) + 4,
	((mframe_t *) infantry_frames_walk) + 5,
	((mframe_t *) infantry_frames_walk) + 6,
	((mframe_t *) infantry_frames_walk) + 7,
	((mframe_t *) infantry_frames_walk) + 8,
	((mframe_t *) infantry_frames_walk) + 9,
	((mframe_t *) infantry_frames_walk) + 10,
	((mframe_t *) infantry_frames_walk) + 11,

	(mmove_t *) &infantry_move_walk,

	((mframe_t *) infantry_frames_run) + 0,
	((mframe_t *) infantry_frames_run) + 1,
	((mframe_t *) infantry_frames_run) + 2,
	((mframe_t *) infantry_frames_run) + 3,
	((mframe_t *) infantry_frames_run) + 4,
	((mframe_t *) infantry_frames_run) + 5,
	((mframe_t *) infantry_frames_run) + 6,
	((mframe_t *) infantry_frames_run) + 7,

	(mmove_t *) &infantry_move_run,

	((mframe_t *) infantry_frames_pain1) + 0,
	((mframe_t *) infantry_frames_pain1) + 1,
	((mframe_t *) infantry_frames_pain1) + 2,
	((mframe_t *) infantry_frames_pain1) + 3,
	((mframe_t *) infantry_frames_pain1) + 4,
	((mframe_t *) infantry_frames_pain1) + 5,
	((mframe_t *) infantry_frames_pain1) + 6,
	((mframe_t *) infantry_frames_pain1) + 7,
	((mframe_t *) infantry_frames_pain1) + 8,
	((mframe_t *) infantry_frames_pain1) + 9,

	(mmove_t *) &infantry_move_pain1,

	((mframe_t *) infantry_frames_pain2) + 0,
	((mframe_t *) infantry_frames_pain2) + 1,
	((mframe_t *) infantry_frames_pain2) + 2,
	((mframe_t *) infantry_frames_pain2) + 3,
	((mframe_t *) infantry_frames_pain2) + 4,
	((mframe_t *) infantry_frames_pain2) + 5,
	((mframe_t *) infantry_frames_pain2) + 6,
	((mframe_t *) infantry_frames_pain2) + 7,
	((mframe_t *) infantry_frames_pain2) + 8,
	((mframe_t *) infantry_frames_pain2) + 9,

	(mmove_t *) &infantry_move_pain2,

	((mframe_t *) infantry_frames_death1) + 0,
	((mframe_t *) infantry_frames_death1) + 1,
	((mframe_t *) infantry_frames_death1) + 2,
	((mframe_t *) infantry_frames_death1) + 3,
	((mframe_t *) infantry_frames_death1) + 4,
	((mframe_t *) infantry_frames_death1) + 5,
	((mframe_t *) infantry_frames_death1) + 6,
	((mframe_t *) infantry_frames_death1) + 7,
	((mframe_t *) infantry_frames_death1) + 8,
	((mframe_t *) infantry_frames_death1) + 9,
	((mframe_t *) infantry_frames_death1) + 10,
	((mframe_t *) infantry_frames_death1) + 11,
	((mframe_t *) infantry_frames_death1) + 12,
	((mframe_t *) infantry_frames_death1) + 13,
	((mframe_t *) infantry_frames_death1) + 14,
	((mframe_t *) infantry_frames_death1) + 15,
	((mframe_t *) infantry_frames_death1) + 16,
	((mframe_t *) infantry_frames_death1) + 17,
	((mframe_t *) infantry_frames_death1) + 18,
	((mframe_t *) infantry_frames_death1) + 19,

	(mmove_t *) &infantry_move_death1,

	((mframe_t *) infantry_frames_death2) + 0,
	((mframe_t *) infantry_frames_death2) + 1,
	((mframe_t *) infantry_frames_death2) + 2,
	((mframe_t *) infantry_frames_death2) + 3,
	((mframe_t *) infantry_frames_death2) + 4,
	((mframe_t *) infantry_frames_death2) + 5,
	((mframe_t *) infantry_frames_death2) + 6,
	((mframe_t *) infantry_frames_death2) + 7,
	((mframe_t *) infantry_frames_death2) + 8,
	((mframe_t *) infantry_frames_death2) + 9,
	((mframe_t *) infantry_frames_death2) + 10,
	((mframe_t *) infantry_frames_death2) + 11,
	((mframe_t *) infantry_frames_death2) + 12,
	((mframe_t *) infantry_frames_death2) + 13,
	((mframe_t *) infantry_frames_death2) + 14,
	((mframe_t *) infantry_frames_death2) + 15,
	((mframe_t *) infantry_frames_death2) + 16,
	((mframe_t *) infantry_frames_death2) + 17,
	((mframe_t *) infantry_frames_death2) + 18,
	((mframe_t *) infantry_frames_death2) + 19,
	((mframe_t *) infantry_frames_death2) + 20,
	((mframe_t *) infantry_frames_death2) + 21,
	((mframe_t *) infantry_frames_death2) + 22,
	((mframe_t *) infantry_frames_death2) + 23,
	((mframe_t *) infantry_frames_death2) + 24,

	(mmove_t *) &infantry_move_death2,

	((mframe_t *) infantry_frames_death3) + 0,
	((mframe_t *) infantry_frames_death3) + 1,
	((mframe_t *) infantry_frames_death3) + 2,
	((mframe_t *) infantry_frames_death3) + 3,
	((mframe_t *) infantry_frames_death3) + 4,
	((mframe_t *) infantry_frames_death3) + 5,
	((mframe_t *) infantry_frames_death3) + 6,
	((mframe_t *) infantry_frames_death3) + 7,
	((mframe_t *) infantry_frames_death3) + 8,

	(mmove_t *) &infantry_move_death3,

	((mframe_t *) infantry_frames_duck) + 0,
	((mframe_t *) infantry_frames_duck) + 1,
	((mframe_t *) infantry_frames_duck) + 2,
	((mframe_t *) infantry_frames_duck) + 3,
	((mframe_t *) infantry_frames_duck) + 4,

	(mmove_t *) &infantry_move_duck,

	((mframe_t *) infantry_frames_attack1) + 0,
	((mframe_t *) infantry_frames_attack1) + 1,
	((mframe_t *) infantry_frames_attack1) + 2,
	((mframe_t *) infantry_frames_attack1) + 3,
	((mframe_t *) infantry_frames_attack1) + 4,
	((mframe_t *) infantry_frames_attack1) + 5,
	((mframe_t *) infantry_frames_attack1) + 6,
	((mframe_t *) infantry_frames_attack1) + 7,
	((mframe_t *) infantry_frames_attack1) + 8,
	((mframe_t *) infantry_frames_attack1) + 9,
	((mframe_t *) infantry_frames_attack1) + 10,
	((mframe_t *) infantry_frames_attack1) + 11,
	((mframe_t *) infantry_frames_attack1) + 12,
	((mframe_t *) infantry_frames_attack1) + 13,
	((mframe_t *) infantry_frames_attack1) + 14,

	(mmove_t *) &infantry_move_attack1,

	((mframe_t *) infantry_frames_attack2) + 0,
	((mframe_t *) infantry_frames_attack2) + 1,
	((mframe_t *) infantry_frames_attack2) + 2,
	((mframe_t *) infantry_frames_attack2) + 3,
	((mframe_t *) infantry_frames_attack2) + 4,
	((mframe_t *) infantry_frames_attack2) + 5,
	((mframe_t *) infantry_frames_attack2) + 6,
	((mframe_t *) infantry_frames_attack2) + 7,

	(mmove_t *) &infantry_move_attack2,

	((mframe_t *) insane_frames_stand_normal) + 0,
	((mframe_t *) insane_frames_stand_normal) + 1,
	((mframe_t *) insane_frames_stand_normal) + 2,
	((mframe_t *) insane_frames_stand_normal) + 3,
	((mframe_t *) insane_frames_stand_normal) + 4,
	((mframe_t *) insane_frames_stand_normal) + 5,

	(mmove_t *) &insane_move_stand_normal,

	((mframe_t *) insane_frames_stand_insane) + 0,
	((mframe_t *) insane_frames_stand_insane) + 1,
	((mframe_t *) insane_frames_stand_insane) + 2,
	((mframe_t *) insane_frames_stand_insane) + 3,
	((mframe_t *) insane_frames_stand_insane) + 4,
	((mframe_t *) insane_frames_stand_insane) + 5,
	((mframe_t *) insane_frames_stand_insane) + 6,
	((mframe_t *) insane_frames_stand_insane) + 7,
	((mframe_t *) insane_frames_stand_insane) + 8,
	((mframe_t *) insane_frames_stand_insane) + 9,
	((mframe_t *) insane_frames_stand_insane) + 10,
	((mframe_t *) insane_frames_stand_insane) + 11,
	((mframe_t *) insane_frames_stand_insane) + 12,
	((mframe_t *) insane_frames_stand_insane) + 13,
	((mframe_t *) insane_frames_stand_insane) + 14,
	((mframe_t *) insane_frames_stand_insane) + 15,
	((mframe_t *) insane_frames_stand_insane) + 16,
	((mframe_t *) insane_frames_stand_insane) + 17,
	((mframe_t *) insane_frames_stand_insane) + 18,
	((mframe_t *) insane_frames_stand_insane) + 19,
	((mframe_t *) insane_frames_stand_insane) + 20,
	((mframe_t *) insane_frames_stand_insane) + 21,
	((mframe_t *) insane_frames_stand_insane) + 22,
	((mframe_t *) insane_frames_stand_insane) + 23,
	((mframe_t *) insane_frames_stand_insane) + 24,
	((mframe_t *) insane_frames_stand_insane) + 25,
	((mframe_t *) insane_frames_stand_insane) + 26,
	((mframe_t *) insane_frames_stand_insane) + 27,
	((mframe_t *) insane_frames_stand_insane) + 28,
	((mframe_t *) insane_frames_stand_insane) + 29,

	(mmove_t *) &insane_move_stand_insane,

	((mframe_t *) insane_frames_uptodown) + 0,
	((mframe_t *) insane_frames_uptodown) + 1,
	((mframe_t *) insane_frames_uptodown) + 2,
	((mframe_t *) insane_frames_uptodown) + 3,
	((mframe_t *) insane_frames_uptodown) + 4,
	((mframe_t *) insane_frames_uptodown) + 5,
	((mframe_t *) insane_frames_uptodown) + 6,
	((mframe_t *) insane_frames_uptodown) + 7,
	((mframe_t *) insane_frames_uptodown) + 8,
	((mframe_t *) insane_frames_uptodown) + 9,
	((mframe_t *) insane_frames_uptodown) + 10,
	((mframe_t *) insane_frames_uptodown) + 11,
	((mframe_t *) insane_frames_uptodown) + 12,
	((mframe_t *) insane_frames_uptodown) + 13,
	((mframe_t *) insane_frames_uptodown) + 14,
	((mframe_t *) insane_frames_uptodown) + 15,
	((mframe_t *) insane_frames_uptodown) + 16,
	((mframe_t *) insane_frames_uptodown) + 17,
	((mframe_t *) insane_frames_uptodown) + 18,
	((mframe_t *) insane_frames_uptodown) + 19,
	((mframe_t *) insane_frames_uptodown) + 20,
	((mframe_t *) insane_frames_uptodown) + 21,
	((mframe_t *) insane_frames_uptodown) + 22,
	((mframe_t *) insane_frames_uptodown) + 23,
	((mframe_t *) insane_frames_uptodown) + 24,
	((mframe_t *) insane_frames_uptodown) + 25,
	((mframe_t *) insane_frames_uptodown) + 26,
	((mframe_t *) insane_frames_uptodown) + 27,
	((mframe_t *) insane_frames_uptodown) + 28,
	((mframe_t *) insane_frames_uptodown) + 29,
	((mframe_t *) insane_frames_uptodown) + 30,
	((mframe_t *) insane_frames_uptodown) + 31,
	((mframe_t *) insane_frames_uptodown) + 32,
	((mframe_t *) insane_frames_uptodown) + 33,
	((mframe_t *) insane_frames_uptodown) + 34,
	((mframe_t *) insane_frames_uptodown) + 35,
	((mframe_t *) insane_frames_uptodown) + 36,
	((mframe_t *) insane_frames_uptodown) + 37,
	((mframe_t *) insane_frames_uptodown) + 38,
	((mframe_t *) insane_frames_uptodown) + 39,

	(mmove_t *) &insane_move_uptodown,

	((mframe_t *) insane_frames_downtoup) + 0,
	((mframe_t *) insane_frames_downtoup) + 1,
	((mframe_t *) insane_frames_downtoup) + 2,
	((mframe_t *) insane_frames_downtoup) + 3,
	((mframe_t *) insane_frames_downtoup) + 4,
	((mframe_t *) insane_frames_downtoup) + 5,
	((mframe_t *) insane_frames_downtoup) + 6,
	((mframe_t *) insane_frames_downtoup) + 7,
	((mframe_t *) insane_frames_downtoup) + 8,
	((mframe_t *) insane_frames_downtoup) + 9,
	((mframe_t *) insane_frames_downtoup) + 10,
	((mframe_t *) insane_frames_downtoup) + 11,
	((mframe_t *) insane_frames_downtoup) + 12,
	((mframe_t *) insane_frames_downtoup) + 13,
	((mframe_t *) insane_frames_downtoup) + 14,
	((mframe_t *) insane_frames_downtoup) + 15,
	((mframe_t *) insane_frames_downtoup) + 16,
	((mframe_t *) insane_frames_downtoup) + 17,
	((mframe_t *) insane_frames_downtoup) + 18,

	(mmove_t *) &insane_move_downtoup,

	((mframe_t *) insane_frames_jumpdown) + 0,
	((mframe_t *) insane_frames_jumpdown) + 1,
	((mframe_t *) insane_frames_jumpdown) + 2,
	((mframe_t *) insane_frames_jumpdown) + 3,
	((mframe_t *) insane_frames_jumpdown) + 4,

	(mmove_t *) &insane_move_jumpdown,

	((mframe_t *) insane_frames_down) + 0,
	((mframe_t *) insane_frames_down) + 1,
	((mframe_t *) insane_frames_down) + 2,
	((mframe_t *) insane_frames_down) + 3,
	((mframe_t *) insane_frames_down) + 4,
	((mframe_t *) insane_frames_down) + 5,
	((mframe_t *) insane_frames_down) + 6,
	((mframe_t *) insane_frames_down) + 7,
	((mframe_t *) insane_frames_down) + 8,
	((mframe_t *) insane_frames_down) + 9,
	((mframe_t *) insane_frames_down) + 10,
	((mframe_t *) insane_frames_down) + 11,
	((mframe_t *) insane_frames_down) + 12,
	((mframe_t *) insane_frames_down) + 13,
	((mframe_t *) insane_frames_down) + 14,
	((mframe_t *) insane_frames_down) + 15,
	((mframe_t *) insane_frames_down) + 16,
	((mframe_t *) insane_frames_down) + 17,
	((mframe_t *) insane_frames_down) + 18,
	((mframe_t *) insane_frames_down) + 19,
	((mframe_t *) insane_frames_down) + 20,
	((mframe_t *) insane_frames_down) + 21,
	((mframe_t *) insane_frames_down) + 22,
	((mframe_t *) insane_frames_down) + 23,
	((mframe_t *) insane_frames_down) + 24,
	((mframe_t *) insane_frames_down) + 25,
	((mframe_t *) insane_frames_down) + 26,
	((mframe_t *) insane_frames_down) + 27,
	((mframe_t *) insane_frames_down) + 28,
	((mframe_t *) insane_frames_down) + 29,
	((mframe_t *) insane_frames_down) + 30,
	((mframe_t *) insane_frames_down) + 31,
	((mframe_t *) insane_frames_down) + 32,
	((mframe_t *) insane_frames_down) + 33,
	((mframe_t *) insane_frames_down) + 34,
	((mframe_t *) insane_frames_down) + 35,
	((mframe_t *) insane_frames_down) + 36,
	((mframe_t *) insane_frames_down) + 37,
	((mframe_t *) insane_frames_down) + 38,
	((mframe_t *) insane_frames_down) + 39,
	((mframe_t *) insane_frames_down) + 40,
	((mframe_t *) insane_frames_down) + 41,
	((mframe_t *) insane_frames_down) + 42,
	((mframe_t *) insane_frames_down) + 43,
	((mframe_t *) insane_frames_down) + 44,
	((mframe_t *) insane_frames_down) + 45,
	((mframe_t *) insane_frames_down) + 46,
	((mframe_t *) insane_frames_down) + 47,
	((mframe_t *) insane_frames_down) + 48,
	((mframe_t *) insane_frames_down) + 49,
	((mframe_t *) insane_frames_down) + 50,
	((mframe_t *) insane_frames_down) + 51,
	((mframe_t *) insane_frames_down) + 52,
	((mframe_t *) insane_frames_down) + 53,
	((mframe_t *) insane_frames_down) + 54,
	((mframe_t *) insane_frames_down) + 55,
	((mframe_t *) insane_frames_down) + 56,
	((mframe_t *) insane_frames_down) + 57,
	((mframe_t *) insane_frames_down) + 58,
	((mframe_t *) insane_frames_down) + 59,
	((mframe_t *) insane_frames_down) + 60,

	(mmove_t *) &insane_move_down,

	((mframe_t *) insane_frames_walk_normal) + 0,
	((mframe_t *) insane_frames_walk_normal) + 1,
	((mframe_t *) insane_frames_walk_normal) + 2,
	((mframe_t *) insane_frames_walk_normal) + 3,
	((mframe_t *) insane_frames_walk_normal) + 4,
	((mframe_t *) insane_frames_walk_normal) + 5,
	((mframe_t *) insane_frames_walk_normal) + 6,
	((mframe_t *) insane_frames_walk_normal) + 7,
	((mframe_t *) insane_frames_walk_normal) + 8,
	((mframe_t *) insane_frames_walk_normal) + 9,
	((mframe_t *) insane_frames_walk_normal) + 10,
	((mframe_t *) insane_frames_walk_normal) + 11,
	((mframe_t *) insane_frames_walk_normal) + 12,

	(mmove_t *) &insane_move_walk_normal,
	(mmove_t *) &insane_move_run_normal,

	((mframe_t *) insane_frames_walk_insane) + 0,
	((mframe_t *) insane_frames_walk_insane) + 1,
	((mframe_t *) insane_frames_walk_insane) + 2,
	((mframe_t *) insane_frames_walk_insane) + 3,
	((mframe_t *) insane_frames_walk_insane) + 4,
	((mframe_t *) insane_frames_walk_insane) + 5,
	((mframe_t *) insane_frames_walk_insane) + 6,
	((mframe_t *) insane_frames_walk_insane) + 7,
	((mframe_t *) insane_frames_walk_insane) + 8,
	((mframe_t *) insane_frames_walk_insane) + 9,
	((mframe_t *) insane_frames_walk_insane) + 10,
	((mframe_t *) insane_frames_walk_insane) + 11,
	((mframe_t *) insane_frames_walk_insane) + 12,
	((mframe_t *) insane_frames_walk_insane) + 13,
	((mframe_t *) insane_frames_walk_insane) + 14,
	((mframe_t *) insane_frames_walk_insane) + 15,
	((mframe_t *) insane_frames_walk_insane) + 16,
	((mframe_t *) insane_frames_walk_insane) + 17,
	((mframe_t *) insane_frames_walk_insane) + 18,
	((mframe_t *) insane_frames_walk_insane) + 19,
	((mframe_t *) insane_frames_walk_insane) + 20,
	((mframe_t *) insane_frames_walk_insane) + 21,
	((mframe_t *) insane_frames_walk_insane) + 22,
	((mframe_t *) insane_frames_walk_insane) + 23,
	((mframe_t *) insane_frames_walk_insane) + 24,
	((mframe_t *) insane_frames_walk_insane) + 25,

	(mmove_t *) &insane_move_walk_insane,
	(mmove_t *) &insane_move_run_insane,

	((mframe_t *) insane_frames_stand_pain) + 0,
	((mframe_t *) insane_frames_stand_pain) + 1,
	((mframe_t *) insane_frames_stand_pain) + 2,
	((mframe_t *) insane_frames_stand_pain) + 3,
	((mframe_t *) insane_frames_stand_pain) + 4,
	((mframe_t *) insane_frames_stand_pain) + 5,
	((mframe_t *) insane_frames_stand_pain) + 6,
	((mframe_t *) insane_frames_stand_pain) + 7,
	((mframe_t *) insane_frames_stand_pain) + 8,
	((mframe_t *) insane_frames_stand_pain) + 9,
	((mframe_t *) insane_frames_stand_pain) + 10,

	(mmove_t *) &insane_move_stand_pain,

	((mframe_t *) insane_frames_stand_death) + 0,
	((mframe_t *) insane_frames_stand_death) + 1,
	((mframe_t *) insane_frames_stand_death) + 2,
	((mframe_t *) insane_frames_stand_death) + 3,
	((mframe_t *) insane_frames_stand_death) + 4,
	((mframe_t *) insane_frames_stand_death) + 5,
	((mframe_t *) insane_frames_stand_death) + 6,
	((mframe_t *) insane_frames_stand_death) + 7,
	((mframe_t *) insane_frames_stand_death) + 8,
	((mframe_t *) insane_frames_stand_death) + 9,
	((mframe_t *) insane_frames_stand_death) + 10,
	((mframe_t *) insane_frames_stand_death) + 11,
	((mframe_t *) insane_frames_stand_death) + 12,
	((mframe_t *) insane_frames_stand_death) + 13,
	((mframe_t *) insane_frames_stand_death) + 14,
	((mframe_t *) insane_frames_stand_death) + 15,
	((mframe_t *) insane_frames_stand_death) + 16,

	(mmove_t *) &insane_move_stand_death,

	((mframe_t *) insane_frames_crawl) + 0,
	((mframe_t *) insane_frames_crawl) + 1,
	((mframe_t *) insane_frames_crawl) + 2,
	((mframe_t *) insane_frames_crawl) + 3,
	((mframe_t *) insane_frames_crawl) + 4,
	((mframe_t *) insane_frames_crawl) + 5,
	((mframe_t *) insane_frames_crawl) + 6,
	((mframe_t *) insane_frames_crawl) + 7,
	((mframe_t *) insane_frames_crawl) + 8,

	(mmove_t *) &insane_move_crawl,
	(mmove_t *) &insane_move_runcrawl,

	((mframe_t *) insane_frames_crawl_pain) + 0,
	((mframe_t *) insane_frames_crawl_pain) + 1,
	((mframe_t *) insane_frames_crawl_pain) + 2,
	((mframe_t *) insane_frames_crawl_pain) + 3,
	((mframe_t *) insane_frames_crawl_pain) + 4,
	((mframe_t *) insane_frames_crawl_pain) + 5,
	((mframe_t *) insane_frames_crawl_pain) + 6,
	((mframe_t *) insane_frames_crawl_pain) + 7,
	((mframe_t *) insane_frames_crawl_pain) + 8,

	(mmove_t *) &insane_move_crawl_pain,

	((mframe_t *) insane_frames_crawl_death) + 0,
	((mframe_t *) insane_frames_crawl_death) + 1,
	((mframe_t *) insane_frames_crawl_death) + 2,
	((mframe_t *) insane_frames_crawl_death) + 3,
	((mframe_t *) insane_frames_crawl_death) + 4,
	((mframe_t *) insane_frames_crawl_death) + 5,
	((mframe_t *) insane_frames_crawl_death) + 6,

	(mmove_t *) &insane_move_crawl_death,

	((mframe_t *) insane_frames_cross) + 0,
	((mframe_t *) insane_frames_cross) + 1,
	((mframe_t *) insane_frames_cross) + 2,
	((mframe_t *) insane_frames_cross) + 3,
	((mframe_t *) insane_frames_cross) + 4,
	((mframe_t *) insane_frames_cross) + 5,
	((mframe_t *) insane_frames_cross) + 6,
	((mframe_t *) insane_frames_cross) + 7,
	((mframe_t *) insane_frames_cross) + 8,
	((mframe_t *) insane_frames_cross) + 9,
	((mframe_t *) insane_frames_cross) + 10,
	((mframe_t *) insane_frames_cross) + 11,
	((mframe_t *) insane_frames_cross) + 12,
	((mframe_t *) insane_frames_cross) + 13,
	((mframe_t *) insane_frames_cross) + 14,

	(mmove_t *) &insane_move_cross,

	((mframe_t *) insane_frames_struggle_cross) + 0,
	((mframe_t *) insane_frames_struggle_cross) + 1,
	((mframe_t *) insane_frames_struggle_cross) + 2,
	((mframe_t *) insane_frames_struggle_cross) + 3,
	((mframe_t *) insane_frames_struggle_cross) + 4,
	((mframe_t *) insane_frames_struggle_cross) + 5,
	((mframe_t *) insane_frames_struggle_cross) + 6,
	((mframe_t *) insane_frames_struggle_cross) + 7,
	((mframe_t *) insane_frames_struggle_cross) + 8,
	((mframe_t *) insane_frames_struggle_cross) + 9,
	((mframe_t *) insane_frames_struggle_cross) + 10,
	((mframe_t *) insane_frames_struggle_cross) + 11,
	((mframe_t *) insane_frames_struggle_cross) + 12,
	((mframe_t *) insane_frames_struggle_cross) + 13,
	((mframe_t *) insane_frames_struggle_cross) + 14,

	(mmove_t *) &insane_move_struggle_cross,

	((mframe_t *) medic_frames_stand) + 0,
	((mframe_t *) medic_frames_stand) + 1,
	((mframe_t *) medic_frames_stand) + 2,
	((mframe_t *) medic_frames_stand) + 3,
	((mframe_t *) medic_frames_stand) + 4,
	((mframe_t *) medic_frames_stand) + 5,
	((mframe_t *) medic_frames_stand) + 6,
	((mframe_t *) medic_frames_stand) + 7,
	((mframe_t *) medic_frames_stand) + 8,
	((mframe_t *) medic_frames_stand) + 9,
	((mframe_t *) medic_frames_stand) + 10,
	((mframe_t *) medic_frames_stand) + 11,
	((mframe_t *) medic_frames_stand) + 12,
	((mframe_t *) medic_frames_stand) + 13,
	((mframe_t *) medic_frames_stand) + 14,
	((mframe_t *) medic_frames_stand) + 15,
	((mframe_t *) medic_frames_stand) + 16,
	((mframe_t *) medic_frames_stand) + 17,
	((mframe_t *) medic_frames_stand) + 18,
	((mframe_t *) medic_frames_stand) + 19,
	((mframe_t *) medic_frames_stand) + 20,
	((mframe_t *) medic_frames_stand) + 21,
	((mframe_t *) medic_frames_stand) + 22,
	((mframe_t *) medic_frames_stand) + 23,
	((mframe_t *) medic_frames_stand) + 24,
	((mframe_t *) medic_frames_stand) + 25,
	((mframe_t *) medic_frames_stand) + 26,
	((mframe_t *) medic_frames_stand) + 27,
	((mframe_t *) medic_frames_stand) + 28,
	((mframe_t *) medic_frames_stand) + 29,
	((mframe_t *) medic_frames_stand) + 30,
	((mframe_t *) medic_frames_stand) + 31,
	((mframe_t *) medic_frames_stand) + 32,
	((mframe_t *) medic_frames_stand) + 33,
	((mframe_t *) medic_frames_stand) + 34,
	((mframe_t *) medic_frames_stand) + 35,
	((mframe_t *) medic_frames_stand) + 36,
	((mframe_t *) medic_frames_stand) + 37,
	((mframe_t *) medic_frames_stand) + 38,
	((mframe_t *) medic_frames_stand) + 39,
	((mframe_t *) medic_frames_stand) + 40,
	((mframe_t *) medic_frames_stand) + 41,
	((mframe_t *) medic_frames_stand) + 42,
	((mframe_t *) medic_frames_stand) + 43,
	((mframe_t *) medic_frames_stand) + 44,
	((mframe_t *) medic_frames_stand) + 45,
	((mframe_t *) medic_frames_stand) + 46,
	((mframe_t *) medic_frames_stand) + 47,
	((mframe_t *) medic_frames_stand) + 48,
	((mframe_t *) medic_frames_stand) + 49,
	((mframe_t *) medic_frames_stand) + 50,
	((mframe_t *) medic_frames_stand) + 51,
	((mframe_t *) medic_frames_stand) + 52,
	((mframe_t *) medic_frames_stand) + 53,
	((mframe_t *) medic_frames_stand) + 54,
	((mframe_t *) medic_frames_stand) + 55,
	((mframe_t *) medic_frames_stand) + 56,
	((mframe_t *) medic_frames_stand) + 57,
	((mframe_t *) medic_frames_stand) + 58,
	((mframe_t *) medic_frames_stand) + 59,
	((mframe_t *) medic_frames_stand) + 60,
	((mframe_t *) medic_frames_stand) + 61,
	((mframe_t *) medic_frames_stand) + 62,
	((mframe_t *) medic_frames_stand) + 63,
	((mframe_t *) medic_frames_stand) + 64,
	((mframe_t *) medic_frames_stand) + 65,
	((mframe_t *) medic_frames_stand) + 66,
	((mframe_t *) medic_frames_stand) + 67,
	((mframe_t *) medic_frames_stand) + 68,
	((mframe_t *) medic_frames_stand) + 69,
	((mframe_t *) medic_frames_stand) + 70,
	((mframe_t *) medic_frames_stand) + 71,
	((mframe_t *) medic_frames_stand) + 72,
	((mframe_t *) medic_frames_stand) + 73,
	((mframe_t *) medic_frames_stand) + 74,
	((mframe_t *) medic_frames_stand) + 75,
	((mframe_t *) medic_frames_stand) + 76,
	((mframe_t *) medic_frames_stand) + 77,
	((mframe_t *) medic_frames_stand) + 78,
	((mframe_t *) medic_frames_stand) + 79,
	((mframe_t *) medic_frames_stand) + 80,
	((mframe_t *) medic_frames_stand) + 81,
	((mframe_t *) medic_frames_stand) + 82,
	((mframe_t *) medic_frames_stand) + 83,
	((mframe_t *) medic_frames_stand) + 84,
	((mframe_t *) medic_frames_stand) + 85,
	((mframe_t *) medic_frames_stand) + 86,
	((mframe_t *) medic_frames_stand) + 87,
	((mframe_t *) medic_frames_stand) + 88,
	((mframe_t *) medic_frames_stand) + 89,

	(mmove_t *) &medic_move_stand,

	((mframe_t *) medic_frames_walk) + 0,
	((mframe_t *) medic_frames_walk) + 1,
	((mframe_t *) medic_frames_walk) + 2,
	((mframe_t *) medic_frames_walk) + 3,
	((mframe_t *) medic_frames_walk) + 4,
	((mframe_t *) medic_frames_walk) + 5,
	((mframe_t *) medic_frames_walk) + 6,
	((mframe_t *) medic_frames_walk) + 7,
	((mframe_t *) medic_frames_walk) + 8,
	((mframe_t *) medic_frames_walk) + 9,
	((mframe_t *) medic_frames_walk) + 10,
	((mframe_t *) medic_frames_walk) + 11,

	(mmove_t *) &medic_move_walk,

	((mframe_t *) medic_frames_run) + 0,
	((mframe_t *) medic_frames_run) + 1,
	((mframe_t *) medic_frames_run) + 2,
	((mframe_t *) medic_frames_run) + 3,
	((mframe_t *) medic_frames_run) + 4,
	((mframe_t *) medic_frames_run) + 5,

	(mmove_t *) &medic_move_run,

	((mframe_t *) medic_frames_pain1) + 0,
	((mframe_t *) medic_frames_pain1) + 1,
	((mframe_t *) medic_frames_pain1) + 2,
	((mframe_t *) medic_frames_pain1) + 3,
	((mframe_t *) medic_frames_pain1) + 4,
	((mframe_t *) medic_frames_pain1) + 5,
	((mframe_t *) medic_frames_pain1) + 6,
	((mframe_t *) medic_frames_pain1) + 7,

	(mmove_t *) &medic_move_pain1,

	((mframe_t *) medic_frames_pain2) + 0,
	((mframe_t *) medic_frames_pain2) + 1,
	((mframe_t *) medic_frames_pain2) + 2,
	((mframe_t *) medic_frames_pain2) + 3,
	((mframe_t *) medic_frames_pain2) + 4,
	((mframe_t *) medic_frames_pain2) + 5,
	((mframe_t *) medic_frames_pain2) + 6,
	((mframe_t *) medic_frames_pain2) + 7,
	((mframe_t *) medic_frames_pain2) + 8,
	((mframe_t *) medic_frames_pain2) + 9,
	((mframe_t *) medic_frames_pain2) + 10,
	((mframe_t *) medic_frames_pain2) + 11,
	((mframe_t *) medic_frames_pain2) + 12,
	((mframe_t *) medic_frames_pain2) + 13,
	((mframe_t *) medic_frames_pain2) + 14,

	(mmove_t *) &medic_move_pain2,

	((mframe_t *) medic_frames_death) + 0,
	((mframe_t *) medic_frames_death) + 1,
	((mframe_t *) medic_frames_death) + 2,
	((mframe_t *) medic_frames_death) + 3,
	((mframe_t *) medic_frames_death) + 4,
	((mframe_t *) medic_frames_death) + 5,
	((mframe_t *) medic_frames_death) + 6,
	((mframe_t *) medic_frames_death) + 7,
	((mframe_t *) medic_frames_death) + 8,
	((mframe_t *) medic_frames_death) + 9,
	((mframe_t *) medic_frames_death) + 10,
	((mframe_t *) medic_frames_death) + 11,
	((mframe_t *) medic_frames_death) + 12,
	((mframe_t *) medic_frames_death) + 13,
	((mframe_t *) medic_frames_death) + 14,
	((mframe_t *) medic_frames_death) + 15,
	((mframe_t *) medic_frames_death) + 16,
	((mframe_t *) medic_frames_death) + 17,
	((mframe_t *) medic_frames_death) + 18,
	((mframe_t *) medic_frames_death) + 19,
	((mframe_t *) medic_frames_death) + 20,
	((mframe_t *) medic_frames_death) + 21,
	((mframe_t *) medic_frames_death) + 22,
	((mframe_t *) medic_frames_death) + 23,
	((mframe_t *) medic_frames_death) + 24,
	((mframe_t *) medic_frames_death) + 25,
	((mframe_t *) medic_frames_death) + 26,
	((mframe_t *) medic_frames_death) + 27,
	((mframe_t *) medic_frames_death) + 28,
	((mframe_t *) medic_frames_death) + 29,

	(mmove_t *) &medic_move_death,

	((mframe_t *) medic_frames_duck) + 0,
	((mframe_t *) medic_frames_duck) + 1,
	((mframe_t *) medic_frames_duck) + 2,
	((mframe_t *) medic_frames_duck) + 3,
	((mframe_t *) medic_frames_duck) + 4,
	((mframe_t *) medic_frames_duck) + 5,
	((mframe_t *) medic_frames_duck) + 6,
	((mframe_t *) medic_frames_duck) + 7,
	((mframe_t *) medic_frames_duck) + 8,
	((mframe_t *) medic_frames_duck) + 9,
	((mframe_t *) medic_frames_duck) + 10,
	((mframe_t *) medic_frames_duck) + 11,
	((mframe_t *) medic_frames_duck) + 12,
	((mframe_t *) medic_frames_duck) + 13,
	((mframe_t *) medic_frames_duck) + 14,
	((mframe_t *) medic_frames_duck) + 15,

	(mmove_t *) &medic_move_duck,

	((mframe_t *) medic_frames_attackHyperBlaster) + 0,
	((mframe_t *) medic_frames_attackHyperBlaster) + 1,
	((mframe_t *) medic_frames_attackHyperBlaster) + 2,
	((mframe_t *) medic_frames_attackHyperBlaster) + 3,
	((mframe_t *) medic_frames_attackHyperBlaster) + 4,
	((mframe_t *) medic_frames_attackHyperBlaster) + 5,
	((mframe_t *) medic_frames_attackHyperBlaster) + 6,
	((mframe_t *) medic_frames_attackHyperBlaster) + 7,
	((mframe_t *) medic_frames_attackHyperBlaster) + 8,
	((mframe_t *) medic_frames_attackHyperBlaster) + 9,
	((mframe_t *) medic_frames_attackHyperBlaster) + 10,
	((mframe_t *) medic_frames_attackHyperBlaster) + 11,
	((mframe_t *) medic_frames_attackHyperBlaster) + 12,
	((mframe_t *) medic_frames_attackHyperBlaster) + 13,
	((mframe_t *) medic_frames_attackHyperBlaster) + 14,
	((mframe_t *) medic_frames_attackHyperBlaster) + 15,

	(mmove_t *) &medic_move_attackHyperBlaster,

	((mframe_t *) medic_frames_attackBlaster) + 0,
	((mframe_t *) medic_frames_attackBlaster) + 1,
	((mframe_t *) medic_frames_attackBlaster) + 2,
	((mframe_t *) medic_frames_attackBlaster) + 3,
	((mframe_t *) medic_frames_attackBlaster) + 4,
	((mframe_t *) medic_frames_attackBlaster) + 5,
	((mframe_t *) medic_frames_attackBlaster) + 6,
	((mframe_t *) medic_frames_attackBlaster) + 7,
	((mframe_t *) medic_frames_attackBlaster) + 8,
	((mframe_t *) medic_frames_attackBlaster) + 9,
	((mframe_t *) medic_frames_attackBlaster) + 10,
	((mframe_t *) medic_frames_attackBlaster) + 11,
	((mframe_t *) medic_frames_attackBlaster) + 12,
	((mframe_t *) medic_frames_attackBlaster) + 13,

	(mmove_t *) &medic_move_attackBlaster,

	((mframe_t *) medic_frames_attackCable) + 0,
	((mframe_t *) medic_frames_attackCable) + 1,
	((mframe_t *) medic_frames_attackCable) + 2,
	((mframe_t *) medic_frames_attackCable) + 3,
	((mframe_t *) medic_frames_attackCable) + 4,
	((mframe_t *) medic_frames_attackCable) + 5,
	((mframe_t *) medic_frames_attackCable) + 6,
	((mframe_t *) medic_frames_attackCable) + 7,
	((mframe_t *) medic_frames_attackCable) + 8,
	((mframe_t *) medic_frames_attackCable) + 9,
	((mframe_t *) medic_frames_attackCable) + 10,
	((mframe_t *) medic_frames_attackCable) + 11,
	((mframe_t *) medic_frames_attackCable) + 12,
	((mframe_t *) medic_frames_attackCable) + 13,
	((mframe_t *) medic_frames_attackCable) + 14,
	((mframe_t *) medic_frames_attackCable) + 15,
	((mframe_t *) medic_frames_attackCable) + 16,
	((mframe_t *) medic_frames_attackCable) + 17,
	((mframe_t *) medic_frames_attackCable) + 18,
	((mframe_t *) medic_frames_attackCable) + 19,
	((mframe_t *) medic_frames_attackCable) + 20,
	((mframe_t *) medic_frames_attackCable) + 21,
	((mframe_t *) medic_frames_attackCable) + 22,
	((mframe_t *) medic_frames_attackCable) + 23,
	((mframe_t *) medic_frames_attackCable) + 24,
	((mframe_t *) medic_frames_attackCable) + 25,
	((mframe_t *) medic_frames_attackCable) + 26,
	((mframe_t *) medic_frames_attackCable) + 27,

	(mmove_t *) &medic_move_attackCable,

	((mframe_t *) mutant_frames_stand) + 0,
	((mframe_t *) mutant_frames_stand) + 1,
	((mframe_t *) mutant_frames_stand) + 2,
	((mframe_t *) mutant_frames_stand) + 3,
	((mframe_t *) mutant_frames_stand) + 4,
	((mframe_t *) mutant_frames_stand) + 5,
	((mframe_t *) mutant_frames_stand) + 6,
	((mframe_t *) mutant_frames_stand) + 7,
	((mframe_t *) mutant_frames_stand) + 8,
	((mframe_t *) mutant_frames_stand) + 9,
	((mframe_t *) mutant_frames_stand) + 10,
	((mframe_t *) mutant_frames_stand) + 11,
	((mframe_t *) mutant_frames_stand) + 12,
	((mframe_t *) mutant_frames_stand) + 13,
	((mframe_t *) mutant_frames_stand) + 14,
	((mframe_t *) mutant_frames_stand) + 15,
	((mframe_t *) mutant_frames_stand) + 16,
	((mframe_t *) mutant_frames_stand) + 17,
	((mframe_t *) mutant_frames_stand) + 18,
	((mframe_t *) mutant_frames_stand) + 19,
	((mframe_t *) mutant_frames_stand) + 20,
	((mframe_t *) mutant_frames_stand) + 21,
	((mframe_t *) mutant_frames_stand) + 22,
	((mframe_t *) mutant_frames_stand) + 23,
	((mframe_t *) mutant_frames_stand) + 24,
	((mframe_t *) mutant_frames_stand) + 25,
	((mframe_t *) mutant_frames_stand) + 26,
	((mframe_t *) mutant_frames_stand) + 27,
	((mframe_t *) mutant_frames_stand) + 28,
	((mframe_t *) mutant_frames_stand) + 29,
	((mframe_t *) mutant_frames_stand) + 30,
	((mframe_t *) mutant_frames_stand) + 31,
	((mframe_t *) mutant_frames_stand) + 32,
	((mframe_t *) mutant_frames_stand) + 33,
	((mframe_t *) mutant_frames_stand) + 34,
	((mframe_t *) mutant_frames_stand) + 35,
	((mframe_t *) mutant_frames_stand) + 36,
	((mframe_t *) mutant_frames_stand) + 37,
	((mframe_t *) mutant_frames_stand) + 38,
	((mframe_t *) mutant_frames_stand) + 39,
	((mframe_t *) mutant_frames_stand) + 40,
	((mframe_t *) mutant_frames_stand) + 41,
	((mframe_t *) mutant_frames_stand) + 42,
	((mframe_t *) mutant_frames_stand) + 43,
	((mframe_t *) mutant_frames_stand) + 44,
	((mframe_t *) mutant_frames_stand) + 45,
	((mframe_t *) mutant_frames_stand) + 46,
	((mframe_t *) mutant_frames_stand) + 47,
	((mframe_t *) mutant_frames_stand) + 48,
	((mframe_t *) mutant_frames_stand) + 49,
	((mframe_t *) mutant_frames_stand) + 50,

	(mmove_t *) &mutant_move_stand,

	((mframe_t *) mutant_frames_idle) + 0,
	((mframe_t *) mutant_frames_idle) + 1,
	((mframe_t *) mutant_frames_idle) + 2,
	((mframe_t *) mutant_frames_idle) + 3,
	((mframe_t *) mutant_frames_idle) + 4,
	((mframe_t *) mutant_frames_idle) + 5,
	((mframe_t *) mutant_frames_idle) + 6,
	((mframe_t *) mutant_frames_idle) + 7,
	((mframe_t *) mutant_frames_idle) + 8,
	((mframe_t *) mutant_frames_idle) + 9,
	((mframe_t *) mutant_frames_idle) + 10,
	((mframe_t *) mutant_frames_idle) + 11,
	((mframe_t *) mutant_frames_idle) + 12,

	(mmove_t *) &mutant_move_idle,

	((mframe_t *) mutant_frames_walk) + 0,
	((mframe_t *) mutant_frames_walk) + 1,
	((mframe_t *) mutant_frames_walk) + 2,
	((mframe_t *) mutant_frames_walk) + 3,
	((mframe_t *) mutant_frames_walk) + 4,
	((mframe_t *) mutant_frames_walk) + 5,
	((mframe_t *) mutant_frames_walk) + 6,
	((mframe_t *) mutant_frames_walk) + 7,
	((mframe_t *) mutant_frames_walk) + 8,
	((mframe_t *) mutant_frames_walk) + 9,
	((mframe_t *) mutant_frames_walk) + 10,
	((mframe_t *) mutant_frames_walk) + 11,

	(mmove_t *) &mutant_move_walk,

	((mframe_t *) mutant_frames_start_walk) + 0,
	((mframe_t *) mutant_frames_start_walk) + 1,
	((mframe_t *) mutant_frames_start_walk) + 2,
	((mframe_t *) mutant_frames_start_walk) + 3,

	(mmove_t *) &mutant_move_start_walk,

	((mframe_t *) mutant_frames_run) + 0,
	((mframe_t *) mutant_frames_run) + 1,
	((mframe_t *) mutant_frames_run) + 2,
	((mframe_t *) mutant_frames_run) + 3,
	((mframe_t *) mutant_frames_run) + 4,
	((mframe_t *) mutant_frames_run) + 5,

	(mmove_t *) &mutant_move_run,

	((mframe_t *) mutant_frames_attack) + 0,
	((mframe_t *) mutant_frames_attack) + 1,
	((mframe_t *) mutant_frames_attack) + 2,
	((mframe_t *) mutant_frames_attack) + 3,
	((mframe_t *) mutant_frames_attack) + 4,
	((mframe_t *) mutant_frames_attack) + 5,
	((mframe_t *) mutant_frames_attack) + 6,

	(mmove_t *) &mutant_move_attack,

	((mframe_t *) mutant_frames_jump) + 0,
	((mframe_t *) mutant_frames_jump) + 1,
	((mframe_t *) mutant_frames_jump) + 2,
	((mframe_t *) mutant_frames_jump) + 3,
	((mframe_t *) mutant_frames_jump) + 4,
	((mframe_t *) mutant_frames_jump) + 5,
	((mframe_t *) mutant_frames_jump) + 6,
	((mframe_t *) mutant_frames_jump) + 7,

	(mmove_t *) &mutant_move_jump,

	((mframe_t *) mutant_frames_pain1) + 0,
	((mframe_t *) mutant_frames_pain1) + 1,
	((mframe_t *) mutant_frames_pain1) + 2,
	((mframe_t *) mutant_frames_pain1) + 3,
	((mframe_t *) mutant_frames_pain1) + 4,

	(mmove_t *) &mutant_move_pain1,

	((mframe_t *) mutant_frames_pain2) + 0,
	((mframe_t *) mutant_frames_pain2) + 1,
	((mframe_t *) mutant_frames_pain2) + 2,
	((mframe_t *) mutant_frames_pain2) + 3,
	((mframe_t *) mutant_frames_pain2) + 4,
	((mframe_t *) mutant_frames_pain2) + 5,

	(mmove_t *) &mutant_move_pain2,

	((mframe_t *) mutant_frames_pain3) + 0,
	((mframe_t *) mutant_frames_pain3) + 1,
	((mframe_t *) mutant_frames_pain3) + 2,
	((mframe_t *) mutant_frames_pain3) + 3,
	((mframe_t *) mutant_frames_pain3) + 4,
	((mframe_t *) mutant_frames_pain3) + 5,
	((mframe_t *) mutant_frames_pain3) + 6,
	((mframe_t *) mutant_frames_pain3) + 7,
	((mframe_t *) mutant_frames_pain3) + 8,
	((mframe_t *) mutant_frames_pain3) + 9,
	((mframe_t *) mutant_frames_pain3) + 10,

	(mmove_t *) &mutant_move_pain3,

	((mframe_t *) mutant_frames_death1) + 0,
	((mframe_t *) mutant_frames_death1) + 1,
	((mframe_t *) mutant_frames_death1) + 2,
	((mframe_t *) mutant_frames_death1) + 3,
	((mframe_t *) mutant_frames_death1) + 4,
	((mframe_t *) mutant_frames_death1) + 5,
	((mframe_t *) mutant_frames_death1) + 6,
	((mframe_t *) mutant_frames_death1) + 7,
	((mframe_t *) mutant_frames_death1) + 8,

	(mmove_t *) &mutant_move_death1,

	((mframe_t *) mutant_frames_death2) + 0,
	((mframe_t *) mutant_frames_death2) + 1,
	((mframe_t *) mutant_frames_death2) + 2,
	((mframe_t *) mutant_frames_death2) + 3,
	((mframe_t *) mutant_frames_death2) + 4,
	((mframe_t *) mutant_frames_death2) + 5,
	((mframe_t *) mutant_frames_death2) + 6,
	((mframe_t *) mutant_frames_death2) + 7,
	((mframe_t *) mutant_frames_death2) + 8,
	((mframe_t *) mutant_frames_death2) + 9,

	(mmove_t *) &mutant_move_death2,

	((mframe_t *) parasite_frames_start_fidget) + 0,
	((mframe_t *) parasite_frames_start_fidget) + 1,
	((mframe_t *) parasite_frames_start_fidget) + 2,
	((mframe_t *) parasite_frames_start_fidget) + 3,

	(mmove_t *) &parasite_move_start_fidget,

	((mframe_t *) parasite_frames_fidget) + 0,
	((mframe_t *) parasite_frames_fidget) + 1,
	((mframe_t *) parasite_frames_fidget) + 2,
	((mframe_t *) parasite_frames_fidget) + 3,
	((mframe_t *) parasite_frames_fidget) + 4,
	((mframe_t *) parasite_frames_fidget) + 5,

	(mmove_t *) &parasite_move_fidget,

	((mframe_t *) parasite_frames_end_fidget) + 0,
	((mframe_t *) parasite_frames_end_fidget) + 1,
	((mframe_t *) parasite_frames_end_fidget) + 2,
	((mframe_t *) parasite_frames_end_fidget) + 3,
	((mframe_t *) parasite_frames_end_fidget) + 4,
	((mframe_t *) parasite_frames_end_fidget) + 5,
	((mframe_t *) parasite_frames_end_fidget) + 6,
	((mframe_t *) parasite_frames_end_fidget) + 7,

	(mmove_t *) &parasite_move_end_fidget,

	((mframe_t *) parasite_frames_stand) + 0,
	((mframe_t *) parasite_frames_stand) + 1,
	((mframe_t *) parasite_frames_stand) + 2,
	((mframe_t *) parasite_frames_stand) + 3,
	((mframe_t *) parasite_frames_stand) + 4,
	((mframe_t *) parasite_frames_stand) + 5,
	((mframe_t *) parasite_frames_stand) + 6,
	((mframe_t *) parasite_frames_stand) + 7,
	((mframe_t *) parasite_frames_stand) + 8,
	((mframe_t *) parasite_frames_stand) + 9,
	((mframe_t *) parasite_frames_stand) + 10,
	((mframe_t *) parasite_frames_stand) + 11,
	((mframe_t *) parasite_frames_stand) + 12,
	((mframe_t *) parasite_frames_stand) + 13,
	((mframe_t *) parasite_frames_stand) + 14,
	((mframe_t *) parasite_frames_stand) + 15,
	((mframe_t *) parasite_frames_stand) + 16,

	(mmove_t *) &parasite_move_stand,

	((mframe_t *) parasite_frames_run) + 0,
	((mframe_t *) parasite_frames_run) + 1,
	((mframe_t *) parasite_frames_run) + 2,
	((mframe_t *) parasite_frames_run) + 3,
	((mframe_t *) parasite_frames_run) + 4,
	((mframe_t *) parasite_frames_run) + 5,
	((mframe_t *) parasite_frames_run) + 6,

	(mmove_t *) &parasite_move_run,

	((mframe_t *) parasite_frames_start_run) + 0,
	((mframe_t *) parasite_frames_start_run) + 1,

	(mmove_t *) &parasite_move_start_run,

	((mframe_t *) parasite_frames_stop_run) + 0,
	((mframe_t *) parasite_frames_stop_run) + 1,
	((mframe_t *) parasite_frames_stop_run) + 2,
	((mframe_t *) parasite_frames_stop_run) + 3,
	((mframe_t *) parasite_frames_stop_run) + 4,
	((mframe_t *) parasite_frames_stop_run) + 5,

	(mmove_t *) &parasite_move_stop_run,

	((mframe_t *) parasite_frames_walk) + 0,
	((mframe_t *) parasite_frames_walk) + 1,
	((mframe_t *) parasite_frames_walk) + 2,
	((mframe_t *) parasite_frames_walk) + 3,
	((mframe_t *) parasite_frames_walk) + 4,
	((mframe_t *) parasite_frames_walk) + 5,
	((mframe_t *) parasite_frames_walk) + 6,

	(mmove_t *) &parasite_move_walk,

	((mframe_t *) parasite_frames_start_walk) + 0,
	((mframe_t *) parasite_frames_start_walk) + 1,

	(mmove_t *) &parasite_move_start_walk,

	((mframe_t *) parasite_frames_stop_walk) + 0,
	((mframe_t *) parasite_frames_stop_walk) + 1,
	((mframe_t *) parasite_frames_stop_walk) + 2,
	((mframe_t *) parasite_frames_stop_walk) + 3,
	((mframe_t *) parasite_frames_stop_walk) + 4,
	((mframe_t *) parasite_frames_stop_walk) + 5,

	(mmove_t *) &parasite_move_stop_walk,

	((mframe_t *) parasite_frames_pain1) + 0,
	((mframe_t *) parasite_frames_pain1) + 1,
	((mframe_t *) parasite_frames_pain1) + 2,
	((mframe_t *) parasite_frames_pain1) + 3,
	((mframe_t *) parasite_frames_pain1) + 4,
	((mframe_t *) parasite_frames_pain1) + 5,
	((mframe_t *) parasite_frames_pain1) + 6,
	((mframe_t *) parasite_frames_pain1) + 7,
	((mframe_t *) parasite_frames_pain1) + 8,
	((mframe_t *) parasite_frames_pain1) + 9,
	((mframe_t *) parasite_frames_pain1) + 10,

	(mmove_t *) &parasite_move_pain1,

	((mframe_t *) parasite_frames_drain) + 0,
	((mframe_t *) parasite_frames_drain) + 1,
	((mframe_t *) parasite_frames_drain) + 2,
	((mframe_t *) parasite_frames_drain) + 3,
	((mframe_t *) parasite_frames_drain) + 4,
	((mframe_t *) parasite_frames_drain) + 5,
	((mframe_t *) parasite_frames_drain) + 6,
	((mframe_t *) parasite_frames_drain) + 7,
	((mframe_t *) parasite_frames_drain) + 8,
	((mframe_t *) parasite_frames_drain) + 9,
	((mframe_t *) parasite_frames_drain) + 10,
	((mframe_t *) parasite_frames_drain) + 11,
	((mframe_t *) parasite_frames_drain) + 12,
	((mframe_t *) parasite_frames_drain) + 13,
	((mframe_t *) parasite_frames_drain) + 14,
	((mframe_t *) parasite_frames_drain) + 15,
	((mframe_t *) parasite_frames_drain) + 16,
	((mframe_t *) parasite_frames_drain) + 17,

	(mmove_t *) &parasite_move_drain,

	((mframe_t *) parasite_frames_break) + 0,
	((mframe_t *) parasite_frames_break) + 1,
	((mframe_t *) parasite_frames_break) + 2,
	((mframe_t *) parasite_frames_break) + 3,
	((mframe_t *) parasite_frames_break) + 4,
	((mframe_t *) parasite_frames_break) + 5,
	((mframe_t *) parasite_frames_break) + 6,
	((mframe_t *) parasite_frames_break) + 7,
	((mframe_t *) parasite_frames_break) + 8,
	((mframe_t *) parasite_frames_break) + 9,
	((mframe_t *) parasite_frames_break) + 10,
	((mframe_t *) parasite_frames_break) + 11,
	((mframe_t *) parasite_frames_break) + 12,
	((mframe_t *) parasite_frames_break) + 13,
	((mframe_t *) parasite_frames_break) + 14,
	((mframe_t *) parasite_frames_break) + 15,
	((mframe_t *) parasite_frames_break) + 16,
	((mframe_t *) parasite_frames_break) + 17,
	((mframe_t *) parasite_frames_break) + 18,
	((mframe_t *) parasite_frames_break) + 19,
	((mframe_t *) parasite_frames_break) + 20,
	((mframe_t *) parasite_frames_break) + 21,
	((mframe_t *) parasite_frames_break) + 22,
	((mframe_t *) parasite_frames_break) + 23,
	((mframe_t *) parasite_frames_break) + 24,
	((mframe_t *) parasite_frames_break) + 25,
	((mframe_t *) parasite_frames_break) + 26,
	((mframe_t *) parasite_frames_break) + 27,
	((mframe_t *) parasite_frames_break) + 28,
	((mframe_t *) parasite_frames_break) + 29,
	((mframe_t *) parasite_frames_break) + 30,
	((mframe_t *) parasite_frames_break) + 31,

	(mmove_t *) &parasite_move_break,

	((mframe_t *) parasite_frames_death) + 0,
	((mframe_t *) parasite_frames_death) + 1,
	((mframe_t *) parasite_frames_death) + 2,
	((mframe_t *) parasite_frames_death) + 3,
	((mframe_t *) parasite_frames_death) + 4,
	((mframe_t *) parasite_frames_death) + 5,
	((mframe_t *) parasite_frames_death) + 6,

	(mmove_t *) &parasite_move_death,

	((mframe_t *) soldier_frames_stand1) + 0,
	((mframe_t *) soldier_frames_stand1) + 1,
	((mframe_t *) soldier_frames_stand1) + 2,
	((mframe_t *) soldier_frames_stand1) + 3,
	((mframe_t *) soldier_frames_stand1) + 4,
	((mframe_t *) soldier_frames_stand1) + 5,
	((mframe_t *) soldier_frames_stand1) + 6,
	((mframe_t *) soldier_frames_stand1) + 7,
	((mframe_t *) soldier_frames_stand1) + 8,
	((mframe_t *) soldier_frames_stand1) + 9,
	((mframe_t *) soldier_frames_stand1) + 10,
	((mframe_t *) soldier_frames_stand1) + 11,
	((mframe_t *) soldier_frames_stand1) + 12,
	((mframe_t *) soldier_frames_stand1) + 13,
	((mframe_t *) soldier_frames_stand1) + 14,
	((mframe_t *) soldier_frames_stand1) + 15,
	((mframe_t *) soldier_frames_stand1) + 16,
	((mframe_t *) soldier_frames_stand1) + 17,
	((mframe_t *) soldier_frames_stand1) + 18,
	((mframe_t *) soldier_frames_stand1) + 19,
	((mframe_t *) soldier_frames_stand1) + 20,
	((mframe_t *) soldier_frames_stand1) + 21,
	((mframe_t *) soldier_frames_stand1) + 22,
	((mframe_t *) soldier_frames_stand1) + 23,
	((mframe_t *) soldier_frames_stand1) + 24,
	((mframe_t *) soldier_frames_stand1) + 25,
	((mframe_t *) soldier_frames_stand1) + 26,
	((mframe_t *) soldier_frames_stand1) + 27,
	((mframe_t *) soldier_frames_stand1) + 28,
	((mframe_t *) soldier_frames_stand1) + 29,

	(mmove_t *) &soldier_move_stand1,

	((mframe_t *) soldier_frames_stand3) + 0,
	((mframe_t *) soldier_frames_stand3) + 1,
	((mframe_t *) soldier_frames_stand3) + 2,
	((mframe_t *) soldier_frames_stand3) + 3,
	((mframe_t *) soldier_frames_stand3) + 4,
	((mframe_t *) soldier_frames_stand3) + 5,
	((mframe_t *) soldier_frames_stand3) + 6,
	((mframe_t *) soldier_frames_stand3) + 7,
	((mframe_t *) soldier_frames_stand3) + 8,
	((mframe_t *) soldier_frames_stand3) + 9,
	((mframe_t *) soldier_frames_stand3) + 10,
	((mframe_t *) soldier_frames_stand3) + 11,
	((mframe_t *) soldier_frames_stand3) + 12,
	((mframe_t *) soldier_frames_stand3) + 13,
	((mframe_t *) soldier_frames_stand3) + 14,
	((mframe_t *) soldier_frames_stand3) + 15,
	((mframe_t *) soldier_frames_stand3) + 16,
	((mframe_t *) soldier_frames_stand3) + 17,
	((mframe_t *) soldier_frames_stand3) + 18,
	((mframe_t *) soldier_frames_stand3) + 19,
	((mframe_t *) soldier_frames_stand3) + 20,
	((mframe_t *) soldier_frames_stand3) + 21,
	((mframe_t *) soldier_frames_stand3) + 22,
	((mframe_t *) soldier_frames_stand3) + 23,
	((mframe_t *) soldier_frames_stand3) + 24,
	((mframe_t *) soldier_frames_stand3) + 25,
	((mframe_t *) soldier_frames_stand3) + 26,
	((mframe_t *) soldier_frames_stand3) + 27,
	((mframe_t *) soldier_frames_stand3) + 28,
	((mframe_t *) soldier_frames_stand3) + 29,
	((mframe_t *) soldier_frames_stand3) + 30,
	((mframe_t *) soldier_frames_stand3) + 31,
	((mframe_t *) soldier_frames_stand3) + 32,
	((mframe_t *) soldier_frames_stand3) + 33,
	((mframe_t *) soldier_frames_stand3) + 34,
	((mframe_t *) soldier_frames_stand3) + 35,
	((mframe_t *) soldier_frames_stand3) + 36,
	((mframe_t *) soldier_frames_stand3) + 37,
	((mframe_t *) soldier_frames_stand3) + 38,

	(mmove_t *) &soldier_move_stand3,

	((mframe_t *) soldier_frames_walk1) + 0,
	((mframe_t *) soldier_frames_walk1) + 1,
	((mframe_t *) soldier_frames_walk1) + 2,
	((mframe_t *) soldier_frames_walk1) + 3,
	((mframe_t *) soldier_frames_walk1) + 4,
	((mframe_t *) soldier_frames_walk1) + 5,
	((mframe_t *) soldier_frames_walk1) + 6,
	((mframe_t *) soldier_frames_walk1) + 7,
	((mframe_t *) soldier_frames_walk1) + 8,
	((mframe_t *) soldier_frames_walk1) + 9,
	((mframe_t *) soldier_frames_walk1) + 10,
	((mframe_t *) soldier_frames_walk1) + 11,
	((mframe_t *) soldier_frames_walk1) + 12,
	((mframe_t *) soldier_frames_walk1) + 13,
	((mframe_t *) soldier_frames_walk1) + 14,
	((mframe_t *) soldier_frames_walk1) + 15,
	((mframe_t *) soldier_frames_walk1) + 16,
	((mframe_t *) soldier_frames_walk1) + 17,
	((mframe_t *) soldier_frames_walk1) + 18,
	((mframe_t *) soldier_frames_walk1) + 19,
	((mframe_t *) soldier_frames_walk1) + 20,
	((mframe_t *) soldier_frames_walk1) + 21,
	((mframe_t *) soldier_frames_walk1) + 22,
	((mframe_t *) soldier_frames_walk1) + 23,
	((mframe_t *) soldier_frames_walk1) + 24,
	((mframe_t *) soldier_frames_walk1) + 25,
	((mframe_t *) soldier_frames_walk1) + 26,
	((mframe_t *) soldier_frames_walk1) + 27,
	((mframe_t *) soldier_frames_walk1) + 28,
	((mframe_t *) soldier_frames_walk1) + 29,
	((mframe_t *) soldier_frames_walk1) + 30,
	((mframe_t *) soldier_frames_walk1) + 31,
	((mframe_t *) soldier_frames_walk1) + 32,

	(mmove_t *) &soldier_move_walk1,

	((mframe_t *) soldier_frames_walk2) + 0,
	((mframe_t *) soldier_frames_walk2) + 1,
	((mframe_t *) soldier_frames_walk2) + 2,
	((mframe_t *) soldier_frames_walk2) + 3,
	((mframe_t *) soldier_frames_walk2) + 4,
	((mframe_t *) soldier_frames_walk2) + 5,
	((mframe_t *) soldier_frames_walk2) + 6,
	((mframe_t *) soldier_frames_walk2) + 7,
	((mframe_t *) soldier_frames_walk2) + 8,
	((mframe_t *) soldier_frames_walk2) + 9,

	(mmove_t *) &soldier_move_walk2,

	((mframe_t *) soldier_frames_start_run) + 0,
	((mframe_t *) soldier_frames_start_run) + 1,

	(mmove_t *) &soldier_move_start_run,

	((mframe_t *) soldier_frames_run) + 0,
	((mframe_t *) soldier_frames_run) + 1,
	((mframe_t *) soldier_frames_run) + 2,
	((mframe_t *) soldier_frames_run) + 3,
	((mframe_t *) soldier_frames_run) + 4,
	((mframe_t *) soldier_frames_run) + 5,

	(mmove_t *) &soldier_move_run,

	((mframe_t *) soldier_frames_pain1) + 0,
	((mframe_t *) soldier_frames_pain1) + 1,
	((mframe_t *) soldier_frames_pain1) + 2,
	((mframe_t *) soldier_frames_pain1) + 3,
	((mframe_t *) soldier_frames_pain1) + 4,

	(mmove_t *) &soldier_move_pain1,

	((mframe_t *) soldier_frames_pain2) + 0,
	((mframe_t *) soldier_frames_pain2) + 1,
	((mframe_t *) soldier_frames_pain2) + 2,
	((mframe_t *) soldier_frames_pain2) + 3,
	((mframe_t *) soldier_frames_pain2) + 4,
	((mframe_t *) soldier_frames_pain2) + 5,
	((mframe_t *) soldier_frames_pain2) + 6,

	(mmove_t *) &soldier_move_pain2,

	((mframe_t *) soldier_frames_pain3) + 0,
	((mframe_t *) soldier_frames_pain3) + 1,
	((mframe_t *) soldier_frames_pain3) + 2,
	((mframe_t *) soldier_frames_pain3) + 3,
	((mframe_t *) soldier_frames_pain3) + 4,
	((mframe_t *) soldier_frames_pain3) + 5,
	((mframe_t *) soldier_frames_pain3) + 6,
	((mframe_t *) soldier_frames_pain3) + 7,
	((mframe_t *) soldier_frames_pain3) + 8,
	((mframe_t *) soldier_frames_pain3) + 9,
	((mframe_t *) soldier_frames_pain3) + 10,
	((mframe_t *) soldier_frames_pain3) + 11,
	((mframe_t *) soldier_frames_pain3) + 12,
	((mframe_t *) soldier_frames_pain3) + 13,
	((mframe_t *) soldier_frames_pain3) + 14,
	((mframe_t *) soldier_frames_pain3) + 15,
	((mframe_t *) soldier_frames_pain3) + 16,
	((mframe_t *) soldier_frames_pain3) + 17,

	(mmove_t *) &soldier_move_pain3,

	((mframe_t *) soldier_frames_pain4) + 0,
	((mframe_t *) soldier_frames_pain4) + 1,
	((mframe_t *) soldier_frames_pain4) + 2,
	((mframe_t *) soldier_frames_pain4) + 3,
	((mframe_t *) soldier_frames_pain4) + 4,
	((mframe_t *) soldier_frames_pain4) + 5,
	((mframe_t *) soldier_frames_pain4) + 6,
	((mframe_t *) soldier_frames_pain4) + 7,
	((mframe_t *) soldier_frames_pain4) + 8,
	((mframe_t *) soldier_frames_pain4) + 9,
	((mframe_t *) soldier_frames_pain4) + 10,
	((mframe_t *) soldier_frames_pain4) + 11,
	((mframe_t *) soldier_frames_pain4) + 12,
	((mframe_t *) soldier_frames_pain4) + 13,
	((mframe_t *) soldier_frames_pain4) + 14,
	((mframe_t *) soldier_frames_pain4) + 15,
	((mframe_t *) soldier_frames_pain4) + 16,

	(mmove_t *) &soldier_move_pain4,

	((mframe_t *) soldier_frames_attack1) + 0,
	((mframe_t *) soldier_frames_attack1) + 1,
	((mframe_t *) soldier_frames_attack1) + 2,
	((mframe_t *) soldier_frames_attack1) + 3,
	((mframe_t *) soldier_frames_attack1) + 4,
	((mframe_t *) soldier_frames_attack1) + 5,
	((mframe_t *) soldier_frames_attack1) + 6,
	((mframe_t *) soldier_frames_attack1) + 7,
	((mframe_t *) soldier_frames_attack1) + 8,
	((mframe_t *) soldier_frames_attack1) + 9,
	((mframe_t *) soldier_frames_attack1) + 10,
	((mframe_t *) soldier_frames_attack1) + 11,

	(mmove_t *) &soldier_move_attack1,

	((mframe_t *) soldier_frames_attack2) + 0,
	((mframe_t *) soldier_frames_attack2) + 1,
	((mframe_t *) soldier_frames_attack2) + 2,
	((mframe_t *) soldier_frames_attack2) + 3,
	((mframe_t *) soldier_frames_attack2) + 4,
	((mframe_t *) soldier_frames_attack2) + 5,
	((mframe_t *) soldier_frames_attack2) + 6,
	((mframe_t *) soldier_frames_attack2) + 7,
	((mframe_t *) soldier_frames_attack2) + 8,
	((mframe_t *) soldier_frames_attack2) + 9,
	((mframe_t *) soldier_frames_attack2) + 10,
	((mframe_t *) soldier_frames_attack2) + 11,
	((mframe_t *) soldier_frames_attack2) + 12,
	((mframe_t *) soldier_frames_attack2) + 13,
	((mframe_t *) soldier_frames_attack2) + 14,
	((mframe_t *) soldier_frames_attack2) + 15,
	((mframe_t *) soldier_frames_attack2) + 16,
	((mframe_t *) soldier_frames_attack2) + 17,

	(mmove_t *) &soldier_move_attack2,

	((mframe_t *) soldier_frames_attack3) + 0,
	((mframe_t *) soldier_frames_attack3) + 1,
	((mframe_t *) soldier_frames_attack3) + 2,
	((mframe_t *) soldier_frames_attack3) + 3,
	((mframe_t *) soldier_frames_attack3) + 4,
	((mframe_t *) soldier_frames_attack3) + 5,
	((mframe_t *) soldier_frames_attack3) + 6,
	((mframe_t *) soldier_frames_attack3) + 7,
	((mframe_t *) soldier_frames_attack3) + 8,

	(mmove_t *) &soldier_move_attack3,

	((mframe_t *) soldier_frames_attack4) + 0,
	((mframe_t *) soldier_frames_attack4) + 1,
	((mframe_t *) soldier_frames_attack4) + 2,
	((mframe_t *) soldier_frames_attack4) + 3,
	((mframe_t *) soldier_frames_attack4) + 4,
	((mframe_t *) soldier_frames_attack4) + 5,

	(mmove_t *) &soldier_move_attack4,

	((mframe_t *) soldier_frames_attack6) + 0,
	((mframe_t *) soldier_frames_attack6) + 1,
	((mframe_t *) soldier_frames_attack6) + 2,
	((mframe_t *) soldier_frames_attack6) + 3,
	((mframe_t *) soldier_frames_attack6) + 4,
	((mframe_t *) soldier_frames_attack6) + 5,
	((mframe_t *) soldier_frames_attack6) + 6,
	((mframe_t *) soldier_frames_attack6) + 7,
	((mframe_t *) soldier_frames_attack6) + 8,
	((mframe_t *) soldier_frames_attack6) + 9,
	((mframe_t *) soldier_frames_attack6) + 10,
	((mframe_t *) soldier_frames_attack6) + 11,
	((mframe_t *) soldier_frames_attack6) + 12,
	((mframe_t *) soldier_frames_attack6) + 13,

	(mmove_t *) &soldier_move_attack6,

	((mframe_t *) soldier_frames_duck) + 0,
	((mframe_t *) soldier_frames_duck) + 1,
	((mframe_t *) soldier_frames_duck) + 2,
	((mframe_t *) soldier_frames_duck) + 3,
	((mframe_t *) soldier_frames_duck) + 4,

	(mmove_t *) &soldier_move_duck,

	((mframe_t *) soldier_frames_death1) + 0,
	((mframe_t *) soldier_frames_death1) + 1,
	((mframe_t *) soldier_frames_death1) + 2,
	((mframe_t *) soldier_frames_death1) + 3,
	((mframe_t *) soldier_frames_death1) + 4,
	((mframe_t *) soldier_frames_death1) + 5,
	((mframe_t *) soldier_frames_death1) + 6,
	((mframe_t *) soldier_frames_death1) + 7,
	((mframe_t *) soldier_frames_death1) + 8,
	((mframe_t *) soldier_frames_death1) + 9,
	((mframe_t *) soldier_frames_death1) + 10,
	((mframe_t *) soldier_frames_death1) + 11,
	((mframe_t *) soldier_frames_death1) + 12,
	((mframe_t *) soldier_frames_death1) + 13,
	((mframe_t *) soldier_frames_death1) + 14,
	((mframe_t *) soldier_frames_death1) + 15,
	((mframe_t *) soldier_frames_death1) + 16,
	((mframe_t *) soldier_frames_death1) + 17,
	((mframe_t *) soldier_frames_death1) + 18,
	((mframe_t *) soldier_frames_death1) + 19,
	((mframe_t *) soldier_frames_death1) + 20,
	((mframe_t *) soldier_frames_death1) + 21,
	((mframe_t *) soldier_frames_death1) + 22,
	((mframe_t *) soldier_frames_death1) + 23,
	((mframe_t *) soldier_frames_death1) + 24,
	((mframe_t *) soldier_frames_death1) + 25,
	((mframe_t *) soldier_frames_death1) + 26,
	((mframe_t *) soldier_frames_death1) + 27,
	((mframe_t *) soldier_frames_death1) + 28,
	((mframe_t *) soldier_frames_death1) + 29,
	((mframe_t *) soldier_frames_death1) + 30,
	((mframe_t *) soldier_frames_death1) + 31,
	((mframe_t *) soldier_frames_death1) + 32,
	((mframe_t *) soldier_frames_death1) + 33,
	((mframe_t *) soldier_frames_death1) + 34,
	((mframe_t *) soldier_frames_death1) + 35,

	(mmove_t *) &soldier_move_death1,

	((mframe_t *) soldier_frames_death2) + 0,
	((mframe_t *) soldier_frames_death2) + 1,
	((mframe_t *) soldier_frames_death2) + 2,
	((mframe_t *) soldier_frames_death2) + 3,
	((mframe_t *) soldier_frames_death2) + 4,
	((mframe_t *) soldier_frames_death2) + 5,
	((mframe_t *) soldier_frames_death2) + 6,
	((mframe_t *) soldier_frames_death2) + 7,
	((mframe_t *) soldier_frames_death2) + 8,
	((mframe_t *) soldier_frames_death2) + 9,
	((mframe_t *) soldier_frames_death2) + 10,
	((mframe_t *) soldier_frames_death2) + 11,
	((mframe_t *) soldier_frames_death2) + 12,
	((mframe_t *) soldier_frames_death2) + 13,
	((mframe_t *) soldier_frames_death2) + 14,
	((mframe_t *) soldier_frames_death2) + 15,
	((mframe_t *) soldier_frames_death2) + 16,
	((mframe_t *) soldier_frames_death2) + 17,
	((mframe_t *) soldier_frames_death2) + 18,
	((mframe_t *) soldier_frames_death2) + 19,
	((mframe_t *) soldier_frames_death2) + 20,
	((mframe_t *) soldier_frames_death2) + 21,
	((mframe_t *) soldier_frames_death2) + 22,
	((mframe_t *) soldier_frames_death2) + 23,
	((mframe_t *) soldier_frames_death2) + 24,
	((mframe_t *) soldier_frames_death2) + 25,
	((mframe_t *) soldier_frames_death2) + 26,
	((mframe_t *) soldier_frames_death2) + 27,
	((mframe_t *) soldier_frames_death2) + 28,
	((mframe_t *) soldier_frames_death2) + 29,
	((mframe_t *) soldier_frames_death2) + 30,
	((mframe_t *) soldier_frames_death2) + 31,
	((mframe_t *) soldier_frames_death2) + 32,
	((mframe_t *) soldier_frames_death2) + 33,
	((mframe_t *) soldier_frames_death2) + 34,

	(mmove_t *) &soldier_move_death2,

	((mframe_t *) soldier_frames_death3) + 0,
	((mframe_t *) soldier_frames_death3) + 1,
	((mframe_t *) soldier_frames_death3) + 2,
	((mframe_t *) soldier_frames_death3) + 3,
	((mframe_t *) soldier_frames_death3) + 4,
	((mframe_t *) soldier_frames_death3) + 5,
	((mframe_t *) soldier_frames_death3) + 6,
	((mframe_t *) soldier_frames_death3) + 7,
	((mframe_t *) soldier_frames_death3) + 8,
	((mframe_t *) soldier_frames_death3) + 9,
	((mframe_t *) soldier_frames_death3) + 10,
	((mframe_t *) soldier_frames_death3) + 11,
	((mframe_t *) soldier_frames_death3) + 12,
	((mframe_t *) soldier_frames_death3) + 13,
	((mframe_t *) soldier_frames_death3) + 14,
	((mframe_t *) soldier_frames_death3) + 15,
	((mframe_t *) soldier_frames_death3) + 16,
	((mframe_t *) soldier_frames_death3) + 17,
	((mframe_t *) soldier_frames_death3) + 18,
	((mframe_t *) soldier_frames_death3) + 19,
	((mframe_t *) soldier_frames_death3) + 20,
	((mframe_t *) soldier_frames_death3) + 21,
	((mframe_t *) soldier_frames_death3) + 22,
	((mframe_t *) soldier_frames_death3) + 23,
	((mframe_t *) soldier_frames_death3) + 24,
	((mframe_t *) soldier_frames_death3) + 25,
	((mframe_t *) soldier_frames_death3) + 26,
	((mframe_t *) soldier_frames_death3) + 27,
	((mframe_t *) soldier_frames_death3) + 28,
	((mframe_t *) soldier_frames_death3) + 29,
	((mframe_t *) soldier_frames_death3) + 30,
	((mframe_t *) soldier_frames_death3) + 31,
	((mframe_t *) soldier_frames_death3) + 32,
	((mframe_t *) soldier_frames_death3) + 33,
	((mframe_t *) soldier_frames_death3) + 34,
	((mframe_t *) soldier_frames_death3) + 35,
	((mframe_t *) soldier_frames_death3) + 36,
	((mframe_t *) soldier_frames_death3) + 37,
	((mframe_t *) soldier_frames_death3) + 38,
	((mframe_t *) soldier_frames_death3) + 39,
	((mframe_t *) soldier_frames_death3) + 40,
	((mframe_t *) soldier_frames_death3) + 41,
	((mframe_t *) soldier_frames_death3) + 42,
	((mframe_t *) soldier_frames_death3) + 43,
	((mframe_t *) soldier_frames_death3) + 44,

	(mmove_t *) &soldier_move_death3,

	((mframe_t *) soldier_frames_death4) + 0,
	((mframe_t *) soldier_frames_death4) + 1,
	((mframe_t *) soldier_frames_death4) + 2,
	((mframe_t *) soldier_frames_death4) + 3,
	((mframe_t *) soldier_frames_death4) + 4,
	((mframe_t *) soldier_frames_death4) + 5,
	((mframe_t *) soldier_frames_death4) + 6,
	((mframe_t *) soldier_frames_death4) + 7,
	((mframe_t *) soldier_frames_death4) + 8,
	((mframe_t *) soldier_frames_death4) + 9,
	((mframe_t *) soldier_frames_death4) + 10,
	((mframe_t *) soldier_frames_death4) + 11,
	((mframe_t *) soldier_frames_death4) + 12,
	((mframe_t *) soldier_frames_death4) + 13,
	((mframe_t *) soldier_frames_death4) + 14,
	((mframe_t *) soldier_frames_death4) + 15,
	((mframe_t *) soldier_frames_death4) + 16,
	((mframe_t *) soldier_frames_death4) + 17,
	((mframe_t *) soldier_frames_death4) + 18,
	((mframe_t *) soldier_frames_death4) + 19,
	((mframe_t *) soldier_frames_death4) + 20,
	((mframe_t *) soldier_frames_death4) + 21,
	((mframe_t *) soldier_frames_death4) + 22,
	((mframe_t *) soldier_frames_death4) + 23,
	((mframe_t *) soldier_frames_death4) + 24,
	((mframe_t *) soldier_frames_death4) + 25,
	((mframe_t *) soldier_frames_death4) + 26,
	((mframe_t *) soldier_frames_death4) + 27,
	((mframe_t *) soldier_frames_death4) + 28,
	((mframe_t *) soldier_frames_death4) + 29,
	((mframe_t *) soldier_frames_death4) + 30,
	((mframe_t *) soldier_frames_death4) + 31,
	((mframe_t *) soldier_frames_death4) + 32,
	((mframe_t *) soldier_frames_death4) + 33,
	((mframe_t *) soldier_frames_death4) + 34,
	((mframe_t *) soldier_frames_death4) + 35,
	((mframe_t *) soldier_frames_death4) + 36,
	((mframe_t *) soldier_frames_death4) + 37,
	((mframe_t *) soldier_frames_death4) + 38,
	((mframe_t *) soldier_frames_death4) + 39,
	((mframe_t *) soldier_frames_death4) + 40,
	((mframe_t *) soldier_frames_death4) + 41,
	((mframe_t *) soldier_frames_death4) + 42,
	((mframe_t *) soldier_frames_death4) + 43,
	((mframe_t *) soldier_frames_death4) + 44,
	((mframe_t *) soldier_frames_death4) + 45,
	((mframe_t *) soldier_frames_death4) + 46,
	((mframe_t *) soldier_frames_death4) + 47,
	((mframe_t *) soldier_frames_death4) + 48,
	((mframe_t *) soldier_frames_death4) + 49,
	((mframe_t *) soldier_frames_death4) + 50,
	((mframe_t *) soldier_frames_death4) + 51,
	((mframe_t *) soldier_frames_death4) + 52,

	(mmove_t *) &soldier_move_death4,

	((mframe_t *) soldier_frames_death5) + 0,
	((mframe_t *) soldier_frames_death5) + 1,
	((mframe_t *) soldier_frames_death5) + 2,
	((mframe_t *) soldier_frames_death5) + 3,
	((mframe_t *) soldier_frames_death5) + 4,
	((mframe_t *) soldier_frames_death5) + 5,
	((mframe_t *) soldier_frames_death5) + 6,
	((mframe_t *) soldier_frames_death5) + 7,
	((mframe_t *) soldier_frames_death5) + 8,
	((mframe_t *) soldier_frames_death5) + 9,
	((mframe_t *) soldier_frames_death5) + 10,
	((mframe_t *) soldier_frames_death5) + 11,
	((mframe_t *) soldier_frames_death5) + 12,
	((mframe_t *) soldier_frames_death5) + 13,
	((mframe_t *) soldier_frames_death5) + 14,
	((mframe_t *) soldier_frames_death5) + 15,
	((mframe_t *) soldier_frames_death5) + 16,
	((mframe_t *) soldier_frames_death5) + 17,
	((mframe_t *) soldier_frames_death5) + 18,
	((mframe_t *) soldier_frames_death5) + 19,
	((mframe_t *) soldier_frames_death5) + 20,
	((mframe_t *) soldier_frames_death5) + 21,
	((mframe_t *) soldier_frames_death5) + 22,
	((mframe_t *) soldier_frames_death5) + 23,

	(mmove_t *) &soldier_move_death5,

	((mframe_t *) soldier_frames_death6) + 0,
	((mframe_t *) soldier_frames_death6) + 1,
	((mframe_t *) soldier_frames_death6) + 2,
	((mframe_t *) soldier_frames_death6) + 3,
	((mframe_t *) soldier_frames_death6) + 4,
	((mframe_t *) soldier_frames_death6) + 5,
	((mframe_t *) soldier_frames_death6) + 6,
	((mframe_t *) soldier_frames_death6) + 7,
	((mframe_t *) soldier_frames_death6) + 8,
	((mframe_t *) soldier_frames_death6) + 9,

	(mmove_t *) &soldier_move_death6,

	((mframe_t *) supertank_frames_stand) + 0,
	((mframe_t *) supertank_frames_stand) + 1,
	((mframe_t *) supertank_frames_stand) + 2,
	((mframe_t *) supertank_frames_stand) + 3,
	((mframe_t *) supertank_frames_stand) + 4,
	((mframe_t *) supertank_frames_stand) + 5,
	((mframe_t *) supertank_frames_stand) + 6,
	((mframe_t *) supertank_frames_stand) + 7,
	((mframe_t *) supertank_frames_stand) + 8,
	((mframe_t *) supertank_frames_stand) + 9,
	((mframe_t *) supertank_frames_stand) + 10,
	((mframe_t *) supertank_frames_stand) + 11,
	((mframe_t *) supertank_frames_stand) + 12,
	((mframe_t *) supertank_frames_stand) + 13,
	((mframe_t *) supertank_frames_stand) + 14,
	((mframe_t *) supertank_frames_stand) + 15,
	((mframe_t *) supertank_frames_stand) + 16,
	((mframe_t *) supertank_frames_stand) + 17,
	((mframe_t *) supertank_frames_stand) + 18,
	((mframe_t *) supertank_frames_stand) + 19,
	((mframe_t *) supertank_frames_stand) + 20,
	((mframe_t *) supertank_frames_stand) + 21,
	((mframe_t *) supertank_frames_stand) + 22,
	((mframe_t *) supertank_frames_stand) + 23,
	((mframe_t *) supertank_frames_stand) + 24,
	((mframe_t *) supertank_frames_stand) + 25,
	((mframe_t *) supertank_frames_stand) + 26,
	((mframe_t *) supertank_frames_stand) + 27,
	((mframe_t *) supertank_frames_stand) + 28,
	((mframe_t *) supertank_frames_stand) + 29,
	((mframe_t *) supertank_frames_stand) + 30,
	((mframe_t *) supertank_frames_stand) + 31,
	((mframe_t *) supertank_frames_stand) + 32,
	((mframe_t *) supertank_frames_stand) + 33,
	((mframe_t *) supertank_frames_stand) + 34,
	((mframe_t *) supertank_frames_stand) + 35,
	((mframe_t *) supertank_frames_stand) + 36,
	((mframe_t *) supertank_frames_stand) + 37,
	((mframe_t *) supertank_frames_stand) + 38,
	((mframe_t *) supertank_frames_stand) + 39,
	((mframe_t *) supertank_frames_stand) + 40,
	((mframe_t *) supertank_frames_stand) + 41,
	((mframe_t *) supertank_frames_stand) + 42,
	((mframe_t *) supertank_frames_stand) + 43,
	((mframe_t *) supertank_frames_stand) + 44,
	((mframe_t *) supertank_frames_stand) + 45,
	((mframe_t *) supertank_frames_stand) + 46,
	((mframe_t *) supertank_frames_stand) + 47,
	((mframe_t *) supertank_frames_stand) + 48,
	((mframe_t *) supertank_frames_stand) + 49,
	((mframe_t *) supertank_frames_stand) + 50,
	((mframe_t *) supertank_frames_stand) + 51,
	((mframe_t *) supertank_frames_stand) + 52,
	((mframe_t *) supertank_frames_stand) + 53,
	((mframe_t *) supertank_frames_stand) + 54,
	((mframe_t *) supertank_frames_stand) + 55,
	((mframe_t *) supertank_frames_stand) + 56,
	((mframe_t *) supertank_frames_stand) + 57,
	((mframe_t *) supertank_frames_stand) + 58,
	((mframe_t *) supertank_frames_stand) + 59,

	(mmove_t *) &supertank_move_stand,

	((mframe_t *) supertank_frames_run) + 0,
	((mframe_t *) supertank_frames_run) + 1,
	((mframe_t *) supertank_frames_run) + 2,
	((mframe_t *) supertank_frames_run) + 3,
	((mframe_t *) supertank_frames_run) + 4,
	((mframe_t *) supertank_frames_run) + 5,
	((mframe_t *) supertank_frames_run) + 6,
	((mframe_t *) supertank_frames_run) + 7,
	((mframe_t *) supertank_frames_run) + 8,
	((mframe_t *) supertank_frames_run) + 9,
	((mframe_t *) supertank_frames_run) + 10,
	((mframe_t *) supertank_frames_run) + 11,
	((mframe_t *) supertank_frames_run) + 12,
	((mframe_t *) supertank_frames_run) + 13,
	((mframe_t *) supertank_frames_run) + 14,
	((mframe_t *) supertank_frames_run) + 15,
	((mframe_t *) supertank_frames_run) + 16,
	((mframe_t *) supertank_frames_run) + 17,

	(mmove_t *) &supertank_move_run,

	((mframe_t *) supertank_frames_forward) + 0,
	((mframe_t *) supertank_frames_forward) + 1,
	((mframe_t *) supertank_frames_forward) + 2,
	((mframe_t *) supertank_frames_forward) + 3,
	((mframe_t *) supertank_frames_forward) + 4,
	((mframe_t *) supertank_frames_forward) + 5,
	((mframe_t *) supertank_frames_forward) + 6,
	((mframe_t *) supertank_frames_forward) + 7,
	((mframe_t *) supertank_frames_forward) + 8,
	((mframe_t *) supertank_frames_forward) + 9,
	((mframe_t *) supertank_frames_forward) + 10,
	((mframe_t *) supertank_frames_forward) + 11,
	((mframe_t *) supertank_frames_forward) + 12,
	((mframe_t *) supertank_frames_forward) + 13,
	((mframe_t *) supertank_frames_forward) + 14,
	((mframe_t *) supertank_frames_forward) + 15,
	((mframe_t *) supertank_frames_forward) + 16,
	((mframe_t *) supertank_frames_forward) + 17,

	(mmove_t *) &supertank_move_forward,

	((mframe_t *) supertank_frames_turn_right) + 0,
	((mframe_t *) supertank_frames_turn_right) + 1,
	((mframe_t *) supertank_frames_turn_right) + 2,
	((mframe_t *) supertank_frames_turn_right) + 3,
	((mframe_t *) supertank_frames_turn_right) + 4,
	((mframe_t *) supertank_frames_turn_right) + 5,
	((mframe_t *) supertank_frames_turn_right) + 6,
	((mframe_t *) supertank_frames_turn_right) + 7,
	((mframe_t *) supertank_frames_turn_right) + 8,
	((mframe_t *) supertank_frames_turn_right) + 9,
	((mframe_t *) supertank_frames_turn_right) + 10,
	((mframe_t *) supertank_frames_turn_right) + 11,
	((mframe_t *) supertank_frames_turn_right) + 12,
	((mframe_t *) supertank_frames_turn_right) + 13,
	((mframe_t *) supertank_frames_turn_right) + 14,
	((mframe_t *) supertank_frames_turn_right) + 15,
	((mframe_t *) supertank_frames_turn_right) + 16,
	((mframe_t *) supertank_frames_turn_right) + 17,

	(mmove_t *) &supertank_move_turn_right,

	((mframe_t *) supertank_frames_turn_left) + 0,
	((mframe_t *) supertank_frames_turn_left) + 1,
	((mframe_t *) supertank_frames_turn_left) + 2,
	((mframe_t *) supertank_frames_turn_left) + 3,
	((mframe_t *) supertank_frames_turn_left) + 4,
	((mframe_t *) supertank_frames_turn_left) + 5,
	((mframe_t *) supertank_frames_turn_left) + 6,
	((mframe_t *) supertank_frames_turn_left) + 7,
	((mframe_t *) supertank_frames_turn_left) + 8,
	((mframe_t *) supertank_frames_turn_left) + 9,
	((mframe_t *) supertank_frames_turn_left) + 10,
	((mframe_t *) supertank_frames_turn_left) + 11,
	((mframe_t *) supertank_frames_turn_left) + 12,
	((mframe_t *) supertank_frames_turn_left) + 13,
	((mframe_t *) supertank_frames_turn_left) + 14,
	((mframe_t *) supertank_frames_turn_left) + 15,
	((mframe_t *) supertank_frames_turn_left) + 16,
	((mframe_t *) supertank_frames_turn_left) + 17,

	(mmove_t *) &supertank_move_turn_left,

	((mframe_t *) supertank_frames_pain3) + 0,
	((mframe_t *) supertank_frames_pain3) + 1,
	((mframe_t *) supertank_frames_pain3) + 2,
	((mframe_t *) supertank_frames_pain3) + 3,

	(mmove_t *) &supertank_move_pain3,

	((mframe_t *) supertank_frames_pain2) + 0,
	((mframe_t *) supertank_frames_pain2) + 1,
	((mframe_t *) supertank_frames_pain2) + 2,
	((mframe_t *) supertank_frames_pain2) + 3,

	(mmove_t *) &supertank_move_pain2,

	((mframe_t *) supertank_frames_pain1) + 0,
	((mframe_t *) supertank_frames_pain1) + 1,
	((mframe_t *) supertank_frames_pain1) + 2,
	((mframe_t *) supertank_frames_pain1) + 3,

	(mmove_t *) &supertank_move_pain1,

	((mframe_t *) supertank_frames_death1) + 0,
	((mframe_t *) supertank_frames_death1) + 1,
	((mframe_t *) supertank_frames_death1) + 2,
	((mframe_t *) supertank_frames_death1) + 3,
	((mframe_t *) supertank_frames_death1) + 4,
	((mframe_t *) supertank_frames_death1) + 5,
	((mframe_t *) supertank_frames_death1) + 6,
	((mframe_t *) supertank_frames_death1) + 7,
	((mframe_t *) supertank_frames_death1) + 8,
	((mframe_t *) supertank_frames_death1) + 9,
	((mframe_t *) supertank_frames_death1) + 10,
	((mframe_t *) supertank_frames_death1) + 11,
	((mframe_t *) supertank_frames_death1) + 12,
	((mframe_t *) supertank_frames_death1) + 13,
	((mframe_t *) supertank_frames_death1) + 14,
	((mframe_t *) supertank_frames_death1) + 15,
	((mframe_t *) supertank_frames_death1) + 16,
	((mframe_t *) supertank_frames_death1) + 17,
	((mframe_t *) supertank_frames_death1) + 18,
	((mframe_t *) supertank_frames_death1) + 19,
	((mframe_t *) supertank_frames_death1) + 20,
	((mframe_t *) supertank_frames_death1) + 21,
	((mframe_t *) supertank_frames_death1) + 22,
	((mframe_t *) supertank_frames_death1) + 23,

	(mmove_t *) &supertank_move_death,

	((mframe_t *) supertank_frames_backward) + 0,
	((mframe_t *) supertank_frames_backward) + 1,
	((mframe_t *) supertank_frames_backward) + 2,
	((mframe_t *) supertank_frames_backward) + 3,
	((mframe_t *) supertank_frames_backward) + 4,
	((mframe_t *) supertank_frames_backward) + 5,
	((mframe_t *) supertank_frames_backward) + 6,
	((mframe_t *) supertank_frames_backward) + 7,
	((mframe_t *) supertank_frames_backward) + 8,
	((mframe_t *) supertank_frames_backward) + 9,
	((mframe_t *) supertank_frames_backward) + 10,
	((mframe_t *) supertank_frames_backward) + 11,
	((mframe_t *) supertank_frames_backward) + 12,
	((mframe_t *) supertank_frames_backward) + 13,
	((mframe_t *) supertank_frames_backward) + 14,
	((mframe_t *) supertank_frames_backward) + 15,
	((mframe_t *) supertank_frames_backward) + 16,
	((mframe_t *) supertank_frames_backward) + 17,

	(mmove_t *) &supertank_move_backward,

	((mframe_t *) supertank_frames_attack4) + 0,
	((mframe_t *) supertank_frames_attack4) + 1,
	((mframe_t *) supertank_frames_attack4) + 2,
	((mframe_t *) supertank_frames_attack4) + 3,
	((mframe_t *) supertank_frames_attack4) + 4,
	((mframe_t *) supertank_frames_attack4) + 5,

	(mmove_t *) &supertank_move_attack4,

	((mframe_t *) supertank_frames_attack3) + 0,
	((mframe_t *) supertank_frames_attack3) + 1,
	((mframe_t *) supertank_frames_attack3) + 2,
	((mframe_t *) supertank_frames_attack3) + 3,
	((mframe_t *) supertank_frames_attack3) + 4,
	((mframe_t *) supertank_frames_attack3) + 5,
	((mframe_t *) supertank_frames_attack3) + 6,
	((mframe_t *) supertank_frames_attack3) + 7,
	((mframe_t *) supertank_frames_attack3) + 8,
	((mframe_t *) supertank_frames_attack3) + 9,
	((mframe_t *) supertank_frames_attack3) + 10,
	((mframe_t *) supertank_frames_attack3) + 11,
	((mframe_t *) supertank_frames_attack3) + 12,
	((mframe_t *) supertank_frames_attack3) + 13,
	((mframe_t *) supertank_frames_attack3) + 14,
	((mframe_t *) supertank_frames_attack3) + 15,
	((mframe_t *) supertank_frames_attack3) + 16,
	((mframe_t *) supertank_frames_attack3) + 17,
	((mframe_t *) supertank_frames_attack3) + 18,
	((mframe_t *) supertank_frames_attack3) + 19,
	((mframe_t *) supertank_frames_attack3) + 20,
	((mframe_t *) supertank_frames_attack3) + 21,
	((mframe_t *) supertank_frames_attack3) + 22,
	((mframe_t *) supertank_frames_attack3) + 23,
	((mframe_t *) supertank_frames_attack3) + 24,
	((mframe_t *) supertank_frames_attack3) + 25,
	((mframe_t *) supertank_frames_attack3) + 26,

	(mmove_t *) &supertank_move_attack3,

	((mframe_t *) supertank_frames_attack2) + 0,
	((mframe_t *) supertank_frames_attack2) + 1,
	((mframe_t *) supertank_frames_attack2) + 2,
	((mframe_t *) supertank_frames_attack2) + 3,
	((mframe_t *) supertank_frames_attack2) + 4,
	((mframe_t *) supertank_frames_attack2) + 5,
	((mframe_t *) supertank_frames_attack2) + 6,
	((mframe_t *) supertank_frames_attack2) + 7,
	((mframe_t *) supertank_frames_attack2) + 8,
	((mframe_t *) supertank_frames_attack2) + 9,
	((mframe_t *) supertank_frames_attack2) + 10,
	((mframe_t *) supertank_frames_attack2) + 11,
	((mframe_t *) supertank_frames_attack2) + 12,
	((mframe_t *) supertank_frames_attack2) + 13,
	((mframe_t *) supertank_frames_attack2) + 14,
	((mframe_t *) supertank_frames_attack2) + 15,
	((mframe_t *) supertank_frames_attack2) + 16,
	((mframe_t *) supertank_frames_attack2) + 17,
	((mframe_t *) supertank_frames_attack2) + 18,
	((mframe_t *) supertank_frames_attack2) + 19,
	((mframe_t *) supertank_frames_attack2) + 20,
	((mframe_t *) supertank_frames_attack2) + 21,
	((mframe_t *) supertank_frames_attack2) + 22,
	((mframe_t *) supertank_frames_attack2) + 23,
	((mframe_t *) supertank_frames_attack2) + 24,
	((mframe_t *) supertank_frames_attack2) + 25,
	((mframe_t *) supertank_frames_attack2) + 26,

	(mmove_t *) &supertank_move_attack2,

	((mframe_t *) supertank_frames_attack1) + 0,
	((mframe_t *) supertank_frames_attack1) + 1,
	((mframe_t *) supertank_frames_attack1) + 2,
	((mframe_t *) supertank_frames_attack1) + 3,
	((mframe_t *) supertank_frames_attack1) + 4,
	((mframe_t *) supertank_frames_attack1) + 5,

	(mmove_t *) &supertank_move_attack1,

	((mframe_t *) supertank_frames_end_attack1) + 0,
	((mframe_t *) supertank_frames_end_attack1) + 1,
	((mframe_t *) supertank_frames_end_attack1) + 2,
	((mframe_t *) supertank_frames_end_attack1) + 3,
	((mframe_t *) supertank_frames_end_attack1) + 4,
	((mframe_t *) supertank_frames_end_attack1) + 5,
	((mframe_t *) supertank_frames_end_attack1) + 6,
	((mframe_t *) supertank_frames_end_attack1) + 7,
	((mframe_t *) supertank_frames_end_attack1) + 8,
	((mframe_t *) supertank_frames_end_attack1) + 9,
	((mframe_t *) supertank_frames_end_attack1) + 10,
	((mframe_t *) supertank_frames_end_attack1) + 11,
	((mframe_t *) supertank_frames_end_attack1) + 12,
	((mframe_t *) supertank_frames_end_attack1) + 13,

	(mmove_t *) &supertank_move_end_attack1,

	((mframe_t *) tank_frames_stand) + 0,
	((mframe_t *) tank_frames_stand) + 1,
	((mframe_t *) tank_frames_stand) + 2,
	((mframe_t *) tank_frames_stand) + 3,
	((mframe_t *) tank_frames_stand) + 4,
	((mframe_t *) tank_frames_stand) + 5,
	((mframe_t *) tank_frames_stand) + 6,
	((mframe_t *) tank_frames_stand) + 7,
	((mframe_t *) tank_frames_stand) + 8,
	((mframe_t *) tank_frames_stand) + 9,
	((mframe_t *) tank_frames_stand) + 10,
	((mframe_t *) tank_frames_stand) + 11,
	((mframe_t *) tank_frames_stand) + 12,
	((mframe_t *) tank_frames_stand) + 13,
	((mframe_t *) tank_frames_stand) + 14,
	((mframe_t *) tank_frames_stand) + 15,
	((mframe_t *) tank_frames_stand) + 16,
	((mframe_t *) tank_frames_stand) + 17,
	((mframe_t *) tank_frames_stand) + 18,
	((mframe_t *) tank_frames_stand) + 19,
	((mframe_t *) tank_frames_stand) + 20,
	((mframe_t *) tank_frames_stand) + 21,
	((mframe_t *) tank_frames_stand) + 22,
	((mframe_t *) tank_frames_stand) + 23,
	((mframe_t *) tank_frames_stand) + 24,
	((mframe_t *) tank_frames_stand) + 25,
	((mframe_t *) tank_frames_stand) + 26,
	((mframe_t *) tank_frames_stand) + 27,
	((mframe_t *) tank_frames_stand) + 28,
	((mframe_t *) tank_frames_stand) + 29,

	(mmove_t *) &tank_move_stand,

	((mframe_t *) tank_frames_start_walk) + 0,
	((mframe_t *) tank_frames_start_walk) + 1,
	((mframe_t *) tank_frames_start_walk) + 2,
	((mframe_t *) tank_frames_start_walk) + 3,

	(mmove_t *) &tank_move_start_walk,

	((mframe_t *) tank_frames_walk) + 0,
	((mframe_t *) tank_frames_walk) + 1,
	((mframe_t *) tank_frames_walk) + 2,
	((mframe_t *) tank_frames_walk) + 3,
	((mframe_t *) tank_frames_walk) + 4,
	((mframe_t *) tank_frames_walk) + 5,
	((mframe_t *) tank_frames_walk) + 6,
	((mframe_t *) tank_frames_walk) + 7,
	((mframe_t *) tank_frames_walk) + 8,
	((mframe_t *) tank_frames_walk) + 9,
	((mframe_t *) tank_frames_walk) + 10,
	((mframe_t *) tank_frames_walk) + 11,
	((mframe_t *) tank_frames_walk) + 12,
	((mframe_t *) tank_frames_walk) + 13,
	((mframe_t *) tank_frames_walk) + 14,
	((mframe_t *) tank_frames_walk) + 15,

	(mmove_t *) &tank_move_walk,

	((mframe_t *) tank_frames_stop_walk) + 0,
	((mframe_t *) tank_frames_stop_walk) + 1,
	((mframe_t *) tank_frames_stop_walk) + 2,
	((mframe_t *) tank_frames_stop_walk) + 3,
	((mframe_t *) tank_frames_stop_walk) + 4,

	(mmove_t *) &tank_move_stop_walk,

	((mframe_t *) tank_frames_start_run) + 0,
	((mframe_t *) tank_frames_start_run) + 1,
	((mframe_t *) tank_frames_start_run) + 2,
	((mframe_t *) tank_frames_start_run) + 3,

	(mmove_t *) &tank_move_start_run,

	((mframe_t *) tank_frames_run) + 0,
	((mframe_t *) tank_frames_run) + 1,
	((mframe_t *) tank_frames_run) + 2,
	((mframe_t *) tank_frames_run) + 3,
	((mframe_t *) tank_frames_run) + 4,
	((mframe_t *) tank_frames_run) + 5,
	((mframe_t *) tank_frames_run) + 6,
	((mframe_t *) tank_frames_run) + 7,
	((mframe_t *) tank_frames_run) + 8,
	((mframe_t *) tank_frames_run) + 9,
	((mframe_t *) tank_frames_run) + 10,
	((mframe_t *) tank_frames_run) + 11,
	((mframe_t *) tank_frames_run) + 12,
	((mframe_t *) tank_frames_run) + 13,
	((mframe_t *) tank_frames_run) + 14,
	((mframe_t *) tank_frames_run) + 15,

	(mmove_t *) &tank_move_run,

	((mframe_t *) tank_frames_stop_run) + 0,
	((mframe_t *) tank_frames_stop_run) + 1,
	((mframe_t *) tank_frames_stop_run) + 2,
	((mframe_t *) tank_frames_stop_run) + 3,
	((mframe_t *) tank_frames_stop_run) + 4,

	(mmove_t *) &tank_move_stop_run,

	((mframe_t *) tank_frames_pain1) + 0,
	((mframe_t *) tank_frames_pain1) + 1,
	((mframe_t *) tank_frames_pain1) + 2,
	((mframe_t *) tank_frames_pain1) + 3,

	(mmove_t *) &tank_move_pain1,

	((mframe_t *) tank_frames_pain2) + 0,
	((mframe_t *) tank_frames_pain2) + 1,
	((mframe_t *) tank_frames_pain2) + 2,
	((mframe_t *) tank_frames_pain2) + 3,
	((mframe_t *) tank_frames_pain2) + 4,

	(mmove_t *) &tank_move_pain2,

	((mframe_t *) tank_frames_pain3) + 0,
	((mframe_t *) tank_frames_pain3) + 1,
	((mframe_t *) tank_frames_pain3) + 2,
	((mframe_t *) tank_frames_pain3) + 3,
	((mframe_t *) tank_frames_pain3) + 4,
	((mframe_t *) tank_frames_pain3) + 5,
	((mframe_t *) tank_frames_pain3) + 6,
	((mframe_t *) tank_frames_pain3) + 7,
	((mframe_t *) tank_frames_pain3) + 8,
	((mframe_t *) tank_frames_pain3) + 9,
	((mframe_t *) tank_frames_pain3) + 10,
	((mframe_t *) tank_frames_pain3) + 11,
	((mframe_t *) tank_frames_pain3) + 12,
	((mframe_t *) tank_frames_pain3) + 13,
	((mframe_t *) tank_frames_pain3) + 14,
	((mframe_t *) tank_frames_pain3) + 15,

	(mmove_t *) &tank_move_pain3,

	((mframe_t *) tank_frames_attack_blast) + 0,
	((mframe_t *) tank_frames_attack_blast) + 1,
	((mframe_t *) tank_frames_attack_blast) + 2,
	((mframe_t *) tank_frames_attack_blast) + 3,
	((mframe_t *) tank_frames_attack_blast) + 4,
	((mframe_t *) tank_frames_attack_blast) + 5,
	((mframe_t *) tank_frames_attack_blast) + 6,
	((mframe_t *) tank_frames_attack_blast) + 7,
	((mframe_t *) tank_frames_attack_blast) + 8,
	((mframe_t *) tank_frames_attack_blast) + 9,
	((mframe_t *) tank_frames_attack_blast) + 10,
	((mframe_t *) tank_frames_attack_blast) + 11,
	((mframe_t *) tank_frames_attack_blast) + 12,
	((mframe_t *) tank_frames_attack_blast) + 13,
	((mframe_t *) tank_frames_attack_blast) + 14,
	((mframe_t *) tank_frames_attack_blast) + 15,

	(mmove_t *) &tank_move_attack_blast,

	((mframe_t *) tank_frames_reattack_blast) + 0,
	((mframe_t *) tank_frames_reattack_blast) + 1,
	((mframe_t *) tank_frames_reattack_blast) + 2,
	((mframe_t *) tank_frames_reattack_blast) + 3,
	((mframe_t *) tank_frames_reattack_blast) + 4,
	((mframe_t *) tank_frames_reattack_blast) + 5,

	(mmove_t *) &tank_move_reattack_blast,

	((mframe_t *) tank_frames_attack_post_blast) + 0,
	((mframe_t *) tank_frames_attack_post_blast) + 1,
	((mframe_t *) tank_frames_attack_post_blast) + 2,
	((mframe_t *) tank_frames_attack_post_blast) + 3,
	((mframe_t *) tank_frames_attack_post_blast) + 4,
	((mframe_t *) tank_frames_attack_post_blast) + 5,

	(mmove_t *) &tank_move_attack_post_blast,

	((mframe_t *) tank_frames_attack_strike) + 0,
	((mframe_t *) tank_frames_attack_strike) + 1,
	((mframe_t *) tank_frames_attack_strike) + 2,
	((mframe_t *) tank_frames_attack_strike) + 3,
	((mframe_t *) tank_frames_attack_strike) + 4,
	((mframe_t *) tank_frames_attack_strike) + 5,
	((mframe_t *) tank_frames_attack_strike) + 6,
	((mframe_t *) tank_frames_attack_strike) + 7,
	((mframe_t *) tank_frames_attack_strike) + 8,
	((mframe_t *) tank_frames_attack_strike) + 9,
	((mframe_t *) tank_frames_attack_strike) + 10,
	((mframe_t *) tank_frames_attack_strike) + 11,
	((mframe_t *) tank_frames_attack_strike) + 12,
	((mframe_t *) tank_frames_attack_strike) + 13,
	((mframe_t *) tank_frames_attack_strike) + 14,
	((mframe_t *) tank_frames_attack_strike) + 15,
	((mframe_t *) tank_frames_attack_strike) + 16,
	((mframe_t *) tank_frames_attack_strike) + 17,
	((mframe_t *) tank_frames_attack_strike) + 18,
	((mframe_t *) tank_frames_attack_strike) + 19,
	((mframe_t *) tank_frames_attack_strike) + 20,
	((mframe_t *) tank_frames_attack_strike) + 21,
	((mframe_t *) tank_frames_attack_strike) + 22,
	((mframe_t *) tank_frames_attack_strike) + 23,
	((mframe_t *) tank_frames_attack_strike) + 24,
	((mframe_t *) tank_frames_attack_strike) + 25,
	((mframe_t *) tank_frames_attack_strike) + 26,
	((mframe_t *) tank_frames_attack_strike) + 27,
	((mframe_t *) tank_frames_attack_strike) + 28,
	((mframe_t *) tank_frames_attack_strike) + 29,
	((mframe_t *) tank_frames_attack_strike) + 30,
	((mframe_t *) tank_frames_attack_strike) + 31,
	((mframe_t *) tank_frames_attack_strike) + 32,
	((mframe_t *) tank_frames_attack_strike) + 33,
	((mframe_t *) tank_frames_attack_strike) + 34,
	((mframe_t *) tank_frames_attack_strike) + 35,
	((mframe_t *) tank_frames_attack_strike) + 36,
	((mframe_t *) tank_frames_attack_strike) + 37,

	(mmove_t *) &tank_move_attack_strike,

	((mframe_t *) tank_frames_attack_pre_rocket) + 0,
	((mframe_t *) tank_frames_attack_pre_rocket) + 1,
	((mframe_t *) tank_frames_attack_pre_rocket) + 2,
	((mframe_t *) tank_frames_attack_pre_rocket) + 3,
	((mframe_t *) tank_frames_attack_pre_rocket) + 4,
	((mframe_t *) tank_frames_attack_pre_rocket) + 5,
	((mframe_t *) tank_frames_attack_pre_rocket) + 6,
	((mframe_t *) tank_frames_attack_pre_rocket) + 7,
	((mframe_t *) tank_frames_attack_pre_rocket) + 8,
	((mframe_t *) tank_frames_attack_pre_rocket) + 9,
	((mframe_t *) tank_frames_attack_pre_rocket) + 10,
	((mframe_t *) tank_frames_attack_pre_rocket) + 11,
	((mframe_t *) tank_frames_attack_pre_rocket) + 12,
	((mframe_t *) tank_frames_attack_pre_rocket) + 13,
	((mframe_t *) tank_frames_attack_pre_rocket) + 14,
	((mframe_t *) tank_frames_attack_pre_rocket) + 15,
	((mframe_t *) tank_frames_attack_pre_rocket) + 16,
	((mframe_t *) tank_frames_attack_pre_rocket) + 17,
	((mframe_t *) tank_frames_attack_pre_rocket) + 18,
	((mframe_t *) tank_frames_attack_pre_rocket) + 19,
	((mframe_t *) tank_frames_attack_pre_rocket) + 20,

	(mmove_t *) &tank_move_attack_pre_rocket,

	((mframe_t *) tank_frames_attack_fire_rocket) + 0,
	((mframe_t *) tank_frames_attack_fire_rocket) + 1,
	((mframe_t *) tank_frames_attack_fire_rocket) + 2,
	((mframe_t *) tank_frames_attack_fire_rocket) + 3,
	((mframe_t *) tank_frames_attack_fire_rocket) + 4,
	((mframe_t *) tank_frames_attack_fire_rocket) + 5,
	((mframe_t *) tank_frames_attack_fire_rocket) + 6,
	((mframe_t *) tank_frames_attack_fire_rocket) + 7,
	((mframe_t *) tank_frames_attack_fire_rocket) + 8,

	(mmove_t *) &tank_move_attack_fire_rocket,

	((mframe_t *) tank_frames_attack_post_rocket) + 0,
	((mframe_t *) tank_frames_attack_post_rocket) + 1,
	((mframe_t *) tank_frames_attack_post_rocket) + 2,
	((mframe_t *) tank_frames_attack_post_rocket) + 3,
	((mframe_t *) tank_frames_attack_post_rocket) + 4,
	((mframe_t *) tank_frames_attack_post_rocket) + 5,
	((mframe_t *) tank_frames_attack_post_rocket) + 6,
	((mframe_t *) tank_frames_attack_post_rocket) + 7,
	((mframe_t *) tank_frames_attack_post_rocket) + 8,
	((mframe_t *) tank_frames_attack_post_rocket) + 9,
	((mframe_t *) tank_frames_attack_post_rocket) + 10,
	((mframe_t *) tank_frames_attack_post_rocket) + 11,
	((mframe_t *) tank_frames_attack_post_rocket) + 12,
	((mframe_t *) tank_frames_attack_post_rocket) + 13,
	((mframe_t *) tank_frames_attack_post_rocket) + 14,
	((mframe_t *) tank_frames_attack_post_rocket) + 15,
	((mframe_t *) tank_frames_attack_post_rocket) + 16,
	((mframe_t *) tank_frames_attack_post_rocket) + 17,
	((mframe_t *) tank_frames_attack_post_rocket) + 18,
	((mframe_t *) tank_frames_attack_post_rocket) + 19,
	((mframe_t *) tank_frames_attack_post_rocket) + 20,
	((mframe_t *) tank_frames_attack_post_rocket) + 21,
	((mframe_t *) tank_frames_attack_post_rocket) + 22,

	(mmove_t *) &tank_move_attack_post_rocket,

	((mframe_t *) tank_frames_attack_chain) + 0,
	((mframe_t *) tank_frames_attack_chain) + 1,
	((mframe_t *) tank_frames_attack_chain) + 2,
	((mframe_t *) tank_frames_attack_chain) + 3,
	((mframe_t *) tank_frames_attack_chain) + 4,
	((mframe_t *) tank_frames_attack_chain) + 5,
	((mframe_t *) tank_frames_attack_chain) + 6,
	((mframe_t *) tank_frames_attack_chain) + 7,
	((mframe_t *) tank_frames_attack_chain) + 8,
	((mframe_t *) tank_frames_attack_chain) + 9,
	((mframe_t *) tank_frames_attack_chain) + 10,
	((mframe_t *) tank_frames_attack_chain) + 11,
	((mframe_t *) tank_frames_attack_chain) + 12,
	((mframe_t *) tank_frames_attack_chain) + 13,
	((mframe_t *) tank_frames_attack_chain) + 14,
	((mframe_t *) tank_frames_attack_chain) + 15,
	((mframe_t *) tank_frames_attack_chain) + 16,
	((mframe_t *) tank_frames_attack_chain) + 17,
	((mframe_t *) tank_frames_attack_chain) + 18,
	((mframe_t *) tank_frames_attack_chain) + 19,
	((mframe_t *) tank_frames_attack_chain) + 20,
	((mframe_t *) tank_frames_attack_chain) + 21,
	((mframe_t *) tank_frames_attack_chain) + 22,
	((mframe_t *) tank_frames_attack_chain) + 23,
	((mframe_t *) tank_frames_attack_chain) + 24,
	((mframe_t *) tank_frames_attack_chain) + 25,
	((mframe_t *) tank_frames_attack_chain) + 26,
	((mframe_t *) tank_frames_attack_chain) + 27,
	((mframe_t *) tank_frames_attack_chain) + 28,

	(mmove_t *) &tank_move_attack_chain,

	((mframe_t *) tank_frames_death1) + 0,
	((mframe_t *) tank_frames_death1) + 1,
	((mframe_t *) tank_frames_death1) + 2,
	((mframe_t *) tank_frames_death1) + 3,
	((mframe_t *) tank_frames_death1) + 4,
	((mframe_t *) tank_frames_death1) + 5,
	((mframe_t *) tank_frames_death1) + 6,
	((mframe_t *) tank_frames_death1) + 7,
	((mframe_t *) tank_frames_death1) + 8,
	((mframe_t *) tank_frames_death1) + 9,
	((mframe_t *) tank_frames_death1) + 10,
	((mframe_t *) tank_frames_death1) + 11,
	((mframe_t *) tank_frames_death1) + 12,
	((mframe_t *) tank_frames_death1) + 13,
	((mframe_t *) tank_frames_death1) + 14,
	((mframe_t *) tank_frames_death1) + 15,
	((mframe_t *) tank_frames_death1) + 16,
	((mframe_t *) tank_frames_death1) + 17,
	((mframe_t *) tank_frames_death1) + 18,
	((mframe_t *) tank_frames_death1) + 19,
	((mframe_t *) tank_frames_death1) + 20,
	((mframe_t *) tank_frames_death1) + 21,
	((mframe_t *) tank_frames_death1) + 22,
	((mframe_t *) tank_frames_death1) + 23,
	((mframe_t *) tank_frames_death1) + 24,
	((mframe_t *) tank_frames_death1) + 25,
	((mframe_t *) tank_frames_death1) + 26,
	((mframe_t *) tank_frames_death1) + 27,
	((mframe_t *) tank_frames_death1) + 28,
	((mframe_t *) tank_frames_death1) + 29,
	((mframe_t *) tank_frames_death1) + 30,
	((mframe_t *) tank_frames_death1) + 31,

	(mmove_t *) &tank_move_death,

	NULL
};

char *static_strings[] = {
	"target_actor",
	"player_noise",
	"skin",
	"all",
	"health",
	"weapons",
	"ammo",
	"armor",
	"Jacket Armor",
	"Combat Armor",
	"Body Armor",
	"Power Shield",
	"Power Shield",
	"godmode OFF\n",
	"godmode ON\n",
	"notarget OFF\n",
	"notarget ON\n",
	"noclip OFF\n",
	"noclip ON\n",
	"...\n",
	" ",
	"\n",
	" (spectator)",
	"",
	"players",
	"say",
	"say_team",
	"score",
	"help",
	"use",
	"drop",
	"give",
	"god",
	"notarget",
	"noclip",
	"inven",
	"invnext",
	"invprev",
	"invnextw",
	"invprevw",
	"invnextp",
	"invprevp",
	"invuse",
	"invdrop",
	"weapprev",
	"weapnext",
	"weaplast",
	"kill",
	"putaway",
	"wave",
	"playerlist",
	"monster_medic",
	"Cells",
	"monster_tank",
	"monster_supertank",
	"monster_makron",
	"monster_jorg",
	"items/protect4.wav",
	"plats/pt1_strt.wav",
	"plats/pt1_mid.wav",
	"plats/pt1_end.wav",
	"switches/butn2.wav",
	"func_areaportal",
	"func_door",
	"func_door_rotating",
	"func_door",
	"func_door_rotating",
	"misc/talk1.wav",
	"doors/dr1_strt.wav",
	"doors/dr1_mid.wav",
	"doors/dr1_end.wav",
	"misc/talk.wav",
	"doors/dr1_strt.wav",
	"doors/dr1_mid.wav",
	"doors/dr1_end.wav",
	"misc/talk.wav",
	"world/mov_watr.wav",
	"world/stp_watr.wav",
	"world/mov_watr.wav",
	"world/stp_watr.wav",
	"func_door",
	"func_train",
	"doors/dr1_strt.wav",
	"doors/dr1_mid.wav",
	"doors/dr1_end.wav",
	"misc/talk.wav",
	"func_door",
	"Bullets",
	"Shells",
	"Bullets",
	"Shells",
	"Cells",
	"Grenades",
	"Rockets",
	"Slugs",
	"items/damage.wav",
	"items/protect.wav",
	"key_power_cube",
	"blaster",
	"misc/power2.wav",
	"cells",
	"misc/power1.wav",
	"items/s_health.wav",
	"items/n_health.wav",
	"items/l_health.wav",
	"items/m_health.wav",
	"md2",
	"sp2",
	"wav",
	"pcx",
	"key_power_cube",
	"weapon_bfg",
	"key_power_cube",
	"item_armor_body",
	"misc/ar1_pkup.wav",
	"models/items/armor/body/tris.md2",
	"i_bodyarmor",
	"Body Armor",
	"",
	"item_armor_combat",
	"misc/ar1_pkup.wav",
	"models/items/armor/combat/tris.md2",
	"i_combatarmor",
	"Combat Armor",
	"",
	"item_armor_jacket",
	"misc/ar1_pkup.wav",
	"models/items/armor/jacket/tris.md2",
	"i_jacketarmor",
	"Jacket Armor",
	"",
	"item_armor_shard",
	"misc/ar2_pkup.wav",
	"models/items/armor/shard/tris.md2",
	"i_jacketarmor",
	"Armor Shard",
	"",
	"item_power_screen",
	"misc/ar3_pkup.wav",
	"models/items/armor/screen/tris.md2",
	"i_powerscreen",
	"Power Screen",
	"",
	"item_power_shield",
	"misc/ar3_pkup.wav",
	"models/items/armor/shield/tris.md2",
	"i_powershield",
	"Power Shield",
	"misc/power2.wav misc/power1.wav",
	"weapon_blaster",
	"misc/w_pkup.wav",
	"models/weapons/v_blast/tris.md2",
	"w_blaster",
	"Blaster",
	"weapons/blastf1a.wav misc/lasfly.wav",
	"weapon_shotgun",
	"misc/w_pkup.wav",
	"models/weapons/g_shotg/tris.md2",
	"models/weapons/v_shotg/tris.md2",
	"w_shotgun",
	"Shotgun",
	"Shells",
	"weapons/shotgf1b.wav weapons/shotgr1b.wav",
	"weapon_supershotgun",
	"misc/w_pkup.wav",
	"models/weapons/g_shotg2/tris.md2",
	"models/weapons/v_shotg2/tris.md2",
	"w_sshotgun",
	"Super Shotgun",
	"Shells",
	"weapons/sshotf1b.wav",
	"weapon_machinegun",
	"misc/w_pkup.wav",
	"models/weapons/g_machn/tris.md2",
	"models/weapons/v_machn/tris.md2",
	"w_machinegun",
	"Machinegun",
	"Bullets",
	"weapons/machgf1b.wav weapons/machgf2b.wav weapons/machgf3b.wav weapons/machgf4b.wav weapons/machgf5b.wav",
	"weapon_chaingun",
	"misc/w_pkup.wav",
	"models/weapons/g_chain/tris.md2",
	"models/weapons/v_chain/tris.md2",
	"w_chaingun",
	"Chaingun",
	"Bullets",
	"weapons/chngnu1a.wav weapons/chngnl1a.wav weapons/machgf3b.wav` weapons/chngnd1a.wav",
	"ammo_grenades",
	"misc/am_pkup.wav",
	"models/items/ammo/grenades/medium/tris.md2",
	"models/weapons/v_handgr/tris.md2",
	"a_grenades",
	"Grenades",
	"grenades",
	"weapons/hgrent1a.wav weapons/hgrena1b.wav weapons/hgrenc1b.wav weapons/hgrenb1a.wav weapons/hgrenb2a.wav ",
	"weapon_grenadelauncher",
	"misc/w_pkup.wav",
	"models/weapons/g_launch/tris.md2",
	"models/weapons/v_launch/tris.md2",
	"w_glauncher",
	"Grenade Launcher",
	"Grenades",
	"models/objects/grenade/tris.md2 weapons/grenlf1a.wav weapons/grenlr1b.wav weapons/grenlb1b.wav",
	"weapon_rocketlauncher",
	"misc/w_pkup.wav",
	"models/weapons/g_rocket/tris.md2",
	"models/weapons/v_rocket/tris.md2",
	"w_rlauncher",
	"Rocket Launcher",
	"Rockets",
	"models/objects/rocket/tris.md2 weapons/rockfly.wav weapons/rocklf1a.wav weapons/rocklr1b.wav models/objects/debris2/tris.md2",
	"weapon_hyperblaster",
	"misc/w_pkup.wav",
	"models/weapons/g_hyperb/tris.md2",
	"models/weapons/v_hyperb/tris.md2",
	"w_hyperblaster",
	"HyperBlaster",
	"Cells",
	"weapons/hyprbu1a.wav weapons/hyprbl1a.wav weapons/hyprbf1a.wav weapons/hyprbd1a.wav misc/lasfly.wav",
	"weapon_railgun",
	"misc/w_pkup.wav",
	"models/weapons/g_rail/tris.md2",
	"models/weapons/v_rail/tris.md2",
	"w_railgun",
	"Railgun",
	"Slugs",
	"weapons/rg_hum.wav",
	"weapon_bfg",
	"misc/w_pkup.wav",
	"models/weapons/g_bfg/tris.md2",
	"models/weapons/v_bfg/tris.md2",
	"w_bfg",
	"BFG10K",
	"Cells",
	"sprites/s_bfg1.sp2 sprites/s_bfg2.sp2 sprites/s_bfg3.sp2 weapons/bfg__f1y.wav weapons/bfg__l1a.wav weapons/bfg__x1b.wav weapons/bfg_hum.wav",
	"ammo_shells",
	"misc/am_pkup.wav",
	"models/items/ammo/shells/medium/tris.md2",
	"a_shells",
	"Shells",
	"",
	"ammo_bullets",
	"misc/am_pkup.wav",
	"models/items/ammo/bullets/medium/tris.md2",
	"a_bullets",
	"Bullets",
	"",
	"ammo_cells",
	"misc/am_pkup.wav",
	"models/items/ammo/cells/medium/tris.md2",
	"a_cells",
	"Cells",
	"",
	"ammo_rockets",
	"misc/am_pkup.wav",
	"models/items/ammo/rockets/medium/tris.md2",
	"a_rockets",
	"Rockets",
	"",
	"ammo_slugs",
	"misc/am_pkup.wav",
	"models/items/ammo/slugs/medium/tris.md2",
	"a_slugs",
	"Slugs",
	"",
	"item_quad",
	"items/pkup.wav",
	"models/items/quaddama/tris.md2",
	"p_quad",
	"Quad Damage",
	"items/damage.wav items/damage2.wav items/damage3.wav",
	"item_invulnerability",
	"items/pkup.wav",
	"models/items/invulner/tris.md2",
	"p_invulnerability",
	"Invulnerability",
	"items/protect.wav items/protect2.wav items/protect4.wav",
	"item_silencer",
	"items/pkup.wav",
	"models/items/silencer/tris.md2",
	"p_silencer",
	"Silencer",
	"",
	"item_breather",
	"items/pkup.wav",
	"models/items/breather/tris.md2",
	"p_rebreather",
	"Rebreather",
	"items/airout.wav",
	"item_enviro",
	"items/pkup.wav",
	"models/items/enviro/tris.md2",
	"p_envirosuit",
	"Environment Suit",
	"items/airout.wav",
	"item_ancient_head",
	"items/pkup.wav",
	"models/items/c_head/tris.md2",
	"i_fixme",
	"Ancient Head",
	"",
	"item_adrenaline",
	"items/pkup.wav",
	"models/items/adrenal/tris.md2",
	"p_adrenaline",
	"Adrenaline",
	"",
	"item_bandolier",
	"items/pkup.wav",
	"models/items/band/tris.md2",
	"p_bandolier",
	"Bandolier",
	"",
	"item_pack",
	"items/pkup.wav",
	"models/items/pack/tris.md2",
	"i_pack",
	"Ammo Pack",
	"",
	"key_data_cd",
	"items/pkup.wav",
	"models/items/keys/data_cd/tris.md2",
	"k_datacd",
	"Data CD",
	"",
	"key_power_cube",
	"items/pkup.wav",
	"models/items/keys/power/tris.md2",
	"k_powercube",
	"Power Cube",
	"",
	"key_pyramid",
	"items/pkup.wav",
	"models/items/keys/pyramid/tris.md2",
	"k_pyramid",
	"Pyramid Key",
	"",
	"key_data_spinner",
	"items/pkup.wav",
	"models/items/keys/spinner/tris.md2",
	"k_dataspin",
	"Data Spinner",
	"",
	"key_pass",
	"items/pkup.wav",
	"models/items/keys/pass/tris.md2",
	"k_security",
	"Security Pass",
	"",
	"key_blue_key",
	"items/pkup.wav",
	"models/items/keys/key/tris.md2",
	"k_bluekey",
	"Blue Key",
	"",
	"key_red_key",
	"items/pkup.wav",
	"models/items/keys/red_key/tris.md2",
	"k_redkey",
	"Red Key",
	"",
	"key_commander_head",
	"items/pkup.wav",
	"models/monsters/commandr/head/tris.md2",
	"k_comhead",
	"Commander\'s Head",
	"",
	"key_airstrike_target",
	"items/pkup.wav",
	"models/items/keys/target/tris.md2",
	"i_airstrike",
	"Airstrike Marker",
	"",
	"items/pkup.wav",
	"i_health",
	"Health",
	"items/s_health.wav items/n_health.wav items/l_health.wav items/m_health.wav",
	"models/items/healing/medium/tris.md2",
	"Health",
	"items/n_health.wav",
	"models/items/healing/stimpack/tris.md2",
	"Health",
	"items/s_health.wav",
	"models/items/healing/large/tris.md2",
	"Health",
	"items/l_health.wav",
	"models/items/mega_h/tris.md2",
	"Health",
	"items/m_health.wav",
	"Jacket Armor",
	"Combat Armor",
	"Body Armor",
	"Power Screen",
	"Power Shield",
	"target_changelevel",
	" ,\n\r",
	"target_changelevel",
	"none",
	"none",
	"needpass",
	"misc/fhit3.wav",
	"models/objects/gibs/head2/tris.md2",
	"models/objects/gibs/skull/tris.md2",
	"debris",
	"models/objects/banner/tris.md2",
	"m",
	"a",
	"a",
	"m",
	"models/objects/debris1/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris1/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris1/tris.md2",
	"models/objects/debris1/tris.md2",
	"models/objects/debris3/tris.md2",
	"models/objects/debris3/tris.md2",
	"models/objects/debris3/tris.md2",
	"models/objects/debris3/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris1/tris.md2",
	"models/objects/debris2/tris.md2",
	"models/objects/debris3/tris.md2",
	"models/objects/barrels/tris.md2",
	"models/objects/black/tris.md2",
	"models/monsters/tank/tris.md2",
	"models/monsters/bitch/tris.md2",
	"models/monsters/bitch/tris.md2",
	"tank/thud.wav",
	"tank/pain.wav",
	"models/monsters/commandr/tris.md2",
	"tank/thud.wav",
	"tank/pain.wav",
	"models/objects/banner/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"models/deadbods/dude/tris.md2",
	"models/ships/viper/tris.md2",
	"models/ships/bigviper/tris.md2",
	"misc_viper",
	"models/objects/bomb/tris.md2",
	"models/ships/strogg1/tris.md2",
	"models/objects/satellite/tris.md2",
	"models/objects/minelite/light1/tris.md2",
	"models/objects/minelite/light2/tris.md2",
	"models/objects/gibs/arm/tris.md2",
	"models/objects/gibs/leg/tris.md2",
	"models/objects/gibs/head/tris.md2",
	"",
	"models/objects/dmspot/tris.md2",
	"world/amb10.wav",
	"models/objects/dmspot/tris.md2",
	"infantry/inflies1.wav",
	"player/watr_out.wav",
	"player/lava1.wav",
	"player/lava2.wav",
	"player/watr_in.wav",
	"player/watr_in.wav",
	"point_combat",
	"point_combat",
	"path_corner",
	"misc/h2ohit1.wav",
	"misc/h2ohit1.wav",
	"world/land.wav",
	"classname",
	"model",
	"spawnflags",
	"speed",
	"accel",
	"decel",
	"target",
	"targetname",
	"pathtarget",
	"deathtarget",
	"killtarget",
	"combattarget",
	"message",
	"team",
	"wait",
	"delay",
	"random",
	"move_origin",
	"move_angles",
	"style",
	"count",
	"health",
	"sounds",
	"light",
	"dmg",
	"mass",
	"volume",
	"attenuation",
	"map",
	"origin",
	"angles",
	"angle",
	"goalentity",
	"movetarget",
	"enemy",
	"oldenemy",
	"activator",
	"groundentity",
	"teamchain",
	"teammaster",
	"owner",
	"mynoise",
	"mynoise2",
	"target_ent",
	"chain",
	"prethink",
	"think",
	"blocked",
	"touch",
	"use",
	"pain",
	"die",
	"stand",
	"idle",
	"search",
	"walk",
	"run",
	"dodge",
	"attack",
	"melee",
	"sight",
	"checkattack",
	"currentmove",
	"endfunc",
	"lip",
	"distance",
	"height",
	"noise",
	"pausetime",
	"item",
	"item",
	"gravity",
	"sky",
	"skyrotate",
	"skyaxis",
	"minyaw",
	"maxyaw",
	"minpitch",
	"maxpitch",
	"nextmap",
	"changemap",
	"sight_client",
	"sight_entity",
	"sound_entity",
	"sound2_entity",
	"pers.weapon",
	"pers.lastweapon",
	"newweapon",
	"gun_x",
	"0",
	"gun_y",
	"0",
	"gun_z",
	"0",
	"sv_rollspeed",
	"200",
	"sv_rollangle",
	"2",
	"sv_maxvelocity",
	"2000",
	"sv_gravity",
	"800",
	"dedicated",
	"0",
	"cheats",
	"0",
	"gamename",
	"baseq2",
	"gamedate",
	"Mar 25 2004",
	"maxclients",
	"4",
	"maxspectators",
	"4",
	"deathmatch",
	"0",
	"coop",
	"0",
	"skill",
	"1",
	"maxentities",
	"1024",
	"dmflags",
	"0",
	"fraglimit",
	"0",
	"timelimit",
	"0",
	"password",
	"",
	"spectator_password",
	"",
	"needpass",
	"0",
	"filterban",
	"1",
	"g_select_empty",
	"0",
	"run_pitch",
	"0.002",
	"run_roll",
	"0.005",
	"bob_up",
	"0.005",
	"bob_pitch",
	"0.002",
	"bob_roll",
	"0.002",
	"flood_msgs",
	"4",
	"flood_persecond",
	"4",
	"flood_waitdelay",
	"10",
	"sv_maplist",
	"",
	"wb",
	"Mar 25 2004",
	"rb",
	"Mar 25 2004",
	"wb",
	"rb",
	"target_crosslevel_target",
	"item_health",
	"item_health_small",
	"item_health_large",
	"item_health_mega",
	"info_player_start",
	"info_player_deathmatch",
	"info_player_coop",
	"info_player_intermission",
	"func_plat",
	"func_button",
	"func_door",
	"func_door_secret",
	"func_door_rotating",
	"func_rotating",
	"func_train",
	"func_water",
	"func_conveyor",
	"func_areaportal",
	"func_clock",
	"func_wall",
	"func_object",
	"func_timer",
	"func_explosive",
	"func_killbox",
	"trigger_always",
	"trigger_once",
	"trigger_multiple",
	"trigger_relay",
	"trigger_push",
	"trigger_hurt",
	"trigger_key",
	"trigger_counter",
	"trigger_elevator",
	"trigger_gravity",
	"trigger_monsterjump",
	"target_temp_entity",
	"target_speaker",
	"target_explosion",
	"target_changelevel",
	"target_secret",
	"target_goal",
	"target_splash",
	"target_spawner",
	"target_blaster",
	"target_crosslevel_trigger",
	"target_crosslevel_target",
	"target_laser",
	"target_help",
	"target_actor",
	"target_lightramp",
	"target_earthquake",
	"target_character",
	"target_string",
	"worldspawn",
	"viewthing",
	"light",
	"light_mine1",
	"light_mine2",
	"info_null",
	"func_group",
	"info_notnull",
	"path_corner",
	"point_combat",
	"misc_explobox",
	"misc_banner",
	"misc_satellite_dish",
	"misc_actor",
	"misc_gib_arm",
	"misc_gib_leg",
	"misc_gib_head",
	"misc_insane",
	"misc_deadsoldier",
	"misc_viper",
	"misc_viper_bomb",
	"misc_bigviper",
	"misc_strogg_ship",
	"misc_teleporter",
	"misc_teleporter_dest",
	"misc_blackhole",
	"misc_eastertank",
	"misc_easterchick",
	"misc_easterchick2",
	"monster_berserk",
	"monster_gladiator",
	"monster_gunner",
	"monster_infantry",
	"monster_soldier_light",
	"monster_soldier",
	"monster_soldier_ss",
	"monster_tank",
	"monster_tank_commander",
	"monster_medic",
	"monster_flipper",
	"monster_chick",
	"monster_parasite",
	"monster_flyer",
	"monster_brain",
	"monster_floater",
	"monster_hover",
	"monster_mutant",
	"monster_supertank",
	"monster_boss2",
	"monster_boss3_stand",
	"monster_jorg",
	"monster_commander_body",
	"turret_breach",
	"turret_base",
	"turret_driver",
	"%f %f %f",
	"skill",
	"command",
	"trigger_once",
	"*27",
	"yb\t-24 xv\t0 hnum xv\t50 pic 0 if 2 \txv\t100 \tanum \txv\t150 \tpic 2 endif if 4 \txv\t200 \trnum \txv\t250 \tpic 4 endif if 6 \txv\t296 \tpic 6 endif yb\t-50 if 7 \txv\t0 \tpic 7 \txv\t26 \tyb\t-42 \tstat_string 8 \tyb\t-50 endif if 9 \txv\t262 \tnum\t2\t10 \txv\t296 \tpic\t9 endif if 11 \txv\t148 \tpic\t11 endif ",
	"yb\t-24 xv\t0 hnum xv\t50 pic 0 if 2 \txv\t100 \tanum \txv\t150 \tpic 2 endif if 4 \txv\t200 \trnum \txv\t250 \tpic 4 endif if 6 \txv\t296 \tpic 6 endif yb\t-50 if 7 \txv\t0 \tpic 7 \txv\t26 \tyb\t-42 \tstat_string 8 \tyb\t-50 endif if 9 \txv\t246 \tnum\t2\t10 \txv\t296 \tpic\t9 endif if 11 \txv\t148 \tpic\t11 endif xr\t-50 yt 2 num 3 14 if 17 xv 0 yb -58 string2 \"SPECTATOR MODE\" endif if 16 xv 0 yb -68 string \"Chasing\" xv 64 stat_string 16 endif ",
	"unit1_",
	"unit1_",
	"i_help",
	"i_health",
	"help",
	"field_3",
	"sv_gravity",
	"800",
	"sv_gravity",
	"player/fry.wav",
	"Blaster",
	"player/lava1.wav",
	"player/lava2.wav",
	"misc/pc_up.wav",
	"misc/talk1.wav",
	"misc/udeath.wav",
	"items/respawn1.wav",
	"*death1.wav",
	"*death2.wav",
	"*death3.wav",
	"*death4.wav",
	"*fall1.wav",
	"*fall2.wav",
	"*gurp1.wav",
	"*gurp2.wav",
	"*jump1.wav",
	"*pain25_1.wav",
	"*pain25_2.wav",
	"*pain50_1.wav",
	"*pain50_2.wav",
	"*pain75_1.wav",
	"*pain75_2.wav",
	"*pain100_1.wav",
	"*pain100_2.wav",
	"#w_blaster.md2",
	"#w_shotgun.md2",
	"#w_sshotgun.md2",
	"#w_machinegun.md2",
	"#w_chaingun.md2",
	"#a_grenades.md2",
	"#w_glauncher.md2",
	"#w_rlauncher.md2",
	"#w_hyperblaster.md2",
	"#w_railgun.md2",
	"#w_bfg.md2",
	"player/gasp1.wav",
	"player/gasp2.wav",
	"player/watr_in.wav",
	"player/watr_out.wav",
	"player/watr_un.wav",
	"player/u_breath1.wav",
	"player/u_breath2.wav",
	"items/pkup.wav",
	"world/land.wav",
	"misc/h2ohit1.wav",
	"items/damage.wav",
	"items/protect.wav",
	"items/protect4.wav",
	"weapons/noammo.wav",
	"infantry/inflies1.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/arm/tris.md2",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/bone2/tris.md2",
	"models/objects/gibs/chest/tris.md2",
	"models/objects/gibs/skull/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"m",
	"mmnmmommommnonmmonqnmmo",
	"abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba",
	"mmmmmaaaaammmmmaaaaaabcdefgabcdefg",
	"mamamamamama",
	"jklmnopqrstuvwxyzyxwvutsrqponmlkj",
	"nmonqnmomnmomomno",
	"mmmaaaabcdefgmmmmaaaammmaamm",
	"mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa",
	"aaaaaaaazzzzzzzz",
	"mmamammmmammamamaaamammma",
	"abcdefghijklmnopqrrqponmlkjihgfedcba",
	"a",
	"game",
	"",
	"wb",
	"test",
	"addip",
	"removeip",
	"listip",
	"writeip",
	"acedebug",
	"on",
	"addbot",
	"removebot",
	"savenodes",
	".wav",
	"misc/secret.wav",
	"mine3",
	"You have found a secret area.",
	"0",
	"misc/secret.wav",
	"*",
	"fact1",
	"fact3",
	"fact3$secret1",
	"weapons/laser2.wav",
	"light",
	"world/quake.wav",
	"misc/secret.wav",
	"misc/talk.wav",
	"misc/trigger1.wav",
	"misc/keytry.wav",
	"misc/keyuse.wav",
	"key_power_cube",
	"misc/keytry.wav",
	"misc/keyuse.wav",
	"misc/talk1.wav",
	"misc/talk1.wav",
	"grenade",
	"misc/windfly.wav",
	"world/electro.wav",
	"weapons/rocklf1a.wav",
	"models/monsters/infantry/tris.md2",
	"DelayedUse",
	"misc/talk1.wav",
	"func_areaportal",
	"func_door",
	"func_door_rotating",
	"noclass",
	"freed",
	"*brwater",
	"sky",
	"models/objects/laser/tris.md2",
	"misc/lasfly.wav",
	"bolt",
	"weapons/hgrenb1a.wav",
	"weapons/hgrenb2a.wav",
	"weapons/grenlb1b.wav",
	"models/objects/grenade/tris.md2",
	"grenade",
	"models/objects/grenade2/tris.md2",
	"hgrenade",
	"weapons/hgrenc1b.wav",
	"weapons/hgrent1a.wav",
	"models/objects/debris2/tris.md2",
	"models/objects/rocket/tris.md2",
	"weapons/rockfly.wav",
	"rocket",
	"weapons/bfg__x1b.wav",
	"sprites/s_bfg3.sp2",
	"misc_explobox",
	"sprites/s_bfg1.sp2",
	"bfg blast",
	"weapons/bfg__l1a.wav",
	"Hellrot",
	"Tokay",
	"Killme",
	"Disruptor",
	"Adrianator",
	"Rambear",
	"Titus",
	"Bitterman",
	"Watch it",
	"#$@*&",
	"Idiot",
	"Check your targets",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"target_actor",
	"players/male/tris.md2",
	"player/male/jump1.wav",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"berserk/berpain2.wav",
	"berserk/berdeth2.wav",
	"berserk/beridle1.wav",
	"berserk/attack.wav",
	"berserk/bersrch1.wav",
	"berserk/sight.wav",
	"models/monsters/berserk/tris.md2",
	"bosshovr/bhvpain1.wav",
	"bosshovr/bhvpain2.wav",
	"bosshovr/bhvpain3.wav",
	"bosshovr/bhvdeth1.wav",
	"bosshovr/bhvunqv1.wav",
	"bosshovr/bhvengn1.wav",
	"models/monsters/boss2/tris.md2",
	"models/monsters/boss3/rider/tris.md2",
	"misc/bigtele.wav",
	"boss3/w_loop.wav",
	"boss3/bs3pain1.wav",
	"boss3/bs3pain2.wav",
	"boss3/bs3pain3.wav",
	"boss3/bs3deth1.wav",
	"boss3/bs3atck1.wav",
	"boss3/bs3atck2.wav",
	"boss3/bs3srch1.wav",
	"boss3/bs3srch2.wav",
	"boss3/bs3srch3.wav",
	"boss3/bs3idle1.wav",
	"boss3/step1.wav",
	"boss3/step2.wav",
	"boss3/xfire.wav",
	"boss3/d_hit.wav",
	"models/monsters/boss3/rider/tris.md2",
	"models/monsters/boss3/jorg/tris.md2",
	"models/monsters/boss3/rider/tris.md2",
	"makron/spine.wav",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/sm_metal/tris.md2",
	"models/objects/gibs/gear/tris.md2",
	"makron/pain3.wav",
	"makron/pain2.wav",
	"makron/pain1.wav",
	"makron/death.wav",
	"makron/step1.wav",
	"makron/step2.wav",
	"makron/bfg_fire.wav",
	"makron/brain1.wav",
	"makron/rail_up.wav",
	"makron/popup.wav",
	"makron/voice4.wav",
	"makron/voice3.wav",
	"makron/voice.wav",
	"makron/bhit.wav",
	"models/monsters/boss3/rider/tris.md2",
	"models/monsters/boss3/rider/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"brain/brnatck1.wav",
	"brain/brnatck2.wav",
	"brain/brnatck3.wav",
	"brain/brndeth1.wav",
	"brain/brnidle1.wav",
	"brain/brnidle2.wav",
	"brain/brnlens1.wav",
	"brain/brnpain1.wav",
	"brain/brnpain2.wav",
	"brain/brnsght1.wav",
	"brain/brnsrch1.wav",
	"brain/melee1.wav",
	"brain/melee2.wav",
	"brain/melee3.wav",
	"models/monsters/brain/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"chick/chkatck1.wav",
	"chick/chkatck2.wav",
	"chick/chkatck3.wav",
	"chick/chkatck4.wav",
	"chick/chkatck5.wav",
	"chick/chkdeth1.wav",
	"chick/chkdeth2.wav",
	"chick/chkfall1.wav",
	"chick/chkidle1.wav",
	"chick/chkidle2.wav",
	"chick/chkpain1.wav",
	"chick/chkpain2.wav",
	"chick/chkpain3.wav",
	"chick/chksght1.wav",
	"chick/chksrch1.wav",
	"models/monsters/bitch/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"flipper/flppain1.wav",
	"flipper/flppain2.wav",
	"flipper/flpdeth1.wav",
	"flipper/flpatck1.wav",
	"flipper/flpatck2.wav",
	"flipper/flpidle1.wav",
	"flipper/flpsrch1.wav",
	"flipper/flpsght1.wav",
	"models/monsters/flipper/tris.md2",
	"floater/fltatck2.wav",
	"floater/fltatck3.wav",
	"floater/fltdeth1.wav",
	"floater/fltidle1.wav",
	"floater/fltpain1.wav",
	"floater/fltpain2.wav",
	"floater/fltsght1.wav",
	"floater/fltatck1.wav",
	"floater/fltsrch1.wav",
	"models/monsters/float/tris.md2",
	"jail5",
	"flyer/flysght1.wav",
	"flyer/flysrch1.wav",
	"flyer/flypain1.wav",
	"flyer/flypain2.wav",
	"flyer/flyatck2.wav",
	"flyer/flyatck1.wav",
	"flyer/flydeth1.wav",
	"flyer/flyatck3.wav",
	"models/monsters/flyer/tris.md2",
	"flyer/flyidle1.wav",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"gladiator/pain.wav",
	"gladiator/gldpain2.wav",
	"gladiator/glddeth2.wav",
	"gladiator/railgun.wav",
	"gladiator/melee1.wav",
	"gladiator/melee2.wav",
	"gladiator/melee3.wav",
	"gladiator/gldidle1.wav",
	"gladiator/gldsrch1.wav",
	"gladiator/sight.wav",
	"models/monsters/gladiatr/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"gunner/death1.wav",
	"gunner/gunpain2.wav",
	"gunner/gunpain1.wav",
	"gunner/gunidle1.wav",
	"gunner/gunatck1.wav",
	"gunner/gunsrch1.wav",
	"gunner/sight1.wav",
	"gunner/gunatck2.wav",
	"gunner/gunatck3.wav",
	"models/monsters/gunner/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"hover/hovpain1.wav",
	"hover/hovpain2.wav",
	"hover/hovdeth1.wav",
	"hover/hovdeth2.wav",
	"hover/hovsght1.wav",
	"hover/hovsrch1.wav",
	"hover/hovsrch2.wav",
	"hover/hovatck1.wav",
	"hover/hovidle1.wav",
	"models/monsters/hover/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"infantry/infpain1.wav",
	"infantry/infpain2.wav",
	"infantry/infdeth1.wav",
	"infantry/infdeth2.wav",
	"infantry/infatck1.wav",
	"infantry/infatck3.wav",
	"infantry/infatck2.wav",
	"infantry/melee2.wav",
	"infantry/infsght1.wav",
	"infantry/infsrch1.wav",
	"infantry/infidle1.wav",
	"models/monsters/infantry/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"insane/insane11.wav",
	"insane/insane5.wav",
	"insane/insane7.wav",
	"insane/insane1.wav",
	"insane/insane2.wav",
	"insane/insane3.wav",
	"insane/insane4.wav",
	"insane/insane6.wav",
	"insane/insane8.wav",
	"insane/insane9.wav",
	"insane/insane10.wav",
	"models/monsters/insane/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"medic/idle.wav",
	"medic/medpain1.wav",
	"medic/medpain2.wav",
	"medic/meddeth1.wav",
	"medic/medsght1.wav",
	"medic/medsrch1.wav",
	"medic/medatck2.wav",
	"medic/medatck3.wav",
	"medic/medatck4.wav",
	"medic/medatck5.wav",
	"medic/medatck1.wav",
	"models/monsters/medic/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"mutant/mutatck1.wav",
	"mutant/mutatck2.wav",
	"mutant/mutatck3.wav",
	"mutant/mutdeth1.wav",
	"mutant/mutidle1.wav",
	"mutant/mutpain1.wav",
	"mutant/mutpain2.wav",
	"mutant/mutsght1.wav",
	"mutant/mutsrch1.wav",
	"mutant/step1.wav",
	"mutant/step2.wav",
	"mutant/step3.wav",
	"mutant/thud1.wav",
	"models/monsters/mutant/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/bone/tris.md2",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"parasite/parpain1.wav",
	"parasite/parpain2.wav",
	"parasite/pardeth1.wav",
	"parasite/paratck1.wav",
	"parasite/paratck2.wav",
	"parasite/paratck3.wav",
	"parasite/paratck4.wav",
	"parasite/parsght1.wav",
	"parasite/paridle1.wav",
	"parasite/paridle2.wav",
	"parasite/parsrch1.wav",
	"models/monsters/parasite/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/chest/tris.md2",
	"models/objects/gibs/head2/tris.md2",
	"models/monsters/soldier/tris.md2",
	"soldier/solidle1.wav",
	"soldier/solsght1.wav",
	"soldier/solsrch1.wav",
	"infantry/infatck3.wav",
	"soldier/solpain2.wav",
	"soldier/soldeth2.wav",
	"models/objects/laser/tris.md2",
	"misc/lasfly.wav",
	"soldier/solatck2.wav",
	"soldier/solpain1.wav",
	"soldier/soldeth1.wav",
	"soldier/solatck1.wav",
	"soldier/solpain3.wav",
	"soldier/soldeth3.wav",
	"soldier/solatck3.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/sm_metal/tris.md2",
	"models/objects/gibs/chest/tris.md2",
	"models/objects/gibs/gear/tris.md2",
	"bosstank/btkpain1.wav",
	"bosstank/btkpain2.wav",
	"bosstank/btkpain3.wav",
	"bosstank/btkdeth1.wav",
	"bosstank/btkunqv1.wav",
	"bosstank/btkunqv2.wav",
	"bosstank/btkengn1.wav",
	"models/monsters/boss1/tris.md2",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"models/objects/gibs/sm_metal/tris.md2",
	"models/objects/gibs/chest/tris.md2",
	"models/objects/gibs/gear/tris.md2",
	"models/monsters/tank/tris.md2",
	"tank/tnkpain2.wav",
	"tank/tnkdeth2.wav",
	"tank/tnkidle1.wav",
	"tank/death.wav",
	"tank/step.wav",
	"tank/tnkatck4.wav",
	"tank/tnkatck5.wav",
	"tank/sight1.wav",
	"tank/tnkatck1.wav",
	"tank/tnkatk2a.wav",
	"tank/tnkatk2b.wav",
	"tank/tnkatk2c.wav",
	"tank/tnkatk2d.wav",
	"tank/tnkatk2e.wav",
	"tank/tnkatck3.wav",
	"monster_tank_commander",
	"monster_tank_commander",
	"info_player_start",
	"security",
	"info_player_coop",
	"jail3",
	"info_player_coop",
	"jail3",
	"info_player_coop",
	"jail3",
	"security",
	"jail2",
	"jail4",
	"mine1",
	"mine2",
	"mine3",
	"mine4",
	"lab",
	"boss1",
	"fact3",
	"biggun",
	"space",
	"command",
	"power2",
	"strike",
	"gender",
	"gender",
	"",
	"suicides",
	"cratered",
	"was squished",
	"sank like a rock",
	"melted",
	"does a back flip into the lava",
	"blew up",
	"found a way out",
	"saw the light",
	"got blasted",
	"was in the wrong place",
	"tried to put the pin back in",
	"tripped on its own grenade",
	"tripped on her own grenade",
	"tripped on his own grenade",
	"blew itself up",
	"blew herself up",
	"blew himself up",
	"should have used a smaller gun",
	"killed itself",
	"killed herself",
	"killed himself",
	"was blasted by",
	"was gunned down by",
	"was blown away by",
	"\'s super shotgun",
	"was machinegunned by",
	"was cut in half by",
	"\'s chaingun",
	"was popped by",
	"\'s grenade",
	"was shredded by",
	"\'s shrapnel",
	"ate",
	"\'s rocket",
	"almost dodged",
	"\'s rocket",
	"was melted by",
	"\'s hyperblaster",
	"was railed by",
	"saw the pretty lights from",
	"\'s BFG",
	"was disintegrated by",
	"\'s BFG blast",
	"couldn\'t hide from",
	"\'s BFG",
	"caught",
	"\'s handgrenade",
	"didn\'t see",
	"\'s handgrenade",
	"feels",
	"\'s pain",
	"tried to invade",
	"\'s personal space",
	"Blaster",
	"item_quad",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"Blaster",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_deathmatch",
	"info_player_coop",
	"",
	"info_player_start",
	"info_player_start",
	"bodyque",
	"misc/udeath.wav",
	"models/objects/gibs/sm_meat/tris.md2",
	"menu_loadgame\n",
	"spectator",
	"none",
	"spectator 0\n",
	"spectator 0\n",
	"password",
	"none",
	"spectator 1\n",
	"player",
	"players/male/tris.md2",
	"fov",
	"player",
	"\\name\\badinfo\\skin\\male/grunt",
	"name",
	"spectator",
	"0",
	"skin",
	"fov",
	"hand",
	"ip",
	"rejmsg",
	"Banned.",
	"spectator",
	"0",
	"none",
	"rejmsg",
	"Spectator password required or incorrect.",
	"rejmsg",
	"Server spectator limit is full.",
	"password",
	"none",
	"rejmsg",
	"Password required or incorrect.",
	"disconnected",
	"",
	"sv %3i:%i %i\n",
	"*jump1.wav",
	"*",
	"info_player_intermission",
	"info_player_start",
	"info_player_deathmatch",
	"info_player_intermission",
	"info_player_intermission",
	"i_fixme",
	"tag1",
	"tag2",
	"easy",
	"medium",
	"hard",
	"hard+",
	"cells",
	"misc/power2.wav",
	"i_powershield",
	"i_powershield",
	"p_quad",
	"p_invulnerability",
	"p_envirosuit",
	"p_rebreather",
	"i_help",
	"player_trail",
	"items/damage2.wav",
	"items/protect2.wav",
	"items/airout.wav",
	"items/airout.wav",
	"player/lava_in.wav",
	"player/watr_in.wav",
	"player/watr_in.wav",
	"player/watr_out.wav",
	"player/watr_un.wav",
	"player/gasp1.wav",
	"player/gasp2.wav",
	"player/u_breath1.wav",
	"player/u_breath2.wav",
	"player/drown1.wav",
	"*gurp1.wav",
	"*gurp2.wav",
	"player/burn1.wav",
	"player/burn2.wav",
	"misc/pc_up.wav",
	"",
	"weapon_railgun",
	"weapons/rg_hum.wav",
	"weapon_bfg",
	"weapons/bfg_hum.wav",
	"player_noise",
	"player_noise",
	"blaster",
	"slugs",
	"railgun",
	"railgun",
	"cells",
	"hyperblaster",
	"hyperblaster",
	"bullets",
	"chaingun",
	"chaingun",
	"bullets",
	"machinegun",
	"machinegun",
	"shells",
	"super shotgun",
	"super shotgun",
	"shells",
	"shotgun",
	"shotgun",
	"blaster",
	"weapons/noammo.wav",
	"items/damage3.wav",
	"weapons/noammo.wav",
	"weapons/hgrena1b.wav",
	"weapons/hgrenc1b.wav",
	"weapons/hyprbl1a.wav",
	"weapons/noammo.wav",
	"weapons/hyprbd1a.wav",
	"weapons/noammo.wav",
	"weapons/chngnu1a.wav",
	"weapons/chngnd1a.wav",
	"weapons/chngnl1a.wav",
	"weapons/noammo.wav",
	"0",
	"q_shared.c",
	"BoxOnPlaneSide",
	"sides != 0",
	"q_shared.c",
	"BoxOnPlaneSide",
	"",
	"",
	"",
	"Com_sprintf: overflow of %i in %i\n",
	"",
	"",
	"",
	"\\",
	"\"",
	";",
	"\\",
	"Can\'t use keys or values with a \\\n",
	"\\",
	"Can\'t use keys or values with a \\\n",
	";",
	"Can\'t use keys or values with a semicolon\n",
	"\"",
	"Can\'t use keys or values with a \"\n",
	"\"",
	"Can\'t use keys or values with a \"\n",
	"Keys and values must be < 64 characters.\n",
	"Keys and values must be < 64 characters.\n",
	"Info string length exceeded\n",
	"tempgoal",
	"plat_trigger",
	"door_trigger",
	"gib",
	"tele_trigger",
// ---- from acesrc
	"rocket",
	"grenade",
	"railgun",
	"bfg10k",
	"rocket launcher",
	"grenade launcher",
	"hyperblaster",
	"chaingun",
	"machinegun",
	"super shotgun",
	"shotgun",
	"blaster",
	"addnode",
	"removelink",
	"addlink",
	"showpath",
	"findnode",
	"movenode",
	"wb",
	"rb",
	"Jacket Armor",
	"Combat Armor",
	"Body Armor",
	"Combat Armor",
	"Jacket Armor",
	"item_armor_body",
	"item_armor_combat",
	"item_armor_jacket",
	"item_armor_shard",
	"item_power_screen",
	"item_power_shield",
	"weapon_grapple",
	"weapon_blaster",
	"weapon_shotgun",
	"weapon_supershotgun",
	"weapon_machinegun",
	"weapon_chaingun",
	"weapon_chaingun",
	"ammo_grenades",
	"weapon_grenadelauncher",
	"weapon_rocketlauncher",
	"weapon_hyperblaster",
	"weapon_railgun",
	"weapon_bfg10k",
	"ammo_shells",
	"ammo_bullets",
	"ammo_cells",
	"ammo_rockets",
	"ammo_slugs",
	"item_quad",
	"item_invunerability",
	"item_silencer",
	"item_rebreather",
	"item_enviornmentsuit",
	"item_ancienthead",
	"item_adrenaline",
	"item_bandolier",
	"item_pack",
	"item_datacd",
	"item_powercube",
	"item_pyramidkey",
	"item_dataspinner",
	"item_securitypass",
	"item_bluekey",
	"item_redkey",
	"item_commandershead",
	"item_airstrikemarker",
	"item_health",
	"item_flag_team1",
	"item_flag_team2",
	"item_tech1",
	"item_tech2",
	"item_tech3",
	"item_tech4",
	"item_health_small",
	"item_health_medium",
	"item_health_large",
	"item_health_mega",
	"func_plat",
	"misc_teleporter_dest",
	"misc_teleporter",
	"func_door",
	"rocket",
	"grenade",
	"grapple",
	"models/items/ammo/grenades/medium/tris.md2",
	"ace\\nav\\",
	".nod",
	"wb",
	"ace\\nav\\",
	".nod",
	"rb",
	"ace\\bots.tmp",
	"wb",
	"ace\\bots.tmp",
	"rb",
	"bot",
	"players/male/tris.md2",
	"fov",
	"name",
	"skin",
	"hand",
	"2",
	"stupid_acebot",
	"all",
// ---- end from acesrc
	NULL
};
