/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#include <qcommon/qcommon.h>
#include <om/Manager.h>
#include "dg_logs.h"

IMPLEMENT_EXPLOG(QuakeStatsLog, QuakeStatsLogEntry);
IMPLEMENT_EXPLOG(DGStoreLog, DGStoreLogEntry);
IMPLEMENT_EXPLOG(ObjectInterestLog, ObjectInterestEntry);
IMPLEMENT_EXPLOG(ObjectDeltaLog, ObjectDeltaEntry);
IMPLEMENT_EXPLOG(GUIDLog, GUIDLogEntry);

IMPLEMENT_EXPLOG(BBoxErrorLog, BBoxErrorEntry);
IMPLEMENT_EXPLOG(DeltaEncodingLog, DeltaEncodingEntry);
IMPLEMENT_EXPLOG(RUsageLog, RUsageEntry);

IMPLEMENT_EXPLOG(DemoLog, DemoLogEntry);

void DG_InitLogs()
{
    ASSERT(g_MeasurementParams.enabled);
    ASSERT(g_LocalSID != SID_NONE);

	if (!g_QuakeStatsLog)
		INIT_EXPLOG(QuakeStatsLog, g_LocalSID);
    if (!g_DGStoreLog)
		INIT_EXPLOG(DGStoreLog, g_LocalSID);
	if (g_QuakePreferences.record_obj_deltas && 
		!g_ObjectDeltaLog)
		INIT_EXPLOG(ObjectDeltaLog, g_LocalSID);
	if ((g_QuakePreferences.record_obj_interests ||
		 g_QuakePreferences.dump_initial) &&
		!g_ObjectInterestLog)
		INIT_EXPLOG(ObjectInterestLog, g_LocalSID);
	if (!g_RUsageLog)
		INIT_EXPLOG(RUsageLog, g_LocalSID);


	// Debugging logs
	if (!g_GUIDLog)
		INIT_EXPLOG(GUIDLog, g_LocalSID);

	if (g_QuakePreferences.dg_record_demo && !g_DemoLog)
		INIT_EXPLOG(DemoLog, g_LocalSID);
}
