/* vim: set sw=4 softtabstop=4 ts=8 noet: -*- Mode:c++; c-basic-offset:4; tab-width:8; indent-tabs-mode:t -*- */
#ifndef __DG_DEMO__H
#define __DG_DEMO__H   

#include <all_common.h>
#include <vector>

class DemoEntity {
    bool is_replica;
    bool is_client;
    guid_t guid;
    player_state_t ps;
    entity_state_t es;
    int  areabytes;
    byte areabits [MAX_MAP_AREAS / 8];

public:
    DemoEntity (edict_t *ent);
    // Default copy constructor will work

    DemoEntity (sizebuf_t *msg);

    bool IsReplica () const { return is_replica; }
    bool IsClient () const { return is_client; } 
    guid_t GetGUID () const { return guid; }    
    int  GetENumber () const { return es.number; }
    entity_state_t GetEntityState () const { return es; }

    void SetEntityNumber (int newnum);
    void Record (sizebuf_t *msg);
    void RecordPlayerState (sizebuf_t *msg);
    void RecordForClient (sizebuf_t *msg);
    ostream& Print (ostream& os) const;
private:
    int ComputeAreaVisibility (edict_t *ent);
};

ostream& operator<<(ostream& out, const DemoEntity &de);
ostream& operator<<(ostream& out, const DemoEntity *de);

typedef vector<DemoEntity *> DEVec;
typedef DEVec::iterator DEVecIter;

class DemoFrame { 
    DEVec  dentities;
    byte  *multicast_data;
    int    multicast_size;
    int    framenum;
    float  frametime;
public:
    DemoFrame (int framenum);
    DemoFrame (game_export_t *ge);
    DemoFrame (sizebuf_t *msg);
    ~DemoFrame ();

    void AddEntity (DemoEntity *de);
    void AddMulticastEvent (byte *data, int len);

    DEVec& GetEntities () { return dentities; }
    int GetFrameNum () const { return framenum; }
    float GetFrameTime () const { return frametime; }

    void Record (sizebuf_t *msg);
    void RecordForClient (sizebuf_t *msg, guid_t player_guid);
    
    ostream& Print (ostream& os) const;
};

ostream& operator<<(ostream& out, const DemoFrame &df);
ostream& operator<<(ostream& out, const DemoFrame *df);

#endif /* __DG_DEMO__H */
