/* vim: set sw=4 ts=4 noet: -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

#ifndef __DG_DELTA_ENCODING_H
#define __DG_DELTA_ENCODING_H

#include <set>
#include <map>
#include <hash_map.h>
#include <om/GUpdate.h>

///////////////////////////////////////////////////////////////////////////////

#define MAX_EDICT_DEPTH 4

typedef struct {
	char *parts[MAX_EDICT_DEPTH];
} dg_field_stack_t;

typedef struct {
	const char *name;
	uint32 key;
} dg_field_key_t;

typedef struct {
	const int index;
    const int num_fields;
    dg_field_key_t *fields;
} dg_cluster_t;

// temp structs for intialization
typedef map<string, dg_cluster_t *> _field_table_t;
extern _field_table_t _dg_field_encoding;

// map from key => field name (for debugging)
typedef map<uint32, string, less<uint32> > fieldname_map_t;
extern fieldname_map_t dg_fieldname_map;

typedef hash_map<uint32, dg_cluster_t *> field_table_t;  // stack key
extern field_table_t dg_field_encoding;         // stack key

// set of stack keys
typedef set<uint32>  dg_fields;

inline void   DG_InitFieldStack(dg_field_stack_t *s) {
	bzero(s->parts, sizeof(s->parts));
}
inline uint32 DG_GetFieldStackIndex(dg_field_stack_t *s)
{
	int index = 0;
    for ( ; s->parts[index] != NULL; index++)
	;
    ASSERT(index < MAX_EDICT_DEPTH);
	return index;
}

/* from http://www.concentric.net/~Ttwang/tech/inthash.htm */
inline unsigned long long __hash64(unsigned long long key)
{
  key += ~(key << 32);
  key ^= (key >> 22);
  key += ~(key << 13);
  key ^= (key >> 8);
  key += (key << 3);
  key ^= (key >> 15);
  key += ~(key << 27);
  key ^= (key >> 31);
  return key;
}

inline uint32 DG_FieldStackToKey(dg_field_stack_t *s) {
	static uint32 bits[] = { 0, 32, 16, 25, 9, 31, 15, 7, 1 };
	uint64 val = 0;
	uint32 key;

	for (int i=0; i<MAX_EDICT_DEPTH && s->parts[i] != NULL; i++) {
		uint64 tmp = ((uint64)s->parts[i]) << bits[i];
		if (i&0x1) 
			val ^= ( i&0x10 ? tmp : ~tmp );
		else
			val += ( i&0x10 ? tmp : ~tmp );
	}

	key = (uint32)( __hash64(val) & 0x00000000FFFFFFFFULL);

	return key;
}

class DG_Edict;
class GObject;

void   DG_InitDeltaTables();
void   DG_MakeInitDeltaMask(DG_Edict *dg_obj);
void   DG_MakeDeltaMask(GObject *obj, dg_fields *fields);
void   DG_MakeEncodeSet(const DeltaMask *mask, dg_fields *to_encode);

///////////////////////////////////////////////////////////////////////////////

#endif
